/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.evp.common.util.AccountingSysUtil;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.entity.ArchiveDetailLogVo;
import kd.fi.evp.entity.ArchiveLogVo;

public class ArchiveUtils {
    private static final String RECONDATE = "recondate";
    private static final String ISDELETE = "isdelete";
    private static final String ISINTOPOOL = "isintopool";
    private static final String ISARCHIVE = "isarchive";
    private static final String BOOKTYPE = "booktype";

    public static ArchiveLogVo buildBkrsTask(Date startdate, Date enddate, Long orgid, String orgnumber, String orgname) {
        ArchiveLogVo archiveLogVo = new ArchiveLogVo();
        ArrayList<Object> bkrsIds = new ArrayList<Object>(16);
        QFilter qFilter1 = new QFilter(RECONDATE, ">=", (Object)startdate);
        QFilter qFilter2 = new QFilter(RECONDATE, "<", (Object)enddate);
        QFilter qFilter = new QFilter(ISINTOPOOL, "=", (Object)"1");
        QFilter qFilter3 = new QFilter(ISARCHIVE, "=", (Object)"0");
        QFilter qFilter4 = new QFilter(ISDELETE, "=", (Object)"0");
        QFilter qFilter5 = new QFilter("org", "=", (Object)orgid);
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"evp.common.util.ArchiveUtils.buildBkrsTask", (String)"evp_bkrs", (String)"id,billid", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter5}, null);){
            if (set != null) {
                for (Row row : set) {
                    bkrsIds.add(row.get("id"));
                }
            }
        }
        archiveLogVo.setOpname(ResManager.loadKDString((String)"\u5f52\u6863", (String)"ArchiveUtils", (String)"fi-evp-common", (Object[])new Object[0]));
        archiveLogVo.setOpdesc("archive");
        archiveLogVo.setOrgnumber(orgnumber);
        archiveLogVo.setOrgname(orgname);
        archiveLogVo.setArchivedate(startdate);
        archiveLogVo.setAllcount(bkrsIds.size());
        HashMap<String, List<Object>> invoicemap = new HashMap<String, List<Object>>(16);
        invoicemap.put("evp_bkrs", bkrsIds);
        archiveLogVo.setInvoicemap(invoicemap);
        return archiveLogVo;
    }

    public static ArchiveLogVo buildTicketTask(Long booktTypeId, Long periodId, List<String> entityNames, Long orgid, String orgnumber, String orgname) {
        ArchiveLogVo archiveLogVo = new ArchiveLogVo();
        DynamicObject dynamicObject = AccountingSysUtil.getPeriodDyn(periodId);
        HashSet<Object> sourcevIds = new HashSet<Object>(16);
        QFilter qFilter1 = new QFilter(ISINTOPOOL, "=", (Object)"1");
        QFilter qFilter2 = new QFilter(ISARCHIVE, "<=", (Object)"0");
        QFilter qFilter3 = new QFilter(ISDELETE, "<=", (Object)"0");
        QFilter qFilter4 = new QFilter("period", "=", (Object)periodId);
        QFilter qFilter5 = new QFilter("org", "=", (Object)orgid);
        QFilter qFilter6 = new QFilter(BOOKTYPE, "=", (Object)booktTypeId);
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"evp.common.util.ArchiveUtils.buildTicketTask", (String)"evp_voucher", (String)"billid", (QFilter[])new QFilter[]{qFilter3, qFilter4, qFilter5, qFilter6}, null);){
            if (set != null) {
                for (Row row : set) {
                    sourcevIds.add(row.get("billid"));
                }
            }
        }
        int allcount = 0;
        HashMap<String, List<Object>> invoicemap = new HashMap<String, List<Object>>(16);
        QFilter invoiceFilter = new QFilter("voucherid", "in", sourcevIds);
        for (String entityName : entityNames) {
            DataSet set = QueryServiceHelper.queryDataSet((String)"evp.common.util.ArchiveUtils.buildTicketTask", (String)entityName, (String)"id, voucherid, billid", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4, invoiceFilter}, null);
            Throwable throwable = null;
            try {
                if (set == null) continue;
                for (Row row : set) {
                    invoicemap.computeIfAbsent(entityName, value -> new ArrayList()).add(row.get("id"));
                    ++allcount;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (set == null) continue;
                if (throwable != null) {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                set.close();
            }
        }
        archiveLogVo.setOpname(ResManager.loadKDString((String)"\u5f52\u6863", (String)"ArchiveUtils", (String)"fi-evp-common", (Object[])new Object[0]));
        archiveLogVo.setOpdesc("archive");
        archiveLogVo.setOrgnumber(orgnumber);
        archiveLogVo.setOrgname(orgname);
        archiveLogVo.setArchivedate(dynamicObject.getDate("begindate"));
        archiveLogVo.setAllcount(allcount);
        archiveLogVo.setInvoicemap(invoicemap);
        return archiveLogVo;
    }

    public static Long saveArchiveLog(ArchiveLogVo archiveLogVo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"evp_archivelog");
        DynamicObject logEntity = (DynamicObject)type.createInstance();
        logEntity.set("username", (Object)RequestContext.get().getUserName());
        logEntity.set("opname", (Object)archiveLogVo.getOpname());
        logEntity.set("opdesc", (Object)archiveLogVo.getOpdesc());
        logEntity.set("opdate", (Object)new Date());
        logEntity.set("orgnumber", (Object)archiveLogVo.getOrgnumber());
        logEntity.set("orgname", (Object)archiveLogVo.getOrgname());
        logEntity.set("archivedate", (Object)archiveLogVo.getArchivedate());
        logEntity.set("allcount", (Object)archiveLogVo.getAllcount());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logEntity});
        return logEntity.getLong("id");
    }

    public static List<List<Object>> spiltData(List<Object> pks, int batchnum) {
        ArrayList<List<Object>> returnList = new ArrayList<List<Object>>(1);
        ArrayList<Object> list = new ArrayList<Object>(16);
        int count = 0;
        for (Object id : pks) {
            list.add(id);
            if (++count != batchnum) continue;
            returnList.add(list);
            count = 0;
            list.clear();
        }
        if (!list.isEmpty()) {
            returnList.add(list);
        }
        return returnList;
    }

    public static DynamicObject[] notArchiveDyns(String entityname, List<Object> pks) {
        QFilter qFilter = new QFilter(ISDELETE, "=", (Object)"0");
        qFilter.and(new QFilter(ISINTOPOOL, "=", (Object)"1"));
        qFilter.and(new QFilter(ISARCHIVE, "=", (Object)"0"));
        qFilter.and(new QFilter("id", "in", pks));
        String selectFields = "id,org,billid,voucherno,isintopool,operator,xbrlurl,fileurl_tag,voucherid,intopooldate,period,bookdate,seqno,isarchive,archivebatchcode";
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityname, (String)selectFields, (QFilter[])qFilter.toArray());
        return dyns;
    }

    public static List<List<DynamicObject>> splitdata(DynamicObject[] arg0, String entityname) {
        String bookdate;
        Long orgid;
        ArrayList<List<DynamicObject>> lists = new ArrayList<List<DynamicObject>>(16);
        HashMap<Long, Map> tempdyns = new HashMap<Long, Map>(2);
        if ("evp_bkrs".equals(entityname)) {
            for (DynamicObject dynamicObject : arg0) {
                orgid = dynamicObject.getLong("org_id");
                bookdate = DateFomatUtils.format(dynamicObject.getDate("bookdate"), "yyyyMM");
                tempdyns.computeIfAbsent(orgid, value -> new HashMap()).computeIfAbsent(bookdate, value -> new ArrayList()).add(dynamicObject);
            }
        } else {
            for (DynamicObject dynamicObject : arg0) {
                orgid = dynamicObject.getLong("org_id");
                bookdate = dynamicObject.getString("period_id");
                tempdyns.computeIfAbsent(orgid, value -> new HashMap()).computeIfAbsent(bookdate, value -> new ArrayList()).add(dynamicObject);
            }
        }
        for (Map.Entry entry : tempdyns.entrySet()) {
            Map map = (Map)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                List dyns = (List)entry2.getValue();
                lists.add(dyns);
            }
        }
        return lists;
    }

    public static Map<Long, Map<String, List<DynamicObject>>> splitReversedata(DynamicObject[] arg0, String entityname) {
        HashMap<Long, Map<String, List<DynamicObject>>> tempdyns = new HashMap<Long, Map<String, List<DynamicObject>>>(2);
        if ("evp_bkrs".equals(entityname)) {
            for (DynamicObject dynamicObject : arg0) {
                Long orgid = dynamicObject.getLong("org_id");
                String bookdate = DateFomatUtils.format(dynamicObject.getDate("bookdate"), "yyyyMM");
                tempdyns.computeIfAbsent(orgid, value -> new HashMap()).computeIfAbsent(bookdate, value -> new ArrayList()).add(dynamicObject);
            }
        } else {
            for (DynamicObject dynamicObject : arg0) {
                Long orgid = dynamicObject.getLong("org_id");
                String bookdate = dynamicObject.getString("period_id");
                tempdyns.computeIfAbsent(orgid, value -> new HashMap()).computeIfAbsent(bookdate, value -> new ArrayList()).add(dynamicObject);
            }
        }
        return tempdyns;
    }

    public static void saveDetail(ArchiveDetailLogVo archiveDetailLogVo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"evp_archivedetail");
        DynamicObject logEntity = (DynamicObject)type.createInstance();
        Date date = new Date();
        logEntity.set("username", (Object)RequestContext.get().getUserName());
        logEntity.set("opname", (Object)archiveDetailLogVo.getOpname());
        logEntity.set("opdesc", (Object)archiveDetailLogVo.getOpdesc());
        logEntity.set("entitynumber", (Object)archiveDetailLogVo.getEntitynumber());
        logEntity.set("entityname", (Object)archiveDetailLogVo.getEntityname());
        logEntity.set("opdate", (Object)date);
        logEntity.set("orgnumber", (Object)archiveDetailLogVo.getOrgnumber());
        logEntity.set("allcount", (Object)archiveDetailLogVo.getAllcount());
        logEntity.set("successcnt", (Object)archiveDetailLogVo.getSuccesscnt());
        logEntity.set("batchcode", (Object)archiveDetailLogVo.getBatchcode());
        logEntity.set("parentid", (Object)archiveDetailLogVo.getParentid());
        logEntity.set("status", (Object)archiveDetailLogVo.getStatus());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logEntity});
    }
}

