/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import api.VoucherFileUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.entity.FieldAttr;
import kd.fi.evp.entity.OriginBillVo;

public class BuildFileUtils {
    private static final Log logger = LogFactory.getLog(BuildFileUtils.class);
    public static final String DEBITORCREDIT = "DebitOrCredit";
    public static final String NAMEOFGENERALLEDGERSUBJECT = "NameOfGeneralLedgerSubject";
    public static final String NAMEOFSUBSIDIARYLEDGERSUBJECT = "NameOfSubsidiaryLedgerSubject";
    public static final String RECORDEDAMOUNT = "RecordedAmount";
    public static final String UNIFIEDSOCIALCREDITCODEOFACCOUNTINGENTITY = "UnifiedSocialCreditCodeOfAccountingEntity";
    public static final String NAMEOFACCOUNTINGENTITY = "NameOfAccountingEntity";
    public static final String NUMBEROFACCOUNTINGDOCUMENTS = "NumberOfAccountingDocuments";
    public static final String POSTINGDATE = "PostingDate";
    public static final String ACCOUNTINGPERIOD = "AccountingPeriod";
    public static final String SUMMARYOFACCOUNTINGDOCUMENTS = "SummaryOfAccountingDocuments";
    public static final String INFORMATIONOFDEBITANDCREDITENTRYTUPLE = "InformationOfDebitAndCreditEntryTuple";
    public static final String INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE = "InformationOfAccountingDocumentsTuple";
    public static final String GBNAME = "gbname";
    public static final String GBNUMBER = "gbnumber";
    public static final String FIELDNAME = "fieldname";
    public static final String FIELDNUMBER = "fieldnumber";
    public static final String FIELDTYPE = "fieldtype";
    public static final String DISPLAYPROP = "displayprop";
    public static final String ISVISIBLE = "isvisible";
    public static final String ISSYSPRESET = "issyspreset";

    public static byte[] json2Xbrl(String json, String configId) {
        logger.info("json2Xbrl\u53c2\u6570[json\uff1a{}\uff0cconfigId\uff1a{}]", (Object)json, (Object)configId);
        byte[] xbrlBytes = null;
        try {
            String xbrlStr = VoucherFileUtil.json2Xbrl((String)json, (String)configId);
            if (null != xbrlStr) {
                xbrlBytes = xbrlStr.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xbrl\u6587\u4ef6\u5931\u8d25{%s}\u3002", (String)"BuildFileUtils_0", (String)"fi-evp-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return xbrlBytes;
    }

    public static void extractXBRL(String ofdFilePath, String xbrlPath) {
        try {
            if (ofdFilePath.endsWith(".ofd")) {
                VoucherFileUtil.extractXBRLFromOFD((String)ofdFilePath, (String)xbrlPath);
            } else if (ofdFilePath.endsWith(".pdf")) {
                VoucherFileUtil.extractXBRLFromPDF((String)ofdFilePath, (String)xbrlPath);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xbrl\u6587\u4ef6\u5931\u8d25{%s}\u3002", (String)"BuildFileUtils_3", (String)"fi-evp-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    public static Map<Object, JSONObject> getVoucherJson(Set<Object> set) {
        QFilter voucherFilter = new QFilter("billid", "in", set);
        HashMap<Long, List> voucherentityJson = new HashMap<Long, List>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getVoucherJson", (String)"evp_voucher", (String)"id, entryentity.amountdc, entryentity.glaccountname, entryentity.detailaccountname, entryentity.bookedamount", (QFilter[])new QFilter[]{voucherFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                List eneityList = voucherentityJson.computeIfAbsent(id, value -> new ArrayList());
                LinkedHashMap<String, Object> eneityMap = new LinkedHashMap<String, Object>(16);
                eneityMap.put(DEBITORCREDIT, "1".equals(row.getString("entryentity.amountdc")) ? ResManager.loadKDString((String)"\u501f", (String)"BuildFileUtils_1", (String)"fi-evp-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"BuildFileUtils_2", (String)"fi-evp-common", (Object[])new Object[0]));
                eneityMap.put(NAMEOFGENERALLEDGERSUBJECT, row.getString("entryentity.glaccountname"));
                eneityMap.put(NAMEOFSUBSIDIARYLEDGERSUBJECT, row.getString("entryentity.detailaccountname"));
                eneityMap.put(RECORDEDAMOUNT, row.getBigDecimal("entryentity.bookedamount"));
                eneityList.add(eneityMap);
            }
        }
        HashMap<Object, JSONObject> voucherJson = new HashMap<Object, JSONObject>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getVoucherJson", (String)"evp_voucher", (String)"id,billid,org.id org,org.uniformsocialcreditcode,org.ffirmname,org.city.name,voucherno,bookdate,vdescription,period.number", (QFilter[])new QFilter[]{voucherFilter}, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                Object id = row.get("id");
                JSONObject mainJson = new JSONObject(new LinkedHashMap());
                mainJson.put(UNIFIEDSOCIALCREDITCODEOFACCOUNTINGENTITY, (Object)row.getString("org.uniformsocialcreditcode"));
                mainJson.put(NAMEOFACCOUNTINGENTITY, (Object)row.getString("org.ffirmname"));
                mainJson.put("id", id);
                mainJson.put("org", (Object)row.getLong("org"));
                mainJson.put(NUMBEROFACCOUNTINGDOCUMENTS, (Object)row.getString("voucherno"));
                mainJson.put(POSTINGDATE, (Object)DateFomatUtils.getTimeStr(row.getDate("bookdate")));
                mainJson.put(ACCOUNTINGPERIOD, (Object)BuildFileUtils.dealPeriodNumber(row.getString("period.number")));
                mainJson.put(SUMMARYOFACCOUNTINGDOCUMENTS, (Object)row.getString("vdescription"));
                mainJson.put(INFORMATIONOFDEBITANDCREDITENTRYTUPLE, voucherentityJson.get(id));
                voucherJson.put(row.get("billid"), mainJson);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return voucherJson;
    }

    private static String dealPeriodNumber(String periodNumber) {
        if (!StringUtils.isEmpty((CharSequence)periodNumber) && periodNumber.length() >= 6) {
            periodNumber = periodNumber.substring(0, 4) + "-" + periodNumber.substring(4, 6);
        }
        return periodNumber;
    }

    public static Map<Object, JSONObject> getInvoiceJson(String invoiceTable, Set<Object> sourceIds) {
        HashMap<Object, JSONObject> returnMap = new HashMap<Object, JSONObject>(16);
        QFilter invoiceFilter = new QFilter("billid", "in", sourceIds);
        QFilter evFilter1 = new QFilter("number", "=", (Object)invoiceTable);
        QFilter evFilter2 = new QFilter("fieldentity.issyspreset", "=", (Object)"1");
        QFilter evFilter3 = new QFilter("fieldentity.gbname", "!=", (Object)" ");
        ArrayList<FieldAttr> fieldAttrs = new ArrayList<FieldAttr>(12);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"evp_elevouchertype", (QFilter[])new QFilter[]{evFilter1, evFilter2, evFilter3});
        DynamicObjectCollection dyns = (DynamicObjectCollection)dynamicObject.get("fieldentity");
        for (Object dObject : dyns) {
            FieldAttr fieldAttr = new FieldAttr();
            fieldAttr.setFieldname(dObject.getString(FIELDNAME));
            fieldAttr.setFieldnumber(dObject.getString(FIELDNUMBER));
            fieldAttr.setGbname(dObject.getString(GBNAME));
            fieldAttr.setGbnumber(dObject.getString(GBNUMBER));
            fieldAttr.setFieldtype(dObject.getString(FIELDTYPE));
            fieldAttrs.add(fieldAttr);
        }
        ArrayList<String> selectFields = new ArrayList<String>(16);
        for (FieldAttr fieldAttr : fieldAttrs) {
            if ("3".equals(fieldAttr.getFieldtype())) {
                selectFields.add(fieldAttr.getFieldnumber() + ".name " + fieldAttr.getFieldnumber());
                continue;
            }
            selectFields.add(fieldAttr.getFieldnumber());
        }
        selectFields.add("billid");
        selectFields.add("bookdate");
        if (!selectFields.contains("seqno")) {
            selectFields.add("seqno");
        }
        if (!selectFields.contains("voucherid")) {
            selectFields.add("voucherid");
        }
        selectFields.add("id");
        if ("evp_bkrs".equals(invoiceTable)) {
            HashMap<Long, String> idAndbillid = new HashMap<Long, String>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getInvoiceJson", (String)invoiceTable, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{invoiceFilter}, null);){
                for (Row row : dataSet) {
                    idAndbillid.put(row.getLong("id"), row.getString("billid"));
                    JSONObject json = new JSONObject(new LinkedHashMap());
                    for (FieldAttr fieldAttr : fieldAttrs) {
                        json.put(fieldAttr.getGbnumber(), BuildFileUtils.getJsonValue(row, fieldAttr));
                    }
                    json.put("MonthOfBankReconciliationStatement", (Object)(row.getString("reconmonth").length() == 1 ? "0" + row.getString("reconmonth") : row.getString("reconmonth")));
                    json.put("seqno", (Object)row.getString("seqno"));
                    json.put("bookdate", (Object)DateFomatUtils.getDateString(row.getDate("bookdate"), "yyyyMMdd"));
                    json.put("voucherid", (Object)row.getString("voucherid"));
                    returnMap.put(row.get("billid"), json);
                }
            }
            HashMap<String, List> entryJsonMap = new HashMap<String, List>(16);
            String entryFields = "id, entryentity.ebookdate bookdate, entryentity.businessproductstype businessproductstype, entryentity.businessserialnumber businessserialnumber, entryentity.sourcevouchertype sourcevouchertype,entryentity.sourcevouchernumber sourcevouchernumber, entryentity.electronicreceiptinfo electronicreceiptinfo, entryentity.creditordebit creditordebit, entryentity.transactionamount transactionamount,entryentity.balancedirect balancedirect, entryentity.accountbalance accountbalance, entryentity.transactioncode transactioncode, entryentity.counterpartyaccount counterpartyaccount, entryentity.counterpartyname counterpartyname,entryentity.depositorybank depositorybank, entryentity.bookkeeper bookkeeper, entryentity.booktime booktime, entryentity.accountjournal accountjournal, entryentity.otherinfo otherinfo, entryentity.electronicreceiptnumber electronicreceiptnumber";
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getVoucherJson", (String)invoiceTable, (String)entryFields, (QFilter[])new QFilter("id", "in", idAndbillid.keySet()).toArray(), null);){
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    Row row3 = (Row)iterator.next();
                    JSONObject json = new JSONObject(new LinkedHashMap());
                    json.put("DateOfBookkeeping", (Object)(row3.getDate("bookdate") == null ? "" : DateFomatUtils.getDateString(row3.getDate("bookdate"), "yyyy-MM-dd")));
                    json.put("TypesOfBusinessProducts", (Object)row3.getString("businessproductstype"));
                    json.put("BusinessSerialNumber", (Object)row3.getString("businessserialnumber"));
                    json.put("TypeOfSourceDocument", (Object)row3.getString("sourcevouchertype"));
                    json.put("NumberOfSourceDocument", (Object)row3.getString("sourcevouchernumber"));
                    json.put("NotesOfBankElectronicReceipt", (Object)row3.getString("electronicreceiptinfo"));
                    json.put("IdentificationOfCreditOrDebit", (Object)row3.getString("creditordebit"));
                    json.put("TransactionAmount", (Object)row3.getString("transactionamount"));
                    json.put("DebitOrCreditOfBalance", (Object)row3.getString("balancedirect"));
                    json.put("AccountBalance", (Object)row3.getString("accountbalance"));
                    json.put("TransactionCode", (Object)row3.getString("transactioncode"));
                    json.put("AccountOfCounterparty", (Object)row3.getString("counterpartyaccount"));
                    json.put("NameOfCounterparty", (Object)row3.getString("counterpartyname"));
                    json.put("DepositoryBankOfCounterparty", (Object)row3.getString("depositorybank"));
                    json.put("Bookkeeper", (Object)row3.getString("bookkeeper"));
                    json.put("TimeOfBookkeeping", (Object)row3.getString("booktime"));
                    json.put("JournalAccountOfBookkeeping", (Object)row3.getString("accountjournal"));
                    json.put("OtherAccountingInformation", (Object)row3.getString("otherinfo"));
                    json.put("NumberOfBankElectronicReceipt", (Object)row3.getString("electronicreceiptnumber"));
                    entryJsonMap.computeIfAbsent((String)idAndbillid.get(row3.getLong("id")), value -> new ArrayList()).add(json);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Map.Entry entry : returnMap.entrySet()) {
                ((JSONObject)entry.getValue()).put("InformationOfReconcileDetailsTuple", entryJsonMap.get(entry.getKey()));
            }
        } else {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getVoucherJson", (String)invoiceTable, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{invoiceFilter}, null);){
                for (Row row : dataSet) {
                    JSONObject jSONObject = new JSONObject(new LinkedHashMap());
                    for (FieldAttr fieldAttr : fieldAttrs) {
                        jSONObject.put(fieldAttr.getGbnumber(), BuildFileUtils.getJsonValue(row, fieldAttr));
                    }
                    jSONObject.put("seqno", (Object)row.getString("seqno"));
                    jSONObject.put("bookdate", (Object)DateFomatUtils.getDateString(row.getDate("bookdate"), "yyyyMMdd"));
                    jSONObject.put("voucherid", (Object)row.getString("voucherid"));
                    returnMap.put(row.get("billid"), jSONObject);
                }
            }
        }
        return returnMap;
    }

    private static Object getJsonValue(Row row, FieldAttr fieldAttr) {
        switch (fieldAttr.getFieldtype()) {
            case "1": 
            case "2": {
                return row.getString(fieldAttr.getFieldnumber());
            }
            case "3": {
                return row.getString(fieldAttr.getFieldnumber());
            }
            case "4": {
                return row.getBoolean(fieldAttr.getFieldnumber());
            }
            case "5": {
                if (row.getDate(fieldAttr.getFieldnumber()) == null) {
                    return "";
                }
                return DateFomatUtils.getDateString(row.getDate(fieldAttr.getFieldnumber()), "yyyy-MM-dd");
            }
        }
        return null;
    }

    public static Map<Object, OriginBillVo> getXbrlurls(String entityname, Set<Object> keySet) {
        HashMap<Object, OriginBillVo> returnMap = new HashMap<Object, OriginBillVo>(16);
        QFilter qFilter = new QFilter("billid", "in", keySet);
        QFilter qFilter1 = new QFilter("isintopool", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("isdelete", "=", (Object)"0");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BuildFileUtils.getXbrlurls", (String)entityname, (String)"id,billid,xbrlurl,fileurl_tag", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2}, null);){
            for (Row row : dataSet) {
                OriginBillVo obv = new OriginBillVo();
                obv.setBillid(row.get("billid"));
                obv.setXbrlurl(row.getString("xbrlurl"));
                obv.setFileurl(row.getString("fileurl_tag"));
                returnMap.put(row.get("id"), obv);
            }
        }
        return returnMap;
    }

    public static List<DynamicObject> notPoolDyns(String entityname) {
        QFilter qFilter = new QFilter("isintopool", "=", (Object)"0");
        qFilter.and(new QFilter("isdelete", "=", (Object)"0"));
        String selectFields = "id,billid,voucherno,isintopool,operator,xbrlurl,voucherid,intopooldate,period";
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityname, (String)selectFields, (QFilter[])qFilter.toArray());
        return Arrays.asList(dyns);
    }
}

