/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;

public class DateFomatUtils {
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDD_HHMMSSSSS = "yyyy/MM/dd/HHmmssSSS";

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date;
        if (StringUtils.isBlank((CharSequence)datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return date;
    }

    public static Date beginOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date endOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Map<Date, Date> splitDateRangeByMonth(Date startDate, Date endDate) {
        HashMap<Date, Date> map = new HashMap<Date, Date>(12);
        Calendar startcal = Calendar.getInstance();
        startcal.setTime(startDate);
        Calendar endcal = Calendar.getInstance();
        endcal.setTime(endDate);
        int startMonth = startcal.get(2) + 1;
        int endMonth = endcal.get(2) + 1;
        int year = endcal.get(1);
        if (startMonth == endMonth) {
            map.put(startDate, endDate);
            return map;
        }
        for (int i = startMonth; i <= endMonth; ++i) {
            Calendar cal = Calendar.getInstance();
            String datestr = year + "-" + i;
            cal.setTime(DateFomatUtils.stringToDate(datestr, YYYY_MM));
            cal.set(5, 1);
            Date monthStartDate = cal.getTime();
            cal.roll(5, -1);
            Date monthEndDate = cal.getTime();
            if (i == startMonth) {
                monthStartDate = startDate;
            }
            if (i == endMonth) {
                monthEndDate = endDate;
            }
            map.put(monthStartDate, monthEndDate);
        }
        return map;
    }

    public static Map<Date, Date> getIntervalTimeByMonth(Date startTime, Date endTime) {
        ArrayList<Date> dateList = new ArrayList<Date>(12);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        dateList.add(calendar.getTime());
        while (calendar.getTimeInMillis() < endTime.getTime()) {
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            if (calendar.getTimeInMillis() >= endTime.getTime()) {
                dateList.add(endTime);
                break;
            }
            calendar.add(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dateList.add(calendar.getTime());
        }
        HashMap<Date, Date> map = new HashMap<Date, Date>(12);
        for (int i = 0; i < dateList.size() && dateList.size() != i + 1; ++i) {
            map.put((Date)dateList.get(i), (Date)dateList.get(i + 1));
        }
        return map;
    }

    public static String getBeforeFirstMonthdate() {
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return format.format(calendar.getTime());
    }

    public static Date getLastMonthdate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getBeforeLastMonthdate() {
        SimpleDateFormat sf = new SimpleDateFormat(YYYY_MM_DD);
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return sf.format(calendar.getTime());
    }

    public static String getBBeforeFirstMonthdate() {
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        calendar.set(5, 1);
        return format.format(calendar.getTime());
    }

    public static String getBBeforeLastMonthdate() {
        SimpleDateFormat sf = new SimpleDateFormat(YYYY_MM_DD);
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        calendar.set(2, month - 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return sf.format(calendar.getTime());
    }

    public static Date getDateWithSpecMills(Date date, int mills) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, mills);
        return cal.getTime();
    }

    public static String getTimeStr(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MM_DD);
        return simpleDateFormat.format(date);
    }

    public static String getShortStr(Date date) {
        String dateStr = "";
        try {
            dateStr = new SimpleDateFormat(YYYY_MM).format(date);
        }
        catch (Exception e) {
            throw new KDBizException("date format error\u3002");
        }
        return dateStr;
    }

    public static String getDateString(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static Date getNextDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 1);
        return cal.getTime();
    }

    public static Date getLastMonthDay(Date dt) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(dt);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 999);
        return ca.getTime();
    }

    public static Date getFirstMonthDay(Date dt) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(dt);
        ca.set(5, 1);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static int betweenMonth(Date startDate, Date endDate, boolean reset) {
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!reset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public static Date offsetMonth(Date originDate, int offset) {
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(originDate);
        beginCal.add(2, offset);
        return beginCal.getTime();
    }

    public static Boolean checkMonthDiff(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(start);
        c2.setTime(end);
        c1.add(2, 3);
        if (c1.getTimeInMillis() <= c2.getTimeInMillis()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

