/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class EVoucherModel {
    public static final Map<String, String> EVTABLEMAP = new HashMap<String, String>(16);
    public static final Map<String, String> TICKETTYPEMAP = new HashMap<String, String>(16);
    public static final String SPLIT_LINE = "_";
    public static final String ATR_RECEIVER = "atr_receiver";
    public static final String RAI_RECEIVER = "rai_receiver";
    public static final String BKRS = "bkrs";
    public static final String BKER_RECEIVER = "bker_receiver";
    public static final String INV_ORD_RECEIVER = "inv_ord_receiver";
    public static final String INV_SPCL_RECEIVER = "inv_spcl_receiver";
    public static final String INV_TLF_RECEIVER = "inv_tlf_receiver";
    public static final String NTREV_GPM_RECEIVER = "ntrev_gpm_receiver";
    public static final String EINV_ORD_RECEIVER = "einv_ord_receiver";
    public static final String EINV_SPCL_RECEIVER = "einv_spcl_receiver";
    public static final String EFI = "efi";
    public static final String EVP_ATRRECEIVER = "evp_atrreceiver";
    public static final String EVP_RAIRECEIVER = "evp_raireceiver";
    public static final String EVP_BKRS = "evp_bkrs";
    public static final String EVP_BKERRECEIVER = "evp_bkerreceiver";
    public static final String EVP_INVORDRECEIVER = "evp_invordreceiver";
    public static final String EVP_INVSPCLRECEIVER = "evp_invspclreceiver";
    public static final String EVP_INVTLFRECEIVER = "evp_invtlfreceiver";
    public static final String EVP_EINVORDRECEIVER = "evp_einvordreceiver";
    public static final String EVP_EINVSPCLRECEIVER = "evp_einvspclreceiver";
    public static final String EVP_NTREVGPMRECEIVER = "evp_ntrevgpmreceiver";
    public static final String EVP_EFI = "evp_efi";
    public static final String EVP_VOUCHER = "evp_voucher";

    public static Map<String, String> getNameMap() {
        HashMap<String, String> namemap = new HashMap<String, String>(16);
        DynamicObjectCollection typedyns = QueryServiceHelper.query((String)"evp_elevouchertype", (String)"number, name", null);
        for (DynamicObject dynamicObject : typedyns) {
            namemap.put(dynamicObject.getString("number"), dynamicObject.getString("name"));
        }
        return namemap;
    }

    public static String createXBRLPath(String ticketType, JSONObject json) {
        String date = json.getString("bookdate");
        String voucherid = json.getString("voucherid");
        String seqno = json.getString("seqno");
        if (StringUtils.isNotEmpty((CharSequence)voucherid)) {
            return ticketType + SPLIT_LINE + date + SPLIT_LINE + seqno + voucherid;
        }
        return ticketType + SPLIT_LINE + date + SPLIT_LINE + seqno;
    }

    public static String createXBRLFilename(String ticketType, JSONObject json) {
        String date = json.getString("bookdate");
        String voucherid = json.getString("voucherid");
        String seqno = json.getString("seqno");
        if (BKRS.equals(ticketType)) {
            ticketType = "bkrs_receiver";
        }
        switch (ticketType) {
            case "atr_receiver": {
                seqno = json.getString("ElectronicInvoiceAirTransportReceiptNumber");
                break;
            }
            case "rai_receiver": {
                seqno = json.getString("ElectronicInvoiceRailwayETicketNumber");
                break;
            }
            case "bker_receiver": {
                seqno = json.getString("IdentifyingCode");
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)voucherid)) {
            return ticketType + SPLIT_LINE + date + SPLIT_LINE + seqno + SPLIT_LINE + voucherid + ".xml";
        }
        return ticketType + SPLIT_LINE + date + SPLIT_LINE + seqno + ".xml";
    }

    public static String createXBRLpath(String filename) {
        return filename == null ? "" : filename.split("\\.")[0];
    }

    static {
        EVTABLEMAP.put(ATR_RECEIVER, EVP_ATRRECEIVER);
        EVTABLEMAP.put(RAI_RECEIVER, EVP_RAIRECEIVER);
        EVTABLEMAP.put(BKRS, EVP_BKRS);
        EVTABLEMAP.put(BKER_RECEIVER, EVP_BKERRECEIVER);
        EVTABLEMAP.put(INV_ORD_RECEIVER, EVP_INVORDRECEIVER);
        EVTABLEMAP.put(INV_SPCL_RECEIVER, EVP_INVSPCLRECEIVER);
        EVTABLEMAP.put(INV_TLF_RECEIVER, EVP_INVTLFRECEIVER);
        EVTABLEMAP.put(EINV_ORD_RECEIVER, EVP_EINVORDRECEIVER);
        EVTABLEMAP.put(EINV_SPCL_RECEIVER, EVP_EINVSPCLRECEIVER);
        EVTABLEMAP.put(NTREV_GPM_RECEIVER, EVP_NTREVGPMRECEIVER);
        EVTABLEMAP.put(EFI, EVP_EFI);
        TICKETTYPEMAP.put(EVP_ATRRECEIVER, ATR_RECEIVER);
        TICKETTYPEMAP.put(EVP_RAIRECEIVER, RAI_RECEIVER);
        TICKETTYPEMAP.put(EVP_BKRS, BKRS);
        TICKETTYPEMAP.put(EVP_BKERRECEIVER, BKER_RECEIVER);
        TICKETTYPEMAP.put(EVP_INVORDRECEIVER, INV_ORD_RECEIVER);
        TICKETTYPEMAP.put(EVP_INVSPCLRECEIVER, INV_SPCL_RECEIVER);
        TICKETTYPEMAP.put(EVP_INVTLFRECEIVER, INV_TLF_RECEIVER);
        TICKETTYPEMAP.put(EVP_EINVORDRECEIVER, EINV_ORD_RECEIVER);
        TICKETTYPEMAP.put(EVP_EINVSPCLRECEIVER, EINV_SPCL_RECEIVER);
        TICKETTYPEMAP.put(EVP_NTREVGPMRECEIVER, NTREV_GPM_RECEIVER);
        TICKETTYPEMAP.put(EVP_EFI, EFI);
    }
}

