/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.evp.common.util.EVoucherModel;

public class EvpDapUtil {
    public static Map<String, Map<Long, Object>> getLinkUpBills(Collection<Long> ids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", ids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<String, Map<Long, Object>> map = new HashMap<String, Map<Long, Object>>(20);
        for (DynamicObject dyo : dyos) {
            Long voucherId = dyo.getLong("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(billType, value -> new HashMap()).put(sourceBillId, voucherId);
            Map sourceTypeBillIdMap = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry sourceEntry : sourceTypeBillIdMap.entrySet()) {
                String source = (String)sourceEntry.getKey();
                Set sourcebillids = (Set)sourceEntry.getValue();
                for (Long sourcebillid : sourcebillids) {
                    map.computeIfAbsent(source, value -> new HashMap()).put(sourcebillid, voucherId);
                }
            }
            Map targetTypeBillIdMap = BFTrackerServiceHelper.findTargetBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry targetEntry : targetTypeBillIdMap.entrySet()) {
                String target = (String)targetEntry.getKey();
                Set targetbillids = (Set)targetEntry.getValue();
                for (Long targetbillid : targetbillids) {
                    map.computeIfAbsent(target, value -> new HashMap()).put(targetbillid, voucherId);
                }
            }
        }
        QFilter bankQfilter1 = new QFilter("sourcebilltype", "=", (Object)"gl_voucher");
        QFilter bankQfilter2 = new QFilter("sourcebillid", "in", ids);
        DynamicObjectCollection bankdyos = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebilltype,sourcebillid,id", (QFilter[])new QFilter[]{bankQfilter1, bankQfilter2});
        for (DynamicObject dyo : bankdyos) {
            map.computeIfAbsent("cas_bankjournal", value -> new HashMap()).put(dyo.getLong("id"), dyo.getLong("sourcebillid"));
        }
        return map;
    }

    public static Map<String, Map<Long, Object>> getExtLinkUpBills(Collection<Object> voucherids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", voucherids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"evp_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<String, Map<Long, Object>> map = new HashMap<String, Map<Long, Object>>(20);
        for (DynamicObject dyo : dyos) {
            Long voucherId = dyo.getLong("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(billType, value -> new HashMap()).put(sourceBillId, voucherId);
            Map sourceTypeBillIdMap = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry sourceEntry : sourceTypeBillIdMap.entrySet()) {
                String source = (String)sourceEntry.getKey();
                Set sourcebillids = (Set)sourceEntry.getValue();
                for (Long sourcebillid : sourcebillids) {
                    map.computeIfAbsent(source, value -> new HashMap()).put(sourcebillid, voucherId);
                }
            }
            Map targetTypeBillIdMap = BFTrackerServiceHelper.findTargetBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry targetEntry : targetTypeBillIdMap.entrySet()) {
                String target = (String)targetEntry.getKey();
                Set targetbillids = (Set)targetEntry.getValue();
                for (Long targetbillid : targetbillids) {
                    map.computeIfAbsent(target, value -> new HashMap()).put(targetbillid, voucherId);
                }
            }
        }
        return map;
    }

    public static Map<Long, Object> getXhVchIdMap(Set<Object> extVchids) {
        HashMap<Long, Object> returnMap = new HashMap<Long, Object>(16);
        QFilter voucherIdf = new QFilter("voucherid", "in", extVchids);
        DataSet evpLeftDs = QueryServiceHelper.queryDataSet((String)"EvpDapUtil.getXhVchIdMap", (String)"evp_daptracker", (String)"billtype,sourcebillid,voucherid evpvid", (QFilter[])new QFilter[]{voucherIdf}, null);
        DataSet copy = evpLeftDs.copy();
        ArrayList<String> billTypes = new ArrayList<String>(16);
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        while (copy.hasNext()) {
            Row row = copy.next();
            billTypes.add(row.getString("billtype"));
            billIds.add(row.getLong("sourcebillid"));
        }
        QFilter billf = new QFilter("billtype", "in", billTypes);
        billf.and(new QFilter("sourcebillid", "in", billIds));
        DataSet airightDs = QueryServiceHelper.queryDataSet((String)"EvpDapUtil.getXhVchIdMap", (String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid aivid", (QFilter[])new QFilter[]{billf}, null);
        try (DataSet tatalDs = evpLeftDs.leftJoin(airightDs).on("billtype", "billtype").on("sourcebillid", "sourcebillid").select(new String[]{"evpvid"}, new String[]{"aivid"}).finish();){
            while (tatalDs.hasNext()) {
                Row row = tatalDs.next();
                if (row.getLong("aivid") == null) continue;
                returnMap.put(row.getLong("aivid"), row.get("evpvid"));
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, String>> getRationBill(Set<String> billids) {
        HashMap<String, Map<String, String>> returnmap = new HashMap<String, Map<String, String>>(16);
        Set<String> tables = EVoucherModel.TICKETTYPEMAP.keySet();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("isdelete", "=", (Object)"0"));
        qFilters.add(new QFilter("voucherid", "in", billids));
        for (String string : tables) {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)"EvpDapUtil.getRationBill", (String)string, (String)"id,voucherid,billid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            Throwable throwable = null;
            try {
                for (Row row : dataset) {
                    String voucherid = row.getString("voucherid");
                    String billid = row.getString("billid");
                    returnmap.computeIfAbsent(string, value -> new HashMap()).put(billid, voucherid);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        return returnmap;
    }

    public static Map<String, Map<Long, Long>> getAiMainBills(Set<Long> ids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", ids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<String, Map<Long, Long>> map = new HashMap<String, Map<Long, Long>>(20);
        for (DynamicObject dyo : dyos) {
            Long voucherId = dyo.getLong("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(billType, v -> new HashMap()).put(sourceBillId, voucherId);
        }
        return map;
    }

    public static Map<String, Map<Long, String>> getEvpMainBills(Set<String> ids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", ids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"evp_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<String, Map<Long, String>> map = new HashMap<String, Map<Long, String>>(20);
        for (DynamicObject dyo : dyos) {
            String voucherId = dyo.getString("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(billType, v -> new HashMap()).put(sourceBillId, voucherId);
        }
        return map;
    }
}

