/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.entity.Attach;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);

    public static byte[] downLoadAnyUrl(String urlstr) throws IOException {
        byte[] data = null;
        data = urlstr.startsWith("http") ? (urlstr.contains("configKey=") ? FileUtils.downLoadCacheUrl(urlstr) : FileUtils.downLoadFromUrl(urlstr)) : FileUtils.downLoadHttpsFile(urlstr);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadCacheUrl(String urlstr) throws IOException {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(urlstr);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadFromUrl(String urlstr) throws IOException {
        URL url = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        url = new URL(urlstr);
        DataInputStream dataInputStream = new DataInputStream(url.openStream());
        try {
            IOUtils.copy((InputStream)dataInputStream, (OutputStream)bos);
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return bos.toByteArray();
    }

    public static byte[] downLoadHttpsFile(String attachUrl) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        attachmentFileService.download(attachUrl, (OutputStream)outStream, null);
        return outStream.toByteArray();
    }

    public static String getOriPath(String billType) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String path = "/" + tenantId + "/" + accountId + "/" + DateFomatUtils.format(new Date(), "yyyyMMdd") + "/" + billType + "/ori/";
        return path;
    }

    public static String getXbrlPath(String billType) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String path = "/" + tenantId + "/" + accountId + "/" + DateFomatUtils.format(new Date(), "yyyyMMdd") + "/" + billType + "/xbrl/";
        return path;
    }

    public static String getAliasFileName(String originsys, Object billid, String filename) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(originsys).append("_").append(billid).append("_").append(filename).toString();
    }

    public static String uploadOriFile(byte[] pdfData, String billid, String billType, String fileName, String originsys, Object oribillid) {
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayInputStream in = new ByteArrayInputStream(pdfData);
        String extname = fileName.split("\\.").length > 1 ? fileName.split("\\.")[fileName.split("\\.").length - 1] : fileName;
        String url = "";
        String path = FileUtils.getOriPath(billType) + FileUtils.getAliasFileName(originsys, oribillid, fileName);
        try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.common.util.FileUtils");){
            try {
                FileItem fileItem = new FileItem(fileName, path, (InputStream)in);
                url = attachmentFileService.upload(fileItem);
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
                DynamicObject temp = (DynamicObject)type.createInstance();
                temp.set("fattachmentname", (Object)fileName);
                temp.set("fextname", (Object)extname);
                temp.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
                temp.set("fcreatemen", (Object)UserServiceHelper.getCurrentUserId());
                temp.set("fcreatetime", (Object)new Date());
                temp.set("fattachmentsize", (Object)pdfData.length);
                temp.set("finterid", (Object)billid);
                temp.set("fbilltype", (Object)billType);
                temp.set("ffileid", (Object)url);
                temp.set("fattachmentpanel", (Object)"attachmentpanel");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
        return url;
    }

    public static String uploadFile(byte[] pdfData, String billid, String billType, String fileName) {
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayInputStream in = new ByteArrayInputStream(pdfData);
        String extname = fileName.split("\\.").length > 1 ? fileName.split("\\.")[fileName.split("\\.").length - 1] : fileName;
        String url = "";
        String path = FileUtils.getXbrlPath(billType) + FileUtils.getAliasFileName("CURRENT", billid, fileName);
        try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.common.util.FileUtils");){
            try {
                FileItem fileItem = new FileItem(fileName, path, (InputStream)in);
                url = attachmentFileService.upload(fileItem);
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
                DynamicObject temp = (DynamicObject)type.createInstance();
                temp.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
                temp.set("fattachmentname", (Object)fileName);
                temp.set("fextname", (Object)extname);
                temp.set("fcreatemen", (Object)UserServiceHelper.getCurrentUserId());
                temp.set("fcreatetime", (Object)new Date());
                temp.set("fattachmentsize", (Object)pdfData.length);
                temp.set("finterid", (Object)billid);
                temp.set("fbilltype", (Object)billType);
                temp.set("ffileid", (Object)url);
                temp.set("fattachmentpanel", (Object)"attachmentpanel");
                temp.set("fbillstatus", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
        return url;
    }

    public static Map<String, String> getattachName(String entity, List<String> zipurls) {
        HashMap<String, String> returnmap = new HashMap<String, String>(16);
        QFilter qFilter = new QFilter("ffileid", "in", zipurls);
        QFilter qFilter1 = new QFilter("fbilltype", "=", (Object)entity);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bos_attachment", (String)"ffileid, fattachmentname", (QFilter[])new QFilter[]{qFilter, qFilter1});
        for (DynamicObject dynamicObject : dyns) {
            returnmap.put(dynamicObject.getString("ffileid"), dynamicObject.getString("fattachmentname"));
        }
        return returnmap;
    }

    public static String toBase64Str(byte[] byteArr) {
        return Base64.getEncoder().encodeToString(byteArr);
    }

    public static byte[] Base64toByte(String fileStr) {
        return Base64.getDecoder().decode(fileStr);
    }

    public static String getLastXbrlDir(String orgnumber, String taskId) {
        String property = System.getProperty("user.home");
        String dirPath = property + File.separator + "EVPDOWNLOAD" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId() + orgnumber + File.separator + taskId;
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath;
    }

    public static String getPoolDir(String pageid) {
        String property = System.getProperty("user.home");
        String dirPath = property + File.separator + "EVPPOOLLIST" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId() + File.separator + pageid;
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath;
    }

    public static String getXbrlWriteDir(String path) {
        File file = FileUtils.getFile(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    public static void writeToFile(byte[] data, String fileName) {
        if (null == data) {
            logger.error("writeToFile\u4f20\u5165\u7684\u5b57\u8282\u6570\u7ec4\u4e3anull");
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(FileUtils.getFile(fileName));){
            fos.write(data);
            fos.flush();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519\u3002", (String)"FileUtils_2", (String)"fi-evp-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    private static File getFile(String path) {
        return new File(FilenameUtils.getFullPath((String)path) + FilenameUtils.getName((String)path));
    }

    public static void zipSpecFile(String dirPath) {
        String zipName = dirPath + ".zip";
        File zipFile = FileUtils.getFile(zipName);
        File zipDir = FileUtils.getFile(dirPath);
        File[] fileList = zipDir.listFiles();
        if (null != fileList && fileList.length > 0) {
            try {
                FileUtils.zipFiles(fileList, zipFile);
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
        } else {
            logger.info(String.format("\u538b\u7f29\u7684\u76ee\u6807\u6587\u4ef6\u5939\u4e3a\u7a7a\uff0c%s", dirPath));
        }
        FileUtils.deleteFile(dirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFiles(File[] srcFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                if (!zipFile.createNewFile()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6%s\u4e0d\u5408\u6cd5\u3002", (String)"FileUtils_3", (String)"fi-evp-common", (Object[])new Object[0]), zipFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (File srcFile : srcFiles) {
                try (FileInputStream fileInputStream = new FileInputStream(srcFile);){
                    int len;
                    ZipEntry zipEntry = new ZipEntry(srcFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buffer = new byte[1024];
                    while ((len = fileInputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                    zipOutputStream.closeEntry();
                }
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void deleteFile(String deletePath) {
        File file = FileUtils.getFile(deletePath);
        if (file.exists()) {
            FileUtils.deleteKd(file);
        }
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-evp-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        } else if (file.isDirectory()) {
            File[] fileList;
            for (File delfile : fileList = file.listFiles()) {
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-evp-common", (Object[])new Object[0]), file.getAbsolutePath()));
                }
                if (!delfile.isDirectory()) continue;
                FileUtils.deleteKd(delfile);
            }
            if (!file.delete()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-evp-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        }
    }

    public static Map<String, String> exportPool(String pageid) {
        HashMap<String, String> exportResult = new HashMap<String, String>();
        String zipFilePath = System.getProperty("user.home") + File.separator + "EVPPOOLLIST" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId() + File.separator + "receiver_" + DateFomatUtils.getDateString(new Date(), "yyyyMMddHHmmssSSS") + ".zip";
        File zipFile = FileUtils.getFile(zipFilePath);
        String zipDirPath = FileUtils.getPoolDir(pageid);
        File zipDir = FileUtils.getFile(zipDirPath);
        File[] fileList = zipDir.listFiles();
        logger.info("exportPool filelistsize : {}", (Object)fileList.length);
        if (null == fileList || fileList.length == 0) {
            logger.info(String.format("\u5bfc\u51fa\u7684\u6587\u4ef6\u4e3a\u7a7a\uff0c%s", zipDirPath));
            FileUtils.deleteFile(zipDirPath);
            return exportResult;
        }
        try {
            FileUtils.zipFiles(fileList, zipFile);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        if (zipFile.exists()) {
            exportResult.put("fileName", zipFile.getPath());
        }
        FileUtils.deleteFile(zipDirPath);
        logger.info("\u6587\u4ef6\u538b\u7f29\u7ed3\u679c{}", (Object)SerializationUtils.toJsonString(exportResult));
        return exportResult;
    }

    public static Map<String, String> exportNew(String orgnumber, String taskId) {
        HashMap<String, String> exportResult = new HashMap<String, String>();
        String zipFilePath = System.getProperty("user.home") + File.separator + "EVPDOWNLOAD" + File.separator + "receiver_" + orgnumber + "_" + System.currentTimeMillis() + ".zip";
        File zipFile = FileUtils.getFile(zipFilePath);
        String zipDirPath = FileUtils.getLastXbrlDir(orgnumber, taskId);
        File zipDir = FileUtils.getFile(zipDirPath);
        File[] fileList = zipDir.listFiles();
        logger.info("exportNew filelistsize : {}", (Object)fileList.length);
        if (null == fileList || fileList.length == 0) {
            logger.info(String.format("\u5bfc\u51fa\u7684\u6587\u4ef6\u4e3a\u7a7a\uff0c%s", zipDirPath));
            FileUtils.deleteFile(zipDirPath);
            return exportResult;
        }
        try {
            FileUtils.zipFiles(fileList, zipFile);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        if (zipFile.exists()) {
            exportResult.put("fileName", zipFile.getPath());
        }
        FileUtils.deleteFile(zipDirPath);
        logger.info("\u6587\u4ef6\u538b\u7f29\u7ed3\u679c{}", (Object)SerializationUtils.toJsonString(exportResult));
        return exportResult;
    }

    public static String getName(String path) {
        return FilenameUtils.getName((String)path);
    }

    public static String saveAsUrl(InputStream in, String fileName) {
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 5000);
    }

    public static Map<Long, List<Attach>> getIdAndAttacheFiles(String billType, Set<Long> ids) {
        HashMap<Long, List<Attach>> map = new HashMap<Long, List<Attach>>();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("fbilltype", "=", (Object)billType));
        qfilters.add(new QFilter("finterid", "in", ids.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "FileUtils.getIdAndAttaches";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_attachment", (String)"fextname,fbilltype,ffileid,finterid,fattachmentname", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"finterid");){
            for (Row row : dataSet) {
                Long id = row.getLong("finterid");
                Attach attach = new Attach();
                attach.setBillId(id);
                attach.setBillType(billType);
                attach.setExtName(row.getString("fextname"));
                attach.setFileName(row.getString("fattachmentname"));
                attach.setUrl(row.getString("ffileid"));
                map.computeIfAbsent(id, value -> new ArrayList()).add(attach);
            }
        }
        return map;
    }
}

