/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.ObjectConverter;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtil.newHashMap(16);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapUtil.newHashMap(16, isLinked);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return MapUtil.newTreeMap(null, comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtil.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static String getStr(Map<?, ?> map, Object key) {
        return MapUtil.getStr(map, key, null);
    }

    public static String getStr(Map<?, ?> map, Object key, String devVal) {
        Object val = MapUtil.checkAndGet(map, key);
        if (val == null) {
            return devVal;
        }
        return val.toString();
    }

    public static Long getLong(Map<?, ?> map, Object key) {
        Object val = MapUtil.checkAndGet(map, key);
        if (val == null) {
            return null;
        }
        return (Long)ObjectConverter.convert((Object)val, Long.class, (boolean)false);
    }

    public static Date getDate(Map<?, ?> map, Object key) {
        Object val = MapUtil.checkAndGet(map, key);
        if (val == null) {
            return null;
        }
        return (Date)ObjectConverter.convert((Object)val, Date.class, (boolean)false);
    }

    private static Object checkAndGet(Map<?, ?> map, Object key) {
        if (map == null) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        return val;
    }
}

