/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.evp.entity.FieldAttr;

public class ReportUtil {
    public static List<Tuple<String, ReportColumnGroup>> getColumnGroup(Collection<String> groupNameSet) {
        ArrayList<Tuple<String, ReportColumnGroup>> groupMap = new ArrayList<Tuple<String, ReportColumnGroup>>(groupNameSet.size());
        int index = 1;
        for (String groupName : groupNameSet) {
            ReportColumnGroup col = new ReportColumnGroup();
            col.setCaption(new LocaleString(groupName));
            col.setFieldKey("grpcontainer" + index++);
            groupMap.add((Tuple<String, ReportColumnGroup>)Tuple.create((Object)groupName, (Object)col));
        }
        return groupMap;
    }

    public static ReportColumn getColumn(String localeString, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(localeString));
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    public static ReportColumn getAmountColumn(String localeString, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(localeString));
        column.setFieldKey(fieldKey);
        column.setFieldType("amount");
        column.setCurrencyField("currency");
        return column;
    }

    private static void addColumnToGroup(List<AbstractReportColumn> columns, ReportColumnGroup group, ReportColumn column) {
        if (group == null) {
            columns.add((AbstractReportColumn)column);
        } else {
            group.getChildren().add(column);
        }
    }

    public static String getNumberPrefixByType(String qType) {
        List<String> lists = Arrays.asList("evp_invordreceiver", "evp_invspclreceiver", "evp_invtlfreceiver", "evp_einvordreceiver", "evp_einvspclreceiver");
        String prefix = lists.contains(qType) ? qType.split("_")[1].substring(0, 5) : qType.split("_")[1].substring(0, 3);
        return prefix.toUpperCase();
    }

    public static String getNumberFieldExpr(String qType) {
        return String.format("concat('%s',%s)", ReportUtil.getNumberPrefixByType(qType), "id");
    }

    public static void buildOriVoiceSelect(List<String> fieldList, String qType) {
        QFilter evFilter1 = new QFilter("number", "=", (Object)qType);
        ArrayList<FieldAttr> fieldAttrs = new ArrayList<FieldAttr>(12);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"evp_elevouchertype", (QFilter[])new QFilter[]{evFilter1});
        DynamicObjectCollection dyns = (DynamicObjectCollection)dynamicObject.get("fieldentity");
        for (DynamicObject dObject : dyns) {
            FieldAttr fieldAttr = new FieldAttr();
            fieldAttr.setFieldname(dObject.getString("fieldname"));
            fieldAttr.setFieldnumber(dObject.getString("fieldnumber"));
            fieldAttr.setGbname(dObject.getString("gbname"));
            fieldAttr.setGbnumber(dObject.getString("gbnumber"));
            fieldAttr.setFieldtype(dObject.getString("fieldtype"));
            fieldAttrs.add(fieldAttr);
        }
        for (FieldAttr fieldAttr : fieldAttrs) {
            if ("3".equals(fieldAttr.getFieldtype())) continue;
            fieldList.add(fieldAttr.getFieldnumber());
        }
    }

    public static void buildOriVoiceSelectFromConfig(List<String> fieldList, String qType, boolean isevppoolpage) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"evp_elevouchertype", (QFilter[])new QFilter("number", "=", (Object)qType).toArray());
        if (dynamicObject != null) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("fieldentity");
            for (DynamicObject entry : entrys) {
                String field;
                String displayprop;
                String fieldnumber;
                String fieldtype;
                if (isevppoolpage && entry.getBoolean("isvisibleevp")) {
                    fieldtype = entry.getString("fieldtype");
                    fieldnumber = entry.getString("fieldnumber");
                    if ("3".equals(fieldtype)) {
                        displayprop = entry.getString("displayprop");
                        field = ReportUtil.getField(fieldnumber, displayprop);
                        if ("currency".equals(fieldnumber)) {
                            field = fieldnumber;
                        }
                        if (fieldList.contains(field.split(" ")[field.split(" ").length - 1])) continue;
                        fieldList.add(field);
                        continue;
                    }
                    if (fieldList.contains(fieldnumber)) continue;
                    fieldList.add(fieldnumber);
                    continue;
                }
                if (!entry.getBoolean("isvisibleorigin")) continue;
                fieldtype = entry.getString("fieldtype");
                fieldnumber = entry.getString("fieldnumber");
                if ("3".equals(fieldtype)) {
                    displayprop = entry.getString("displayprop");
                    field = ReportUtil.getField(fieldnumber, displayprop);
                    if ("currency".equals(fieldnumber)) {
                        field = fieldnumber;
                    }
                    if (fieldList.contains(field.split(" ")[field.split(" ").length - 1])) continue;
                    fieldList.add(field);
                    continue;
                }
                if (fieldList.contains(fieldnumber)) continue;
                fieldList.add(fieldnumber);
            }
        }
    }

    private static String getField(String fieldnumber, String displayprop) {
        String field = fieldnumber + ".name " + fieldnumber;
        switch (displayprop) {
            case "1": {
                field = fieldnumber + ".number " + fieldnumber;
                break;
            }
            case "3": {
                field = String.format("%s as %s", String.format("concat(%s,%s)", fieldnumber + ".name", fieldnumber + ".number"), fieldnumber);
                break;
            }
        }
        return field;
    }

    public static void createColumnFromConfig(String qType, List<AbstractReportColumn> columns, boolean isevppoolpage) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"evp_elevouchertype", (QFilter[])new QFilter("number", "=", (Object)qType).toArray());
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)qType, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (dynamicObject != null) {
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("fieldentity");
            List usedEntries = entries.stream().filter(r -> isevppoolpage ? r.getBoolean("isvisibleevp") : r.getBoolean("isvisibleorigin")).collect(Collectors.toList());
            List sortedEntries = usedEntries.stream().sorted(Comparator.comparing(r -> r.getInt("seq"))).collect(Collectors.toList());
            Set<String> allFieldNumberSet = sortedEntries.stream().map(dyn -> dyn.getString("fieldnumber")).collect(Collectors.toSet());
            FiledModel filedModel = ReportUtil.getFiledModel(formMeta, allFieldNumberSet);
            Map<String, String> fieldNumber2GroupNameMap = filedModel.getFieldNumber2GroupNameMap();
            Map<String, String> fieldNumber2FieldNameMap = filedModel.getFieldNumber2FieldNameMap();
            ArrayList<String> fieldGroups = new ArrayList<String>(2);
            HashMap<String, Integer> fieldGroupFieldCntMap = new HashMap<String, Integer>(8);
            for (DynamicObject row : sortedEntries) {
                String fieldNumber = row.getString("fieldnumber");
                String groupName = fieldNumber2GroupNameMap.get(fieldNumber);
                if (StringUtils.isEmpty((CharSequence)groupName)) continue;
                if (fieldGroups.contains(groupName)) {
                    Integer cnt = (Integer)fieldGroupFieldCntMap.get(groupName);
                    fieldGroupFieldCntMap.put(groupName, cnt + 1);
                    continue;
                }
                fieldGroups.add(groupName);
                fieldGroupFieldCntMap.put(groupName, 1);
            }
            List<Tuple<String, ReportColumnGroup>> fieldGroupColList = ReportUtil.getColumnGroup(fieldGroups);
            List colGroups = fieldGroupColList.stream().map(tp -> (ReportColumnGroup)tp.item2).collect(Collectors.toList());
            Map<String, ReportColumnGroup> fieldGroupColMap = fieldGroupColList.stream().collect(Collectors.toMap(grp -> (String)grp.item1, grp -> (ReportColumnGroup)grp.item2));
            columns.addAll(colGroups);
            for (DynamicObject entry : usedEntries) {
                String fieldtype;
                String fieldNumber = entry.getString("fieldnumber");
                String fieldName = fieldNumber2FieldNameMap.get(fieldNumber) == null ? "" : fieldNumber2FieldNameMap.get(fieldNumber);
                String groupName = fieldNumber2GroupNameMap.get(fieldNumber) == null ? "" : fieldNumber2GroupNameMap.get(fieldNumber);
                int fieldCnt = fieldGroupFieldCntMap.get(groupName) == null ? 0 : (Integer)fieldGroupFieldCntMap.get(groupName);
                ReportColumnGroup receiptStatusGroup = null;
                if (StringUtils.isNotEmpty((CharSequence)groupName) && fieldCnt > 1) {
                    receiptStatusGroup = fieldGroupColMap.get(groupName);
                }
                if (isevppoolpage && entry.getBoolean("isvisibleevp")) {
                    fieldtype = entry.getString("fieldtype");
                    if ("2".equals(fieldtype)) {
                        ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getAmountColumn(fieldName, fieldNumber));
                        continue;
                    }
                    if ("currency".equals(fieldNumber)) {
                        ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getColumn(fieldName, fieldNumber, "currency"));
                        continue;
                    }
                    ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getColumn(fieldName, fieldNumber, ReportUtil.getFieldType(fieldtype)));
                    continue;
                }
                if (!entry.getBoolean("isvisibleorigin")) continue;
                fieldtype = entry.getString("fieldtype");
                if ("2".equals(fieldtype)) {
                    ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getAmountColumn(fieldName, fieldNumber));
                    continue;
                }
                if ("currency".equals(fieldNumber)) {
                    ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getColumn(fieldName, fieldNumber, "currency"));
                    continue;
                }
                ReportUtil.addColumnToGroup(columns, receiptStatusGroup, ReportUtil.getColumn(fieldName, fieldNumber, ReportUtil.getFieldType(fieldtype)));
            }
        }
    }

    public static FiledModel getFiledModel(FormMetadata formMeta, Set<String> allFieldNumberSet) {
        HashMap<String, String> fieldNumber2GroupNameMap = new HashMap<String, String>(allFieldNumberSet.size());
        HashMap<String, String> fieldNumber2FieldNameMap = new HashMap<String, String>(allFieldNumberSet.size());
        FiledModel filedModel = new FiledModel();
        for (ControlAp ctl : formMeta.getItems()) {
            if (!allFieldNumberSet.contains(ctl.getKey())) continue;
            String parentCtlId = ctl.getParentId();
            ControlAp parentCtl = formMeta.getItem(parentCtlId);
            if (Objects.nonNull(parentCtl)) {
                fieldNumber2GroupNameMap.put(ctl.getKey(), parentCtl.getName().getLocaleValue());
            }
            fieldNumber2FieldNameMap.put(ctl.getKey(), ctl.getName().getLocaleValue());
        }
        filedModel.setFieldNumber2FieldNameMap(fieldNumber2FieldNameMap);
        filedModel.setFieldNumber2GroupNameMap(fieldNumber2GroupNameMap);
        return filedModel;
    }

    private static String getFieldType(String fieldtype) {
        String field = "text";
        switch (fieldtype) {
            case "3": 
            case "1": {
                field = "text";
                break;
            }
            case "4": {
                field = "checkbox";
                break;
            }
            case "5": {
                field = "date";
                break;
            }
        }
        return field;
    }

    public static class FiledModel {
        private Map<String, String> fieldNumber2GroupNameMap;
        private Map<String, String> fieldNumber2FieldNameMap;

        public Map<String, String> getFieldNumber2GroupNameMap() {
            return this.fieldNumber2GroupNameMap;
        }

        public void setFieldNumber2GroupNameMap(Map<String, String> fieldNumber2GroupNameMap) {
            this.fieldNumber2GroupNameMap = fieldNumber2GroupNameMap;
        }

        public Map<String, String> getFieldNumber2FieldNameMap() {
            return this.fieldNumber2FieldNameMap;
        }

        public void setFieldNumber2FieldNameMap(Map<String, String> fieldNumber2FieldNameMap) {
            this.fieldNumber2FieldNameMap = fieldNumber2FieldNameMap;
        }
    }
}

