/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.engine;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.common.cache.CacheHelper;
import kd.fi.evp.common.cache.CacheModule;
import kd.fi.evp.common.cache.DistributeCache;
import kd.fi.evp.common.util.ArchiveUtils;
import kd.fi.evp.entity.ArchiveLogVo;
import kd.fi.evp.entity.ExecResult;

public class ArchiveEngineImpl
implements Callable<ExecResult> {
    private static final Log logger = LogFactory.getLog(ArchiveEngineImpl.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.export);
    public static final int BATCHNUM = 1000;
    private ExecResult execResult = new ExecResult();
    private ArchiveLogVo archiveLogVo;

    public ArchiveEngineImpl(ArchiveLogVo logVo) {
        this.archiveLogVo = logVo;
    }

    @Override
    public ExecResult call() {
        this.setEntry();
        if (!this.execResult.getIsSuccess().booleanValue()) {
            this.cache.put(this.archiveLogVo.getPageId() + "errorMsg", this.execResult.getErrMsg());
        } else {
            this.cache.put(this.archiveLogVo.getPageId() + "allcount", Integer.toString(this.execResult.getSuccessCnt()));
        }
        return this.execResult;
    }

    private void setEntry() {
        Map<String, List<Object>> invoicemap = this.archiveLogVo.getInvoicemap();
        int allcount = 0;
        try {
            for (Map.Entry<String, List<Object>> entry : invoicemap.entrySet()) {
                String entityname = entry.getKey();
                List<Object> pks = entry.getValue();
                List<List<Object>> lists = ArchiveUtils.spiltData(pks, 1000);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isfrompage", "1");
                operateOption.setVariableValue("archivelogid", Long.toString(this.archiveLogVo.getCurrentid()));
                operateOption.setVariableValue("pageid", this.archiveLogVo.getPageId());
                for (List<Object> list : lists) {
                    DynamicObject[] dyns = ArchiveUtils.notArchiveDyns(entityname, list);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"evparchive", (String)entityname, (DynamicObject[])dyns, (OperateOption)operateOption);
                    allcount += result.getSuccessPkIds().size();
                }
            }
            this.execResult.setSuccessCnt(allcount);
        }
        catch (Exception e) {
            this.execResult.setIsSuccess(false);
            this.execResult.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

