/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.engine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.common.cache.CacheHelper;
import kd.fi.evp.common.cache.CacheModule;
import kd.fi.evp.common.cache.DistributeCache;
import kd.fi.evp.common.util.BuildFileUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.FileUtils;
import kd.fi.evp.entity.ExecResult;
import kd.fi.evp.entity.ExportTaskVo;
import kd.fi.evp.entity.OriginBillVo;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class BuildEvoucherEngineImpl
implements Callable<ExecResult> {
    private static final Log logger = LogFactory.getLog(BuildEvoucherEngineImpl.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.export);
    private static final String ENTITY = "evp_exporttask";
    private ExecResult execResult = new ExecResult();
    private DynamicObject dynamicObject;
    private ExportTaskVo exportTaskVo;

    public BuildEvoucherEngineImpl(ExportTaskVo exportVo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY);
        this.dynamicObject = (DynamicObject)type.createInstance();
        this.exportTaskVo = exportVo;
    }

    @Override
    public ExecResult call() {
        this.setEntry(this.dynamicObject, this.exportTaskVo);
        if (!this.execResult.getIsSuccess().booleanValue()) {
            this.cache.put(this.exportTaskVo.getPageid() + "errorMsg", this.exportTaskVo.getFailreason());
        }
        return this.execResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setEntry(DynamicObject temp, ExportTaskVo taskVo) {
        BufferedInputStream bufferedInputStream;
        InputStream inputStream;
        InputStream in;
        String filePath;
        block41: {
            String orgnumber;
            block40: {
                taskVo.setStatus("1");
                DynamicObject orgdyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"uniformsocialcreditcode,number", (QFilter[])new QFilter("id", "=", (Object)taskVo.getOrg()).toArray());
                orgnumber = orgdyn.getString("uniformsocialcreditcode");
                if (StringUtils.isBlank((CharSequence)orgnumber)) {
                    orgnumber = orgdyn.getString("number");
                }
                String lastDir = FileUtils.getLastXbrlDir(orgnumber, taskVo.getNumber());
                try {
                    if (taskVo.getBkrsnum() != null && taskVo.getBkrsnum() > 0) {
                        String entityname = "evp_bkrs";
                        Map<Object, OriginBillVo> urlMap = BuildFileUtils.getXbrlurls(entityname, taskVo.getBkrsids());
                        List list = urlMap.values().stream().map(o -> o.getXbrlurl()).collect(Collectors.toList());
                        ArrayList<String> allurls = new ArrayList<String>(16);
                        allurls.addAll(list);
                        Map<String, String> filenamemap = FileUtils.getattachName("evp_bkrs", allurls);
                        for (Map.Entry entry : urlMap.entrySet()) {
                            OriginBillVo originBillVo = (OriginBillVo)entry.getValue();
                            if (StringUtils.isEmpty((CharSequence)originBillVo.getXbrlurl())) {
                                logger.error("xbrlurl_is_empty. billtype: {}, billid:{}", (Object)entityname, originBillVo.getBillid());
                                continue;
                            }
                            String xbrlName = filenamemap.get(originBillVo.getXbrlurl());
                            String fullurl = FileUtils.getXbrlWriteDir(lastDir + File.separator + EVoucherModel.createXBRLpath(xbrlName));
                            byte[] xbrlbytes = FileUtils.downLoadHttpsFile(originBillVo.getXbrlurl());
                            FileUtils.writeToFile(xbrlbytes, fullurl + File.separator + xbrlName);
                            FileUtils.zipSpecFile(lastDir + File.separator + EVoucherModel.createXBRLpath(xbrlName));
                        }
                        break block40;
                    }
                    Map<String, Map<Object, Object>> invoicemap = taskVo.getInvoicemap();
                    for (Map.Entry entry : invoicemap.entrySet()) {
                        String entityname = (String)entry.getKey();
                        Map invoiceVoucherMap = (Map)entry.getValue();
                        Map<Object, OriginBillVo> urlMap = BuildFileUtils.getXbrlurls(entityname, invoiceVoucherMap.keySet());
                        List<String> xbrlurls = urlMap.values().stream().map(o -> o.getXbrlurl()).collect(Collectors.toList());
                        List<String> fileurls = urlMap.values().stream().map(o -> o.getFileurl()).collect(Collectors.toList());
                        Map<String, String> xbrlnamemap = FileUtils.getattachName(entityname, xbrlurls);
                        Map<String, String> filenamemap = FileUtils.getattachName(entityname, fileurls);
                        if (xbrlnamemap.size() == 0) {
                            String err = "taskid :" + taskVo.getNumber() + " xbrlfile not exist";
                            logger.error(err);
                            this.execResult.setIsSuccess(false);
                            this.execResult.setErrMsg(err);
                            return;
                        }
                        for (Map.Entry<Object, OriginBillVo> entry2 : urlMap.entrySet()) {
                            byte[] filebytes;
                            Object billid = entry2.getKey();
                            OriginBillVo originBillVo = entry2.getValue();
                            if (StringUtils.isEmpty((CharSequence)originBillVo.getXbrlurl())) {
                                logger.error("xbrl_is_empty. billtype: {}, billid:{}", (Object)entityname, originBillVo.getBillid());
                                continue;
                            }
                            byte[] xbrlbytes = null;
                            try {
                                xbrlbytes = FileUtils.downLoadHttpsFile(originBillVo.getXbrlurl());
                            }
                            catch (Exception e) {
                                logger.error("xbrl_not_exist. billtype: {}, billid:{}, xbrl:{}", new Object[]{entityname, originBillVo.getBillid(), originBillVo.getXbrlurl()});
                                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                                this.execResult.setIsSuccess(false);
                                this.execResult.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                                continue;
                            }
                            String xbrlName = xbrlnamemap.get(originBillVo.getXbrlurl());
                            if (StringUtils.isBlank((CharSequence)xbrlName)) {
                                logger.error("xbrl not exist. billtype: {} billid:{}", (Object)entityname, originBillVo.getBillid());
                                continue;
                            }
                            String fullurl = FileUtils.getXbrlWriteDir(lastDir + File.separator + EVoucherModel.createXBRLpath(xbrlName));
                            FileUtils.writeToFile(xbrlbytes, fullurl + File.separator + xbrlName);
                            String fileurl = originBillVo.getFileurl();
                            String filename = filenamemap.get(fileurl);
                            if (StringUtils.isNotEmpty((CharSequence)fileurl) && (filebytes = FileUtils.downLoadHttpsFile(fileurl)) != null && filebytes.length > 0) {
                                FileUtils.writeToFile(filebytes, fullurl + File.separator + filename);
                                if (StringUtils.isNotEmpty((CharSequence)filename)) {
                                    String issuerFilename = fullurl + File.separator + xbrlName.replace("receiver", "issuer");
                                    if ("evp_efi".equals(entityname)) {
                                        issuerFilename = issuerFilename.replace("efi", "efi_issuer");
                                    }
                                    try {
                                        BuildFileUtils.extractXBRL(fullurl + File.separator + filename, issuerFilename);
                                    }
                                    catch (Throwable t) {
                                        logger.error(fullurl + File.separator + filename, t);
                                    }
                                    logger.info("issuername : {}", (Object)issuerFilename);
                                    FileUtils.deleteFile(fullurl + File.separator + filename);
                                }
                            }
                            FileUtils.zipSpecFile(lastDir + File.separator + EVoucherModel.createXBRLpath(xbrlName));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    this.execResult.setIsSuccess(false);
                    this.execResult.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    return;
                }
            }
            filePath = "";
            in = null;
            inputStream = null;
            try {
                Long logid = BuildEvoucherEngineImpl.saveTaskDyn(temp, taskVo);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)logid, (String)ENTITY);
                Map<String, String> result = FileUtils.exportNew(orgnumber, taskVo.getNumber());
                filePath = result.get("fileName");
                File file = new File(filePath);
                in = new BufferedInputStream(new FileInputStream(file));
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] bytes = IOUtils.toByteArray((InputStream)bufferedInputStream);
                String url = FileUtils.uploadFile(bytes, dynamicObject.getString("id"), ENTITY, FilenameUtils.getName((String)filePath));
                dynamicObject.set("zipurl", (Object)url);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                TempFileCache filecache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String tempurl = filecache.saveAsUrl(FilenameUtils.getName((String)filePath), in, 12000);
                if (this.cache.get(taskVo.getPageid() + "ziplist") != null) {
                    String listjson = this.cache.get(taskVo.getPageid() + "ziplist");
                    List ziplist = SerializationUtils.fromJsonStringToList((String)listjson, String.class);
                    ziplist.add(tempurl);
                    this.cache.put(taskVo.getPageid() + "ziplist", SerializationUtils.toJsonString((Object)ziplist));
                } else {
                    ArrayList<String> ziplist = new ArrayList<String>(16);
                    ziplist.add(tempurl);
                    this.cache.put(taskVo.getPageid() + "ziplist", SerializationUtils.toJsonString(ziplist));
                }
                if (in == null) break block41;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                temp.set("status", (Object)"0");
                String err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                err = err.length() > 500 ? err.substring(0, 500) : err;
                temp.set("failreason", (Object)err);
                SaveServiceHelper.update((DynamicObject)temp);
                this.execResult.setIsSuccess(false);
                this.execResult.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                return;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        if (bufferedInputStream != null) {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        FileUtils.deleteFile(filePath);
        return;
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            FileUtils.deleteFile(filePath);
        }
    }

    private static Long saveTaskDyn(DynamicObject temp, ExportTaskVo taskVo) {
        temp.set("createtime", (Object)taskVo.getCreatetime());
        temp.set("creator", (Object)taskVo.getCreator());
        temp.set("status", (Object)taskVo.getStatus());
        if (taskVo.getFailreason() != null) {
            temp.set("failreason", (Object)(taskVo.getFailreason().length() > 500 ? taskVo.getFailreason().substring(0, 500) : taskVo.getFailreason()));
        }
        temp.set("number", (Object)taskVo.getNumber());
        temp.set("org", (Object)taskVo.getOrg());
        temp.set("zipurl", (Object)taskVo.getZipurl());
        if (taskVo.getBkrsnum() != null && taskVo.getBkrsnum() > 0) {
            temp.set("booktype", (Object)taskVo.getRecondate());
            temp.set("bkrsnum", (Object)taskVo.getBkrsnum());
            temp.set("bookdate", (Object)taskVo.getBookdate());
        } else {
            temp.set("booktype", (Object)taskVo.getBooktype());
            temp.set("period", (Object)taskVo.getPeriod());
            temp.set("vouchernum", (Object)taskVo.getVouchernum());
            temp.set("einvspclnum", (Object)taskVo.getEinvspclnum());
            temp.set("einvordnum", (Object)taskVo.getEinvordnum());
            temp.set("invspclnum", (Object)taskVo.getInvspclnum());
            temp.set("invordnum", (Object)taskVo.getInvordnum());
            temp.set("invtlnum", (Object)taskVo.getInvtlnum());
            temp.set("ntrenum", (Object)taskVo.getNtrenum());
            temp.set("efinum", (Object)taskVo.getEfinum());
            temp.set("rainum", (Object)taskVo.getRainum());
            temp.set("atrnum", (Object)taskVo.getAtrnum());
            temp.set("bkernum", (Object)taskVo.getBkernum());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
        return temp.getLong("id");
    }
}

