/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.execlog;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.evp.common.entity.AccountBookInfo;

public class PullDataLogServiceHelper {
    private static Log logger = LogFactory.getLog(PullDataLogServiceHelper.class);
    private static final String ENTITY = "evp_pulldata_log";
    private static final String ENTITY_DETAIL = "evp_pulldata_logdetail";

    public static DynamicObject createTaskLog(String opName, RequestContext context, TaskInfo taskInfo, AccountBookInfo bookInfo, String periodNumber, String periodName, Date pstartdate, Date penddate) {
        DynamicObject logEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
        logEntity.set("username", (Object)context.getUserName());
        logEntity.set("opname", (Object)opName);
        logEntity.set("opdesc", (Object)opName);
        logEntity.set("opdate", (Object)taskInfo.getDispachTime());
        logEntity.set("orgnumber", (Object)bookInfo.getOrgNumber());
        logEntity.set("orgname", (Object)bookInfo.getOrgName());
        logEntity.set("periodnumber", (Object)periodNumber);
        logEntity.set("periodname", (Object)periodName);
        logEntity.set("booktype", (Object)bookInfo.getBookTypeName());
        logEntity.set("pstartdate", (Object)pstartdate);
        logEntity.set("penddate", (Object)penddate);
        logEntity.set("starttime", (Object)new Date());
        logEntity.set("batchcode", (Object)taskInfo.getId());
        logEntity.set("execstatus", (Object)"2");
        return PullDataLogServiceHelper.commitWithTx(() -> {
            LogORM.create().insert(Collections.singletonList(logEntity));
            return logEntity;
        });
    }

    public static void successFinishTask(DynamicObject logEntity, int pullDataCnt) {
        if (logEntity == null) {
            return;
        }
        logEntity.set("execstatus", (Object)"3");
        logEntity.set("endtime", (Object)new Date());
        logEntity.set("pulldatacnt", (Object)pullDataCnt);
        LogORM.create().update(Collections.singletonList(logEntity));
    }

    public static void failFinishTask(DynamicObject logEntity, String errorMsg) {
        if (logEntity == null) {
            return;
        }
        logEntity.set("execstatus", (Object)"4");
        logEntity.set("endtime", (Object)new Date());
        logEntity.set("errormsg", (Object)(errorMsg.length() > 1000 ? errorMsg.substring(0, 1000) : errorMsg));
        PullDataLogServiceHelper.commitWithTx(() -> {
            LogORM.create().update(Collections.singletonList(logEntity));
            return logEntity;
        });
    }

    public static DynamicObject createDetailLog(String batchNo, long logId, int taskSeq, String billType) {
        DynamicObject logEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_DETAIL);
        logEntity.set("logid", (Object)logId);
        logEntity.set("batchcode", (Object)batchNo);
        logEntity.set("taskseq", (Object)taskSeq);
        logEntity.set("billtype", (Object)billType);
        logEntity.set("starttime", (Object)new Date());
        logEntity.set("execstatus", (Object)"2");
        return PullDataLogServiceHelper.commitWithTx(() -> {
            LogORM.create().insert(Collections.singletonList(logEntity));
            return logEntity;
        });
    }

    public static void successFinishDetail(DynamicObject detailLog, int pullDataCnt, Set<String> evpBillTypes) {
        if (detailLog == null) {
            return;
        }
        detailLog.set("execstatus", (Object)"3");
        detailLog.set("endtime", (Object)new Date());
        detailLog.set("pulldatacnt", (Object)pullDataCnt);
        if (!CollectionUtils.isEmpty(evpBillTypes)) {
            String types = String.join((CharSequence)",", evpBillTypes);
            String billtypename = types.length() > 80 ? types.substring(0, 80) : types;
            detailLog.set("billtypename", (Object)billtypename);
        }
        PullDataLogServiceHelper.commitWithTx(() -> {
            LogORM.create().update(Collections.singletonList(detailLog));
            return detailLog;
        });
    }

    public static void failFinishDetail(DynamicObject detailLog, Set<String> evpBillTypes, String errorMsg) {
        if (detailLog == null) {
            return;
        }
        detailLog.set("execstatus", (Object)"4");
        if (!CollectionUtils.isEmpty(evpBillTypes)) {
            String types = String.join((CharSequence)",", evpBillTypes);
            String billtypename = types.length() > 80 ? types.substring(0, 80) : types;
            detailLog.set("billtypename", (Object)billtypename);
        }
        detailLog.set("endtime", (Object)new Date());
        detailLog.set("errormsg", (Object)(errorMsg.length() > 1000 ? errorMsg.substring(0, 1000) : errorMsg));
        PullDataLogServiceHelper.commitWithTx(() -> {
            LogORM.create().update(Collections.singletonList(detailLog));
            return detailLog;
        });
    }

    private static DynamicObject commitWithTx(Supplier<DynamicObject> run) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject dynamicObject = run.get();
            return dynamicObject;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return null;
    }
}

