/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.business.execlog.PullDataLogServiceHelper;
import kd.fi.evp.business.task.extractdata.AbstractExtractBillTask;
import kd.fi.evp.business.task.extractdata.ExtractDataService;
import kd.fi.evp.common.entity.AccountBookInfo;
import kd.fi.evp.common.util.AccountingSysUtil;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.MapUtil;
import kd.fi.evp.common.util.SysConfigUtil;

public class ExtractDataFormTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ExtractDataFormTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u62bd\u53d6\u4efb\u52a1,taskID={},params={}", (Object)this.taskId, (Object)SerializationUtils.toJsonString(params));
        List orgIds = (List)params.get("orgIds");
        if (orgIds == null || orgIds.size() == 0) {
            return;
        }
        String evpBillType = MapUtil.getStr(params, (Object)"evpBillType");
        if (StringUtils.isEmpty((CharSequence)evpBillType)) {
            return;
        }
        String pulldata = SysConfigUtil.getString((String)"pulldata");
        if ("C".equals(pulldata)) {
            logger.info("\u7cfb\u7edf\u672a\u5f00\u542f\u62bd\u53d6\u6570\u636e\u529f\u80fd");
            return;
        }
        DynamicObject[] orgList = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds)});
        Map<Long, DynamicObject> orgNameMap = Arrays.stream(orgList).collect(Collectors.toMap(org -> org.getLong("id"), org -> org));
        String filterType = MapUtil.getStr(params, (Object)"filterType");
        if ("period".equals(filterType)) {
            this.pullDataByPeriod(context, params, orgIds, evpBillType, pulldata, orgNameMap);
        } else {
            this.pullDataByDate(context, params, orgIds, evpBillType, pulldata, orgNameMap);
        }
    }

    private void pullDataByDate(RequestContext context, Map<String, Object> params, List<Object> orgIds, String evpBillType, Object pulldataType, Map<Long, DynamicObject> orgNameMap) {
        Date startDate = MapUtil.getDate(params, (Object)"startDate");
        Date endDate = MapUtil.getDate(params, (Object)"endDate");
        ArrayList<Tuple> dataRangeList = new ArrayList<Tuple>();
        int monthDiff = DateFomatUtils.betweenMonth((Date)startDate, (Date)endDate, (boolean)true) + 1;
        if (monthDiff == 0) {
            dataRangeList.add(new Tuple((Object)startDate, (Object)DateFomatUtils.getLastMonthDay((Date)startDate)));
        } else {
            Date curMonthStart = startDate;
            for (int i = 0; i < monthDiff; ++i) {
                Date curMonthEnd = DateFomatUtils.getLastMonthDay((Date)curMonthStart);
                dataRangeList.add(new Tuple((Object)curMonthStart, (Object)curMonthEnd));
                curMonthStart = DateFomatUtils.offsetMonth((Date)curMonthStart, (int)1);
            }
        }
        String opName = ResManager.loadKDString((String)"\u62bd\u53d6\u5355\u636e\u3001\u53d1\u7968", (String)"PullDataOpName_2", (String)"fi-evp-business", (Object[])new Object[0]);
        int totalTask = orgIds.size() * dataRangeList.size();
        int progress = 0;
        for (Object originOrgId : orgIds) {
            long orgId = Long.parseLong(originOrgId.toString());
            for (Tuple monthRange : dataRangeList) {
                DynamicObject logEntity = null;
                try {
                    TaskInfo taskInfo = JobClient.queryTask((String)this.taskId);
                    AccountBookInfo logInfo = new AccountBookInfo();
                    DynamicObject orgDyn = orgNameMap.get(orgId);
                    logInfo.setOrgId(Long.valueOf(orgId));
                    logInfo.setOrgNumber(orgDyn.getString("number"));
                    logInfo.setOrgName(orgDyn.getString("name"));
                    logEntity = PullDataLogServiceHelper.createTaskLog(opName, context, taskInfo, logInfo, "", "", (Date)monthRange.item1, (Date)monthRange.item2);
                    AbstractExtractBillTask task = ExtractDataService.get(evpBillType, logInfo).prepareByDate(params, (Date)monthRange.item1, (Date)monthRange.item2, this.taskId, pulldataType.toString()).log(logEntity.getLong("id"));
                    task.execute(context, params);
                    if (!params.containsKey("ExtractDataSchedule")) {
                        this.feedbackProgress(++progress / totalTask);
                    }
                    if (task.getErrorTaskCnt() > 0) {
                        PullDataLogServiceHelper.failFinishTask(logEntity, "");
                        continue;
                    }
                    PullDataLogServiceHelper.successFinishTask(logEntity, task.getPullDataCnt());
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u62bd\u53d6\u5f02\u5e38", (Throwable)e);
                    if (logEntity == null) continue;
                    PullDataLogServiceHelper.failFinishTask(logEntity, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
    }

    private void pullDataByPeriod(RequestContext context, Map<String, Object> params, List<Object> orgIds, String evpBillType, Object pulldataType, Map<Long, DynamicObject> orgNameMap) {
        Long bookTypeId = MapUtil.getLong(params, (Object)"bookType");
        String bookTypeName = MapUtil.getStr(params, (Object)"bookTypeName");
        Long beginPeriodId = MapUtil.getLong(params, (Object)"beginPeriod");
        Long endPeriodId = MapUtil.getLong(params, (Object)"endPeriod");
        String type = MapUtil.getStr(params, (Object)"period");
        Long periodtype = MapUtil.getLong(params, (Object)"periodtype");
        int totalTask = 0;
        ArrayList<Tuple> execTaskList = new ArrayList<Tuple>(10);
        HashMap execOrgBookMap = MapUtil.newHashMap();
        for (Object originOrgId : orgIds) {
            long orgId = Long.parseLong(originOrgId.toString());
            AccountBookInfo acctBook = null;
            if (bookTypeId != null) {
                acctBook = AccountingSysUtil.getAcctBookFromAccSys((long)orgId, (long)bookTypeId);
            } else {
                DynamicObject mainBookType = AccountingSysUtil.getMainBookType();
                bookTypeName = mainBookType.getString("name");
                acctBook = AccountingSysUtil.getAcctBookFromAccSys((long)orgId, (long)mainBookType.getLong("id"));
            }
            if (acctBook == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u4f1a\u8ba1\u8d26\u7c3f", (String)"ExtractDataFormTask_1", (String)"fi-evp-business", (Object[])new Object[0]), orgNameMap.get(orgId), bookTypeName));
            }
            execOrgBookMap.put(orgId, acctBook);
            if (periodtype != null && acctBook.getPeriodTypeId().compareTo(periodtype) != 0) {
                logger.warn("\u5f53\u671f\u7ec4\u7ec7\u7684\u4f1a\u8ba1\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0e\u6240\u9009\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4,org = {},number = {},periodTypeId = {},periodtype = {}", new Object[]{acctBook.getOrgName(), acctBook.getNumber(), acctBook.getPeriodTypeId(), periodtype});
                continue;
            }
            List<DynamicObject> periodRange = new ArrayList<DynamicObject>();
            if (beginPeriodId == null || endPeriodId == null) {
                Long curPeriodId = acctBook.getCurPeriodId();
                if (curPeriodId == null) {
                    logger.warn("\u5f53\u671f\u7ec4\u7ec7\u7684\u4f1a\u8ba1\u8d26\u7c3f\u6ca1\u6709\u6ca1\u6709\u5f53\u524d\u671f\u95f4,org = {}", (Object)acctBook.getOrgName());
                    continue;
                }
                DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)"bd_period");
                DynamicObject previousPeriod = AccountingSysUtil.getPreviousPeriod((Object)curPeriodId);
                if ("0".equals(type)) {
                    periodRange.add(period);
                } else if ("1".equals(type)) {
                    if (previousPeriod != null) {
                        periodRange.add(previousPeriod);
                    }
                } else if ("2".equals(type)) {
                    periodRange.add(period);
                    if (previousPeriod != null) {
                        periodRange.add(previousPeriod);
                    }
                }
            } else {
                QFilter periodFilter = new QFilter("periodtype", "=", (Object)acctBook.getPeriodTypeId());
                periodFilter = periodFilter.and("id", ">=", (Object)beginPeriodId).and(new QFilter("isadjustperiod", "=", (Object)false)).and("id", "<=", (Object)endPeriodId);
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,number,name,begindate,enddate", (QFilter[])periodFilter.toArray(), (String)"id");
                periodRange = Arrays.asList(load);
            }
            totalTask += periodRange.size();
            execTaskList.add(new Tuple((Object)orgId, periodRange));
        }
        String opName = ResManager.loadKDString((String)"\u62bd\u53d6\u5355\u636e\u3001\u53d1\u7968", (String)"PullDataOpName_2", (String)"fi-evp-business", (Object[])new Object[0]);
        int progress = 0;
        for (Tuple orgTaskList : execTaskList) {
            long orgId = (Long)orgTaskList.item1;
            AccountBookInfo acctBook = (AccountBookInfo)execOrgBookMap.get(orgId);
            List periodRange = (List)orgTaskList.item2;
            for (DynamicObject curPeriod : periodRange) {
                DynamicObject logEntity = null;
                try {
                    TaskInfo taskInfo = JobClient.queryTask((String)this.taskId);
                    String periodNumber = curPeriod.getString("number");
                    String periodName = curPeriod.getString("name");
                    Date beginDate = DateFomatUtils.beginOfDay((Date)curPeriod.getDate("begindate"));
                    Date endDate = DateFomatUtils.beginOfDay((Date)curPeriod.getDate("enddate"));
                    logEntity = PullDataLogServiceHelper.createTaskLog(opName, context, taskInfo, acctBook, periodNumber, periodName, beginDate, endDate);
                    AbstractExtractBillTask task = ExtractDataService.get(evpBillType, acctBook).prepareByPeriod(params, curPeriod, this.taskId, pulldataType.toString()).log(logEntity.getLong("id"));
                    task.execute(context, params);
                    if (!params.containsKey("ExtractDataSchedule")) {
                        this.feedbackProgress(++progress / totalTask);
                    }
                    if (task.getErrorTaskCnt() > 0) {
                        PullDataLogServiceHelper.failFinishTask(logEntity, "");
                        continue;
                    }
                    PullDataLogServiceHelper.successFinishTask(logEntity, task.getPullDataCnt());
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u62bd\u53d6\u5f02\u5e38", (Throwable)e);
                    if (logEntity == null) continue;
                    PullDataLogServiceHelper.failFinishTask(logEntity, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
    }
}

