/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.evp.business.task.ExtractDataFormTask;
import kd.fi.evp.common.util.DateFomatUtils;

public class ExtractDataSchedule
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ExtractDataSchedule.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("begin ExtractDataSchedule,taskID={},params={}", (Object)this.taskId, (Object)SerializationUtils.toJsonString(params));
        List<String> orgnumbers = Arrays.asList(((String)params.get("orgs")).split(","));
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter("number", "in", orgnumbers).toArray(), null, (int)-1);
        if (pks == null || pks.size() == 0) {
            logger.error("orgs illegal : {}", orgnumbers);
            return;
        }
        params.put("orgIds", pks);
        if (params.containsKey("period")) {
            params.put("filterType", "period");
            params.put("evpBillType", "evp_voucher");
            String bookTypeNumber = (String)params.get("booktypenumber");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id,name", (QFilter[])new QFilter("number", "=", (Object)bookTypeNumber).toArray());
            if (dynamicObject == null) {
                logger.error("booktypenumber illegal : {}", (Object)bookTypeNumber);
                return;
            }
            params.put("bookType", dynamicObject.getLong("id"));
            params.put("bookTypeName", dynamicObject.getString("name"));
            String periodtypenumber = (String)params.get("periodtypenumber");
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_period_type", (String)"id,name", (QFilter[])new QFilter("number", "=", (Object)periodtypenumber).toArray());
            if (dyn == null) {
                logger.error("periodtypenumber illegal : {}", (Object)periodtypenumber);
                return;
            }
            params.put("periodtype", dyn.getLong("id"));
            params.put("beginPeriod", null);
            params.put("endPeriod", null);
        } else {
            String type = (String)params.get("month");
            params.put("filterType", "date");
            params.put("evpBillType", "evp_bkrs");
            Date date = DateFomatUtils.getFirstMonthDay((Date)new Date());
            Date lastMonth = DateFomatUtils.getLastMonthdate();
            if ("0".equals(type)) {
                params.put("startDate", date);
                params.put("endDate", date);
            } else if ("1".equals(type)) {
                params.put("startDate", lastMonth);
                params.put("endDate", lastMonth);
            } else if ("2".equals(type)) {
                params.put("startDate", lastMonth);
                params.put("endDate", date);
            }
        }
        params.put("ExtractDataSchedule", "true");
        logger.info("end ExtractDataSchedule,taskID={},params={}", (Object)this.taskId, (Object)SerializationUtils.toJsonString(params));
        ExtractDataFormTask extractDataFormTask = new ExtractDataFormTask();
        extractDataFormTask.setTaskId(this.taskId);
        extractDataFormTask.execute(context, params);
    }
}

