/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task.extractdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.business.execlog.PullDataLogServiceHelper;
import kd.fi.evp.business.task.extractdata.PullDataInterfaceConfig;
import kd.fi.evp.business.task.extractdata.VchPullevpDataParam;
import kd.fi.evp.common.OriginSystemServiceHelper;
import kd.fi.evp.common.constant.enums.DataFromType;
import kd.fi.evp.common.entity.AccountBookInfo;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.MapUtil;

public abstract class AbstractExtractBillTask {
    protected static final Log logger = LogFactory.getLog((String)"evp.BillExtractTask");
    protected String vchPullType;
    protected AccountBookInfo acctBook;
    protected String batchNo;
    protected DynamicObject period;
    protected Date beginDate;
    protected Date endDate;
    protected int pullDataCnt;
    protected long logId;
    protected Map<Integer, DynamicObject> logSeqMap = MapUtil.newHashMap();
    protected int errorTaskCnt = 0;

    public AbstractExtractBillTask(AccountBookInfo acctBook) {
        this.acctBook = acctBook;
    }

    public int getPullDataCnt() {
        return this.pullDataCnt;
    }

    public int getErrorTaskCnt() {
        return this.errorTaskCnt;
    }

    protected void incrError() {
        ++this.errorTaskCnt;
    }

    protected abstract List<PullevpDataParam> queryBillIds() throws Exception;

    protected void beforeExecuteQuery(int taskSeq, PullevpDataParam queryParam) {
        if (this.logId > 0L) {
            DynamicObject detailLog = PullDataLogServiceHelper.createDetailLog(this.batchNo, this.logId, taskSeq, queryParam.getBillType());
            this.logSeqMap.put(taskSeq, detailLog);
        }
    }

    protected abstract Map<String, Map<Long, List<JSONObject>>> executeQuery(PullevpDataParam var1, PullDataInterfaceConfig var2) throws Exception;

    protected void afterExecuteQuery(int taskSeq, PullevpDataParam queryParam, Map<String, Map<Long, List<JSONObject>>> dataList) {
    }

    protected DynamicObject convertData(Map<String, Object> param) {
        DynamicObjectType mainEntityType = (DynamicObjectType)param.get("mainEntityType");
        JSONObject data = (JSONObject)param.get("json");
        DynamicObject dynObj = new DynamicObject(mainEntityType);
        for (Map.Entry entry : data.entrySet()) {
            String fieldKey = (String)entry.getKey();
            Object fieldVal = entry.getValue();
            DynamicProperty property = mainEntityType.getProperty(fieldKey);
            if (property == null) continue;
            if (property instanceof AmountProp) {
                if (fieldVal == null || fieldVal instanceof String && StringUtils.isEmpty((CharSequence)((String)fieldVal))) {
                    fieldVal = BigDecimal.ZERO;
                }
            } else if (fieldVal == null || fieldVal instanceof String && StringUtils.isEmpty((CharSequence)((String)fieldVal))) continue;
            this.setVal(dynObj, fieldKey, fieldVal, property);
        }
        return dynObj;
    }

    protected void afterSaveData(int taskSeq, PullevpDataParam queryParam, Map<String, Map<Long, List<JSONObject>>> dataList, Set<String> evpBillTypes) {
        DynamicObject detailLog;
        int batchCnt = 0;
        if (dataList != null) {
            for (Map.Entry<String, Map<Long, List<JSONObject>>> billTypeEntry : dataList.entrySet()) {
                Map<Long, List<JSONObject>> billTypeDatas = billTypeEntry.getValue();
                if (billTypeDatas == null) continue;
                for (Map.Entry<Long, List<JSONObject>> vchEntry : billTypeDatas.entrySet()) {
                    List<JSONObject> dataSize = vchEntry.getValue();
                    batchCnt += dataSize.size();
                }
            }
        }
        this.pullDataCnt += batchCnt;
        if (this.logId > 0L && (detailLog = this.logSeqMap.get(taskSeq)) != null) {
            PullDataLogServiceHelper.successFinishDetail(detailLog, batchCnt, evpBillTypes);
        }
    }

    public AbstractExtractBillTask prepareByPeriod(Map<String, Object> params, DynamicObject curPeriod, String batchNo, String vchPullType) {
        this.period = curPeriod;
        this.beginDate = DateFomatUtils.beginOfDay((Date)curPeriod.getDate("begindate"));
        this.endDate = DateFomatUtils.endOfDay((Date)curPeriod.getDate("enddate"));
        this.batchNo = batchNo;
        this.vchPullType = vchPullType;
        return this;
    }

    public AbstractExtractBillTask prepareByDate(Map<String, Object> params, Date beginDate, Date endDate, String batchNo, String vchPullType) {
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.batchNo = batchNo;
        this.vchPullType = vchPullType;
        return this;
    }

    public AbstractExtractBillTask log(long logId) {
        this.logId = logId;
        return this;
    }

    public void execute(RequestContext context, Map<String, Object> params) throws Exception {
        List<PullevpDataParam> batchQueryParams = this.queryBillIds();
        int taskSeq = 1;
        for (PullevpDataParam queryParam : batchQueryParams) {
            this._executeQuery(taskSeq, queryParam);
            ++taskSeq;
        }
    }

    protected Map<String, List<DynamicObject>> convert(PullevpDataParam queryParam, Map<String, Map<Long, List<JSONObject>>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return MapUtil.newHashMap();
        }
        HashMap billTypeMap = MapUtil.newHashMap();
        for (Map.Entry<String, Map<Long, List<JSONObject>>> billTypeEntry : dataList.entrySet()) {
            String fieldName;
            String billType = billTypeEntry.getKey();
            Map<Long, List<JSONObject>> billDataMap = billTypeEntry.getValue();
            if (MapUtil.isEmpty(billDataMap)) continue;
            MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            HashMap<Long, String> billNoMap = new HashMap<Long, String>(16);
            if (srcEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(fieldName = ((BillEntityType)srcEntityType).getBillNo()))) {
                this.buildbillNoMap(billType, billDataMap.keySet(), fieldName, billNoMap);
            }
            for (Map.Entry<Long, List<JSONObject>> billData : billDataMap.entrySet()) {
                Long billId = billData.getKey();
                List<JSONObject> secBillList = billData.getValue();
                for (JSONObject bill : secBillList) {
                    String evpBillType;
                    MainEntityType mainEntityType;
                    logger.info("\u5173\u8054\u5355\u636ebillid = {}, data = {}", (Object)billId, (Object)bill.toJSONString());
                    String ticketType = bill.getString("tickettype");
                    if (StringUtils.isEmpty((CharSequence)ticketType) || (mainEntityType = MetadataServiceHelper.getDataEntityType((String)(evpBillType = (String)EVoucherModel.EVTABLEMAP.get(ticketType)))) == null) continue;
                    List billList = billTypeMap.computeIfAbsent(evpBillType, list -> new ArrayList());
                    HashMap<String, Object> param = new HashMap<String, Object>(6);
                    param.put("queryParam", queryParam);
                    param.put("billType", billType);
                    param.put("billId", billId);
                    param.put("srcBillNo", billNoMap.get(billId));
                    param.put("json", bill);
                    param.put("mainEntityType", mainEntityType);
                    DynamicObject dynObj = this.convertData(param);
                    if (dynObj.get("voucherid") != null && bill.containsKey((Object)"dap_voucherid")) {
                        Object vchId = dynObj.get("voucherid");
                        Long returnvoucherid = bill.getLong("dap_voucherid");
                        Object extvchid = ((VchPullevpDataParam)queryParam).getXhVchIdMap().get(returnvoucherid);
                        if (StringUtils.isNotBlank((Object)extvchid)) {
                            dynObj.set("voucherid", extvchid);
                        } else {
                            logger.warn("vchId : {} ,returnvoucherid : {} , extvchid {}", new Object[]{vchId, returnvoucherid, extvchid});
                        }
                    }
                    dynObj.set("ishandle", (Object)DataFromType.SYS_PULL.getValue());
                    dynObj.set("batchcode", (Object)this.batchNo);
                    dynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                    dynObj.set("originsys", (Object)OriginSystemServiceHelper.getDefaultSystemId());
                    dynObj.set("originsys_id", (Object)OriginSystemServiceHelper.getDefaultSystemId());
                    dynObj.set("isdelete", (Object)false);
                    if (!ticketType.equals("bkrs")) {
                        dynObj.set("hasbeenbooked", (Object)true);
                    }
                    if (Arrays.asList("inv_spcl_receiver", "inv_ord_receiver", "inv_tlf_receiver").contains(ticketType) && StringUtils.isNotBlank((Object)bill.get((Object)"invoicecode"))) {
                        dynObj.set("seqno", (Object)(bill.getString("invoicecode") + bill.getString("invoicenumber")));
                    }
                    billList.add(dynObj);
                }
            }
        }
        return billTypeMap;
    }

    private void _executeQuery(int taskSeq, PullevpDataParam queryParam) {
        try (TXHandle h = TX.requiresNew();){
            PullDataInterfaceConfig pluginCfg;
            HashSet<String> evpBillTypes;
            block21: {
                evpBillTypes = new HashSet<String>(4);
                this.beforeExecuteQuery(taskSeq, queryParam);
                pluginCfg = this.getServicePathByBillType(queryParam.getBillType());
                if (pluginCfg != null) break block21;
                logger.warn("\u62bd\u53d6\u5355\u636e{}\u6570\u636e\u67e5\u8be2\u63d2\u4ef6\u672a\u914d\u7f6e", (Object)queryParam.getBillType());
                this.afterSaveData(taskSeq, queryParam, null, null);
                return;
            }
            try {
                long t1 = System.currentTimeMillis();
                logger.info("begin extract bill query at {}, param = [{},{},{}]", new Object[]{t1, queryParam.getAccorgid(), queryParam.getBillType(), queryParam.getBillIds()});
                Map<String, Map<Long, List<JSONObject>>> dataList = this.executeQuery(queryParam, pluginCfg);
                long t2 = System.currentTimeMillis();
                logger.info("end extract bill query at {}, cost: {}, datasize = {}", new Object[]{t2, t2 - t1, dataList == null ? 0 : dataList.size()});
                this.afterExecuteQuery(taskSeq, queryParam, dataList);
                Map<String, List<DynamicObject>> billTypeMap = this.convert(queryParam, dataList);
                for (Map.Entry<String, List<DynamicObject>> typeEntry : billTypeMap.entrySet()) {
                    evpBillTypes.add(typeEntry.getKey());
                    DynamicObject[] dataEntities = typeEntry.getValue().toArray(new DynamicObject[0]);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    option.setVariableValue("ishandle", DataFromType.SYS_PULL.getValue());
                    OperationResult opResult = SaveServiceHelper.saveOperate((String)typeEntry.getKey(), (DynamicObject[])dataEntities, (OperateOption)option);
                    if (opResult.isSuccess()) continue;
                    List errorList = opResult.getAllErrorOrValidateInfo();
                    Map<Object, List<IOperateInfo>> billErrorGroup = errorList.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue));
                    ArrayList<String> errorInfos = new ArrayList<String>(billErrorGroup.size());
                    for (Map.Entry<Object, List<IOperateInfo>> billErrorList : billErrorGroup.entrySet()) {
                        List<IOperateInfo> bills = billErrorList.getValue();
                        if (bills == null || bills.size() == 0) continue;
                        StringBuilder errorBuilder = new StringBuilder();
                        String billTitle = bills.get(0).getTitle();
                        errorBuilder.append("billId=").append(billTitle).append(":");
                        for (IOperateInfo opInfo : billErrorList.getValue()) {
                            errorBuilder.append(opInfo.getMessage());
                        }
                        errorInfos.add(errorBuilder.toString());
                    }
                    throw new KDBizException(String.join((CharSequence)";", errorInfos));
                }
                this.afterSaveData(taskSeq, queryParam, dataList, evpBillTypes);
            }
            catch (Exception e) {
                logger.info("\u5f53\u524d\u6279\u6b21\u6570\u636e\u62bd\u53d6\u5931\u8d25,param = {}", (Object)queryParam, (Object)e);
                h.markRollback();
                this.failExecuteQuery(taskSeq, evpBillTypes, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    protected void setVal(DynamicObject dynObj, String fieldKey, Object fieldVal, DynamicProperty property) {
        if (property instanceof DynamicCollectionProperty) {
            JSONArray srcEntryRows = (JSONArray)fieldVal;
            DynamicObjectCollection destEntryRows = dynObj.getDynamicObjectCollection(fieldKey);
            for (int i = 0; i < srcEntryRows.size(); ++i) {
                JSONObject srcRow = srcEntryRows.getJSONObject(i);
                DynamicObject destRow = destEntryRows.addNew();
                for (Map.Entry entryField : srcRow.entrySet()) {
                    DynamicProperty subProp = destEntryRows.getDynamicObjectType().getProperty((String)entryField.getKey());
                    if (subProp == null) continue;
                    this.setVal(destRow, (String)entryField.getKey(), entryField.getValue(), subProp);
                }
            }
        } else if (property instanceof DateProp) {
            if (fieldVal instanceof Date) {
                dynObj.set(fieldKey, fieldVal);
            } else {
                Date parseVal = DateFomatUtils.stringToDate((String)fieldVal.toString(), (String)"yyyy-MM-dd");
                dynObj.set(fieldKey, (Object)parseVal);
            }
        } else if (property instanceof DateTimeProp) {
            if (fieldVal instanceof Date) {
                dynObj.set(fieldKey, fieldVal);
            } else {
                Date parseVal = (Date)ObjectConverter.convert((Object)fieldVal, Date.class, (boolean)false);
                dynObj.set(fieldKey, (Object)parseVal);
            }
        } else if (property instanceof BasedataProp) {
            dynObj.set(fieldKey + "_id", fieldVal);
        } else if (property instanceof BooleanProp) {
            dynObj.set(fieldKey, (Object)Boolean.valueOf(fieldVal.toString()));
        } else {
            dynObj.set(fieldKey, fieldVal);
        }
    }

    protected void failExecuteQuery(int taskSeq, Set<String> evpBillTypes, String errorMsg) {
        DynamicObject detailLog;
        this.incrError();
        if (this.logId > 0L && (detailLog = this.logSeqMap.get(taskSeq)) != null) {
            PullDataLogServiceHelper.failFinishDetail(detailLog, evpBillTypes, errorMsg);
        }
    }

    protected PullDataInterfaceConfig getServicePathByBillType(String billType) {
        DynamicObject queryCfg = BusinessDataServiceHelper.loadSingle((String)"evp_queryinterface", (QFilter[])new QFilter[]{new QFilter("elevouchertype", "=", (Object)billType), new QFilter("enable", "=", (Object)"1")});
        if (queryCfg == null) {
            return null;
        }
        PullDataInterfaceConfig pluginCfg = new PullDataInterfaceConfig();
        String pluginname = queryCfg.getString("pluginname");
        if (StringUtils.isEmpty((CharSequence)pluginname)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62bd\u53d6\u5355\u636e%s\u6570\u636e\u67e5\u8be2\u63d2\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e", (String)"AbstractExtractBillTask_2", (String)"fi-evp-business", (Object[])new Object[0]), billType));
        }
        pluginCfg.setPluginPath(pluginname);
        pluginCfg.setBillType(billType);
        int dataSize = queryCfg.getInt("batchdatasize");
        if (dataSize != 0) {
            pluginCfg.setDataSize(dataSize);
        }
        return pluginCfg;
    }

    private void buildbillNoMap(String billType, Set<Long> keySet, String fieldName, Map<Long, String> billNoMap) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractExtractBillTask.buildbillNoMap", (String)billType, (String)("id," + fieldName), (QFilter[])new QFilter("id", "in", keySet).toArray(), null);){
            for (Row row : dataSet) {
                billNoMap.put(row.getLong("id"), row.getString(fieldName));
            }
        }
    }
}

