/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task.extractdata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.evp.business.invoke.InvokeBizQueryService;
import kd.fi.evp.business.task.extractdata.AbstractExtractBillTask;
import kd.fi.evp.business.task.extractdata.PullDataInterfaceConfig;
import kd.fi.evp.common.OriginSystemServiceHelper;
import kd.fi.evp.common.entity.AccountBookInfo;

public class ExtractBKRSTask
extends AbstractExtractBillTask {
    private static final String BIZ_BILL_TYPE = "bei_elecstatement";

    public ExtractBKRSTask(AccountBookInfo acctBook) {
        super(acctBook);
    }

    @Override
    protected List<PullevpDataParam> queryBillIds() throws Exception {
        PullDataInterfaceConfig pluginCfg = this.getServicePathByBillType(BIZ_BILL_TYPE);
        logger.info("pullEvpIdList, params = [{}, {}, {}]", new Object[]{this.acctBook.getOrgId(), this.beginDate, this.endDate});
        List<Long> ids = InvokeBizQueryService.pullEvpIdList(this.acctBook.getOrgId(), this.beginDate, this.endDate, pluginCfg.getPluginPath());
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        logger.info("\u62bd\u53d6\u7684\u5bf9\u8d26\u5355ID\u4e2a\u6570 {}", (Object)ids.size());
        int queryLimit = pluginCfg.getDataSize();
        if (ids.size() <= queryLimit) {
            PullevpDataParam qParam = new PullevpDataParam();
            qParam.setBillIds(new HashSet<Long>(ids));
            qParam.setBillType(BIZ_BILL_TYPE);
            return Collections.singletonList(qParam);
        }
        int batchSize = (int)Math.ceil((double)ids.size() * 1.0 / (double)queryLimit);
        ArrayList<PullevpDataParam> queryParamList = new ArrayList<PullevpDataParam>(batchSize);
        for (int i = 0; i < batchSize - 1; ++i) {
            List<Long> batchIds = ids.subList(i * queryLimit, (i + 1) * queryLimit);
            PullevpDataParam qParam = new PullevpDataParam();
            qParam.setBillIds(new HashSet<Long>(batchIds));
            qParam.setBillType(BIZ_BILL_TYPE);
            queryParamList.add(qParam);
        }
        List<Long> batchIds = ids.subList((batchSize - 1) * queryLimit, ids.size());
        PullevpDataParam qParam = new PullevpDataParam();
        qParam.setBillIds(new HashSet<Long>(batchIds));
        qParam.setBillType(BIZ_BILL_TYPE);
        queryParamList.add(qParam);
        return queryParamList;
    }

    @Override
    protected void beforeExecuteQuery(int taskSeq, PullevpDataParam queryParam) {
        super.beforeExecuteQuery(taskSeq, queryParam);
        Set collect = queryParam.getBillIds().stream().map(Object::toString).collect(Collectors.toSet());
        DataSet existIdDataSet = QueryServiceHelper.queryDataSet((String)"evp.ExtractBKRSTask", (String)"evp_bkrs", (String)"id,billid,isarchive", (QFilter[])new QFilter[]{new QFilter("billid", "in", collect), new QFilter("originsys", "=", (Object)OriginSystemServiceHelper.getDefaultSystemId())}, null);
        HashSet<String> duplicateIds = new HashSet<String>();
        HashSet<Long> pkIds = new HashSet<Long>();
        for (Row row : existIdDataSet) {
            Long billid = row.getLong("billid");
            Boolean isarchive = row.getBoolean("isarchive");
            if (isarchive.booleanValue()) {
                queryParam.getBillIds().remove(billid);
                continue;
            }
            duplicateIds.add(billid.toString());
            pkIds.add(row.getLong("id"));
        }
        if (duplicateIds.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"evp_bkrs", (QFilter[])new QFilter[]{new QFilter("billid", "in", duplicateIds)});
        try (TXHandle txHandle = TX.requiresNew((String)"ExtractBKRSTask.beforeExecuteQuery");){
            try {
                QFilter qFilter2 = new QFilter("fbilltype", "=", (Object)"evp_bkrs");
                qFilter2.and(new QFilter("finterid", "in", pkIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
                DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter2});
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                txHandle.markRollback();
                throw ex;
            }
        }
    }

    @Override
    protected Map<String, Map<Long, List<JSONObject>>> executeQuery(PullevpDataParam queryParam, PullDataInterfaceConfig pluginCfg) throws Exception {
        Map<Long, List<JSONObject>> jsonList = InvokeBizQueryService.pullEvpJsonList(queryParam, pluginCfg.getPluginPath());
        return Collections.singletonMap(queryParam.getBillType(), jsonList);
    }
}

