/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task.extractdata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.business.execlog.PullDataLogServiceHelper;
import kd.fi.evp.business.task.extractdata.AbstractExtractBillTask;
import kd.fi.evp.business.task.extractdata.PullDataInterfaceConfig;
import kd.fi.evp.common.OriginSystemServiceHelper;
import kd.fi.evp.common.constant.enums.DataFromType;
import kd.fi.evp.common.entity.AccountBookInfo;
import kd.fi.evp.common.util.MapUtil;

public class ExtractGlVoucherTask
extends AbstractExtractBillTask {
    public ExtractGlVoucherTask(AccountBookInfo acctBook) {
        super(acctBook);
    }

    @Override
    protected List<PullevpDataParam> queryBillIds() throws Exception {
        return null;
    }

    @Override
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        SqlBuilder vchQuerySQl = new SqlBuilder();
        vchQuerySQl.append("select a.fid id,a.forgid org,a.fnumber billno,A.Fbookeddate bookeddate,A.floccurrency localcur,a.fdescription description", new Object[0]).append(",b.FENTRYDC \"entries.entrydc\",b.FLOCALDEBIT \"entries.debitlocal\",b.FLOCALCREDIT \"entries.creditlocal\",b.faccountid \"entries.account\"", new Object[0]).append(" from t_gl_voucher a inner join T_GL_VOUCHERENTRY b on a.fid = b.fid", new Object[0]);
        vchQuerySQl.append(" WHERE A.forgid = ? AND A.fbooktypeid = ? AND A.FPERIODID = ? and A.fbillstatus >= ? and A.fispost = ?", new Object[]{this.acctBook.getOrgId(), this.acctBook.getBookTypeId(), this.period.getLong("id"), "C", "1"});
        vchQuerySQl.append(" and not exists (select 1 from t_evp_voucher c where c.fisdelete = '0' and c.fxhvoucherid = a.fid)", new Object[0]).append(" order by a.fid, b.fseq", new Object[0]);
        DataSet originVchDataSet = DB.queryDataSet((String)"ExtractBKERTask.queryVch1", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)vchQuerySQl);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,fullname", (QFilter[])new QFilter[]{new QFilter("accounttable", "=", (Object)this.acctBook.getAcctTableId())});
        HashMap acctNameMap = MapUtil.newHashMap((int)accounts.size());
        for (DynamicObject account : accounts) {
            acctNameMap.put(account.getLong("id"), account);
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(2000);
        long preVchID = 0L;
        DynamicObject evpVch = null;
        int seqIndex = 1;
        for (Row row : originVchDataSet) {
            String[] names;
            String fullname;
            DynamicObject acct;
            Long acctId;
            String amtDC;
            DynamicObject entryRow;
            DynamicObjectCollection entryentity;
            Long curVchId = row.getLong("id");
            if (preVchID != curVchId) {
                preVchID = curVchId;
                evpVch = BusinessDataServiceHelper.newDynamicObject((String)"evp_voucher");
                saveList.add(evpVch);
                evpVch.set("org_id", (Object)row.getLong("org"));
                evpVch.set("booktype_id", (Object)this.acctBook.getBookTypeId());
                evpVch.set("period_id", (Object)this.period.getLong("id"));
                evpVch.set("billid", (Object)row.getString("id"));
                evpVch.set("voucherno", (Object)row.getString("billno"));
                evpVch.set("billno", (Object)row.getString("billno"));
                evpVch.set("bookdate", (Object)row.getDate("bookeddate"));
                evpVch.set("xhvoucherid", (Object)row.getLong("id"));
                evpVch.set("currency_id", (Object)row.getLong("localcur"));
                evpVch.set("vdescription", (Object)row.getString("description"));
                evpVch.set("originsys_id", (Object)OriginSystemServiceHelper.getDefaultSystemId());
                evpVch.set("ishandle", (Object)DataFromType.SYS_PULL.getValue());
                evpVch.set("batchcode", (Object)this.batchNo);
                entryentity = evpVch.getDynamicObjectCollection("entryentity");
                entryRow = entryentity.addNew();
                amtDC = row.getString("entries.entrydc");
                if ("1".equals(amtDC)) {
                    entryRow.set("amountdc", (Object)"1");
                    entryRow.set("bookedamount", (Object)row.getBigDecimal("entries.debitlocal"));
                } else {
                    entryRow.set("amountdc", (Object)"0");
                    entryRow.set("bookedamount", (Object)row.getBigDecimal("entries.creditlocal"));
                }
                acctId = row.getLong("entries.account");
                acct = (DynamicObject)acctNameMap.get(acctId);
                if (acct != null) {
                    fullname = acct.getString("fullname");
                    names = fullname.split("_");
                    entryRow.set("glaccountname", (Object)names[0]);
                    entryRow.set("detailaccountname", (Object)acct.getString("name"));
                }
            } else {
                if (evpVch == null) {
                    logger.error("\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u5bfc\u81f4\u5b9e\u4f53\u5bf9\u8c61\u672a\u8d4b\u503c\uff0c curVchId={}, preVchId={}", (Object)curVchId, (Object)preVchID);
                    return;
                }
                entryentity = evpVch.getDynamicObjectCollection("entryentity");
                entryRow = entryentity.addNew();
                amtDC = row.getString("entries.entrydc");
                if ("1".equals(amtDC)) {
                    entryRow.set("amountdc", (Object)"1");
                    entryRow.set("bookedamount", (Object)row.getBigDecimal("entries.debitlocal"));
                } else {
                    entryRow.set("amountdc", (Object)"0");
                    entryRow.set("bookedamount", (Object)row.getBigDecimal("entries.creditlocal"));
                }
                acctId = row.getLong("entries.account");
                acct = (DynamicObject)acctNameMap.get(acctId);
                if (acct != null) {
                    fullname = acct.getString("fullname");
                    names = fullname.split("_");
                    entryRow.set("glaccountname", (Object)names[0]);
                    entryRow.set("detailaccountname", (Object)acct.getString("name"));
                }
            }
            if (saveList.size() < 2000) continue;
            this.flushData(seqIndex, saveList);
            ++seqIndex;
        }
        if (saveList.size() > 0) {
            this.flushData(seqIndex, saveList);
        }
    }

    @Override
    protected Map<String, Map<Long, List<JSONObject>>> executeQuery(PullevpDataParam queryParam, PullDataInterfaceConfig pluginCfg) throws Exception {
        return null;
    }

    @Override
    protected DynamicObject convertData(Map<String, Object> param) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushData(int seqIndex, List<DynamicObject> saveList) {
        try (TXHandle h = TX.requiresNew();){
            HashSet<String> evpBillTypes = new HashSet<String>(Collections.singletonList("evp_voucher"));
            DynamicObject detailLog = null;
            try {
                detailLog = PullDataLogServiceHelper.createDetailLog(this.batchNo, this.logId, seqIndex, "gl_voucher");
                DynamicObject[] dataEntities = saveList.toArray(new DynamicObject[0]);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("ishandle", DataFromType.SYS_PULL.getValue());
                OperationResult opResult = SaveServiceHelper.saveOperate((String)"evp_voucher", (DynamicObject[])dataEntities, (OperateOption)option);
                if (!opResult.isSuccess()) {
                    logger.error("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u6570\u636e\u540c\u6b65\u5b58\u5728\u5931\u8d25, {}", (Object)opResult.getMessage());
                    this.incrError();
                    PullDataLogServiceHelper.failFinishDetail(detailLog, evpBillTypes, opResult.getMessage());
                } else {
                    this.pullDataCnt += opResult.getSuccessPkIds().size();
                    PullDataLogServiceHelper.successFinishDetail(detailLog, opResult.getSuccessPkIds().size(), evpBillTypes);
                }
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u6570\u636e\u540c\u6b65\u5931\u8d25", (Throwable)e);
                this.incrError();
                h.markRollback();
                PullDataLogServiceHelper.failFinishDetail(detailLog, evpBillTypes, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                saveList.clear();
            }
        }
    }
}

