/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.business.task.extractdata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.business.execlog.PullDataLogServiceHelper;
import kd.fi.evp.business.invoke.InvokeBizQueryService;
import kd.fi.evp.business.task.extractdata.AbstractExtractBillTask;
import kd.fi.evp.business.task.extractdata.ExtractGlVoucherTask;
import kd.fi.evp.business.task.extractdata.PullDataInterfaceConfig;
import kd.fi.evp.business.task.extractdata.VchPullevpDataParam;
import kd.fi.evp.common.OriginSystemServiceHelper;
import kd.fi.evp.common.constant.enums.DataFromType;
import kd.fi.evp.common.entity.AccountBookInfo;
import kd.fi.evp.common.util.EvpDapUtil;
import kd.fi.evp.common.util.MapUtil;

public class ExtractUpBillByVchTask
extends AbstractExtractBillTask {
    private static final int BATCH_LIMIT = 2000;

    public ExtractUpBillByVchTask(AccountBookInfo acctBook) {
        super(acctBook);
    }

    @Override
    public void execute(RequestContext context, Map<String, Object> params) throws Exception {
        if ("A".equals(this.vchPullType)) {
            DynamicObject vchLogEntity = null;
            try {
                TaskInfo taskInfo = JobClient.queryTask((String)this.batchNo);
                String opName = ResManager.loadKDString((String)"\u62bd\u53d6\u603b\u8d26\u51ed\u8bc1", (String)"PullDataOpName_1", (String)"fi-evp-business", (Object[])new Object[0]);
                vchLogEntity = PullDataLogServiceHelper.createTaskLog(opName, context, taskInfo, this.acctBook, this.period.getString("number"), this.period.getString("name"), this.beginDate, this.endDate);
                long t1 = System.currentTimeMillis();
                logger.info("\u5f00\u59cb\u62bd\u53d6\u661f\u701a\u51ed\u8bc1\u6570\u636e, t1 = {}", (Object)t1);
                AbstractExtractBillTask vchTask = new ExtractGlVoucherTask(this.acctBook).prepareByPeriod(params, this.period, this.batchNo, this.vchPullType).log(vchLogEntity.getLong("id"));
                vchTask.execute(context, params);
                long t2 = System.currentTimeMillis();
                logger.info("\u5b8c\u6210\u62bd\u53d6\u661f\u701a\u51ed\u8bc1\u6570\u636e, cost = {}", (Object)(t2 - t1));
                if (this.getErrorTaskCnt() > 0) {
                    PullDataLogServiceHelper.failFinishTask(vchLogEntity, "has exception");
                } else {
                    PullDataLogServiceHelper.successFinishTask(vchLogEntity, vchTask.getPullDataCnt());
                }
            }
            catch (Exception ex) {
                ++this.errorTaskCnt;
                PullDataLogServiceHelper.failFinishTask(vchLogEntity, ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                throw ex;
            }
        }
        List<PullevpDataParam> batchQueryParams = this.queryBillIds();
        int taskSeq = 1;
        for (PullevpDataParam queryParam : batchQueryParams) {
            this._executeQuery(taskSeq, queryParam);
            ++taskSeq;
        }
    }

    @Override
    protected List<PullevpDataParam> queryBillIds() throws Exception {
        VchPullevpDataParam vchParam;
        Map linkUpBills;
        VchPullevpDataParam vchParam2;
        Map linkUpBills2;
        List<Object> batchIds;
        ArrayList ids;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("org", "=", (Object)this.acctBook.getOrgId()));
        filters.add(new QFilter("period", "=", (Object)this.period.getLong("id")));
        filters.add(new QFilter("isdelete", "=", (Object)false));
        filters.add(new QFilter("haspullbill", "=", (Object)"0"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExtractBKERTask", (String)"evp_voucher", (String)"id,billid,xhvoucherid,originsys", (QFilter[])filters.toArray(new QFilter[0]), (String)"id");
        HashSet<Long> defSysIds = new HashSet<Long>(2000);
        HashSet<String> otherSysIds = new HashSet<String>(2000);
        HashMap<Long, Object> xhVchIdMap = new HashMap<Long, Object>(2000);
        HashSet<String> extVchids = new HashSet<String>(16);
        for (Row row : dataSet) {
            Long sysId = row.getLong("originsys");
            Long xhvoucherid = row.getLong("xhvoucherid");
            if (OriginSystemServiceHelper.getDefaultSystemId() == sysId) {
                if (0L == xhvoucherid) continue;
                defSysIds.add(xhvoucherid);
                xhVchIdMap.put(xhvoucherid, xhvoucherid);
                continue;
            }
            otherSysIds.add(row.getString("billid"));
            if (0L != xhvoucherid) {
                xhVchIdMap.put(xhvoucherid, row.getString("billid"));
                continue;
            }
            extVchids.add(row.getString("billid"));
        }
        logger.info("extVchids : {}", extVchids);
        if (extVchids.size() > 0) {
            Map tempMap = EvpDapUtil.getXhVchIdMap(extVchids);
            xhVchIdMap.putAll(tempMap);
        }
        logger.info("xhVchIdMap : {}", xhVchIdMap);
        ArrayList<PullevpDataParam> vchQueryParamList = new ArrayList<PullevpDataParam>();
        if (!CollectionUtils.isEmpty(defSysIds)) {
            if (defSysIds.size() <= 2000) {
                Map linkUpBills3 = EvpDapUtil.getLinkUpBills(defSysIds);
                VchPullevpDataParam vchParam3 = this.buildBatchVchParam(defSysIds, linkUpBills3);
                if (vchParam3 != null) {
                    vchParam3.setVoucherIds(defSysIds);
                    vchParam3.setXhVchIdMap(xhVchIdMap);
                    vchQueryParamList.add(vchParam3);
                }
            } else {
                ids = new ArrayList(defSysIds);
                int batchSize = (int)Math.ceil((double)ids.size() * 1.0 / 2000.0);
                for (int i = 0; i < batchSize - 1; ++i) {
                    batchIds = ids.subList(i * 2000, (i + 1) * 2000);
                    try {
                        linkUpBills2 = EvpDapUtil.getLinkUpBills(batchIds);
                        vchParam2 = this.buildBatchVchParam(batchIds, linkUpBills2);
                        if (vchParam2 == null) continue;
                        vchParam2.setVoucherIds(new HashSet(batchIds));
                        vchParam2.setXhVchIdMap(xhVchIdMap);
                        vchQueryParamList.add(vchParam2);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
                    }
                }
                List batchIds2 = ids.subList((batchSize - 1) * 2000, ids.size());
                try {
                    linkUpBills = EvpDapUtil.getLinkUpBills(batchIds2);
                    vchParam = this.buildBatchVchParam(batchIds2, linkUpBills);
                    if (vchParam != null) {
                        vchParam.setVoucherIds(new HashSet(batchIds2));
                        vchParam.setXhVchIdMap(xhVchIdMap);
                        vchQueryParamList.add(vchParam);
                    }
                }
                catch (Exception e) {
                    logger.warn("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (!CollectionUtils.isEmpty(otherSysIds)) {
            if (otherSysIds.size() <= 2000) {
                Map extLinkUpBills = EvpDapUtil.getExtLinkUpBills(otherSysIds);
                VchPullevpDataParam vchParam4 = this.buildBatchVchParam(otherSysIds, extLinkUpBills);
                if (vchParam4 != null) {
                    vchParam4.setVoucherIds(new HashSet(xhVchIdMap.keySet()));
                    vchParam4.setXhVchIdMap(xhVchIdMap);
                    vchQueryParamList.add(vchParam4);
                }
            } else {
                ids = new ArrayList(otherSysIds);
                int batchSize = (int)Math.ceil((double)ids.size() * 1.0 / 2000.0);
                for (int i = 0; i < batchSize - 1; ++i) {
                    batchIds = ids.subList(i * 2000, (i + 1) * 2000);
                    try {
                        linkUpBills2 = EvpDapUtil.getExtLinkUpBills(batchIds);
                        vchParam2 = this.buildBatchVchParam(batchIds, linkUpBills2);
                        if (vchParam2 == null) continue;
                        vchParam2.setVoucherIds(this.getXhXhVchIds(batchIds, xhVchIdMap));
                        vchParam2.setXhVchIdMap(xhVchIdMap);
                        vchQueryParamList.add(vchParam2);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
                    }
                }
                List<Object> batchIds3 = ids.subList((batchSize - 1) * 2000, ids.size());
                try {
                    linkUpBills = EvpDapUtil.getExtLinkUpBills(batchIds3);
                    vchParam = this.buildBatchVchParam(batchIds3, linkUpBills);
                    if (vchParam != null) {
                        vchParam.setVoucherIds(this.getXhXhVchIds(batchIds3, xhVchIdMap));
                        vchParam.setXhVchIdMap(xhVchIdMap);
                        vchQueryParamList.add(vchParam);
                    }
                }
                catch (Exception e) {
                    logger.warn("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return vchQueryParamList;
    }

    @Override
    protected Map<String, Map<Long, List<JSONObject>>> executeQuery(PullevpDataParam queryParam, PullDataInterfaceConfig pluginCfg) throws Exception {
        VchPullevpDataParam vchQueryParam = (VchPullevpDataParam)queryParam;
        List<PullevpDataParam> paramList = vchQueryParam.getParamList();
        HashMap resultMap = MapUtil.newHashMap();
        for (PullevpDataParam pullevpDataParam : paramList) {
            Map<String, JSONObject> step2Datas;
            JSONObject firstVal;
            String tickettype;
            List<JSONObject> firstEntryVal;
            pullevpDataParam.setVoucherIds(queryParam.getVoucherIds());
            logger.info("begin extract bill by vch, param = {}", (Object)pullevpDataParam);
            HashMap totalDatas = MapUtil.newHashMap((int)(2000 * paramList.size()));
            pullevpDataParam.setAccorgid(this.acctBook.getOrgId());
            PullDataInterfaceConfig billQueryPlugin = this.getServicePathByBillType(pullevpDataParam.getBillType());
            if (billQueryPlugin == null) continue;
            Map<Long, List<JSONObject>> step1Datas = InvokeBizQueryService.pullEvpJsonList(pullevpDataParam, billQueryPlugin.getPluginPath());
            if (MapUtil.isEmpty(step1Datas)) {
                logger.info(pullevpDataParam.getBillType() + " \u6839\u636e\u5355\u636e\u67e5\u8be2\u5230\u7684\u7968\u636e\u6570\u636e\u96c6\u4e3a\u7a7a");
                continue;
            }
            Collection<List<JSONObject>> values = step1Datas.values();
            if (!(values.isEmpty() || (firstEntryVal = values.iterator().next()) == null || firstEntryVal.size() <= 0 || "bker_receiver".equals(tickettype = (firstVal = firstEntryVal.get(0)).getString("tickettype")) || (step2Datas = InvokeBizQueryService.getSeqNoAndJson(step1Datas)).isEmpty())) {
                for (Map.Entry<Long, List<JSONObject>> step1Data : step1Datas.entrySet()) {
                    List<JSONObject> value = step1Data.getValue();
                    for (JSONObject data : value) {
                        String seqNo = data.getString("seqno");
                        JSONObject invoiceData = step2Datas.get(seqNo);
                        if (invoiceData == null) continue;
                        data.putAll((Map)invoiceData);
                    }
                }
            }
            totalDatas.putAll(step1Datas);
            resultMap.put(pullevpDataParam.getBillType(), totalDatas);
        }
        return resultMap;
    }

    @Override
    protected DynamicObject convertData(Map<String, Object> param) {
        DynamicObjectType mainEntityType = (DynamicObjectType)param.get("mainEntityType");
        JSONObject json = (JSONObject)param.get("json");
        VchPullevpDataParam vchPullevpDataParam = (VchPullevpDataParam)((Object)param.get("queryParam"));
        String srcBillType = (String)param.get("billType");
        Long srcBillId = (Long)param.get("billId");
        String srcBillNo = (String)param.get("srcBillNo");
        Map<Long, Object> srcBillLinkMap = vchPullevpDataParam.getBillLinkVchMap().get(srcBillType);
        Object vchId = srcBillLinkMap.get(srcBillId);
        DynamicObject dynObj = new DynamicObject(mainEntityType);
        for (Map.Entry entry : json.entrySet()) {
            Object fieldVal;
            String fieldKey = (String)entry.getKey();
            DynamicProperty property = mainEntityType.getProperty(fieldKey);
            if (property == null || (fieldVal = entry.getValue()) == null) continue;
            this.setVal(dynObj, fieldKey, fieldVal, property);
        }
        dynObj.set("originsys", (Object)OriginSystemServiceHelper.getDefaultSystemId());
        dynObj.set("voucherid", vchId);
        if (StringUtils.isNotBlank((CharSequence)srcBillNo)) {
            dynObj.set("directbillno", (Object)srcBillNo);
        }
        dynObj.set("directbilltype", (Object)srcBillType);
        dynObj.set("directbillid", (Object)srcBillId);
        return dynObj;
    }

    @Override
    protected void afterSaveData(int taskSeq, PullevpDataParam queryParam, Map<String, Map<Long, List<JSONObject>>> dataList, Set<String> evpBillTypes) {
        VchPullevpDataParam vchPullevpDataParam = (VchPullevpDataParam)queryParam;
        List<String> vchIds = vchPullevpDataParam.getVchIds();
        Set<String> failVchIds = vchPullevpDataParam.getFailVchIds();
        logger.info("\u5f53\u524d\u6279\u6b21\u51ed\u8bc1-\u603b\u6570{},\u5931\u8d25\u51ed\u8bc1\u6570{}", (Object)vchIds.size(), (Object)(failVchIds == null ? 0 : failVchIds.size()));
        List<String> successIds = null;
        successIds = failVchIds != null ? vchIds.stream().filter(id -> !failVchIds.contains(id)).collect(Collectors.toList()) : vchIds;
        if (successIds.size() > 0) {
            SqlBuilder updateSql = new SqlBuilder();
            updateSql.append("update t_evp_voucher set fhaspullbill = '1' where ", new Object[0]);
            updateSql.append("forgid = ?", new Object[]{this.acctBook.getOrgId()});
            updateSql.appendIn("and fbillid", successIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)updateSql);
        }
        super.afterSaveData(taskSeq, queryParam, dataList, evpBillTypes);
    }

    @Override
    protected PullDataInterfaceConfig getServicePathByBillType(String billType) {
        if ("evp_voucher".equals(billType)) {
            PullDataInterfaceConfig config = new PullDataInterfaceConfig();
            return config;
        }
        return super.getServicePathByBillType(billType);
    }

    private void _executeQuery(int taskSeq, PullevpDataParam queryParam) {
        try (TXHandle h = TX.requiresNew();){
            PullDataInterfaceConfig pluginCfg;
            HashSet<String> evpBillTypes;
            block23: {
                evpBillTypes = new HashSet<String>(4);
                this.beforeExecuteQuery(taskSeq, queryParam);
                pluginCfg = this.getServicePathByBillType(queryParam.getBillType());
                if (pluginCfg != null) break block23;
                logger.warn("\u62bd\u53d6\u5355\u636e{}\u6570\u636e\u67e5\u8be2\u63d2\u4ef6\u672a\u914d\u7f6e", (Object)queryParam.getBillType());
                this.afterSaveData(taskSeq, queryParam, null, null);
                return;
            }
            try {
                long t1 = System.currentTimeMillis();
                logger.info("begin extract bill query at {}, param = {}", (Object)t1, (Object)queryParam.toString());
                Map<String, Map<Long, List<JSONObject>>> dataList = this.executeQuery(queryParam, pluginCfg);
                long t2 = System.currentTimeMillis();
                logger.info("end extract bill query at {}, cost: {}, datasize = {}", new Object[]{t2, t2 - t1, dataList == null ? 0 : dataList.size()});
                this.afterExecuteQuery(taskSeq, queryParam, dataList);
                Map<String, List<DynamicObject>> billTypeMap = this.convert(queryParam, dataList);
                HashSet<String> failVchPks = new HashSet<String>();
                ArrayList<String> errorInfos = new ArrayList<String>(100);
                for (Map.Entry<String, List<DynamicObject>> typeEntry : billTypeMap.entrySet()) {
                    evpBillTypes.add(typeEntry.getKey());
                    DynamicObject[] dataEntities = typeEntry.getValue().toArray(new DynamicObject[0]);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    option.setVariableValue("ishandle", DataFromType.SYS_PULL.getValue());
                    OperationResult opResult = SaveServiceHelper.saveOperate((String)typeEntry.getKey(), (DynamicObject[])dataEntities, (OperateOption)option);
                    if (opResult.isSuccess()) continue;
                    for (DynamicObject dataEntity : dataEntities) {
                        long id = dataEntity.getLong("id");
                        if (id != 0L) continue;
                        String voucherid = dataEntity.getString("voucherid");
                        failVchPks.add(voucherid);
                    }
                    List errorList = opResult.getAllErrorOrValidateInfo();
                    Map<Object, List<IOperateInfo>> billErrorGroup = errorList.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue));
                    for (Map.Entry<Object, List<IOperateInfo>> billErrorList : billErrorGroup.entrySet()) {
                        List<IOperateInfo> bills = billErrorList.getValue();
                        if (bills == null || bills.size() == 0) continue;
                        StringBuilder errorBuilder = new StringBuilder();
                        String billTitle = bills.get(0).getTitle();
                        errorBuilder.append("billId=").append(billTitle).append(":");
                        for (IOperateInfo opInfo : billErrorList.getValue()) {
                            errorBuilder.append(opInfo.getMessage());
                        }
                        errorInfos.add(errorBuilder.toString());
                    }
                }
                if (errorInfos.size() > 0) {
                    logger.info("\u5f53\u524d\u6279\u6b21\u6570\u636e\u62bd\u53d6\u6570\u636e\u4fdd\u5b58\u5b58\u5728\u5931\u8d25,{}", (Object)String.join((CharSequence)";", errorInfos));
                    this.failExecuteQuery(taskSeq, evpBillTypes, String.join((CharSequence)";", errorInfos));
                }
                VchPullevpDataParam vchPullevpDataParam = (VchPullevpDataParam)queryParam;
                vchPullevpDataParam.setFailVchIds(failVchPks);
                this.afterSaveData(taskSeq, queryParam, dataList, evpBillTypes);
            }
            catch (Exception e) {
                logger.info("\u5f53\u524d\u6279\u6b21\u6570\u636e\u62bd\u53d6\u5931\u8d25,param = {}", (Object)queryParam, (Object)e);
                h.markRollback();
                this.failExecuteQuery(taskSeq, evpBillTypes, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    private VchPullevpDataParam buildBatchVchParam(Collection<?> batchIds, Map<String, Map<Long, Object>> linkUpBills) {
        if (MapUtil.isEmpty(linkUpBills)) {
            return null;
        }
        ArrayList<PullevpDataParam> billParamList = new ArrayList<PullevpDataParam>(linkUpBills.size());
        VchPullevpDataParam vchParam = new VchPullevpDataParam();
        List<String> updateVchIds = batchIds.stream().map(Object::toString).collect(Collectors.toList());
        vchParam.setVchIds(updateVchIds);
        vchParam.setParamList(billParamList);
        vchParam.setBillLinkVchMap(linkUpBills);
        vchParam.setBillType("evp_voucher");
        for (Map.Entry<String, Map<Long, Object>> entry : linkUpBills.entrySet()) {
            PullevpDataParam billParam = new PullevpDataParam();
            billParam.setAccorgid(this.acctBook.getOrgId());
            billParam.setBillType(entry.getKey());
            billParam.setBillIds(new HashSet<Long>(entry.getValue().keySet()));
            billParamList.add(billParam);
        }
        return vchParam;
    }

    private Set<Long> getXhXhVchIds(List<Object> batchIds, Map<Long, Object> xhVchIdMap) {
        HashSet<Long> returnSet = new HashSet<Long>(16);
        if (xhVchIdMap != null && xhVchIdMap.size() > 0) {
            for (Map.Entry<Long, Object> entry : xhVchIdMap.entrySet()) {
                Object object = entry.getValue();
                Long vid = entry.getKey();
                if (!batchIds.contains(object)) continue;
                returnSet.add(vid);
            }
        }
        return returnSet;
    }
}

