/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.constant.SourceSys;

public class AccountingOrgConfigFormPlugin
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("bizapp".equals(key)) {
            ChangeData[] changeData = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
            String type = null;
            if (newValue != null) {
                type = newValue.getString("type");
            }
            int count = model.getEntryRowCount("entryentity");
            for (int i = 0; i < count; ++i) {
                model.setValue("type", (Object)type, i);
            }
        } else if ("sourcesys".equals(key)) {
            ChangeData[] changeData = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)changeData[0].getOldValue();
            if (oldValue != null && newValue != null) {
                if (SourceSys.isLocalSYS((String)oldValue.getString("number")) != SourceSys.isLocalSYS((String)newValue.getString("number"))) {
                    model.setValue("bizapp", null);
                }
            } else {
                model.setValue("bizapp", null);
            }
        } else if ("bizorg".equals(key)) {
            model.setValue("bizbooktype", null, model.getEntryCurrentRowIndex("entryentity"));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model;
        DynamicObject bizapp;
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName) && (bizapp = (DynamicObject)(model = this.getModel()).getValue("bizapp")) != null) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                model.setValue("type", (Object)bizapp.getString("type"), row.getRowIndex());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().getValue("type", 0);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = billShowParameter.getBillStatus();
        String name = billStatus.name();
        if ("ADDNEW".equals(name)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"sourcesys", "bizapp", "org"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcesys", "bizapp", "org"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_new"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IDataModel model = this.getModel();
        BasedataEdit bizBookType = (BasedataEdit)this.getView().getControl("bizbooktype");
        bizBookType.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List filter = beforeF7SelectEvent.getCustomQFilters();
                int curIndex = model.getEntryCurrentRowIndex("entryentity");
                Long orgId = (Long)model.getValue(FCCField.id_((String)"bizorg"), curIndex);
                String type = (String)model.getValue("type", curIndex);
                ArrayList<Long> typeIds = new ArrayList<Long>(4);
                if ("bd_accountbookstype".equals(type)) {
                    Map bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"id,bookstype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("enable", "=", (Object)true)});
                    for (Map.Entry entry : bizBookTypes.entrySet()) {
                        DynamicObject bizBook = (DynamicObject)entry.getValue();
                        typeIds.add(bizBook.getLong("bookstype_id"));
                    }
                    filter.add(new QFilter("id", "in", typeIds));
                } else if ("fa_depreuse".equals(type)) {
                    Map bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,depreuse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("enable", "=", (Object)true)});
                    for (Map.Entry entry : bizBookTypes.entrySet()) {
                        DynamicObject bizBook = (DynamicObject)entry.getValue();
                        typeIds.add(bizBook.getLong("depreuse_id"));
                    }
                    filter.add(new QFilter("id", "in", typeIds));
                } else if ("ar_policytype".equals(type)) {
                    Map bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)"ar_policy", (String)"id,policytype", (QFilter[])new QFilter[]{new QFilter("useorg", "=", (Object)orgId), new QFilter("enable", "=", (Object)true)});
                    for (Map.Entry entry : bizBookTypes.entrySet()) {
                        DynamicObject bizBook = (DynamicObject)entry.getValue();
                        typeIds.add(bizBook.getLong("policytype_id"));
                    }
                    filter.add(new QFilter("id", "in", typeIds));
                } else if ("cal_bd_costaccounttype".equals(type)) {
                    Map bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_costaccount", (String)"id,booktype", (QFilter[])new QFilter[]{new QFilter("calorg", "=", (Object)orgId), new QFilter("enable", "=", (Object)true)});
                    for (Map.Entry entry : bizBookTypes.entrySet()) {
                        DynamicObject bizBook = (DynamicObject)entry.getValue();
                        typeIds.add(bizBook.getLong("booktype_id"));
                    }
                    filter.add(new QFilter("id", "in", typeIds));
                }
            }
        });
    }
}

