/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class BizSystemFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl("bizapp");
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name = f7.getProperty().getName();
        if ("bizapp".equals(name)) {
            this.filterBizApp(f7);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"localsys")) {
            this.localSysChange(e);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"bizapp")) {
            this.bizAppChange(e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindDataSetVisibleAndEnable();
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        String localSys = (String)data.get("localsys");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)localSys)) {
            data.remove("bizapp");
            data.remove("type");
        }
    }

    private void filterBizApp(BeforeF7SelectEvent f7) {
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        QFilter qFilter1 = new QFilter("deploystatus", "=", (Object)"2");
        QFilter qFilter2 = new QFilter("type", "=", (Object)"0");
        qFilterList.add(qFilter1);
        qFilterList.add(qFilter2);
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(qFilterList);
    }

    private void localSysChange(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = (String)changeSet[0].getNewValue();
        if (StringUtils.equals((CharSequence)newValue, (CharSequence)"1")) {
            view.setVisible(Boolean.valueOf(true), new String[]{"bizapp", "type"});
        } else {
            model.setValue("bizapp", null);
            view.setVisible(Boolean.valueOf(false), new String[]{"bizapp", "type"});
        }
    }

    private void bizAppChange(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject newBizApp = (DynamicObject)changeSet[0].getNewValue();
        if (null != newBizApp) {
            String bizAppNumber = newBizApp.getString("number");
            String bizAppName = newBizApp.getString("name");
            model.setValue("number", (Object)bizAppNumber);
            OrmLocaleValue name = (OrmLocaleValue)model.getValue("name");
            if (name.isEmpty()) {
                model.setValue("name", (Object)bizAppName);
            }
        } else {
            model.setValue("number", null);
        }
    }

    private void bindDataSetVisibleAndEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Boolean sysInitialize = (Boolean)model.getValue("sysinitialize");
        String localSys = (String)model.getValue("localsys");
        if (null != sysInitialize && sysInitialize.booleanValue()) {
            view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "button_save"});
        }
        if (null != localSys && StringUtils.equals((CharSequence)"0", (CharSequence)localSys)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bizapp", "type"});
        }
    }
}

