/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CheckOutExplainFormPlugin
extends AbstractFormPlugin {
    private static final String EXPLAIN = "checkout_explain";
    private static final String ATTACHMENT = "attachmentfield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("explainStr")) {
            String explainStr = (String)customParams.get("explainStr");
            this.getModel().setValue(EXPLAIN, (Object)explainStr);
        }
        if (customParams.containsKey("attachmentIds")) {
            List attaIdList = (List)customParams.get("attachmentIds");
            this.getModel().setValue(ATTACHMENT, (Object)attaIdList.toArray(new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btnok")) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            DynamicObjectCollection headerAttaColl = (DynamicObjectCollection)this.getModel().getValue(ATTACHMENT);
            if (headerAttaColl != null && headerAttaColl.size() > 0) {
                this.updateAttachments();
            }
            returnMap.put("attach", headerAttaColl);
            String explain = (String)this.getModel().getValue(EXPLAIN);
            returnMap.put("explain", explain);
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private void updateAttachments() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String parentPageId = (String)param.getCustomParam("parentPageId");
        QFilter filter1 = new QFilter("tempfile", "=", (Object)"0");
        QFilter filter2 = new QFilter("pageid", "=", (Object)this.getView().getPageId());
        QFilter filter3 = new QFilter("status", "=", (Object)"B");
        String selectProperties = "id, name, tempfile, pageid, size, status, modifytime";
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        Map attaMap = BusinessDataServiceHelper.loadFromCache((String)"bd_attachment", (String)selectProperties, (QFilter[])filters);
        ArrayList<DynamicObject> attas = new ArrayList<DynamicObject>(attaMap.size());
        for (Map.Entry entry : attaMap.entrySet()) {
            DynamicObject attachDt = (DynamicObject)entry.getValue();
            attachDt.set("pageid", (Object)parentPageId);
            attachDt.set("modifytime", (Object)new Date());
            attas.add(attachDt);
        }
        SaveServiceHelper.save((DynamicObject[])attas.toArray(new DynamicObject[0]));
    }
}

