/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class CheckOutMemberFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CheckOutMemberFormPlugin.class);
    private static final String ENTITY = "fcc_checkout_user";
    private static final String BUSINESS_SYSTEM_ID = "businesssystem";
    private static final String ORG = "org";
    private static final String MEMBERID = "member";
    private static final String SUB_ENTITY = "fcc_checkout_members";
    private static final String FCC_BIZSYSTEM_ID = "masterid";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit businessSystem = (BasedataEdit)this.getView().getControl(BUSINESS_SYSTEM_ID);
        businessSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UserEdit memberId = (UserEdit)this.getView().getControl(MEMBERID);
        memberId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent f) {
        IDataModel model = this.getModel();
        if (f.getProperty().getName().equals(BUSINESS_SYSTEM_ID)) {
            DynamicObjectCollection fcc_checkout_members = model.getEntryEntity(SUB_ENTITY);
            List dynamicObjects = fcc_checkout_members.stream().map(r -> r.getDynamicObject(BUSINESS_SYSTEM_ID)).collect(Collectors.toList());
            List ids = dynamicObjects.stream().filter(r -> r != null).map(r -> r.get(FCC_BIZSYSTEM_ID)).collect(Collectors.toList());
            QFilter qFilter = new QFilter(FCC_BIZSYSTEM_ID, "not in", ids);
            f.getCustomQFilters().add(qFilter);
        }
        if (f.getProperty().getName().equals(MEMBERID)) {
            ListShowParameter listShowParameter = (ListShowParameter)f.getFormShowParameter();
            listShowParameter.setMultiSelect(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        QFilter[] qFilters;
        boolean bos_org_structure;
        super.afterCreateNewData(e);
        long currUserId = UserServiceHelper.getCurrentUserId();
        long orgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
        if (orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u672a\u5206\u914d\u7ec4\u7ec7\u3002", (String)"CheckOutMemberFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue(ORG);
        long inOrgId = orgId;
        String inOrgName = "";
        if (org != null) {
            inOrgId = org.getLong("id");
            inOrgName = org.getString("name");
        }
        if (bos_org_structure = QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])(qFilters = new QFilter("view", "=", (Object)10).and(new QFilter("org.enable", "=", (Object)"1")).and(new QFilter("parent", "=", (Object)inOrgId)).toArray()))) {
            this.getModel().setValue(ORG, (Object)0L);
            return;
        }
        if (inOrgId != orgId) {
            this.getModel().setValue(ORG, (Object)inOrgId);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map data = e.getSourceData();
        log.info("CheckOutMemberListPlugin beforeImportData data:" + JSON.toJSONString((Object)data));
        Map org = (Map)data.get(ORG);
        if (null == org || org.isEmpty()) {
            return;
        }
        Long orgId = (Long)org.get("id");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY, (String)ORG, (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)orgId)});
        if (null != load && load.length > 0) {
            DynamicObject dynamicObject = load[0];
            DynamicObject orgDynamic = dynamicObject.getDynamicObject(ORG);
            String orgName = orgDynamic.getString("name");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d \u503c \u201c%1$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"CheckOutMemberFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), orgName));
        }
    }
}

