/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fcc.common.enums.OrgPermissionEnum;

public class CheckOutMemberListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(CheckOutMemberListPlugin.class);
    private static final String ENTITY = "fcc_checkout_user";
    private static final String ORG_ID = "org.id";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : commonFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)column;
            String columnName = column.getFieldName();
            if (!ORG_ID.equals(columnName)) continue;
            Long userId = RequestContext.get().getCurrUserId();
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)"ssc", (String)ENTITY, (String)OrgPermissionEnum.VIEW.getValue());
            boolean isAllPerssion = allPermOrgs.hasAllOrgPerm();
            if (!isAllPerssion) {
                List hasPermOrgs = allPermOrgs.getHasPermOrgs();
                List<Long> leafOrgs = CheckOutMemberListPlugin.getLeafOrgs(hasPermOrgs);
                List<ComboItem> leafOrgCombos = this.getLeafOrgCombos(leafOrgs);
                commFilter.setComboItems(leafOrgCombos);
            }
            column.setDefaultValue("");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)"ssc", (String)ENTITY, (String)OrgPermissionEnum.VIEW.getValue());
        boolean isAllPerssion = allPermOrgs.hasAllOrgPerm();
        if (!isAllPerssion) {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            List<Long> leafOrgs = CheckOutMemberListPlugin.getLeafOrgs(hasPermOrgs);
            String fieldName = args.getFieldName();
            if (ORG_ID.equals(fieldName)) {
                args.addCustomQFilter(new QFilter("id", "in", leafOrgs));
            }
        } else {
            String fieldName = args.getFieldName();
            if (ORG_ID.equals(fieldName)) {
                args.addCustomQFilter(new QFilter("id", "in", this.getOrgInfoByViewId(10L, null)));
            }
        }
        super.filterContainerBeforeF7Select(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter(ORG_ID, "in", this.getOrgInfoByViewId(10L, null)));
    }

    private Set<Long> getOrgInfoByViewId(Long viewId, QFilter qFilter) {
        if (qFilter == null) {
            QFilter qFilter1 = new QFilter("view", "=", (Object)viewId);
            qFilter1.and(new QFilter("isleaf", "=", (Object)true)).and(new QFilter("org.enable", "=", (Object)"1"));
            DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,isleaf,org.enable", (QFilter[])new QFilter[]{qFilter1});
            return orgDyn.stream().map(r -> r.getLong("org")).collect(Collectors.toSet());
        }
        HashSet<Long> set = new HashSet<Long>(16);
        List orgIds = (List)qFilter.getValue();
        if (CollectionUtils.isNotEmpty((Collection)orgIds)) {
            for (Long orgId : orgIds) {
                List orgs = OrgServiceHelper.getOrgAllSubIds((Long)orgId, (String)"10", (boolean)false);
                if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue;
                set.addAll(orgs);
            }
        }
        return set;
    }

    private static List<Long> getLeafOrgs(List<Long> orgIds) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter};
        log.info("\u5f00\u59cb\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,isleaf", (QFilter[])filters);
        log.info("\u7ed3\u675f\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        ArrayList<Long> leafOrgs = new ArrayList<Long>();
        for (DynamicObject s : orgs) {
            Boolean isLeaf = s.getBoolean("isleaf");
            if (!isLeaf.booleanValue()) continue;
            leafOrgs.add(s.getLong(ORG_ID));
        }
        leafOrgs.sort((v1, v2) -> v1.compareTo((Long)v2));
        log.info("\u8ddf\u8e2a\u8fd4\u56de\u7684\u53f6\u5b50\u7ec4\u7ec7\u662f\u4ec0\u4e48:" + leafOrgs);
        return leafOrgs;
    }

    private List<ComboItem> getLeafOrgCombos(List<Long> allPermissionOrgs) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("org", "in", allPermissionOrgs);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])filters);
        ArrayList<ComboItem> leafOrgs = new ArrayList<ComboItem>(10);
        LinkedHashMap<String, String> orgIdAndNameMap = new LinkedHashMap<String, String>();
        for (DynamicObject s : orgs) {
            orgIdAndNameMap.put(Long.valueOf(s.getLong(ORG_ID)).toString(), s.getString("org.name"));
        }
        for (Map.Entry m : orgIdAndNameMap.entrySet()) {
            ComboItem c = new ComboItem();
            c.setValue((String)m.getKey());
            c.setCaption(new LocaleString((String)m.getValue()));
            leafOrgs.add(c);
        }
        return leafOrgs;
    }
}

