/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.common.enums.DelayStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;
import kd.fi.fcc.formplugin.util.WorkBenchTreeUtils;

public class CheckOutPretaskFormPlugin
extends AbstractFormPlugin {
    private static final String CHECK_METHOD = "checkmethod";
    private static final String DAY_CHECK = "day_check";
    private static final String MONTH_CHECK = "month_check";
    private static final String REFRESH_BTN = "refresh";
    private static final String PRESS_BTN = "press";
    private static final String ENTRY = "entryentity";
    private static final String TASKSTATUS = "taskstatus";
    private static final String DELAYSTATUS = "isdelay";
    private static final String TRUEENDTIME = "trueendtime";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String STARTDAYTIME = "startdaytime";
    private static final String ENDDAYTIME = "enddaytime";
    private static final String CHECKOUTFLOW_ID = "checkoutflowid";
    private static final String PID = "pid";
    private static final String PERSON_WORKBENCH = "fcc_workbench_person";
    private static final String PRETASKSTATUS = "pretaskstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH_BTN, PRESS_BTN});
    }

    public void beforeBindData(EventObject e) {
        String checkMethod;
        String formName;
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("formName") && !PERSON_WORKBENCH.equals(formName = (String)customParams.get("formName"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REFRESH_BTN, PRESS_BTN});
        }
        if (customParams.containsKey("taskStatus") && TaskStatusEnum.DONE.getType().equals(customParams.get("taskStatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{REFRESH_BTN});
        }
        if (DAY_CHECK.equals(checkMethod = (String)this.getView().getParentView().getModel().getValue(CHECK_METHOD))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{STARTTIME, ENDTIME});
        } else if (MONTH_CHECK.equals(checkMethod)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{STARTDAYTIME, ENDDAYTIME});
        }
        if (customParams.containsKey("checkOutId") && customParams.containsKey("taskIdSet")) {
            Long checkOutId = (Long)customParams.get("checkOutId");
            List pretaskIds = (List)customParams.get("taskIdSet");
            DynamicObject checkOut = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_checkout_flow_detail", (String)String.join((CharSequence)",", this.getFields()), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)checkOutId)});
            if (null != checkOut) {
                DynamicObjectCollection tasks = checkOut.getDynamicObjectCollection("taskentry");
                List pretasks = tasks.stream().filter(r -> pretaskIds.contains(r.getLong("id"))).collect(Collectors.toList());
                int row = 0;
                for (DynamicObject pretask : pretasks) {
                    this.getModel().createNewEntryRow(ENTRY);
                    this.setCheckFields(pretask, row, checkOut.getLong("id"));
                    ++row;
                }
                this.getPageCache().put("pretaskNum", String.valueOf(row));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (REFRESH_BTN.equals(key)) {
            Set<Integer> successRowCount = this.refreshTaskStatus(selectRows);
            this.getView().updateView(ENTRY);
            if (successRowCount != null && successRowCount.size() > 0) {
                int btnType = 1;
                selectRows = successRowCount.stream().mapToInt(Integer::intValue).toArray();
                this.sendMessageWithBusiness(selectRows, btnType);
            }
        } else if (PRESS_BTN.equals(key)) {
            int btnType = 2;
            this.sendMessageWithBusiness(selectRows, btnType);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u529e\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"CheckOutPretaskFormPlugin_10", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Integer> refreshTaskStatus(int[] selectRows) {
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u3002", (String)"CheckOutPretaskFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return null;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY);
        HashSet<Integer> successRows = new HashSet<Integer>(selectRows.length);
        int successRow = 0;
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            String taskStatus = dynamicObject.getString(TASKSTATUS);
            if (!TaskStatusEnum.DONE.getType().equals(taskStatus) && !TaskStatusEnum.FAILED.getType().equals(taskStatus)) continue;
            this.getModel().setValue(TASKSTATUS, (Object)TaskStatusEnum.NOT_START.getType(), selectRow);
            successRows.add(selectRow);
            ++successRow;
        }
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u6216\u5931\u8d25\u7684\u7ed3\u8d26\u4efb\u52a1\u624d\u80fd\u91cd\u7f6e\u72b6\u6001\uff0c\u5df2\u6210\u529f\u91cd\u7f6e%s\u4e2a\u4efb\u52a1\u72b6\u6001\u3002", (String)"CheckOutPretaskFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), successRow));
        String taskSetRowStr = this.getView().getParentView().getPageCache().get("taskSetRow");
        String parentToChildStr = this.getView().getParentView().getPageCache().get("parentToChild");
        String taskToPretasksStr = this.getView().getParentView().getPageCache().get("taskToPretasks");
        if (StringUtils.isEmpty((String)taskSetRowStr) || StringUtils.isEmpty((String)parentToChildStr) || StringUtils.isEmpty((String)taskToPretasksStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"CheckOutPretaskFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return null;
        }
        Map taskSetRowMap = (Map)SerializationUtils.fromJsonString((String)taskSetRowStr, Map.class);
        Map parentToChildMap = (Map)SerializationUtils.fromJsonString((String)parentToChildStr, Map.class);
        Map taskToPretasksMap = (Map)SerializationUtils.fromJsonString((String)taskToPretasksStr, Map.class);
        this.refreshTaskStatus(successRows, taskSetRowMap, parentToChildMap, taskToPretasksMap);
        this.refreshPreTaskStatus(successRows, taskToPretasksMap, taskSetRowMap);
        IFormView parentView = this.getView().getParentView();
        WorkBenchFormUtils.showStatusTotal(parentView.getModel(), parentView);
        this.getView().sendFormAction(parentView);
        return successRows;
    }

    private void refreshTaskStatus(Set<Integer> successRows, Map<String, Integer> taskSetRowMap, Map<String, List<Long>> parentToChildMap, Map<String, List<Long>> taskToPretasksMap) {
        if (successRows.size() == 0) {
            return;
        }
        List successRowIds = successRows.stream().map(r -> this.getModel().getValue("id", r.intValue()).toString()).collect(Collectors.toList());
        for (String successRowId : successRowIds) {
            CheckOutTaskHelper.writeTaskFlowStatus((Long)Long.valueOf(successRowId), (String)TaskStatusEnum.NOT_START.getType(), null, null);
            WorkBenchFormUtils.deleteEndTime(Long.valueOf(successRowId));
        }
        IFormView parentView = this.getView().getParentView();
        List parentSuccessRows = successRowIds.stream().filter(taskSetRowMap::containsKey).map(taskSetRowMap::get).collect(Collectors.toList());
        Iterator iterator = parentSuccessRows.iterator();
        while (iterator.hasNext()) {
            int parentSuccessRow = (Integer)iterator.next();
            parentView.getModel().setValue(TASKSTATUS, (Object)TaskStatusEnum.NOT_START.getType(), parentSuccessRow);
            parentView.getModel().setValue(TRUEENDTIME, null, parentSuccessRow);
            parentView.updateView(TASKSTATUS, parentSuccessRow);
            parentView.updateView(TRUEENDTIME, parentSuccessRow);
            this.getView().sendFormAction(parentView);
        }
        if (!parentSuccessRows.isEmpty()) {
            String focusNodeID = parentView.getPageCache().get("focusNodeId");
            String leafOrgIds = parentView.getPageCache().get("leafOrgIds");
            List leafOrgIdList = (List)SerializationUtils.fromJsonString((String)leafOrgIds, List.class);
            WorkBenchTreeUtils.refreshOrgTree(parentView, leafOrgIdList, focusNodeID);
            this.getView().sendFormAction(parentView);
        }
        HashSet<Long> taskSetRows = new HashSet<Long>(successRows.size());
        for (int row : successRows) {
            taskSetRows.add((Long)this.getModel().getValue(PID, row));
        }
        for (Long taskSetRow : taskSetRows) {
            List<Long> childRows = parentToChildMap.get(taskSetRow.toString());
            if (null == childRows) continue;
            ArrayList<String> childStatus = new ArrayList<String>(childRows.size());
            for (Long childRow : childRows) {
                if (!taskSetRowMap.containsKey(childRow.toString())) continue;
                childStatus.add((String)parentView.getModel().getValue(TASKSTATUS, taskSetRowMap.get(childRow.toString()).intValue()));
            }
            String status = WorkBenchFormUtils.getTaskSetStatus(childStatus);
            if (!taskSetRowMap.containsKey(taskSetRow.toString())) continue;
            int row = taskSetRowMap.get(taskSetRow.toString());
            CheckOutTaskHelper.writeTaskFlowStatus((Long)((Long)parentView.getModel().getValue("id", row)), (String)TaskStatusEnum.NOT_START.getType(), null, null);
            WorkBenchFormUtils.deleteEndTime((Long)parentView.getModel().getValue("id", row));
            parentView.getModel().setValue(TASKSTATUS, (Object)status, row);
            parentView.getModel().setValue(TRUEENDTIME, null, row);
            parentView.updateView(TASKSTATUS, row);
            parentView.updateView(TRUEENDTIME, row);
            this.getView().sendFormAction(parentView);
        }
    }

    private void refreshPreTaskStatus(Set<Integer> successRows, Map<String, List<Long>> taskToPretasksMap, Map<String, Integer> taskSetRowMap) {
        for (int row : successRows) {
            Long pretaskId = (Long)this.getModel().getValue("id", row);
            for (Map.Entry<String, List<Long>> entry : taskToPretasksMap.entrySet()) {
                List<Long> pretasks = entry.getValue();
                if (!pretasks.contains(pretaskId)) continue;
                String taskId = entry.getKey();
                int taskRow = taskSetRowMap.get(taskId);
                List<String> preTaskStatus = WorkBenchFormUtils.getTaskStatus(new HashSet<Long>(pretasks));
                String parentPreTaskStatus = WorkBenchFormUtils.getTaskSetStatus(preTaskStatus);
                IFormView parentView = this.getView().getParentView();
                parentView.getModel().setValue(PRETASKSTATUS, (Object)parentPreTaskStatus, taskRow);
                parentView.updateView(PRETASKSTATUS, taskRow);
                this.getView().sendFormAction(parentView);
            }
        }
    }

    private void setCheckFields(DynamicObject pretask, int row, Long checkOutId) {
        List<String> fields = this.getFields();
        for (String field : fields) {
            this.getModel().setValue(CHECKOUTFLOW_ID, (Object)checkOutId, row);
            this.getModel().setValue(PID, (Object)pretask.getLong(PID), row);
            if (field.equals("id") || field.equals("taskentry.pid") || field.equals("org")) continue;
            if (STARTDAYTIME.equals(field = field.substring(field.lastIndexOf(46) + 1)) || ENDDAYTIME.equals(field)) {
                if (null == pretask.get(field) || pretask.getInt(field) <= 0) continue;
                int totalSeconds = pretask.getInt(field);
                int hours = totalSeconds / 3600;
                int minutes = totalSeconds % 3600 / 60;
                int seconds = totalSeconds % 60;
                if (24 == hours) {
                    hours = 0;
                }
                Date date = (Date)this.getView().getParentView().getModel().getValue("date");
                LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                LocalDateTime updatedDateTime = localDateTime.withHour(hours).withMinute(minutes).withSecond(seconds);
                Date updatedDate = Date.from(updatedDateTime.atZone(ZoneId.systemDefault()).toInstant());
                this.getModel().setValue(field, (Object)updatedDate, row);
                continue;
            }
            if (DELAYSTATUS.equals(field)) {
                String isDelay = WorkBenchFormUtils.checkIsDelay(pretask, this.getView().getParentView()) ? DelayStatusEnum.DELAY.getType() : DelayStatusEnum.NORMAL.getType();
                this.getModel().setValue(field, (Object)isDelay, row);
                continue;
            }
            this.getModel().setValue(field, pretask.get(field), row);
        }
    }

    private List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("id");
        fields.add("taskentry.id");
        fields.add("taskentry.pid");
        fields.add("taskentry.eorg");
        fields.add("taskentry.ebizorg");
        fields.add("taskentry.type");
        fields.add("taskentry.bizbooktype");
        fields.add("taskentry.isdelay");
        fields.add("taskentry.tasknumber");
        fields.add("taskentry.taskstatus");
        fields.add("taskentry.starttime");
        fields.add("taskentry.endtime");
        fields.add("taskentry.startdaytime");
        fields.add("taskentry.enddaytime");
        fields.add("taskentry.trueendtime");
        fields.add("taskentry.checkoutexplain");
        fields.add("taskentry.executor");
        return fields;
    }

    private void sendMessageWithBusiness(int[] selectRows, int btnType) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY);
        long currUserId = UserServiceHelper.getCurrentUserId();
        String userName = RequestContext.get().getUserName();
        LocaleString tagName = ResManager.getLocaleString((String)"\u7ed3\u8d26\u9a7e\u9a76\u8231", (String)"CheckOutPretaskFormPlugin_11", (String)"fi-fcc-formplugin");
        LocaleString title = ResManager.getLocaleString((String)"\u7ed3\u8d26\u4efb\u52a1\u72b6\u6001\u91cd\u7f6e", (String)"CheckOutPretaskFormPlugin_12", (String)"fi-fcc-formplugin");
        if (btnType == 2) {
            title = ResManager.getLocaleString((String)"\u7ed3\u8d26\u4efb\u52a1\u50ac\u529e", (String)"CheckOutPretaskFormPlugin_13", (String)"fi-fcc-formplugin");
        }
        String entityNumber = PERSON_WORKBENCH;
        HashSet<Long> set = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            long checkoutflowid = dynamicObject.getLong(CHECKOUTFLOW_ID);
            set.add(checkoutflowid);
        }
        QFilter qFilter = new QFilter("id", "in", set);
        DynamicObject[] fcc_checkout_flow_details = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id,plan.name", (QFilter[])new QFilter[]{qFilter});
        Map<Long, ILocaleString> planNameMap = Arrays.stream(fcc_checkout_flow_details).collect(Collectors.toMap(r -> r.getLong("id"), r -> (ILocaleString)r.get("plan.name")));
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            DynamicObject executor = dynamicObject.getDynamicObject("executor");
            ILocaleString executorName = (ILocaleString)executor.get("name");
            long executorId = executor.getLong("id");
            DynamicObject eorg = dynamicObject.getDynamicObject("eorg");
            ILocaleString orgName = (ILocaleString)eorg.get("name");
            DynamicObject tasknumber = dynamicObject.getDynamicObject("tasknumber");
            ILocaleString taskName = (ILocaleString)tasknumber.get("name");
            long checkoutflowid = dynamicObject.getLong(CHECKOUTFLOW_ID);
            LocaleString localeContent = null;
            HashMap contentValues = new HashMap();
            if (btnType == 2) {
                ResManager.getLocaleString((String)"\u60a8\u8d1f\u8d23\u7684\u7ed3\u8d26\u8ba1\u5212\u201c%1$s\u201d\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u7ed3\u8d26\u4efb\u52a1\u201c%3$s\u201d\u672a\u5b8c\u6210\uff0c\u5df2\u5f71\u54cd\u540e\u7f6e\u4efb\u52a1\u6267\u884c\uff0c\u540e\u7f6e\u4efb\u52a1\u6267\u884c\u4eba%4$s\u63d0\u9192\u60a8\u5c3d\u5feb\u5904\u7406\u3002", (String)"CheckOutPretaskFormPlugin_15", (String)"fi-fcc-formplugin").forEach((k, v) -> {
                    String content = String.format(v, ((ILocaleString)planNameMap.get(checkoutflowid)).get(k), orgName.get(k), taskName.get(k), userName);
                    contentValues.put(k, content);
                });
                localeContent = LocaleString.fromMap(contentValues);
            } else if (btnType == 1) {
                ResManager.getLocaleString((String)"\u60a8\u8d1f\u8d23\u7684\u7ed3\u8d26\u8ba1\u5212\u201c%1$s\u201d\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u7ed3\u8d26\u4efb\u52a1\u201c%3$s\u201d\u7684\u72b6\u6001\u5df2\u88ab\u540e\u7f6e\u4efb\u52a1\u6267\u884c\u4eba\u201c%4$s\u201d\u91cd\u7f6e\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u5904\u7406\u3002\u64cd\u4f5c\u8def\u5f84\uff1a\u3010\u7ed3\u8d26\u9a7e\u9a76\u8231>\u4e2a\u4eba\u5de5\u4f5c\u53f0\u3011\u3002", (String)"CheckOutPretaskFormPlugin_14", (String)"fi-fcc-formplugin").forEach((k, v) -> {
                    String content = String.format(v, ((ILocaleString)planNameMap.get(checkoutflowid)).get(k), orgName.get(k), taskName.get(k), userName);
                    contentValues.put(k, content);
                });
                localeContent = LocaleString.fromMap(contentValues);
            }
            HashSet<Long> receivers = new HashSet<Long>(16);
            receivers.add(executorId);
            this.sendMessage((ILocaleString)title, (ILocaleString)localeContent, currUserId, (ILocaleString)tagName, entityNumber, receivers);
        }
    }

    private void sendMessage(ILocaleString title, ILocaleString content, long senderId, ILocaleString tag, String entityNumber, Set<Long> receivers) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        MessageInfo message = new MessageInfo();
        message.setMessageTitle(title);
        message.setMessageContent(content);
        message.setMessageTag(tag);
        message.setUserIds(receivers.stream().collect(Collectors.toList()));
        message.setSenderId(Long.valueOf(senderId));
        message.setEntityNumber(entityNumber);
        message.setType("message");
        message.setOperation("submit");
        message.setBizDataId(Long.valueOf(1972058526805354496L));
        message.setNestBillno(String.valueOf(1972058526805354496L));
        String clientUrl = UrlService.getDomainContextUrl();
        message.setContentUrl(clientUrl + "/index.html?formId=" + entityNumber + "&pkId=1972058526805354496");
        StringBuilder notifyType = new StringBuilder();
        notifyType.append(MessageChannels.MC.getNumber());
        message.setNotifyType(notifyType.toString());
        messageInfos.add(message);
        MessageCenterServiceHelper.batchSendMessages(messageInfos);
    }
}

