/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fcc.common.enums.OperationEnum;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;

public class CheckOutTaskFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CALL_BACK_SAVE = "saveTaskCallBack";

    public void registerListener(EventObject e) {
        BasedataEdit preTask = (BasedataEdit)this.getView().getControl("service");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit task = (BasedataEdit)this.getView().getControl("preservice");
        task.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildTaskTypeComboItems();
        this.newDataSetVisibleAndEnable();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.taskTypeSetVisibleAndEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && null == args.getCancelMessage()) {
            this.isUsedByPlan(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OperationEnum.SAVE.getType().equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.saveSetVisibleAndEnable();
            }
        } else if (OperationEnum.MODIFY.getType().equals(operateKey)) {
            this.modifySetVisibleAndEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("tasktype".equals(propertyName)) {
            this.taskTypeChange();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_SAVE.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            ArrayList<DynamicObject> blankObjList = new ArrayList<DynamicObject>(1);
            DynamicObjectCollection services = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject service : services) {
                if (null != service.get("service") || null != service.get("preservice") && ((MulBasedataDynamicObjectCollection)service.get("preservice")).size() != 0) continue;
                blankObjList.add(service);
            }
            services.removeAll(blankObjList);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            this.saveSetVisibleAndEnable();
            this.getView().updateView("entryentity");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\uff01", (String)"CheckOutTaskFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name = f7.getProperty().getName();
        if (name.equals("service")) {
            this.filterService(f7);
        } else if (name.equals("preservice")) {
            this.filterPreService(f7);
        }
    }

    private void buildTaskTypeComboItems() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        String parentId = null;
        String bizSystemId = null;
        String sourceSystemId = null;
        if (null != parentView) {
            parentId = parentView.getPageCache().get("parentid");
            bizSystemId = parentView.getPageCache().get("bizsystem");
            sourceSystemId = parentView.getPageCache().get("group");
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        if (null != parentId) {
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setValue(TaskTypeEnum.PROGRAM_TASK.getType());
            comboItem1.setCaption(new LocaleString(TaskTypeEnum.PROGRAM_TASK.getName()));
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setValue(TaskTypeEnum.MANUAL_TASKS.getType());
            comboItem2.setCaption(new LocaleString(TaskTypeEnum.MANUAL_TASKS.getName()));
            comboItems.add(comboItem1);
            comboItems.add(comboItem2);
            if (null != parentId && !StringUtils.equals((CharSequence)parentId, (CharSequence)"null")) {
                model.setValue("virtualtask", (Object)parentId);
            }
            if (null != bizSystemId && !StringUtils.equals((CharSequence)bizSystemId, (CharSequence)"null")) {
                model.setValue("bizsystem", (Object)bizSystemId);
            }
            if (null != sourceSystemId && !StringUtils.equals((CharSequence)sourceSystemId, (CharSequence)"null")) {
                model.setValue("group", (Object)sourceSystemId);
            }
            model.setValue("tasktype", (Object)TaskTypeEnum.PROGRAM_TASK.getType());
            view.setEnable(Boolean.valueOf(true), new String[]{"tasktype"});
        } else {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(TaskTypeEnum.TASK_SET.getType());
            comboItem.setCaption(new LocaleString(TaskTypeEnum.TASK_SET.getName()));
            comboItems.add(comboItem);
            model.setValue("tasktype", (Object)TaskTypeEnum.TASK_SET.getType());
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            view.setVisible(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
            view.setEnable(Boolean.valueOf(false), new String[]{"tasktype"});
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("tasktype");
        comboEdit.setComboItems(comboItems);
        this.getView().getPageCache().put("isNewData", "true");
    }

    private void newDataSetVisibleAndEnable() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String taskType = (String)model.getValue("tasktype");
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.TASK_SET.getType())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"virtualtask", "operationinfo"});
        } else {
            view.setEnable(Boolean.valueOf(false), new String[]{"bizsystem"});
        }
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_disable"});
        view.setEnable(Boolean.valueOf(false), new String[]{"group", "createorg"});
    }

    private void taskTypeSetVisibleAndEnable() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String taskType = (String)model.getValue("tasktype");
        Long id = (Long)model.getValue("id");
        IFormView parentView = view.getParentView();
        String isModify = null;
        if (null != parentView) {
            isModify = parentView.getPageCache().get("isModify");
        }
        String isNewData = view.getPageCache().get("isNewData");
        String parentEntity = "";
        if (null != view.getParentView()) {
            parentEntity = view.getParentView().getEntityId();
        }
        if (null != isNewData) {
            view.getPageCache().remove("isNewData");
            return;
        }
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.TASK_SET.getType())) {
            boolean existsChildTask = QueryServiceHelper.exists((String)"fcc_checkout_task", (QFilter[])new QFilter[]{new QFilter("virtualtask.id", "=", (Object)id)});
            if (existsChildTask) {
                DataEntityPropertyCollection properties = model.getDataEntity().getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    view.setEnable(Boolean.valueOf(false), new String[]{name});
                }
                view.setEnable(Boolean.valueOf(true), new String[]{"explain", "name"});
            } else {
                view.setEnable(Boolean.valueOf(false), new String[]{"number", "group", "tasktype"});
            }
            view.setVisible(Boolean.valueOf(false), new String[]{"tasktype", "virtualtask", "operationinfo", "advconap", "attachmentpanelap"});
        } else if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.PROGRAM_TASK.getType()) || StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.MANUAL_TASKS.getType())) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setValue(TaskTypeEnum.PROGRAM_TASK.getType());
            comboItem1.setCaption(new LocaleString(TaskTypeEnum.PROGRAM_TASK.getName()));
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setValue(TaskTypeEnum.MANUAL_TASKS.getType());
            comboItem2.setCaption(new LocaleString(TaskTypeEnum.MANUAL_TASKS.getName()));
            comboItems.add(comboItem1);
            comboItems.add(comboItem2);
            ComboEdit comboEdit = (ComboEdit)this.getControl("tasktype");
            comboEdit.setComboItems(comboItems);
            view.setEnable(Boolean.valueOf(false), new String[]{"number", "group", "virtualtask", "bizsystem"});
        }
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.MANUAL_TASKS.getType())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        }
        if (null == isModify) {
            view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "operationinfo", "advconap", "attachmentpanelap"});
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
            view.setVisible(Boolean.valueOf(true), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        }
        if (null != isModify) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        }
        if (!StringUtils.equals((CharSequence)parentEntity, (CharSequence)"bos_templatetreelist")) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        }
        view.setEnable(Boolean.valueOf(false), new String[]{"createorg", "group"});
        if (null != parentView && null != isModify) {
            parentView.getPageCache().remove("isModify");
        }
    }

    private void isUsedByPlan(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        String number = (String)model.getValue("number");
        QFilter qFilter1 = new QFilter("taskentry.tasknumber.number", "=", (Object)number);
        QFilter qFilter2 = new QFilter("plan.planstatus", "=", (Object)"B");
        DynamicObjectCollection plans = QueryServiceHelper.query((String)"fcc_checkout_flow_detail", (String)"plan.name", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        StringBuilder planNames = new StringBuilder();
        if (null == plans || plans.size() == 0) {
            return;
        }
        for (DynamicObject plan : plans) {
            String name = plan.getString("plan.name");
            planNames.append(name);
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u88ab\u7ed3\u8d26\u8ba1\u5212\u201c%s\u201d\u5f15\u7528\uff0c\u786e\u8ba4\u4fee\u6539\u4efb\u52a1\u5417\uff1f", (String)"CheckOutTaskFormPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]), planNames), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_SAVE));
        args.setCancel(Boolean.TRUE.booleanValue());
    }

    private void saveSetVisibleAndEnable() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(true), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "operationinfo", "advconap", "attachmentpanelap"});
    }

    private void modifySetVisibleAndEnable() {
        this.getView().getParentView().getPageCache().put("isModify", "true");
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        view.setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        view.setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo", "operationinfo", "advconap", "attachmentpanelap"});
        this.taskTypeSetVisibleAndEnable();
    }

    private void taskTypeChange() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String taskType = (String)model.getValue("tasktype");
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.MANUAL_TASKS.getType())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.PROGRAM_TASK.getType())) {
            view.setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            view.setVisible(Boolean.valueOf(true), new String[]{"attachmentpanelap"});
        }
    }

    private void filterService(BeforeF7SelectEvent f7) {
        IDataModel model = this.getModel();
        ArrayList<Long> serviceIdList = new ArrayList<Long>(2);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        DynamicObject system = (DynamicObject)model.getValue("group");
        Long systemId = 0L;
        if (null != system) {
            systemId = system.getLong("id");
        }
        DynamicObjectCollection serviceEntries = model.getEntryEntity("entryentity");
        for (DynamicObject serviceEntry : serviceEntries) {
            DynamicObject service = (DynamicObject)serviceEntry.get("service");
            if (null == service) continue;
            serviceIdList.add(service.getLong("id"));
        }
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        QFilter qFilter1 = new QFilter("id", "not in", serviceIdList);
        QFilter qFilter2 = new QFilter("srcsys.id", "=", (Object)systemId);
        qFilterList.add(qFilter1);
        qFilterList.add(qFilter2);
        showParameter.getListFilterParameter().setQFilters(qFilterList);
    }

    private void filterPreService(BeforeF7SelectEvent f7) {
        QFilter qFilter2;
        IDataModel model = this.getModel();
        DynamicObjectCollection serviceEntries = model.getEntryEntity("entryentity");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        ArrayList<Long> serviceIdList = new ArrayList<Long>(2);
        ArrayList<Long> enableIdList = new ArrayList<Long>(2);
        HashMap servicesMap = new HashMap(2);
        int row = f7.getRow();
        DynamicObject currentService = (DynamicObject)model.getValue("service", row);
        boolean isEnable = true;
        if (null != currentService) {
            Long currentServiceId = currentService.getLong("id");
            for (DynamicObject serviceEntry : serviceEntries) {
                Long id;
                ArrayList<Long> preIdList = new ArrayList<Long>(2);
                MulBasedataDynamicObjectCollection preServices = (MulBasedataDynamicObjectCollection)serviceEntry.get("preservice");
                DynamicObject service = (DynamicObject)serviceEntry.get("service");
                if (null == service || (id = Long.valueOf(service.getLong("id"))).equals(currentServiceId)) continue;
                enableIdList.add(id);
                if (null == preServices) continue;
                for (DynamicObject preService : preServices) {
                    preIdList.add(preService.getLong("fbasedataid_id"));
                }
                if (preIdList.contains(currentServiceId)) {
                    serviceIdList.add(id);
                }
                servicesMap.put(id, preIdList);
            }
            servicesMap.put(currentServiceId, enableIdList);
            for (DynamicObject serviceEntry : serviceEntries) {
                Boolean hasCycle;
                Long id;
                DynamicObject service = (DynamicObject)serviceEntry.get("service");
                if (null == service || (id = Long.valueOf(service.getLong("id"))).equals(currentServiceId) || !(hasCycle = HasCycleUtils.hasCycle((Long)id, servicesMap)).booleanValue()) continue;
                serviceIdList.add(id);
            }
        } else {
            isEnable = false;
        }
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        if (!isEnable) {
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        if (null != serviceIdList && serviceIdList.size() > 0) {
            QFilter qFilter1 = new QFilter("id", "not in", serviceIdList);
            qFilterList.add(qFilter1);
        }
        if (null != enableIdList && enableIdList.size() > 0) {
            qFilter2 = new QFilter("id", "in", enableIdList);
            qFilterList.add(qFilter2);
        } else {
            qFilter2 = new QFilter("id", "=", (Object)0L);
            qFilterList.add(qFilter2);
        }
        showParameter.getListFilterParameter().setQFilters(qFilterList);
    }
}

