/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.enums.TaskTypeEnum;

public class CheckOutTaskListPlugin
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemkey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("tblnew".equals(itemkey)) {
            this.addTaskCheck(evt, selectedRows);
        } else if ("tblmodifty".equals(itemkey)) {
            this.modifyTaskCheck(evt, selectedRows);
        }
    }

    private void addTaskCheck(BeforeItemClickEvent evt, ListSelectedRowCollection selectedRows) {
        if (null != selectedRows && selectedRows.size() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u6761\u4efb\u52a1\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"CheckOutTaskListPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        Map focusNode = treeView.getTreeState().getFocusNode();
        Object parent = focusNode.get("parentid");
        if (null == parent || StringUtils.isBlank(parent)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u7cfb\u7edf\u3002", (String)"CheckOutTaskListPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (null != selectedRows && selectedRows.size() == 1) {
            DynamicObject bizSystem;
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Long rowId = (Long)listSelectedRow.getPrimaryKeyValue();
            Long bizSystemId = null;
            Long sourceSystemId = null;
            DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"fcc_checkout_task", (String)"tasktype,virtualtask.id,bizsystem,group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rowId)});
            String taskType = task.getString("tasktype");
            if (StringUtils.equals((CharSequence)TaskTypeEnum.PROGRAM_TASK.getType(), (CharSequence)taskType) || StringUtils.equals((CharSequence)TaskTypeEnum.MANUAL_TASKS.getType(), (CharSequence)taskType)) {
                Long virtualtask;
                rowId = virtualtask = (Long)task.get("virtualtask.id");
            }
            bizSystemId = (bizSystem = (DynamicObject)task.get("bizsystem")) != null ? Long.valueOf(bizSystem.getLong("id")) : null;
            DynamicObject sourceSystem = (DynamicObject)task.get("group");
            sourceSystemId = sourceSystem != null ? Long.valueOf(sourceSystem.getLong("id")) : null;
            this.getView().getPageCache().put("parentid", String.valueOf(rowId));
            this.getView().getPageCache().put("bizsystem", String.valueOf(bizSystemId));
            this.getView().getPageCache().put("group", String.valueOf(sourceSystemId));
        }
        if (null == selectedRows || selectedRows.size() == 0) {
            this.getView().getPageCache().remove("parentid");
        }
    }

    private void modifyTaskCheck(BeforeItemClickEvent evt, ListSelectedRowCollection selectedRows) {
        if (null != selectedRows && selectedRows.size() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CheckOutTaskListPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (null != selectedRows && selectedRows.size() == 1) {
            this.getView().getPageCache().put("isModify", "true");
        }
    }
}

