/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.OperationEnum;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;

public class CheckOutTemplateFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getView().getControl("pretasks");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit task = (BasedataEdit)this.getView().getControl("task");
        task.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.newDataSetVisibleAndEnable();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().getPageCache().put("isCopyData", "true");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindDataSetVisibleAndEnable();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"newchildtask", (CharSequence)itemKey)) {
            this.insertChildTaskEntry(evt);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OperationEnum.SAVE.getType().equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.saveSetVisibleAndEnable();
            }
        } else if (OperationEnum.MODIFY.getType().equals(operateKey)) {
            this.modifySetVisibleAndEnable();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name = f7.getProperty().getName();
        String sourceMethod = f7.getSourceMethod();
        if (name.equals("task")) {
            if (StringUtils.equals((CharSequence)"click", (CharSequence)sourceMethod)) {
                f7.setCancel(true);
                ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"fcc_checkout_task", (boolean)true);
                showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "task"));
                this.filterTask(showListForm, f7);
                this.getView().showForm((FormShowParameter)showListForm);
            } else if (StringUtils.equals((CharSequence)"getLookUpList", (CharSequence)sourceMethod)) {
                this.filterTask(null, f7);
                this.getView().getPageCache().remove("showListForm");
            } else if (StringUtils.equals((CharSequence)"setItemByIdFromClient", (CharSequence)sourceMethod)) {
                this.getView().getPageCache().put("setItem", "true");
            }
        } else if (name.equals("pretasks")) {
            this.filterPreTask(f7);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"task")) {
            if (null != closedCallBackEvent.getReturnData()) {
                this.changeTaskEntry(closedCallBackEvent);
                this.lockEntry(false);
            }
            this.getView().getPageCache().remove("showListForm");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"checkouttype", (CharSequence)propertyName)) {
            this.checkoutTypeChange();
        } else if (StringUtils.equals((CharSequence)"task", (CharSequence)propertyName)) {
            this.changeTaskInfo(e);
            this.clearTaskInfo(e);
        }
    }

    private void newDataSetVisibleAndEnable() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        view.setEnable(Boolean.valueOf(false), new String[]{"temptype", "bizsystem", "createorg"});
        this.getView().getPageCache().put("isNewData", "true");
    }

    private void bindDataSetVisibleAndEnable() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        String isModify = null;
        if (null != parentView) {
            isModify = parentView.getPageCache().get("isModify");
        }
        String isNewData = view.getPageCache().get("isNewData");
        String isCopyData = view.getPageCache().get("isCopyData");
        if (null != isNewData) {
            view.getPageCache().remove("isNewData");
            return;
        }
        if (null == isModify && null == isCopyData) {
            this.lockEntry(true);
            view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_save", "advcontoolbarap"});
        }
        if (null != isModify) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
            view.setEnable(Boolean.valueOf(false), new String[]{"createorg", "number"});
            this.lockEntry(false);
        }
        if (null != isCopyData) {
            view.setEnable(Boolean.valueOf(true), new String[]{"createorg", "number", "name", "checkouttype", "explain", "taskentry", "advcontoolbarap"});
        }
        if (null != parentView && null != isModify) {
            this.getView().getParentView().getPageCache().remove("isModify");
        }
        this.checkoutTypeChange();
    }

    private void saveSetVisibleAndEnable() {
        IFormView view = this.getView();
        this.lockEntry(true);
        view.setVisible(Boolean.valueOf(true), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        view.setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap", "bar_save"});
        view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
        view.updateView("taskentry");
    }

    private void lockEntry(boolean isLock) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("taskentry");
        DynamicObjectCollection taskEntries = model.getEntryEntity("taskentry");
        int rowCount = taskEntries.getRowCount();
        int[] rows = new int[rowCount];
        int[] pRows = new int[rowCount];
        if (isLock) {
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
        } else {
            for (int i = 0; i < taskEntries.size(); ++i) {
                DynamicObject taskEntry = (DynamicObject)taskEntries.get(i);
                Long pid = taskEntry.getLong("pid");
                Object task = taskEntry.get("task");
                if (pid != 0L) {
                    rows[i] = i;
                    pRows[i] = -1;
                    continue;
                }
                if (pid == 0L && null != task) {
                    rows[i] = -1;
                    pRows[i] = i;
                    continue;
                }
                rows[i] = -1;
                pRows[i] = -1;
            }
            entryGrid.setRowLock(true, pRows);
        }
        entryGrid.setRowLock(isLock, rows);
    }

    private void modifySetVisibleAndEnable() {
        IFormView view = this.getView();
        this.lockEntry(false);
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_delete", "bar_disable"});
        view.setVisible(Boolean.valueOf(true), new String[]{"advcontoolbarap", "bar_save"});
        view.setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo", "taskentry"});
        view.setEnable(Boolean.valueOf(false), new String[]{"createorg", "number"});
    }

    private void changeTaskEntry(ClosedCallBackEvent closedCallBackEvent) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("taskentry");
        DynamicObjectCollection taskEntry = this.getModel().getEntryEntity("taskentry");
        DynamicObject task = (DynamicObject)taskEntry.get(rowIndex);
        Long pid = (Long)task.get("pid");
        if (pid.equals(0L)) {
            this.buildRootTaskEntry(closedCallBackEvent);
        } else {
            this.buildTaskEntry(closedCallBackEvent, pid);
        }
    }

    private void buildRootTaskEntry(ClosedCallBackEvent closedCallBackEvent) {
        QFilter qFilter2;
        Long orgId;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        for (ListSelectedRow selectedRow : returnData) {
            Long id = (Long)selectedRow.getPrimaryKeyValue();
            taskIdList.add(id);
        }
        QFilter[] qFilters = new QFilter[2];
        DynamicObject createOrg = (DynamicObject)model.getValue("createorg");
        Long l = orgId = createOrg != null ? Long.valueOf(createOrg.getLong("id")) : null;
        if (null != orgId) {
            QFilter qFilter1;
            qFilters[0] = qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"fcc_checkout_task", (Long)orgId);
        }
        qFilters[1] = qFilter2 = new QFilter("virtualtask.id", "in", taskIdList);
        Map taskLoadMap = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_task", (String)"id,number,name,taskType,startdate,enddate,starttime,endtime,virtualtask.id", (QFilter[])qFilters, (String)"number");
        Map<Long, List<DynamicObject>> taskMap = taskLoadMap.values().stream().collect(Collectors.groupingBy(t -> t.getLong("virtualtask.id")));
        int rowIndex = model.getEntryCurrentRowIndex("taskentry");
        for (int i = 0; i < taskIdList.size(); ++i) {
            int index = 0;
            if (i > 0) {
                model.createNewEntryRow("taskentry");
                rowIndex = model.getEntryRowCount("taskentry") - 1;
            }
            Long id = (Long)taskIdList.get(i);
            model.setValue("task", (Object)id, rowIndex);
            List<DynamicObject> tasksList = taskMap.get(id);
            if (null == tasksList || tasksList.size() == 0) continue;
            for (DynamicObject task : tasksList) {
                model.insertEntryRow("taskentry", rowIndex);
                model.setValue("task", (Object)task.getLong("id"), rowIndex + ++index);
                model.setValue("startdate", (Object)task.getInt("startdate"), rowIndex + index);
                model.setValue("starttime", task.getInt("starttime") != -1 ? task.get("starttime") : Integer.valueOf(0), rowIndex + index);
                model.setValue("enddate", (Object)task.getInt("enddate"), rowIndex + index);
                model.setValue("endtime", task.getInt("endtime") != -1 ? task.get("endtime") : Integer.valueOf(0), rowIndex + index);
            }
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl("taskentry");
        treeEntryGrid.setCollapse(false);
        view.updateView("taskentry");
    }

    private void buildTaskEntry(ClosedCallBackEvent closedCallBackEvent, Long rootId) {
        Long pkId;
        IDataModel model = this.getModel();
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
        int currentRowIndex = model.getEntryCurrentRowIndex("taskentry");
        ArrayList<Long> taskIdList = new ArrayList<Long>(2);
        ListSelectedRowCollection taskCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        for (ListSelectedRow selectedRow : taskCollection) {
            pkId = (Long)selectedRow.getPrimaryKeyValue();
            taskIdList.add(pkId);
        }
        Map<Long, DynamicObject> taskMap = Arrays.stream(BusinessDataServiceHelper.load((String)"fcc_checkout_task", (String)"id,number,name,tasktype,startdate,enddate,starttime,endtime", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIdList)})).collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
        for (int i = 0; i < taskCollection.size(); ++i) {
            if (i > 0) {
                model.appendEntryRow("taskentry", ++currentRowIndex - 1, 1);
            }
            pkId = (Long)taskCollection.get(i).getPrimaryKeyValue();
            DynamicObject task = taskMap.get(pkId);
            model.setValue("task", (Object)pkId, currentRowIndex);
            model.setValue("startdate", (Object)task.getInt("startdate"), currentRowIndex);
            model.setValue("starttime", task.getInt("starttime") != -1 ? task.get("starttime") : Integer.valueOf(0), currentRowIndex);
            model.setValue("enddate", (Object)task.getInt("enddate"), currentRowIndex);
            model.setValue("endtime", task.getInt("endtime") != -1 ? task.get("endtime") : Integer.valueOf(0), currentRowIndex);
        }
    }

    private void filterTask(ListShowParameter showListForm, BeforeF7SelectEvent f7) {
        Long orgId;
        IDataModel model = this.getModel();
        ArrayList<Long> taskPidList = new ArrayList<Long>();
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
        DynamicObject createOrg = (DynamicObject)model.getValue("createorg");
        DynamicObject current = (DynamicObject)taskEntry.get(f7.getRow());
        Long currentPid = (Long)current.get("pid");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        ArrayList<QFilter> treeQFilterList = new ArrayList<QFilter>(1);
        if (currentPid.equals(0L)) {
            Long orgId2;
            QFilter qFilter3;
            for (DynamicObject entry : taskEntry) {
                Long pid = (Long)entry.get("pid");
                DynamicObject task = (DynamicObject)entry.get("task");
                if (!pid.equals(0L) || null == task) continue;
                taskPidList.add(task.getLong("id"));
            }
            QFilter qFilter1 = new QFilter("tasktype", "=", (Object)TaskTypeEnum.TASK_SET.getType());
            qFilterList.add(qFilter1);
            QFilter qFilter2 = new QFilter("id", "not in", taskPidList);
            qFilterList.add(qFilter2);
            HashSet<Long> taskIdSet = new HashSet<Long>(1);
            QFilter[] qFilters = new QFilter[2];
            qFilters[0] = qFilter3 = new QFilter("tasktype", "!=", (Object)TaskTypeEnum.TASK_SET.getType());
            Long l = orgId2 = createOrg != null ? Long.valueOf(createOrg.getLong("id")) : null;
            if (null != orgId2) {
                QFilter qFilter4;
                qFilters[1] = qFilter4 = BaseDataServiceHelper.getBaseDataFilter((String)"fcc_checkout_task", (Long)orgId2);
            }
            Map childTasks = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_task", (String)"virtualtask.id", (QFilter[])qFilters);
            for (DynamicObject task : childTasks.values()) {
                taskIdSet.add(task.getLong("virtualtask.id"));
            }
            QFilter qFilter5 = new QFilter("id", "in", taskIdSet);
            qFilterList.add(qFilter5);
        } else {
            Long currentId = -1L;
            for (DynamicObject entry : taskEntry) {
                Long pid = (Long)entry.get("pid");
                Long id = (Long)entry.get("id");
                DynamicObject task = (DynamicObject)entry.get("task");
                if (pid.equals(currentPid) && null != task) {
                    taskPidList.add(task.getLong("id"));
                }
                if (!currentPid.equals(id) || null == task) continue;
                currentId = task.getLong("id");
                Long groupId = (Long)task.get("group.id");
                groupIdList.add(groupId);
            }
            QFilter qFilter1 = new QFilter("virtualtask.id", "=", (Object)currentId);
            QFilter qFilter2 = new QFilter("id", "not in", taskPidList);
            qFilterList.add(qFilter1);
            qFilterList.add(qFilter2);
            QFilter treeQFilter = new QFilter("id", "in", groupIdList);
            treeQFilterList.add(treeQFilter);
        }
        Long l = orgId = createOrg != null ? Long.valueOf(createOrg.getLong("id")) : null;
        if (null != orgId) {
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fcc_checkout_task", (Long)orgId);
            qFilterList.add(qFilter);
        }
        if (null == showListForm) {
            showListForm = (ListShowParameter)f7.getFormShowParameter();
        }
        showListForm.getListFilterParameter().setQFilters(qFilterList);
        if (null != treeQFilterList && treeQFilterList.size() > 0) {
            showListForm.getTreeFilterParameter().setQFilters(treeQFilterList);
        }
    }

    private void filterPreTask(BeforeF7SelectEvent f7) {
        QFilter treeQFilter;
        QFilter qFilter2;
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        ArrayList<QFilter> treeQFilterList = new ArrayList<QFilter>(2);
        ArrayList<Long> taskIdList = new ArrayList<Long>(2);
        ArrayList<Long> enableTaskIdList = new ArrayList<Long>(2);
        ArrayList<Long> enableGroupIdList = new ArrayList<Long>(2);
        HashMap tasksMap = new HashMap(2);
        int row = f7.getRow();
        boolean isEnable = true;
        DynamicObject currentTask = (DynamicObject)model.getValue("task", row);
        if (null != currentTask) {
            Long currentTaskId = currentTask.getLong("id");
            DynamicObjectCollection taskEntry = model.getEntryEntity("taskentry");
            for (DynamicObject taskDetail : taskEntry) {
                MulBasedataDynamicObjectCollection preTasks = (MulBasedataDynamicObjectCollection)taskDetail.get("pretasks");
                ArrayList<Long> preTaskIdList = new ArrayList<Long>(2);
                DynamicObject task = taskDetail.getDynamicObject("task");
                if (null == task) continue;
                Long id = task.getLong("id");
                String taskType = task.getString("tasktype");
                if (id.equals(currentTaskId) || StringUtils.equals((CharSequence)TaskTypeEnum.TASK_SET.getType(), (CharSequence)taskType)) continue;
                enableTaskIdList.add(id);
                enableGroupIdList.add(task.getLong("group.id"));
                if (null == preTasks) continue;
                for (DynamicObject preTask : preTasks) {
                    preTaskIdList.add(preTask.getLong("fbasedataid_id"));
                }
                if (preTaskIdList.contains(currentTaskId)) {
                    Long taskId = task.getLong("id");
                    taskIdList.add(taskId);
                }
                tasksMap.put(id, preTaskIdList);
            }
            taskIdList.add(currentTaskId);
            tasksMap.put(currentTaskId, enableTaskIdList);
            for (DynamicObject taskDetail : taskEntry) {
                Boolean hasCycle;
                Long id;
                DynamicObject task = (DynamicObject)taskDetail.get("task");
                if (null == task || (id = Long.valueOf(task.getLong("id"))).equals(currentTaskId) || !(hasCycle = HasCycleUtils.hasCycle((Long)id, tasksMap)).booleanValue()) continue;
                taskIdList.add(id);
            }
        } else {
            isEnable = false;
        }
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        if (!isEnable) {
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            treeQFilterList.add(qFilter);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.getTreeFilterParameter().setQFilters(treeQFilterList);
            return;
        }
        if (null != taskIdList && taskIdList.size() > 0) {
            QFilter qFilter1 = new QFilter("id", "not in", taskIdList);
            qFilterList.add(qFilter1);
        }
        if (null != enableTaskIdList && enableTaskIdList.size() > 0) {
            qFilter2 = new QFilter("id", "in", enableTaskIdList);
            qFilterList.add(qFilter2);
        } else {
            qFilter2 = new QFilter("id", "=", (Object)0L);
            qFilterList.add(qFilter2);
        }
        if (null != enableGroupIdList && enableGroupIdList.size() > 0) {
            treeQFilter = new QFilter("id", "in", enableGroupIdList);
            treeQFilterList.add(treeQFilter);
        } else {
            treeQFilter = new QFilter("id", "=", (Object)0L);
            treeQFilterList.add(treeQFilter);
        }
        showParameter.getTreeFilterParameter().setQFilters(treeQFilterList);
        showParameter.getListFilterParameter().setQFilters(qFilterList);
    }

    private void insertChildTaskEntry(BeforeItemClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("taskentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckOutTemplateFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectRows.length > 1) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4efb\u52a1\u65b0\u589e\u5b50\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CheckOutTemplateFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentry");
        DynamicObject dataEntity = (DynamicObject)entryEntity.get(selectRows[0]);
        Long pid = dataEntity.getLong("pid");
        if (0L != pid) {
            evt.setCancel(true);
            List parentTasks = entryEntity.stream().filter(task -> task.getLong("id") == pid.longValue()).collect(Collectors.toList());
            DynamicObject parentTask = (DynamicObject)parentTasks.get(0);
            int seq = parentTask.getInt("seq");
            this.getModel().insertEntryRow("taskentry", seq - 1);
        }
    }

    private void checkoutTypeChange() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String checkoutType = (String)model.getValue("checkouttype");
        if (checkoutType.equals(CheckoutCycleEnum.DAY_END.getValue())) {
            view.setVisible(Boolean.valueOf(false), new String[]{"startdate"});
            view.setVisible(Boolean.valueOf(false), new String[]{"enddate"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"startdate"});
            view.setVisible(Boolean.valueOf(true), new String[]{"enddate"});
        }
    }

    private void clearTaskInfo(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject task = changeData.getDataEntity();
        Object oldValue = changeData.getOldValue();
        if (null == oldValue) {
            return;
        }
        model.setValue("pretasks", null);
        if (null == task) {
            return;
        }
        model.setValue("startdate", task.get("startdate") != null ? Integer.valueOf(task.getInt("startdate")) : null, rowIndex);
        model.setValue("starttime", task.getInt("starttime") != -1 ? task.get("starttime") : Integer.valueOf(0), rowIndex);
        model.setValue("enddate", task.get("enddate") != null ? Integer.valueOf(task.getInt("enddate")) : null, rowIndex);
        model.setValue("endtime", task.getInt("endtime") != -1 ? task.get("endtime") : Integer.valueOf(0), rowIndex);
    }

    private void changeTaskInfo(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String setItem = this.getView().getPageCache().get("setItem");
        if (null == setItem) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        int index = 0;
        DynamicObject taskEn = changeData.getDataEntity();
        if (null == taskEn) {
            return;
        }
        DynamicObject pTask = (DynamicObject)taskEn.get("task");
        if (null == pTask) {
            return;
        }
        String taskType = pTask.getString("tasktype");
        if (!StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.TASK_SET.getType())) {
            return;
        }
        Long taskId = pTask.getLong("id");
        Map taskLoadMap = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_task", (String)"id,number,name,taskType,startdate,enddate,starttime,endtime,virtualtask.id", (QFilter[])new QFilter[]{new QFilter("virtualtask.id", "=", (Object)taskId)}, (String)"number");
        List tasksList = taskLoadMap.values().stream().collect(Collectors.toList());
        if (null == tasksList || tasksList.size() == 0) {
            return;
        }
        for (DynamicObject task : tasksList) {
            model.insertEntryRow("taskentry", rowIndex);
            model.setValue("task", (Object)task.getLong("id"), rowIndex + ++index);
            model.setValue("startdate", (Object)task.getInt("startdate"), rowIndex + index);
            model.setValue("starttime", task.getInt("starttime") != -1 ? task.get("starttime") : Integer.valueOf(0), rowIndex + index);
            model.setValue("enddate", (Object)task.getInt("enddate"), rowIndex + index);
            model.setValue("endtime", task.getInt("endtime") != -1 ? task.get("endtime") : Integer.valueOf(0), rowIndex + index);
        }
        view.getPageCache().remove("setItem");
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl("taskentry");
        treeEntryGrid.setCollapse(false);
        this.lockEntry(false);
    }
}

