/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;

public class CheckoutFlowDetailFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(CheckoutFlowDetailFormPlugin.class);
    private static final String TASK_NUMBER = "tasknumber";
    private static final String EORG = "eorg";
    private static final String EBIZORG = "ebizorg";
    private static final String EXECUTOR = "executor";
    private static final String START_DATE = "starttime";
    private static final String END_DATE = "endtime";
    private static final String START_DAYTIME = "startdaytime";
    private static final String END_DAYTIME = "enddaytime";
    private static final String PRE_TASKS = "pretasks";
    private static final String PRE_TASKS_TEXT = "pretaskstext";
    private static final String TYPE = "type";
    private static final String BIZBOOKTYPE = "bizbooktype";
    private static final String TASKNUM = "tasknum";
    private static final String TASK_ENTRY = "taskentry";
    private static final String COPY_ENTRY = "copyrow";
    private static final String KEY_LABEL = "labelap";
    private static final String FCC_CHECKOUT_TASK = "fcc_checkout_task";
    private static final String FCC_BIZSYSTEM = "fcc_bizsystem";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_MEMBER = "fcc_checkout_user";
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tasknumber = (BasedataEdit)this.getControl(TASK_NUMBER);
        BasedataEdit executor = (BasedataEdit)this.getControl(EXECUTOR);
        BasedataEdit eorg = (BasedataEdit)this.getControl(EORG);
        tasknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        executor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        eorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
        this.addClickListeners(new String[]{PRE_TASKS_TEXT});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map params = param.getCustomParams();
        if (params == null || params.size() == 0) {
            return;
        }
        Object plan = params.get("planId");
        Object org = params.get("orgId");
        Object isleaf = params.get("isleaf");
        if (plan != null && org != null) {
            Long orgId = Long.valueOf(org.toString());
            Long planId = Long.valueOf(plan.toString());
            if (isleaf != null && "isleaf".equals(isleaf.toString())) {
                this.getView().setStatus(OperationStatus.VIEW);
                model.setValue("plan", null);
            } else {
                model.setValue("plan", (Object)planId);
            }
            model.setValue("org", (Object)orgId);
        }
        model.setValue("flowdate", params.get("plandate"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        this.setControlEnable(entryEntity);
        this.disableVirtualTaskInfo();
        this.setLabel();
        this.setPreTasksText(entryEntity);
        this.setDateRange();
    }

    private void setDateRange() {
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan != null && CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
            DateTimeEdit startTime = (DateTimeEdit)this.getView().getControl(START_DATE);
            DateTimeEdit endTIme = (DateTimeEdit)this.getView().getControl(END_DATE);
            Date month = plan.getDate("month");
            startTime.setMinDate(month);
            endTIme.setMinDate(month);
            Calendar cal = Calendar.getInstance();
            cal.setTime(month);
            cal.add(2, 2);
            cal.add(5, -1);
            startTime.setMaxDate(cal.getTime());
            endTIme.setMaxDate(cal.getTime());
        }
    }

    private void setControlEnable(DynamicObjectCollection entryEntity) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirm", "canconfirm", "bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_insertentry", COPY_ENTRY, "moveentryup", "moveentrydown", "tb_del"});
            for (DynamicObject dynamicObject : entryEntity) {
                this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{TASK_NUMBER, EBIZORG, BIZBOOKTYPE, EORG, TYPE, EXECUTOR, START_DATE, END_DATE, START_DAYTIME, END_DAYTIME, PRE_TASKS_TEXT});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_LABEL, "flowstatus"});
            return;
        }
        String flowstatus = (String)this.getModel().getValue("flowstatus");
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan == null) {
            return;
        }
        String planstatus = plan.getString("planstatus");
        if ("B".equals(planstatus) || "D".equals(planstatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_insertentry", COPY_ENTRY, "moveentryup", "moveentrydown", "tb_del"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirm", "canconfirm", "bar_save"});
            for (DynamicObject dynamicObject : entryEntity) {
                this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{TASK_NUMBER, EBIZORG, BIZBOOKTYPE, EORG, TYPE, EXECUTOR, START_DATE, END_DATE, START_DAYTIME, END_DAYTIME, PRE_TASKS_TEXT});
            }
            if (flowstatus.equals(CheckoutFlowStatusEnum.confirm.getType())) {
                this.setBorderStyle();
            }
        } else if (flowstatus.equals(CheckoutFlowStatusEnum.confirm.getType())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_insertentry", COPY_ENTRY, "moveentryup", "moveentrydown", "tb_del", "bar_save", "flowperson"});
            for (DynamicObject dynamicObject : entryEntity) {
                this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{TASK_NUMBER, EBIZORG, BIZBOOKTYPE, EORG, TYPE, EXECUTOR, START_DATE, END_DATE, START_DAYTIME, END_DAYTIME, PRE_TASKS_TEXT});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirm"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"canconfirm"});
            this.setBorderStyle();
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"tb_new", "tb_insertentry", COPY_ENTRY, "moveentryup", "moveentrydown", "tb_del", "bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"confirm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"canconfirm"});
            HashSet<Long> set = new HashSet<Long>(entryEntity.size());
            for (DynamicObject dynamicObject : entryEntity) {
                if (!"a".equals(dynamicObject.getString("taskstatus"))) {
                    this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{TASK_NUMBER, EBIZORG, BIZBOOKTYPE, EORG, TYPE, EXECUTOR, START_DATE, END_DATE, START_DAYTIME, END_DAYTIME, PRE_TASKS_TEXT});
                    long pid = dynamicObject.getLong("pid");
                    set.add(pid);
                    continue;
                }
                if (StringUtils.isEmpty((String)dynamicObject.getString(TYPE))) {
                    this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{BIZBOOKTYPE});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, dynamicObject.getInt("seq") - 1, new String[]{BIZBOOKTYPE});
            }
            for (DynamicObject dynamicObject : entryEntity) {
                if (!set.contains(dynamicObject.getLong("id"))) continue;
                this.getView().setEnable(Boolean.FALSE, dynamicObject.getInt("seq") - 1, new String[]{TASK_NUMBER, EBIZORG, BIZBOOKTYPE, EORG, TYPE, EXECUTOR, START_DATE, END_DATE, START_DAYTIME, END_DAYTIME, PRE_TASKS_TEXT});
            }
        }
    }

    private void setPreTasksText(DynamicObjectCollection entryEntity) {
        QFilter qFilter = new QFilter("flowid", "=", this.getModel().getValue("id"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"flowid,taskrowid,entryentity.tasknumber", (QFilter[])new QFilter[]{qFilter});
        if (load == null || load.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> preTasksMap = Arrays.stream(load).collect(Collectors.groupingBy(preTask -> preTask.getLong("taskrowid")));
        for (DynamicObject task : entryEntity) {
            DynamicObject preTask2;
            DynamicObjectCollection entryentity;
            List<DynamicObject> preTasks;
            if (!task.containsProperty(PRE_TASKS_TEXT) || task.getLong("pid") == 0L || (preTasks = preTasksMap.get(task.getLong("id"))) == null || preTasks.size() == 0 || (entryentity = (preTask2 = preTasks.get(0)).getDynamicObjectCollection("entryentity")) == null || entryentity.size() <= 0) continue;
            List preTasksNames = entryentity.stream().map(entry -> entry.getDynamicObject(TASK_NUMBER).getString("name")).collect(Collectors.toList());
            String name = org.apache.commons.lang3.StringUtils.join(preTasksNames, (String)"\uff0c");
            this.getModel().setValue(PRE_TASKS_TEXT, (Object)name, task.getInt("seq") - 1);
        }
        this.getModel().updateCache();
    }

    private void setBorderStyle() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(2);
        fieldMap.put("fc", "#1DB363");
        this.getView().updateControlMetadata("flowstatus", fieldMap);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setLabel();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.setLabel();
    }

    public void setLabel() {
        Label label = (Label)this.getView().getControl(KEY_LABEL);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        label.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"CheckoutFlowDetailFormPlugin_7", (String)"fi-fcc-formplugin", (Object[])new Object[0]), entryEntity.size()));
        List pid = entryEntity.stream().filter(entry -> entry.getLong("pid") != 0L).collect(Collectors.toList());
        this.getModel().setValue(TASKNUM, (Object)pid.size());
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getModel().setValue("flowstatus", (Object)CheckoutFlowStatusEnum.confirm.getType());
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(currentRowIndex);
        long pid = dynamicObject.getLong("pid");
        if (TASK_NUMBER.equals(name)) {
            String sourceMethod = evt.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod)) {
                this.getPageCache().put("sourceMethod", "getLookUpList");
            }
            this.taskBeforeF7Select(evt, pid, entryEntity);
        } else if (EXECUTOR.equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
        } else if (EORG.equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
        }
    }

    private void taskBeforeF7Select(BeforeF7SelectEvent evt, long pid, DynamicObjectCollection entryEntity) {
        FormShowParameter showParameter = evt.getFormShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FCC_CHECKOUT_FLOW_DETAIL));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        ArrayList<Long> selectedTasks = new ArrayList<Long>();
        if (pid != 0L) {
            DynamicObject parentTask = null;
            for (DynamicObject object : entryEntity) {
                DynamicObject o;
                if (object.getLong("id") == pid) {
                    if (object.get(TASK_NUMBER) == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u96c6\u3002", (String)"CheckoutFlowDetailFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    parentTask = (DynamicObject)object.get(TASK_NUMBER);
                    continue;
                }
                if (object.getLong("pid") != pid || (o = (DynamicObject)object.get(TASK_NUMBER)) == null) continue;
                selectedTasks.add(o.getLong("id"));
            }
            if (parentTask != null) {
                qFilters.add(new QFilter("virtualtask", "=", parentTask.getPkValue()));
                qFilters.add(new QFilter("id", "not in", selectedTasks));
            }
        } else {
            qFilters.add(new QFilter("virtualtask", "=", (Object)0));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObjectCollection dynamicObjects = BaseDataServiceHelper.queryBaseData((String)FCC_CHECKOUT_TASK, (Long)org.getLong("id"), (QFilter)new QFilter("enable", "=", (Object)"1"), (String)"id,virtualtask");
            Map<Long, List<DynamicObject>> map = dynamicObjects.stream().filter(task -> task.getLong("virtualtask") != 0L).collect(Collectors.groupingBy(task -> task.getLong("virtualtask")));
            if (map != null && map.size() > 0) {
                Set<Long> longs = map.keySet();
                qFilters.add(new QFilter("id", "in", longs));
            }
        }
        evt.setCustomQFilters(qFilters);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.equals(FCC_CHECKOUT_FLOW_DETAIL)) {
            ListSelectedRowCollection returnData2 = (ListSelectedRowCollection)evt.getReturnData();
            if (returnData2 != null && !returnData2.isEmpty()) {
                this.buildCurAndSubTask(returnData2);
            }
            this.disableVirtualTaskInfo();
        } else if (PRE_TASKS_TEXT.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            String preTaskNames = returnData.toString();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
            this.getModel().setValue(PRE_TASKS_TEXT, (Object)preTaskNames, currentRowIndex);
            this.getModel().updateCache();
        }
    }

    private void disableVirtualTaskInfo() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection taskEntry = model.getEntryEntity(TASK_ENTRY);
        for (int i = 0; i < taskEntry.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)taskEntry.get(i);
            DynamicObject task = (DynamicObject)((DynamicObject)taskEntry.get(i)).get(TASK_NUMBER);
            if (null != task && dynamicObject.getLong("pid") != 0L) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{PRE_TASKS_TEXT});
            view.setEnable(Boolean.FALSE, i, new String[]{START_DATE});
            view.setEnable(Boolean.FALSE, i, new String[]{END_DATE});
            view.setEnable(Boolean.FALSE, i, new String[]{START_DAYTIME});
            view.setEnable(Boolean.FALSE, i, new String[]{END_DAYTIME});
        }
    }

    private void buildCurAndSubTask(ListSelectedRowCollection returnData) {
        List virtualTaskIds = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (virtualTaskIds.isEmpty()) {
            return;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        DynamicObject task = (DynamicObject)entryEntity.get(currentRowIndex);
        if (task.getLong("pid") != 0L) {
            QFilter qFilter = new QFilter("id", "in", virtualTaskIds);
            Map taskMap = BusinessDataServiceHelper.loadFromCache((String)FCC_CHECKOUT_TASK, (String)"id,bizsystem.id,startdate,enddate,starttime,endtime", (QFilter[])new QFilter[]{qFilter}, (String)"number");
            for (int i = 0; i < virtualTaskIds.size(); ++i) {
                if (i > 0) {
                    this.getModel().appendEntryRow(TASK_ENTRY, currentRowIndex, i);
                    ++currentRowIndex;
                }
                this.setSubTask(currentRowIndex, (DynamicObject)taskMap.get(virtualTaskIds.get(i)));
            }
        } else {
            this.deleteCurAndSubTask(currentRowIndex);
            int[] ints = new int[virtualTaskIds.size()];
            for (int i = 0; i < virtualTaskIds.size(); ++i) {
                Object virtualTaskId = virtualTaskIds.get(i);
                int virtualTaskRow = this.createVirtualTask(virtualTaskId);
                this.createSubTasks(virtualTaskRow, virtualTaskId);
                ints[i] = virtualTaskRow;
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TASK_ENTRY);
            treeEntryGrid.expand(ints);
        }
    }

    private boolean buildCurAndSubTask(long taskId) {
        String sourceMethod = this.getPageCache().get("sourceMethod");
        if (StringUtils.isEmpty((String)sourceMethod) || !"getLookUpList".equals(sourceMethod)) {
            return false;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        DynamicObject task = (DynamicObject)entryEntity.get(currentRowIndex);
        if (task.getLong("pid") != 0L) {
            return false;
        }
        this.getPageCache().remove("sourceMethod");
        this.deleteCurAndSubTask(currentRowIndex);
        int virtualTaskRow = this.createVirtualTask(taskId);
        this.createSubTasks(virtualTaskRow, taskId);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TASK_ENTRY);
        treeEntryGrid.expand(virtualTaskRow);
        return true;
    }

    private void deleteCurAndSubTask(int currentRowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        if (entryEntity.isEmpty()) {
            return;
        }
        DynamicObject curTask = (DynamicObject)entryEntity.get(currentRowIndex);
        long id = curTask.getLong("id");
        List subTasks = entryEntity.stream().filter(task -> task.getLong("pid") == id).collect(Collectors.toList());
        if (!subTasks.isEmpty()) {
            for (int i = 0; i < subTasks.size(); ++i) {
                this.getModel().deleteEntryRow(TASK_ENTRY, currentRowIndex + subTasks.size() - i);
                this.getModel().updateCache();
            }
        }
        this.getModel().deleteEntryRow(TASK_ENTRY, currentRowIndex);
        this.getModel().updateCache();
    }

    private int createVirtualTask(Object virtualTaskId) {
        int newEntryRow = this.getModel().createNewEntryRow(TASK_ENTRY);
        this.getModel().updateCache();
        DynamicObject task = BusinessDataServiceHelper.loadSingleFromCache((Object)virtualTaskId, (String)FCC_CHECKOUT_TASK);
        logger.info("createVirtualTask() \u521b\u5efa\u4efb\u52a1\u96c6\uff1a" + task.getString("name") + ";\u884c\u53f7\uff1a" + newEntryRow + ";entrysize()" + this.getModel().getEntryEntity(TASK_ENTRY).size());
        this.setVirtualTask(newEntryRow, task);
        return newEntryRow;
    }

    private void createSubTasks(int parentRowIndex, Object virtualTaskId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter = new QFilter("virtualtask", "=", virtualTaskId);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection subTasks = BaseDataServiceHelper.queryBaseData((String)FCC_CHECKOUT_TASK, (Long)org.getLong("id"), (QFilter)qFilter, (String)"id,name");
        if (subTasks == null || subTasks.isEmpty()) {
            return;
        }
        for (DynamicObject subTask : subTasks) {
            int i = this.getModel().insertEntryRow(TASK_ENTRY, parentRowIndex);
            this.getModel().updateCache();
            logger.info("createSubTasks() \u521b\u5efa\u5b50\u4efb\u52a1\uff1a" + subTask.getString("name") + ";\u884c\u53f7\uff1a" + i + ";\u7236\u4efb\u52a1\u884c\u53f7\uff1a" + parentRowIndex + ";entrysize()" + this.getModel().getEntryEntity(TASK_ENTRY).size());
            this.setSubTask(i, subTask);
        }
    }

    private void setSubTask(int newEntryRow, DynamicObject subTask) {
        this.getModel().setValue(TASK_NUMBER, (Object)subTask.getLong("id"), newEntryRow);
    }

    private void setPlanDate(DynamicObject subTask, int newEntryRow) {
        int startday = subTask.getInt("startdate");
        int endday = subTask.getInt("enddate");
        int starttime = (Integer)subTask.get(START_DATE);
        int endtime = (Integer)subTask.get(END_DATE);
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan == null) {
            return;
        }
        String method = plan.getString("method");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(newEntryRow);
        if (dynamicObject.getLong("pid") == 0L) {
            return;
        }
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            Date month = plan.getDate("month");
            Date startDate = this.getPlanDate(startday, starttime, month);
            this.getModel().setValue(START_DATE, (Object)startDate, newEntryRow);
            Date endDate = this.getPlanDate(endday, endtime, month);
            this.getModel().setValue(END_DATE, (Object)endDate, newEntryRow);
        } else {
            this.getModel().setValue(START_DAYTIME, (Object)starttime, newEntryRow);
            this.getModel().setValue(END_DAYTIME, (Object)endtime, newEntryRow);
        }
    }

    private Date getPlanDate(int day, int time, Date month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(month);
        calendar.add(2, 1);
        calendar.add(5, day - 1);
        Date monthAndDay = calendar.getTime();
        long l = 0L;
        l = time >= 0 ? monthAndDay.getTime() + (long)time * 1000L : monthAndDay.getTime();
        return new Date(l);
    }

    private void setVirtualTask(int newEntryRow, DynamicObject entry) {
        this.getModel().setValue(TASK_NUMBER, (Object)entry.getLong("id"), newEntryRow);
    }

    private void setExcutor(DynamicObject org, DynamicObject task, int newEntryRow) {
        String selectFields = "org.id,fcc_checkout_members.businesssystem.id,fcc_checkout_members.member.id";
        QFilter qFilter = new QFilter("org.id", "=", org.getPkValue());
        qFilter.and("fcc_checkout_members.businesssystem.id", "=", (Object)task.getLong("bizsystem.id"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)FCC_CHECKOUT_MEMBER, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long aLong = row.getLong("fcc_checkout_members.member.id");
                this.getModel().setValue(EXECUTOR, (Object)aLong, newEntryRow);
            } else {
                this.getModel().setValue(EXECUTOR, null, newEntryRow);
            }
        }
    }

    private void setEorg(DynamicObject bizOrgColl, int newEntryRow) {
        if (bizOrgColl != null) {
            this.getModel().setValue(EBIZORG, (Object)bizOrgColl.getLong("toorg"), newEntryRow);
        } else {
            this.getModel().setValue(EBIZORG, this.getModel().getValue("org"), newEntryRow);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        block21: {
            String itemKey;
            block20: {
                super.beforeItemClick(evt);
                itemKey = evt.getItemKey();
                if (!"tb_insertentry".equals(itemKey)) break block20;
                EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckoutFlowDetailFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectRows.length > 1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4efb\u52a1\u65b0\u589e\u5b50\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CheckoutFlowDetailFormPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[0]);
                long pid = dynamicObject.getLong("pid");
                if (pid == 0L) break block21;
                evt.setCancel(true);
                List parentTasks = entryEntity.stream().filter(task -> task.getLong("id") == pid).collect(Collectors.toList());
                DynamicObject parentTask = (DynamicObject)parentTasks.get(0);
                int seq = parentTask.getInt("seq");
                this.getModel().insertEntryRow(TASK_ENTRY, seq - 1);
                break block21;
            }
            if ("tb_del".equals(itemKey)) {
                evt.setCancel(true);
                EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckoutFlowDetailFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
                if (this.validateTaskDel(entryEntity, selectRows)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u53ea\u80fd\u591a\u9009\u4efb\u52a1\u96c6\u6216\u5b50\u4efb\u52a1\u3002", (String)"CheckoutFlowDetailFormPlugin_5", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (int i = selectRows.length - 1; i >= 0; --i) {
                    int selectRow = selectRows[i];
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow);
                    long pid = dynamicObject.getLong("pid");
                    long id = dynamicObject.getLong("id");
                    if (pid == 0L) {
                        List executedSubTasks = entryEntity.stream().filter(task -> task.getLong("pid") == id && !"a".equals(task.getString("taskstatus"))).collect(Collectors.toList());
                        if (executedSubTasks.size() > 0) {
                            List subTasks = entryEntity.stream().filter(task -> task.getLong("pid") == id).collect(Collectors.toList());
                            if (subTasks.size() <= 0) continue;
                            for (int j = subTasks.size() - 1; j >= 0; --j) {
                                DynamicObject subTask = (DynamicObject)subTasks.get(j);
                                String taskstatus = subTask.getString("taskstatus");
                                if (!"a".equals(taskstatus)) {
                                    DynamicObject task2 = subTask.getDynamicObject(TASK_NUMBER);
                                    if (task2 == null) continue;
                                    String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u5df2\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CheckoutFlowDetailFormPlugin_6", (String)"fi-fcc-formplugin", (Object[])new Object[0]), task2.getString("name"));
                                    this.getView().showTipNotification(format);
                                    continue;
                                }
                                this.getModel().deleteEntryRow(TASK_ENTRY, subTask.getInt("seq") - 1);
                                this.getModel().updateCache();
                            }
                            continue;
                        }
                        this.deleteCurAndSubTask(selectRow);
                        continue;
                    }
                    String taskstatus = dynamicObject.getString("taskstatus");
                    if (!"a".equals(taskstatus)) {
                        DynamicObject task3 = dynamicObject.getDynamicObject(TASK_NUMBER);
                        if (task3 == null) continue;
                        String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u5df2\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CheckoutFlowDetailFormPlugin_6", (String)"fi-fcc-formplugin", (Object[])new Object[0]), task3.getString("name"));
                        this.getView().showTipNotification(format);
                        continue;
                    }
                    List otherSubTask = entryEntity.stream().filter(entry -> entry.getLong("pid") == pid && entry.getLong("id") != id).collect(Collectors.toList());
                    this.getModel().deleteEntryRow(TASK_ENTRY, selectRow);
                    this.getModel().updateCache();
                    if (!otherSubTask.isEmpty()) continue;
                    this.getModel().deleteEntryRow(TASK_ENTRY, selectRow - 1);
                    this.getModel().updateCache();
                }
            } else if (COPY_ENTRY.equals(itemKey)) {
                DynamicObject dynamicObject;
                EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckoutFlowDetailFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection taskentry = this.getModel().getEntryEntity(TASK_ENTRY);
                for (int selectRow : selectRows) {
                    dynamicObject = (DynamicObject)taskentry.get(selectRow);
                    long pid = dynamicObject.getLong("pid");
                    if (pid == 0L) continue;
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4efb\u52a1\u96c6\u624d\u80fd\u590d\u5236\u3002", (String)"CheckoutFlowDetailFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (int selectRow : selectRows) {
                    dynamicObject = (DynamicObject)taskentry.get(selectRow);
                    this.copyFirstEntry(dynamicObject, taskentry);
                }
                this.disableVirtualTaskInfo();
            } else if ("bar_save".equals(itemKey) || "confirm".equals(itemKey)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
                for (int i = entryEntity.size() - 1; i >= 0; --i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    if (dynamicObject.getDynamicObject(TASK_NUMBER) != null) continue;
                    long pid = dynamicObject.getLong("pid");
                    long id = dynamicObject.getLong("id");
                    int seq = dynamicObject.getInt("seq");
                    if (pid == 0L) {
                        this.deleteCurAndSubTask(seq - 1);
                        continue;
                    }
                    List otherSubTask = entryEntity.stream().filter(entry -> entry.getLong("pid") == pid && entry.getLong("id") != id).collect(Collectors.toList());
                    this.getModel().deleteEntryRow(TASK_ENTRY, seq - 1);
                    if (otherSubTask.size() != 0) continue;
                    this.getModel().deleteEntryRow(TASK_ENTRY, seq - 2);
                    --i;
                }
            }
        }
    }

    private boolean validateTaskDel(DynamicObjectCollection entryEntity, int[] selectRows) {
        int parent = 0;
        int sub = 0;
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow);
            long pid = dynamicObject.getLong("pid");
            if (pid != 0L) {
                ++sub;
                continue;
            }
            ++parent;
        }
        return parent > 0 && sub > 0;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void copyFirstEntry(DynamicObject dynamicObject, DynamicObjectCollection taskentry) {
        long id = dynamicObject.getLong("id");
        List subTaskEntry = taskentry.stream().filter(entry -> entry.getLong("pid") == id).collect(Collectors.toList());
        int index = this.getModel().createNewEntryRow(TASK_ENTRY);
        this.getModel().updateCache();
        this.setCopyEntry(dynamicObject, index);
        if (subTaskEntry.size() > 0) {
            for (DynamicObject entry2 : subTaskEntry) {
                this.copySubEntry(index, entry2);
            }
        }
        this.getModel().updateCache();
    }

    public void copySubEntry(int parentIndex, DynamicObject dynamicObject) {
        int newEntryRow = this.getModel().insertEntryRow(TASK_ENTRY, parentIndex);
        this.getModel().updateCache();
        this.setCopyEntry(dynamicObject, newEntryRow);
    }

    public void setCopyEntry(DynamicObject dynamicObject, int index) {
        this.getModel().setValue(TASK_NUMBER, dynamicObject.get(TASK_NUMBER), index);
        this.getModel().setValue(EORG, dynamicObject.get(EORG), index);
        this.getModel().setValue(EBIZORG, dynamicObject.get(EBIZORG), index);
        this.getModel().setValue(BIZBOOKTYPE, dynamicObject.get(BIZBOOKTYPE), index);
        this.getModel().setValue(TYPE, dynamicObject.get(TYPE), index);
        this.getModel().setValue(EXECUTOR, dynamicObject.get(EXECUTOR), index);
        this.getModel().setValue(START_DATE, dynamicObject.get(START_DATE), index);
        this.getModel().setValue(END_DATE, dynamicObject.get(END_DATE), index);
        this.getModel().setValue(START_DAYTIME, dynamicObject.get(START_DAYTIME), index);
        this.getModel().setValue(END_DAYTIME, dynamicObject.get(END_DAYTIME), index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("confirm".equals(operateKey)) {
            this.checkPlanStatus(args);
        } else if ("canconfirm".equals(operateKey)) {
            this.checkPlanStatus(args);
        } else if ("save".equals(operateKey)) {
            this.checkPlanStatus(args);
        }
    }

    private void checkPlanStatus(BeforeDoOperationEventArgs args) {
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        DynamicObject currPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)plan.getPkValue(), (String)FCC_CHECKOUT_PLAN);
        if ("B".equals(currPlan.getString("planstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5df2\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckoutFlowDetailFormPlugin_9", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("newentry".equals(operateKey) || COPY_ENTRY.equals(operateKey)) {
            this.disableVirtualTaskInfo();
        } else if ("confirm".equals(operateKey) || "canconfirm".equals(operateKey)) {
            OperationResult operationResult2 = args.getOperationResult();
            if (operationResult2.isSuccess()) {
                this.getView().invokeOperation("refresh");
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("currOrg", org.getPkValue().toString());
                operateOption.setVariableValue(operateKey, operateKey);
                this.getView().getParentView().invokeOperation("refresh", operateOption);
                IFormView parentView = this.getView().getParentView();
                parentView.updateView("treeviewap");
                this.getView().sendFormAction(parentView);
            }
        } else if ("save".equals(operateKey) && (operationResult = args.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        logger.info("propertyChanged(): rowIndex:" + rowIndex + ";entrysize():" + this.getModel().getEntryEntity(TASK_ENTRY).size());
        if (TASK_NUMBER.equals(name)) {
            DynamicObject newTask = (DynamicObject)newValue;
            if (newTask == null) {
                return;
            }
            if (this.buildCurAndSubTask(newTask.getLong("id"))) {
                this.disableVirtualTaskInfo();
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org.getLong("id");
            DynamicObject bizOrgColl = this.getBizOrgColl(orgId);
            this.setEorg(bizOrgColl, rowIndex);
            this.setType(newTask, rowIndex);
            this.setExcutor(org, newTask, rowIndex);
            this.setPlanDate(newTask, rowIndex);
            this.getModel().setValue(PRE_TASKS_TEXT, null, rowIndex);
        } else if (EBIZORG.equals(name)) {
            this.setSubTaskField(EBIZORG, rowIndex, newValue);
        } else if (BIZBOOKTYPE.equals(name)) {
            this.setSubTaskField(BIZBOOKTYPE, rowIndex, newValue);
        } else if (EXECUTOR.equals(name)) {
            this.setSubTaskField(EXECUTOR, rowIndex, newValue);
        }
    }

    private void setType(DynamicObject newTask, int rowIndex) {
        DynamicObject dynamicObject;
        DynamicObject bizsystem = newTask.getDynamicObject("bizsystem");
        if (bizsystem != null && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizsystem.getPkValue(), (String)FCC_BIZSYSTEM)) != null) {
            Object type = dynamicObject.get(TYPE);
            this.getModel().setValue(TYPE, type, rowIndex);
            if (ObjectUtils.isEmpty((Object)type)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{BIZBOOKTYPE});
            }
        }
    }

    public void setSubTaskField(String field, int rowIndex, Object newValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        logger.info("setSubTaskField(): entryEntity size\uff1a" + entryEntity.size() + ";rowIndex:" + rowIndex);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
        if (dynamicObject.getLong("pid") == 0L) {
            for (DynamicObject task : entryEntity) {
                if (task.getLong("pid") != dynamicObject.getLong("id")) continue;
                this.getModel().setValue(field, newValue, task.getInt("seq") - 1);
            }
        }
    }

    public DynamicObject getBizOrgColl(long bizOrgID) {
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("fromorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizOrgColl = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (bizOrgColl.isEmpty()) {
            return null;
        }
        return (DynamicObject)bizOrgColl.get(0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PRE_TASKS_TEXT.equals(key)) {
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex(TASK_ENTRY);
            Long flowId = (Long)model.getValue("id");
            DynamicObjectCollection entryEntity = model.getEntryEntity(TASK_ENTRY);
            DynamicObject task = (DynamicObject)entryEntity.get(currentRowIndex);
            if (task.getLong("pid") == 0L) {
                return;
            }
            Object taskId = task.getPkValue();
            this.openPreTasksForm(taskId, flowId);
        }
    }

    private void openPreTasksForm(Object taskId, Long flowId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FCC_CHECKOUT_PRETASKS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRE_TASKS_TEXT));
        QFilter qFilter = new QFilter("flowid", "=", (Object)flowId);
        qFilter.and("taskrowid", "=", taskId);
        DynamicObject preTask = QueryServiceHelper.queryOne((String)FCC_CHECKOUT_PRETASKS, (String)"id", (QFilter[])new QFilter[]{qFilter});
        boolean edit = false;
        if (preTask != null) {
            showParameter.setPkId((Object)preTask.get("id").toString());
            edit = true;
        }
        if (!edit) {
            showParameter.setCustomParam("flowId", (Object)flowId);
            showParameter.setCustomParam("taskId", taskId);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRY);
        List otherSubTasks = entryEntity.stream().filter(otherTask -> otherTask.getLong("pid") != 0L && !otherTask.getPkValue().equals(taskId)).collect(Collectors.toList());
        ArrayList entries = new ArrayList(otherSubTasks.size());
        for (DynamicObject otherSubTask : otherSubTasks) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put(TASK_NUMBER, otherSubTask.getLong(FCCField.id_((String)TASK_NUMBER)));
            map.put(EBIZORG, otherSubTask.getLong(FCCField.id_((String)EBIZORG)));
            map.put(TYPE, otherSubTask.getString(TYPE));
            map.put(START_DATE, otherSubTask.getDate(START_DATE));
            map.put(END_DATE, otherSubTask.getDate(END_DATE));
            map.put(START_DAYTIME, otherSubTask.getInt(START_DAYTIME));
            map.put(END_DAYTIME, otherSubTask.getInt(END_DAYTIME));
            map.put(BIZBOOKTYPE, otherSubTask.getLong(FCCField.id_((String)BIZBOOKTYPE)));
            map.put("othertaskid", otherSubTask.getLong("id"));
            entries.add(map);
        }
        showParameter.setCustomParam(TASK_ENTRY, entries);
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan != null) {
            showParameter.setCustomParam("method", (Object)plan.getString("method"));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

