/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;

public class CheckoutFlowDetailListPlugin
extends AbstractListPlugin {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_FLOW = "fcc_checkout_flow";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        Object sourceFlag = params.get("sourceFlag");
        if (sourceFlag != null && (sourceFlag.toString().startsWith(FCC_CHECKOUT_PLAN) || FCC_CHECKOUT_FLOW.equals(sourceFlag.toString()))) {
            String fieldName = args.getFieldName();
            if ("plan.id".equals(fieldName)) {
                args.addCustomQFilter(new QFilter("planstatus", "=", (Object)"A"));
            } else if ("org.id".equals(fieldName)) {
                args.getCustomParams().put("isIncludeAllSub", true);
                String planId = this.getPageCache().get("planId");
                List<Long> viewOrgIds = this.getCheckoutViewOrgIds(Long.parseLong(planId));
                QFilter qFilter = new QFilter("id", "in", viewOrgIds);
                args.addCustomQFilter(qFilter);
            }
        }
        super.filterContainerBeforeF7Select(args);
    }

    private Map<Object, DynamicObject> getEnableLeafOrgByView(long view) {
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)FCC_CHECKOUT_FLOW_DETAIL, (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("view", "=", (Object)view);
        qFilter.and("isleaf", "=", (Object)"1");
        qFilter.and("org.enable", "=", (Object)"1");
        if (!fcc.hasAllOrgPerm()) {
            qFilter.and("org", "in", (Object)fcc.getHasPermOrgs());
        }
        String selectProperties = "id,org.id,org.name,org.number,parent.id,isleaf,longnumber";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        return orgStructures;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        String fieldName = args.getFieldName();
        if ("org.id".equals(fieldName)) {
            Long planid = (Long)params.get("planid");
            List<Long> viewOrgIds = this.getCheckoutViewOrgIds(planid);
            QFilter qFilter = new QFilter("id", "in", viewOrgIds);
            args.addCustomQFilter(qFilter);
        }
    }

    public List<Long> getCheckoutViewOrgIds(long planid) {
        long view = CheckOutViewUtil.getView((Long)planid);
        Map<Object, DynamicObject> orgStructures = this.getEnableLeafOrgByView(view);
        List<Long> viewOrgIds = orgStructures.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
        return viewOrgIds;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        Object sourceFlag = params.get("sourceFlag");
        Long planid = (Long)params.get("planid");
        String paramStr = this.getPageCache().get("sourceFlag");
        if (StringUtils.isEmpty((String)paramStr) && sourceFlag != null && (sourceFlag.toString().startsWith(FCC_CHECKOUT_PLAN) || sourceFlag.toString().equals(FCC_CHECKOUT_FLOW))) {
            this.getPageCache().put("sourceFlag", sourceFlag.toString());
            this.getPageCache().put("planId", params.get("planid").toString());
            FilterColumn planidFilter = args.getFilterColumn("plan.id");
            planidFilter.setDefaultValue(String.valueOf(planid));
            FilterColumn flowstatusFilter = args.getFilterColumn("flowstatus");
            if (sourceFlag.equals("fcc_checkout_plan_field")) {
                String flowstatus = params.get("flowstatus").toString();
                flowstatusFilter.setDefaultValues(new Object[]{flowstatus});
            } else {
                ArrayList<String> defaultParams = new ArrayList<String>(2);
                defaultParams.add("1");
                defaultParams.add("2");
                flowstatusFilter.setDefaultValues(defaultParams);
            }
            FilterColumn orgidFilter = args.getFilterColumn("org.id");
            orgidFilter.setDefaultValue(null);
        } else {
            Map filters;
            FilterColumn filterColumn = args.getFilterColumn("plan.id");
            ControlFilters controlFilters = filterColumn.getContext().getControlFilters();
            if (controlFilters != null && !(filters = controlFilters.getFilters()).isEmpty()) {
                ControlFilter controlFilter = (ControlFilter)filters.get("plan.id");
                String planId = controlFilter.getValue().get(0).toString();
                this.getPageCache().put("planId", planId);
                filterColumn.setDefaultValue(controlFilter.getValue().get(0).toString());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("confirm".equals(operateKey) || "canconfirm".equals(operateKey)) {
            String planId = this.getPageCache().get("planId");
            Map plans = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{planId}, (String)FCC_CHECKOUT_PLAN);
            DynamicObject plan = (DynamicObject)plans.get(Long.parseLong(planId));
            if (plan == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8ba1\u5212\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckoutFlowDetailListPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("B".equals(plan.getString("planstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5df2\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckoutFlowDetailListPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!"refresh".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String planId = this.getPageCache().get("planId");
        List<Long> viewOrgIds = this.getCheckoutViewOrgIds(Long.parseLong(planId));
        QFilter qFilter = new QFilter("org.id", "in", viewOrgIds);
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)FCC_CHECKOUT_PLAN);
        String method = plan.getString("method");
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            qFilter.and(new QFilter("flowdate", "=", (Object)plan.getDate("month")));
        } else {
            Date currentDate;
            Date startDate = plan.getDate("startdate");
            if (startDate.after(currentDate = DateUtils.getCurrentDate())) {
                qFilter.and(new QFilter("flowdate", "=", (Object)startDate));
            } else {
                QFilter qFilter1 = new QFilter("flowdate", "<=", (Object)DateUtils.getCurrentDate());
                DynamicObject[] flowDateDescs = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,flowdate", (QFilter[])new QFilter[]{qFilter1}, (String)"flowdate desc", (int)1);
                if (flowDateDescs.length > 0) {
                    DynamicObject flowdateDesc = flowDateDescs[0];
                    qFilter.and(new QFilter("flowdate", "=", (Object)flowdateDesc.getDate("flowdate")));
                }
            }
        }
        e.addCustomQFilter(qFilter);
    }
}

