/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.enums.OrgPermissionEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;

public class CheckoutFlowFormPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
SearchEnterListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(CheckoutFlowFormPlugin.class);
    private TreeView orgTree;
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_FLOW = "fcc_checkout_flow";
    private static final Long ACC_VIEW = 10L;

    public void initialize() {
        super.initialize();
        this.orgTree = (TreeView)this.getView().getControl("treeviewap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.orgTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "importdata", "tblassign"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("plan");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("plan".equals(name)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("planstatus", "!=", (Object)"C");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject plan = this.initCheckoutPlan();
        if (plan == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutFlowFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4", "flexpanelap"});
            return;
        }
        this.initAcctOrgTree(plan.getLong("id"));
    }

    private DynamicObject initCheckoutPlan() {
        QFilter qFilter = new QFilter("month", "<=", (Object)new Date());
        qFilter.and("planstatus", "!=", (Object)"C");
        qFilter.and("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
        Map month_desc = BusinessDataServiceHelper.loadFromCache((String)FCC_CHECKOUT_PLAN, (String)"id,number,name,method,month,startdate,planstatus", (QFilter[])new QFilter[]{qFilter}, (String)"month desc");
        ArrayList values = new ArrayList(month_desc.values());
        if (values.size() > 0) {
            DynamicObject plan = (DynamicObject)values.get(0);
            this.getModel().setValue("plan", (Object)plan.getLong("id"));
            this.initPlanDate(plan);
            this.getModel().updateCache();
            return plan;
        }
        return null;
    }

    private void refreshCheckoutPlan() {
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan != null) {
            this.getPageCache().put("setPlanToNull", "setPlanToNull");
            this.getModel().setValue("plan", null);
            this.getModel().setValue("plan", (Object)plan.getLong("id"));
            this.initPlanDate(plan);
            this.getModel().setValue("checkbox", (Object)false);
            this.getModel().updateCache();
            this.getView().updateView("plan");
        }
    }

    private void initAcctOrgTree(long planId) {
        this.orgTree.deleteAllNodes();
        this.getPageCache().remove("treenode");
        long view = CheckOutViewUtil.getView((Long)planId);
        if (view == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u4fdd\u5b58/\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u7ed3\u8d26\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CheckoutFlowFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode orgTreeNode = this.getTreeNode(planId, view);
        if (orgTreeNode == null) {
            orgTreeNode = this.getNullTreeNode();
        }
        this.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)orgTreeNode));
        this.orgTree.addNode(orgTreeNode);
        this.orgTree.focusNode(orgTreeNode);
        this.orgTree.treeNodeClick("", orgTreeNode.getId());
        TreeNodeEvent tne = new TreeNodeEvent((Object)this.orgTree, (Object)orgTreeNode.getParentid(), (Object)orgTreeNode.getId());
        this.treeNodeClick(tne);
    }

    private TreeNode getNullTreeNode() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        DynamicObject rootOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)rootOrgId, (String)"bos_org");
        String rootName = rootOrg.getString("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(String.valueOf(rootOrgId));
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(rootOrg.getString("number"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    private void initUnConfirmOrgTree(long planId) {
        this.orgTree.deleteAllNodes();
        this.getPageCache().remove("treenode");
        long view = CheckOutViewUtil.getView((Long)planId);
        if (view == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u4fdd\u5b58/\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u7ed3\u8d26\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CheckoutFlowFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode orgTreeNode = this.getUnConfirmTreeNode(planId, view);
        if (orgTreeNode == null) {
            return;
        }
        this.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)orgTreeNode));
        this.orgTree.addNode(orgTreeNode);
        this.orgTree.focusNode(orgTreeNode);
        this.orgTree.treeNodeClick("", orgTreeNode.getId());
        TreeNodeEvent tne = new TreeNodeEvent((Object)this.orgTree, (Object)orgTreeNode.getParentid(), (Object)orgTreeNode.getId());
        this.treeNodeClick(tne);
    }

    public TreeNode getTreeNode(long planId, Long orgViewSchemaId) {
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)FCC_CHECKOUT_FLOW_DETAIL, (String)OrgPermissionEnum.VIEW.getValue());
        QFilter qFilter = null;
        HashSet<Long> set = new HashSet<Long>();
        if (!fcc.hasAllOrgPerm()) {
            List hasPermOrgs = fcc.getHasPermOrgs();
            logger.info("hasPermOrgs:" + JSON.toJSONString((Object)hasPermOrgs));
            Map<Long, List<Long>> allSuperiorOrgs = this.getAllSuperiorOrgs(orgViewSchemaId, hasPermOrgs);
            logger.info("allSuperiorOrgs:" + JSON.toJSONString(allSuperiorOrgs));
            if (!allSuperiorOrgs.isEmpty()) {
                for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
                    Long key = entry.getKey();
                    List<Long> value = entry.getValue();
                    set.add(key);
                    set.addAll(value);
                }
            } else {
                set.addAll(hasPermOrgs);
            }
            qFilter = new QFilter("org", "in", set);
        }
        logger.info("set:" + JSON.toJSONString(set));
        Map orgTreeMap = CheckOutViewUtil.getAllOrgByViewId((Long)planId, qFilter, (boolean)true);
        logger.info("orgTreeMap:" + JSON.toJSONString((Object)orgTreeMap));
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)orgTreeMap);
        Map<String, String> statusMap = this.getStatusByPlanAndOrg();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        logger.info("rootOrgId:" + rootOrgId);
        TreeNode rootTreeNode = this.createTreeNode(orgTreeMap, Long.toString(rootOrgId), statusMap);
        if (rootTreeNode != null && flatOrgTreeMap.size() > 0) {
            this.createChildNodes(flatOrgTreeMap, rootTreeNode.getId(), rootTreeNode, statusMap);
        }
        return rootTreeNode;
    }

    public TreeNode getUnConfirmTreeNode(long planId, Long orgViewSchemaId) {
        DynamicObject[] dynamicObjects = this.getUnConfirmOrg(planId, orgViewSchemaId);
        HashMap<String, String> statusMap = new HashMap<String, String>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject org = (DynamicObject)dynamicObject.get("org");
                String pkValue = org.getPkValue().toString();
                String flowstatus = dynamicObject.getString("flowstatus");
                statusMap.put(pkValue, CheckoutFlowStatusEnum.getValue((String)flowstatus));
                orgIds.add(org.getLong("id"));
            }
        } else {
            return null;
        }
        HashSet<Long> set = new HashSet<Long>();
        Map<Long, List<Long>> allSuperiorOrgs = this.getAllSuperiorOrgs(orgViewSchemaId, orgIds);
        if (!allSuperiorOrgs.isEmpty()) {
            for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
                Long key = entry.getKey();
                List<Long> value = entry.getValue();
                set.add(key);
                set.addAll(value);
            }
        } else {
            set.addAll(orgIds);
        }
        QFilter qFilter = new QFilter("org", "in", set);
        Map orgTreeMap = CheckOutViewUtil.getAllOrgByViewId((Long)planId, (QFilter)qFilter, (boolean)true);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)orgTreeMap);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        TreeNode rootTreeNode = this.createTreeNode(orgTreeMap, Long.toString(rootOrgId), statusMap);
        if (rootTreeNode != null && flatOrgTreeMap.size() > 0) {
            this.createChildNodes(flatOrgTreeMap, rootTreeNode.getId(), rootTreeNode, statusMap);
        }
        return rootTreeNode;
    }

    private DynamicObject[] getUnConfirmOrg(long planId, long viewId) {
        QFilter qFilter = new QFilter("plan", "=", (Object)planId);
        qFilter.and("flowstatus", "=", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
        qFilter.and("flowdate", "=", this.getModel().getValue("plandate"));
        Map orgByView = CheckOutViewUtil.getHasPermOrgByView((long)viewId);
        if (orgByView == null || orgByView.size() <= 0) {
            return null;
        }
        List viewOrgIds = orgByView.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
        qFilter.and("org", "in", viewOrgIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"org,flowstatus", (QFilter[])new QFilter[]{qFilter});
        return dynamicObjects;
    }

    public Map<String, String> getStatusByPlanAndOrg() {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
        qFilter.and("flowdate", "=", this.getModel().getValue("plandate"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"org,flowstatus", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String pkValue = dynamicObject.get("org_id").toString();
                String flowstatus = dynamicObject.getString("flowstatus");
                statusMap.put(pkValue, CheckoutFlowStatusEnum.getValue((String)flowstatus));
            }
        }
        return statusMap;
    }

    public TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap, String orgId, Map<String, String> statusMap) {
        if (orgTreeMap == null || orgTreeMap.size() == 0) {
            return null;
        }
        logger.info("orgTreeMap.keySet():" + orgTreeMap.keySet());
        String rootName = orgTreeMap.get(orgId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(orgId);
        if (kd.bos.util.StringUtils.isNotEmpty((String)statusMap.get(orgId))) {
            root.setText(rootName + "-" + statusMap.get(orgId));
        } else {
            root.setText(rootName);
        }
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(orgId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root, Map<String, String> statusMap) {
        if (orgTreeMap != null && rootId != null && orgTreeMap.size() != 0 && root != null) {
            this.buildTreeNode(orgTreeMap, rootId, root, statusMap);
            return root;
        }
        return null;
    }

    public void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode, Map<String, String> statusMap) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        Map dataMap = (Map)treeNode.getData();
        if (childList != null && childList.size() != 0) {
            treeNode.setLeaf(false);
            String parentName = (String)dataMap.get("fullname");
            for (Map<String, String> org : childList) {
                TreeNode childrenTree = new TreeNode();
                String orgid = org.get("id");
                if (Long.valueOf(0L).equals(Long.valueOf(orgid)) || kd.bos.util.StringUtils.isEmpty((String)org.get("name"))) continue;
                childrenTree.setParentid(org.get("parentid"));
                childrenTree.setId(orgid);
                if (kd.bos.util.StringUtils.isNotEmpty((String)statusMap.get(orgid))) {
                    childrenTree.setText(org.get("name") + "-" + statusMap.get(orgid));
                } else {
                    childrenTree.setText(org.get("name"));
                }
                childrenTree.setIsOpened(false);
                childrenTree.setLongNumber(org.get("longnumber"));
                HashMap<String, String> childDataMap = new HashMap<String, String>(3);
                childDataMap.put("level", String.valueOf(childrenTree.getLongNumber().split("!").length));
                childDataMap.put("fullname", parentName + "_" + org.get("name"));
                childrenTree.setData(childDataMap);
                treeNode.addChild(childrenTree);
                this.buildTreeNode(orgTreeMap, orgid, childrenTree, statusMap);
            }
            AccountingSysUtil.sortTreeNode((List)treeNode.getChildren());
        } else {
            dataMap.put("isleaf", "1");
            treeNode.setLeaf(true);
        }
    }

    public void search(SearchEnterEvent e) {
        String content;
        String text = e.getText();
        String focusNodeId = this.orgTree.getTreeState().getFocusNodeId();
        boolean isFocus = false;
        boolean matched = false;
        if (focusNodeId == null) {
            isFocus = true;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(content = this.getPageCache().get("treenode")))) {
            return;
        }
        TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)content, TreeNode.class);
        List<TreeNode> allTreeNode = this.getAllChildrenAndSelf(orgTreeNode);
        TreeNode treeNode = null;
        for (TreeNode matchedTreeNode : allTreeNode) {
            if (matchedTreeNode.getId().equals(focusNodeId)) {
                isFocus = true;
                continue;
            }
            if (!this.patten(matchedTreeNode.getText(), text) || !isFocus) continue;
            treeNode = matchedTreeNode;
            matchedTreeNode.setExpend(true);
            matched = true;
            break;
        }
        if (!matched) {
            for (TreeNode matchedTreeNode : allTreeNode) {
                if (matchedTreeNode.getId().equals(focusNodeId)) {
                    if (!this.patten(matchedTreeNode.getText(), text)) break;
                    treeNode = matchedTreeNode;
                    matchedTreeNode.setExpend(true);
                    break;
                }
                if (!this.patten(matchedTreeNode.getText(), text)) continue;
                treeNode = matchedTreeNode;
                matchedTreeNode.setExpend(true);
                break;
            }
        }
        if (treeNode != null) {
            this.orgTree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            this.orgTree.showNode(treeNode.getId());
            this.orgTree.focusNode(treeNode);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"CheckoutFlowFormPlugin_10", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"CheckoutFlowFormPlugin_11", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean patten(String name, String search) {
        return Pattern.matches(".*" + search + ".*", name);
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(0, parentNode);
        return allChildren;
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children != null && children.size() != 0) {
            ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
            for (TreeNode child : children) {
                result.addAll(this.getAllChildren(child));
            }
            return result;
        }
        return new ArrayList<TreeNode>();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Long orgId = Long.valueOf((String)evt.getNodeId());
        IDataModel model = this.getModel();
        Long planId = (Long)model.getValue("plan_id");
        boolean leaf = true;
        Map focusNode = this.orgTree.getTreeState().getFocusNode();
        if (focusNode.get("isParent") != null) {
            leaf = (Boolean)focusNode.get("isParent");
            if (orgId.equals(OrgUnitServiceHelper.getRootOrgId())) {
                leaf = true;
            }
        } else if (focusNode.get("leaf") != null) {
            boolean bl = leaf = (Boolean)focusNode.get("leaf") == false;
        }
        if (!leaf) {
            this.showDetailForm(planId, orgId, true);
        } else {
            this.showDetailForm(planId, orgId, false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = args.getOperateKey();
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan == null) {
            return;
        }
        if ("refresh".equals(operateKey)) {
            this.refreshCheckoutPlan();
            this.initAcctOrgTree(plan.getLong("id"));
            if (!source.getOption().containsVariable("currOrg")) {
                return;
            }
            String currOrg = source.getOption().getVariableValue("currOrg");
            String content = this.getPageCache().get("treenode");
            TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)content, TreeNode.class);
            TreeNode treeNode = orgTreeNode.getTreeNode(currOrg);
            this.orgTree.focusNode(treeNode);
            TreeNodeEvent tne = new TreeNodeEvent((Object)this.orgTree, (Object)"", (Object)currOrg);
            this.treeNodeClick(tne);
            OperateOption option = source.getOption();
            if (option.containsVariable("confirm")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f\u3002", (String)"CheckoutFlowFormPlugin_5", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            } else if (option.containsVariable("canconfirm")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u786e\u8ba4\u6210\u529f\u3002", (String)"CheckoutFlowFormPlugin_6", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("plan".equals(name)) {
            DynamicObject plan = (DynamicObject)changeSet[0].getNewValue();
            if (plan == null) {
                String setPlanToNull = this.getPageCache().get("setPlanToNull");
                if (kd.bos.util.StringUtils.isNotEmpty((String)setPlanToNull)) {
                    this.getPageCache().remove("setPlanToNull");
                    return;
                }
                this.getModel().setValue("plan", changeSet[0].getOldValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u8ba1\u5212\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"CheckoutFlowFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap4", "flexpanelap"});
            this.initPlanDate(plan);
            this.initAcctOrgTree(plan.getLong("id"));
            this.intiPlanProperties();
        } else if ("checkbox".equals(name)) {
            boolean newValue = (Boolean)changeSet[0].getNewValue();
            DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
            if (plan == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u8ba1\u5212\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"CheckoutFlowFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (newValue) {
                this.initUnConfirmOrgTree(plan.getLong("id"));
            } else {
                this.initAcctOrgTree(plan.getLong("id"));
            }
        }
    }

    private void initPlanDate(DynamicObject plan) {
        String method = plan.getString("method");
        logger.info("\u8ba1\u5212\u7ed3\u8d26\u5468\u671f\uff1a" + method);
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            logger.info("\u6708\u7ed3\uff1a" + CheckoutCycleEnum.MONTH_END.getValue());
            Date month = plan.getDate("month");
            this.getModel().setValue("plandate", (Object)month);
            this.getModel().setValue("month", (Object)month);
        } else {
            logger.info("\u65e5\u7ed3\uff1a" + CheckoutCycleEnum.DAY_END.getValue());
            Date startdate = plan.getDate("startdate");
            Date currentDate = DateUtils.getCurrentDate();
            if (startdate.after(currentDate)) {
                this.getModel().setValue("plandate", (Object)startdate);
            } else {
                QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
                qFilter.and("flowdate", "<=", (Object)DateUtils.getCurrentDate());
                DynamicObject[] flowDateDescs = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,flowdate", (QFilter[])new QFilter[]{qFilter}, (String)"flowdate desc", (int)1);
                if (flowDateDescs.length > 0) {
                    DynamicObject flowDateDesc = flowDateDescs[0];
                    Date flowDate = flowDateDesc.getDate("flowdate");
                    this.getModel().setValue("plandate", (Object)flowDate);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.intiPlanProperties();
    }

    public void intiPlanProperties() {
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        if (plan == null) {
            return;
        }
        String planstatus = plan.getString("planstatus");
        if ("B".equals(planstatus) || "D".equals(planstatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flowconfirm", "tblassign"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flowconfirm", "tblassign"});
        }
        String method = plan.getString("method");
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startdate", "enddate", "labelap3", "labelap4"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"month", "labelap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"startdate", "enddate", "labelap3", "labelap4"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"month", "labelap"});
        }
    }

    private void showDetailForm(Long planId, Long orgId, boolean leaf) {
        BillShowParameter billShowParam = new BillShowParameter();
        billShowParam.setFormId(FCC_CHECKOUT_FLOW_DETAIL);
        billShowParam.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParam.getOpenStyle().setTargetKey("flexpanelap2");
        String pageId = UUID.randomUUID().toString().replace("-", "") + "1";
        billShowParam.setPageId(pageId);
        DynamicObject plan = BusinessDataServiceHelper.loadSingleFromCache((Object)planId, (String)FCC_CHECKOUT_PLAN);
        if (plan == null) {
            return;
        }
        boolean edit = false;
        if (planId != null && planId != 0L) {
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and("plan", "=", (Object)planId);
            qFilter.and("flowdate", "=", this.getModel().getValue("plandate"));
            DynamicObject checkoutFlowDetail = QueryServiceHelper.queryOne((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (checkoutFlowDetail != null) {
                billShowParam.setPkId((Object)checkoutFlowDetail.getLong("id"));
                edit = true;
            }
        }
        if (!edit) {
            HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
            paramMap.put("orgId", orgId);
            paramMap.put("planId", planId);
            billShowParam.setCustomParams(paramMap);
        }
        billShowParam.setCustomParam("plandate", this.getModel().getValue("plandate"));
        billShowParam.setCustomParam("method", (Object)plan.getString("method"));
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
            billShowParam.setCustomParam("month", (Object)plan.getDate("month"));
        } else {
            billShowParam.setCustomParam("startdate", (Object)plan.getDate("startdate"));
            billShowParam.setCustomParam("enddate", (Object)plan.getDate("enddate"));
        }
        if (!leaf) {
            billShowParam.setBillStatus(BillOperationStatus.VIEW);
            billShowParam.setCustomParam("isleaf", (Object)"isleaf");
        }
        this.getView().showForm((FormShowParameter)billShowParam);
        this.getPageCache().put("pageId", pageId);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("flowconfirm".equals(itemKey)) {
            DynamicObject plan;
            long planId = (Long)this.getModel().getValue("plan_id");
            if (planId != 0L && "B".equals((plan = BusinessDataServiceHelper.loadSingleFromCache((Object)planId, (String)FCC_CHECKOUT_PLAN)).getString("planstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5df2\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CheckoutFlowFormPlugin_7", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.openFlowConfirmView(planId);
        } else if ("refresh".equals(itemKey)) {
            this.getModel().setValue("checkbox", (Object)false);
        } else if ("tblassign".equals(itemKey)) {
            this.openTemplateAssign();
        }
    }

    public void openFlowConfirmView(long planId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(FCC_CHECKOUT_FLOW_DETAIL);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("planid", planId);
        params.put("flowstatus", CheckoutFlowStatusEnum.unconfirm.getType());
        params.put("sourceFlag", FCC_CHECKOUT_FLOW);
        listShowParameter.setCustomParams(params);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public Map<Long, List<Long>> getAllSuperiorOrgs(long viewId, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter filter = new QFilter("view", "=", (Object)viewId);
        if (orgIds.size() <= 1000) {
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            filter = filter.and(orgFilter);
        }
        return this.getAllSuperiorOrgs(filter, orgIds.size());
    }

    private Map<Long, List<Long>> getAllSuperiorOrgs(QFilter filter, int count) {
        HashMap<Long, List<Long>> parentIdMap = new HashMap<Long, List<Long>>(count);
        HashSet<String> parentNumbers = new HashSet<String>(count);
        HashMap<Long, String> parentLongNumberMap = new HashMap<Long, String>(count);
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(count);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllSuperiorOrgs", (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])filters, (String)"");){
            Iterator var10 = ds.iterator();
            while (var10.hasNext()) {
                Row row = (Row)var10.next();
                String longNumber = row.getString("longnumber");
                Long orgId = row.getLong("org");
                if (StringUtils.isBlank((CharSequence)longNumber)) {
                    parentIdMap.put(orgId, new ArrayList(0));
                    continue;
                }
                if (longNumber.indexOf("!") == -1) {
                    parentIdMap.put(orgId, new ArrayList(0));
                    numberIdMap.put(longNumber, orgId);
                    continue;
                }
                String[] numbers = longNumber.split("!");
                int currentNumberIndex = numbers.length - 1;
                String currentNumber = numbers[currentNumberIndex];
                numberIdMap.put(currentNumber, orgId);
                for (int i = 0; i < currentNumberIndex; ++i) {
                    String number = numbers[i];
                    parentNumbers.add(number);
                }
                parentLongNumberMap.put(orgId, StringUtils.substringBeforeLast((String)longNumber, (String)"!"));
                parentIdMap.put(orgId, new ArrayList(numbers.length));
            }
        }
        parentNumbers.removeAll(numberIdMap.keySet());
        numberIdMap.putAll(this.getOrgNumberIdMap(parentNumbers));
        HashMap<String, List<Long>> longNumberIdMap = new HashMap<String, List<Long>>(numberIdMap.size());
        for (Map.Entry parentEntry : parentLongNumberMap.entrySet()) {
            this.getParentIdByLongNumber((List)parentIdMap.get(parentEntry.getKey()), (String)parentEntry.getValue(), numberIdMap, longNumberIdMap);
        }
        return parentIdMap;
    }

    private void getParentIdByLongNumber(List<Long> orgIds, String parentLongNumber, Map<String, Long> numberIdMap, Map<String, List<Long>> longNumberIdMap) {
        List<Long> parentIds = longNumberIdMap.get(parentLongNumber);
        if (parentIds != null) {
            orgIds.addAll(parentIds);
        } else {
            String[] numbers = parentLongNumber.split("!");
            if (numbers.length != 0) {
                String[] var7 = numbers;
                int var8 = numbers.length;
                for (int var9 = 0; var9 < var8; ++var9) {
                    String number = var7[var9];
                    Long orgId = numberIdMap.get(number);
                    if (orgId == null) continue;
                    orgIds.add(orgId);
                }
                longNumberIdMap.put(parentLongNumber, orgIds);
            }
        }
    }

    private Map<String, Long> getOrgNumberIdMap(Collection<String> numbers) {
        if (numbers.isEmpty()) {
            return new HashMap<String, Long>(0);
        }
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter[] filters = new QFilter[]{numberFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"number", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(orgObjMap.size());
        for (Map.Entry orgEntry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)orgEntry.getValue();
            numberIdMap.put(orgObj.getString("number"), orgObj.getLong("id"));
        }
        return numberIdMap;
    }

    public void openTemplateAssign() {
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("fcc_template_assign");
        DynamicObject plan = (DynamicObject)this.getModel().getValue("plan");
        long planId = 0L;
        if (plan == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutFlowFormPlugin_9", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        planId = plan.getLong("id");
        listShowParameter.setCustomParam("plan", (Object)planId);
        listShowParameter.setCustomParam("method", (Object)plan.getString("method"));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openTemplateAssign"));
        this.getView().showForm(listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("openTemplateAssign".equals(key) && (returnData = closedCallBackEvent.getReturnData()) != null && "success".equals(returnData.toString())) {
            this.refreshCheckoutPlan();
        }
    }
}

