/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckoutFlowPreTaskFormPlugin
extends AbstractFormPlugin {
    private static final String FLOW_ID = "flowid";
    private static final String TASK_ROW_ID = "taskrowid";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TASK_NUMBER = "tasknumber";
    private static final String TYPE = "type";
    private static final String BIZBOOKTYPE = "bizbooktype";
    private static final String EBIZORG = "ebizorg";
    private static final String START_DATE = "starttime";
    private static final String END_DATE = "endtime";
    private static final String START_DAYTIME = "startdaytime";
    private static final String END_DAYTIME = "enddaytime";
    private static final String OTHERTASKID = "othertaskid";
    private static final String FCC_CHECKOUT_SELECTTASKS = "fcc_checkout_selecttasks";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        if (params == null || params.size() == 0) {
            return;
        }
        Object flowId = params.get("flowId");
        Object taskId = params.get("taskId");
        if (flowId != null && taskId != null) {
            model.setValue(FLOW_ID, flowId);
            model.setValue(TASK_ROW_ID, taskId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        if (params == null || params.size() == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entryEntity.size() == 0) {
            return;
        }
        List taskentry = (List)params.get("taskentry");
        if (taskentry == null || taskentry.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            for (Map map : taskentry) {
                if (!map.get(OTHERTASKID).equals(dynamicObject.getLong(OTHERTASKID))) continue;
                this.getModel().setValue(TASK_NUMBER, map.get(TASK_NUMBER), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(EBIZORG, map.get(EBIZORG), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(TYPE, map.get(TYPE), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(START_DATE, map.get(START_DATE), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(END_DATE, map.get(END_DATE), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(START_DAYTIME, map.get(START_DAYTIME), dynamicObject.getInt("seq") - 1);
                this.getModel().setValue(END_DAYTIME, map.get(END_DAYTIME), dynamicObject.getInt("seq") - 1);
                if (map.get(TYPE) == null || !StringUtils.isNotEmpty((CharSequence)map.get(TYPE).toString())) continue;
                this.getModel().setValue(BIZBOOKTYPE, map.get(BIZBOOKTYPE), dynamicObject.getInt("seq") - 1);
            }
        }
        this.getModel().updateCache();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String method = (String)showParameter.getCustomParam("method");
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{START_DAYTIME, END_DAYTIME});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{START_DATE, END_DATE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tb_new".equals(itemKey)) {
            evt.setCancel(true);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map params = showParameter.getCustomParams();
            if (params == null || params.size() == 0) {
                return;
            }
            List taskentry = (List)params.get("taskentry");
            List<Map<String, Object>> collect = null;
            if (taskentry.size() > 0) {
                collect = this.filterTaskEntry(taskentry);
            }
            this.openSelectTaskForm(collect);
        }
    }

    private List<Map<String, Object>> filterTaskEntry(List<Map<String, Object>> taskentry) {
        Long taskRowId = (Long)this.getModel().getValue(TASK_ROW_ID);
        Long flowId = (Long)this.getModel().getValue(FLOW_ID);
        List selectedIds = null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entryEntity.size() > 0) {
            List finalSelectedIds = selectedIds = entryEntity.stream().map(entry -> entry.getLong(OTHERTASKID)).collect(Collectors.toList());
            taskentry.removeIf(task -> finalSelectedIds.contains(task.get(OTHERTASKID)));
        }
        if (taskentry.size() == 0) {
            return null;
        }
        Map<Long, List<Long>> serviceMap = this.getServiceMap(flowId);
        if (serviceMap.size() > 0) {
            List<Long> preTaskIds = serviceMap.get(taskRowId);
            if (preTaskIds == null) {
                preTaskIds = new ArrayList<Long>(taskentry.size());
                serviceMap.put(taskRowId, preTaskIds);
            } else if (selectedIds != null && selectedIds.size() > 0) {
                serviceMap.put(taskRowId, selectedIds);
            }
            Iterator<Map<String, Object>> iterator = taskentry.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> task2 = iterator.next();
                long id = (Long)task2.get(OTHERTASKID);
                preTaskIds.add(id);
                serviceMap.put(taskRowId, preTaskIds);
                if (HasCycleUtils.hasCycle((Long)taskRowId, serviceMap).booleanValue()) {
                    iterator.remove();
                }
                preTaskIds.remove(id);
                serviceMap.put(taskRowId, preTaskIds);
            }
        }
        return taskentry;
    }

    private Map<Long, List<Long>> getServiceMap(Long flowId) {
        HashMap<Long, List<Long>> serviceMap = new HashMap<Long, List<Long>>();
        QFilter qFilter = new QFilter(FLOW_ID, "=", (Object)flowId);
        DynamicObjectCollection allPreTasks = QueryServiceHelper.query((String)FCC_CHECKOUT_PRETASKS, (String)"flowid,taskrowid,entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter});
        if (allPreTasks.size() > 0) {
            Map<Long, List<DynamicObject>> allPreTasksMapping = allPreTasks.stream().collect(Collectors.groupingBy(preTask -> preTask.getLong(TASK_ROW_ID)));
            for (Map.Entry<Long, List<DynamicObject>> entry : allPreTasksMapping.entrySet()) {
                Long taskId = entry.getKey();
                List<DynamicObject> preTasks = entry.getValue();
                if (preTasks.size() <= 0) continue;
                ArrayList<Long> ids = new ArrayList<Long>(preTasks.size());
                for (DynamicObject preTask2 : preTasks) {
                    long othertaskid = preTask2.getLong("entryentity.othertaskid");
                    if (othertaskid == 0L) continue;
                    ids.add(othertaskid);
                }
                serviceMap.put(taskId, ids);
            }
        }
        return serviceMap;
    }

    private void openSelectTaskForm(List<Map<String, Object>> taskentry) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FCC_CHECKOUT_SELECTTASKS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FCC_CHECKOUT_SELECTTASKS));
        showParameter.setCustomParam("taskentry", taskentry);
        showParameter.setCustomParam("method", parameter.getCustomParam("method"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (FCC_CHECKOUT_SELECTTASKS.equals(actionId) && returnData != null) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map params = showParameter.getCustomParams();
            List selectedPreTaskIds = (List)returnData;
            List taskentry = (List)params.get("taskentry");
            String method = (String)params.get("method");
            Map<Long, Map> taskEntryMap = taskentry.stream().collect(Collectors.toMap(map -> (Long)map.get(OTHERTASKID), map -> map));
            for (Long selectedPreTaskId : selectedPreTaskIds) {
                Map map2 = taskEntryMap.get(selectedPreTaskId);
                int newEntryRow = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                this.getModel().setValue(TASK_NUMBER, map2.get(TASK_NUMBER), newEntryRow);
                this.getModel().setValue(EBIZORG, map2.get(EBIZORG), newEntryRow);
                if (map2.get(TYPE) != null && kd.bos.util.StringUtils.isNotEmpty((String)map2.get(TYPE).toString())) {
                    this.getModel().setValue(TYPE, map2.get(TYPE), newEntryRow);
                    this.getModel().setValue(BIZBOOKTYPE, map2.get(BIZBOOKTYPE), newEntryRow);
                }
                if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                    this.getModel().setValue(START_DATE, map2.get(START_DATE), newEntryRow);
                    this.getModel().setValue(END_DATE, map2.get(END_DATE), newEntryRow);
                } else {
                    this.getModel().setValue(START_DAYTIME, map2.get(START_DAYTIME), newEntryRow);
                    this.getModel().setValue(END_DAYTIME, map2.get(END_DAYTIME), newEntryRow);
                }
                this.getModel().setValue(OTHERTASKID, map2.get(OTHERTASKID), newEntryRow);
            }
            this.getModel().updateCache();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            String returnData;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (entryEntity != null && entryEntity.size() > 0) {
                List names = entryEntity.stream().map(task -> task.getDynamicObject(TASK_NUMBER).getString("name")).collect(Collectors.toList());
                returnData = StringUtils.join(names, (String)",");
            } else {
                returnData = "";
            }
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }
}

