/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;

public class CheckoutFlowPreTaskSelectFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TASK_NUMBER = "tasknumber";
    private static final String EBIZORG = "ebizorg";
    private static final String TYPE = "type";
    private static final String BIZBOOKTYPE = "bizbooktype";
    private static final String START_DATE = "starttime";
    private static final String END_DATE = "endtime";
    private static final String START_DAYTIME = "startdaytime";
    private static final String END_DAYTIME = "enddaytime";
    private static final String OTHERTASKID = "othertaskid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List taskentry = (List)showParameter.getCustomParam("taskentry");
        if (taskentry != null && taskentry.size() > 0) {
            for (Map map : taskentry) {
                int newEntryRow = model.createNewEntryRow(ENTRY_ENTITY);
                model.setValue(TASK_NUMBER, map.get(TASK_NUMBER), newEntryRow);
                model.setValue(EBIZORG, map.get(EBIZORG), newEntryRow);
                if (map.get(TYPE) != null && StringUtils.isNotEmpty((String)map.get(TYPE).toString())) {
                    model.setValue(TYPE, map.get(TYPE), newEntryRow);
                    model.setValue(BIZBOOKTYPE, map.get(BIZBOOKTYPE), newEntryRow);
                }
                model.setValue(START_DATE, map.get(START_DATE), newEntryRow);
                model.setValue(END_DATE, map.get(END_DATE), newEntryRow);
                model.setValue(START_DAYTIME, map.get(START_DAYTIME), newEntryRow);
                model.setValue(END_DAYTIME, map.get(END_DAYTIME), newEntryRow);
                model.setValue(OTHERTASKID, map.get(OTHERTASKID), newEntryRow);
            }
            this.getModel().updateCache();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String method = (String)showParameter.getCustomParam("method");
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{START_DAYTIME, END_DAYTIME});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{START_DATE, END_DATE});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"CheckoutFlowPreTaskSelectFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            ArrayList<Long> selectedIds = new ArrayList<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject task = (DynamicObject)entryEntity.get(selectRow);
                long otherTaskId = task.getLong(OTHERTASKID);
                selectedIds.add(otherTaskId);
            }
            this.getView().returnDataToParent(selectedIds);
            this.getView().close();
        }
    }
}

