/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.fcc.common.enums.OperationEnum;
import kd.fi.fcc.common.enums.ServiceApiType;

public class CheckoutIntegrationFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CALL_BACK_MODIFY = "modifyTaskCallBack";
    private static final String CACHE_IS_NEW = "isNewData";
    private static final String CACHE_IS_MODIFY = "isModify";
    private static final String CACHE_IS_COPY = "isCopy";
    private static final String PARAM_INTEGRATION_CLOUD = "integrationcloud";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getView().getControl("bizapp");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.newDataSetVisibleAndEnable();
        this.isEnableIntegrationCloud();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindDataSetVisibleAndEnable();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.isEnableIntegrationCloud();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Modify) {
            this.isModifyCheck(args);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name = f7.getProperty().getName();
        if (name.equals("bizapp")) {
            this.filterBizApp(f7);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OperationEnum.SAVE.getType().equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.saveSetVisibleAndEnable();
            }
        } else if (OperationEnum.MODIFY.getType().equals(operateKey)) {
            this.modifySetVisibleAndEnable();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_MODIFY.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().invokeOperation("disable");
            this.getView().invokeOperation("modify");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"srcsys")) {
            this.sourceSysChange(e);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"bizcloud")) {
            this.bizCloudChange(e);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"serviceapitype")) {
            this.serviceApiTypeChange(e);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"servicetype")) {
            this.serviceTypeChange(e);
        }
    }

    private void newDataSetVisibleAndEnable() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify"});
        view.setEnable(Boolean.valueOf(false), new String[]{"bizapp"});
        this.getView().getPageCache().put(CACHE_IS_NEW, "true");
    }

    private void isEnableIntegrationCloud() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        AppParam param = new AppParam("44W6RTUA4SKG", Long.valueOf(RequestContext.get().getOrgId()));
        Object integrationCloud = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)PARAM_INTEGRATION_CLOUD);
        if (null != integrationCloud && !((Boolean)integrationCloud).booleanValue()) {
            DynamicObject sourceSys = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_sourcesys", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KDIERP")});
            if (null == sourceSys) {
                return;
            }
            Long id = sourceSys.getLong("id");
            model.setValue("srcsys", (Object)id);
            view.setEnable(Boolean.valueOf(false), new String[]{"srcsys"});
        }
    }

    private void bindDataSetVisibleAndEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String isNewData = view.getPageCache().get(CACHE_IS_NEW);
        IFormView parentView = view.getParentView();
        String isModify = null;
        String isCopy = null;
        view.setVisible(Boolean.valueOf(false), new String[]{"serviceapitype"});
        String serviceType = (String)model.getValue("servicetype");
        if (!StringUtils.equals((CharSequence)"2", (CharSequence)serviceType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"isvid"});
            model.setValue("isvid", null);
        }
        if (null != parentView) {
            isModify = parentView.getPageCache().get(CACHE_IS_MODIFY);
            isCopy = parentView.getPageCache().get(CACHE_IS_COPY);
        }
        if (null != isNewData) {
            view.getPageCache().remove(CACHE_IS_NEW);
            return;
        }
        if (null != isCopy) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify"});
            if (null != parentView) {
                parentView.getPageCache().remove(CACHE_IS_COPY);
            }
            return;
        }
        if (null != isModify) {
            this.modifySetVisibleAndEnable();
            return;
        }
        view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "advconap"});
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        String parentEntityId = view.getParentView().getEntityId();
        String entityId = view.getEntityId();
        if (!StringUtils.equals((CharSequence)parentEntityId, (CharSequence)entityId) && !StringUtils.equals((CharSequence)"bos_list", (CharSequence)parentEntityId)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_modify"});
        }
    }

    private void filterBizApp(BeforeF7SelectEvent f7) {
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        ArrayList<QFilter> treeQFilterList = new ArrayList<QFilter>(2);
        DynamicObject bizCloud = (DynamicObject)model.getValue("bizcloud");
        if (null == bizCloud) {
            QFilter qFilter = new QFilter("id", "=", (Object)"0");
            qFilterList.add(qFilter);
        } else {
            String number = bizCloud.getString("number");
            String id = bizCloud.getString("id");
            QFilter qFilter1 = new QFilter("bizcloud.number", "=", (Object)number);
            QFilter qFilter2 = new QFilter("deploystatus", "=", (Object)"2");
            QFilter qFilter3 = new QFilter("type", "=", (Object)"0");
            QFilter treeQFilter = new QFilter("id", "=", (Object)id);
            qFilterList.add(qFilter1);
            qFilterList.add(qFilter2);
            qFilterList.add(qFilter3);
            treeQFilterList.add(treeQFilter);
        }
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        showParameter.getTreeFilterParameter().setQFilters(treeQFilterList);
        showParameter.getListFilterParameter().setQFilters(qFilterList);
    }

    private void isModifyCheck(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        String enable = (String)model.getValue("enable");
        Boolean sysInitialize = (Boolean)model.getValue("sysinitialize");
        if (sysInitialize.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CheckoutIntegrationFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u8d26\u96c6\u6210\u670d\u52a1\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u786e\u5b9a\u8981\u7981\u7528\u5417\uff1f", (String)"CheckoutIntegrationFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_MODIFY));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private void saveSetVisibleAndEnable() {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "advconap"});
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        view.setVisible(Boolean.valueOf(true), new String[]{"bar_modify"});
    }

    private void modifySetVisibleAndEnable() {
        IFormView parentView;
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo", "advconap"});
        view.setEnable(Boolean.valueOf(false), new String[]{"number"});
        view.setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        view.setVisible(Boolean.valueOf(false), new String[]{"bar_modify"});
        IDataModel model = this.getModel();
        DynamicObject sourceSys = (DynamicObject)model.getValue("srcsys");
        AppParam param = new AppParam("44W6RTUA4SKG", Long.valueOf(RequestContext.get().getOrgId()));
        Boolean integrationCloud = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)PARAM_INTEGRATION_CLOUD);
        String number = sourceSys.getString("number");
        if (null != integrationCloud && !integrationCloud.booleanValue()) {
            view.setEnable(Boolean.valueOf(false), new String[]{"srcsys"});
        }
        String isIsc = sourceSys.getString("isisc");
        if (null != integrationCloud && integrationCloud.booleanValue() && !StringUtils.equals((CharSequence)number, (CharSequence)"KDIERP") && StringUtils.equals((CharSequence)"1", (CharSequence)isIsc)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"serviceapitype"});
            view.setEnable(Boolean.valueOf(false), new String[]{"servicetype", "bizcloud", "bizapp", "serviceinterface", "servicemethod"});
        }
        if (null != (parentView = view.getParentView())) {
            parentView.getPageCache().remove(CACHE_IS_MODIFY);
        }
    }

    private void sourceSysChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        DynamicObject sourceSys = (DynamicObject)changeData.getNewValue();
        if (null == sourceSys) {
            return;
        }
        AppParam param = new AppParam("44W6RTUA4SKG", Long.valueOf(RequestContext.get().getOrgId()));
        Boolean integrationCloud = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)PARAM_INTEGRATION_CLOUD);
        String number = sourceSys.getString("number");
        String isIsc = sourceSys.getString("isisc");
        if (null != integrationCloud && integrationCloud.booleanValue() && !StringUtils.equals((CharSequence)number, (CharSequence)"KDIERP") && StringUtils.equals((CharSequence)"1", (CharSequence)isIsc)) {
            DynamicObject bizCloud = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizcloud", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"EIP")});
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"iscb")});
            model.setValue("serviceapitype", (Object)ServiceApiType.API.getType());
            model.setValue("servicetype", (Object)"1");
            model.setValue("bizcloud", (Object)bizCloud.getString("id"));
            model.setValue("bizapp", (Object)bizApp.getString("id"));
            model.setValue("serviceinterface", (Object)ServiceApiType.API.getsInterface());
            model.setValue("servicemethod", (Object)ServiceApiType.API.getsMethod());
            view.setVisible(Boolean.valueOf(true), new String[]{"serviceapitype"});
            view.setEnable(Boolean.valueOf(false), new String[]{"servicetype", "bizcloud", "bizapp", "serviceinterface", "servicemethod"});
        } else if (null != integrationCloud && integrationCloud.booleanValue() && StringUtils.equals((CharSequence)"0", (CharSequence)isIsc)) {
            String serviceInterface = (String)model.getValue("serviceinterface");
            if (StringUtils.equals((CharSequence)"IscApicService", (CharSequence)serviceInterface)) {
                model.setValue("servicetype", null);
                model.setValue("bizcloud", null);
                model.setValue("bizapp", null);
                model.setValue("serviceinterface", null);
                model.setValue("servicemethod", null);
                view.setVisible(Boolean.valueOf(false), new String[]{"serviceapitype"});
                view.setEnable(Boolean.valueOf(true), new String[]{"servicetype", "bizcloud", "bizapp", "serviceinterface", "servicemethod"});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"serviceapitype"});
        }
    }

    private void bizCloudChange(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (null == newValue) {
            view.setEnable(Boolean.valueOf(false), new String[]{"bizapp"});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{"bizapp"});
        }
        model.setValue("bizapp", null);
    }

    private void serviceApiTypeChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        String type = (String)changeSet[0].getNewValue();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            model.setValue("serviceinterface", (Object)ServiceApiType.getType((String)type).getsInterface());
            model.setValue("servicemethod", (Object)ServiceApiType.getType((String)type).getsMethod());
        }
    }

    private void serviceTypeChange(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        String type = (String)changeSet[0].getNewValue();
        if (StringUtils.equals((CharSequence)type, (CharSequence)"2")) {
            view.setVisible(Boolean.valueOf(true), new String[]{"isvid"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"isvid"});
            model.setValue("isvid", null);
        }
    }
}

