/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class CheckoutPlanFormPlugin
extends AbstractFormPlugin {
    private static final String PARAM_AFTER_CONFIRM = "afterCopyConfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{""});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)formShowParameter.getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"method"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        if (params.get("sourcePk") != null && params.get(PARAM_AFTER_CONFIRM) != null) {
            this.getPageCache().put("sourcePk", params.get("sourcePk").toString());
            this.getPageCache().put(PARAM_AFTER_CONFIRM, params.get(PARAM_AFTER_CONFIRM).toString());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            if (!StringUtils.isEmpty((String)this.getPageCache().get(PARAM_AFTER_CONFIRM))) {
                source.getOption().setVariableValue(PARAM_AFTER_CONFIRM, this.getPageCache().get(PARAM_AFTER_CONFIRM));
                source.getOption().setVariableValue("sourcePk", this.getPageCache().get("sourcePk"));
            } else {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                OperationStatus status = formShowParameter.getStatus();
                source.getOption().setVariableValue("OperationStatus", status.name());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        if ("save".equals(operateKey)) {
            if (!args.getOperationResult().isSuccess()) {
                return;
            }
            String tipMessage = "";
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Boolean iscopy = (Boolean)formShowParameter.getCustomParam("iscopy");
            if (iscopy != null && iscopy.booleanValue()) {
                this.getPageCache().remove(PARAM_AFTER_CONFIRM);
                this.getPageCache().remove("sourcePk");
                if (option.containsVariable("deleteTaskMessage")) {
                    tipMessage = tipMessage + option.getVariableValue("deleteTaskMessage");
                }
                if (option.containsVariable("changeViewMessage")) {
                    tipMessage = tipMessage + option.getVariableValue("changeViewMessage");
                }
                if (StringUtils.isNotEmpty((String)tipMessage)) {
                    this.showCustomConfirm(tipMessage);
                }
            }
        }
    }

    private void showCustomConfirm(String message) {
        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4fdd\u5b58\u6210\u529f\u3002", (String)"CheckoutPlanFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]), this.getModel().getValue("number"));
        String detail = message;
        MessageBoxOptions options = MessageBoxOptions.OK;
        ConfirmTypes confirmTypes = ConfirmTypes.Save;
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(2, ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"CheckoutPlanFormPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        this.getView().getParentView().showConfirm(msg, detail, options, confirmTypes, null, btnNameMaps, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("method".equals(name)) {
            this.getModel().setValue("month", null);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
        }
    }
}

