/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;

public class CheckoutPlanListPlugin
extends AbstractListPlugin {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String COPY_PLAN_CALLBACK = "copyPlanCallback";
    private static final String PARAM_AFTER_CONFIRM = "afterCopyConfirm";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                if (data.isEmpty()) {
                    return data;
                }
                ArrayList ids = new ArrayList();
                data.forEach(v -> ids.add(v.getPkValue()));
                if (ids.size() > 0) {
                    CheckoutPlanListPlugin.this.setUnconfirmedNum(data, ids);
                }
                return data;
            }
        });
    }

    private void setUnconfirmedNum(DynamicObjectCollection data, List<Object> ids) {
        QFilter qFilter = new QFilter("plan", "in", ids);
        qFilter.and("flowstatus", "=", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
        for (DynamicObject datum : data) {
            String method = datum.getString("method");
            int unconfirmedNum = this.getUnconfirmedNum(datum);
            if (unconfirmedNum <= 0) continue;
            datum.set("unconfirmednum", (Object)unconfirmedNum);
        }
    }

    private int getUnconfirmedNum(DynamicObject plan) {
        long planId = plan.getLong("id");
        QFilter qFilter = new QFilter("plan", "=", (Object)planId);
        String method = plan.getString("method");
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
            qFilter.and("flowdate", "=", (Object)plan.getDate("month"));
        } else {
            Date latestFlowDate = FccUtil.getLatestFlowDate((Long)planId);
            if (latestFlowDate != null) {
                qFilter.and("flowdate", "=", (Object)latestFlowDate);
            }
        }
        long viewId = CheckOutViewUtil.getView((Long)planId);
        Map orgByView = CheckOutViewUtil.getEnableLeafOrgByView((long)viewId);
        if (orgByView != null && orgByView.size() > 0) {
            List viewOrgIds = orgByView.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            qFilter.and("org", "in", viewOrgIds);
        }
        qFilter.and("flowstatus", "=", (Object)"1");
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id", (QFilter[])new QFilter[]{qFilter});
        return ids.length;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn listColumn = new ListColumn();
        listColumn.setKey(key);
        listColumn.setListFieldKey(key);
        listColumn.setCaption(new LocaleString(caption));
        listColumn.setHyperlink(true);
        return listColumn;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("unconfirmednum".equals(fieldName)) {
            args.setCancel(true);
            ListSelectedRow selectedRow = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)FCC_CHECKOUT_PLAN);
            String planstatus = dynamicObject.getString("planstatus");
            if (!"A".equals(planstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u8ba1\u5212\u662f\u201c\u672a\u53d1\u5e03\u201d\u72b6\u6001\u624d\u80fd\u6279\u91cf\u786e\u8ba4\u3002", (String)"CheckoutPlanListPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openFlowConfirmView(dynamicObject, "fcc_checkout_plan_field");
        }
    }

    public void openFlowConfirmView(DynamicObject dynamicObject, String sourceFlag) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(FCC_CHECKOUT_FLOW_DETAIL);
        listShowParameter.setStatus(OperationStatus.VIEW);
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("planid", dynamicObject.getPkValue());
        params.put("flowstatus", CheckoutFlowStatusEnum.unconfirm.getType());
        params.put("sourceFlag", sourceFlag);
        listShowParameter.setCustomParams(params);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (!"flowconfirm".equals(itemKey) && "tblcopy".equals(itemKey)) {
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckoutPlanListPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (CheckoutPlanListPlugin.isMultiSelect(selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CheckoutPlanListPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("copy".equals(operateKey)) {
            if (!source.getOption().containsVariable(PARAM_AFTER_CONFIRM)) {
                args.setCancel(true);
                String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u6309\u4eba\u5458\u7ba1\u7406\u66f4\u65b0\u7ed3\u8d26\u4efb\u52a1\u6267\u884c\u4eba\uff1f", (String)"CheckoutPlanListPlugin_5", (String)"fi-fcc-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, new ConfirmCallBackListener(COPY_PLAN_CALLBACK));
            }
        } else if ("flowconfirm".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckoutPlanListPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CheckoutPlanListPlugin.isMultiSelect(selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u4e2a\u7ed3\u8d26\u8ba1\u5212\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CheckoutPlanListPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)FCC_CHECKOUT_PLAN);
            String planstatus = dynamicObject.getString("planstatus");
            if (!"A".equals(planstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u8ba1\u5212\u662f\u201c\u672a\u53d1\u5e03\u201d\u72b6\u6001\u624d\u80fd\u6279\u91cf\u786e\u8ba4\u3002", (String)"CheckoutPlanListPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.openFlowConfirmView(dynamicObject, "fcc_checkout_plan_btn");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(COPY_PLAN_CALLBACK)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(PARAM_AFTER_CONFIRM, String.valueOf(messageBoxClosedEvent.getResult().getValue()));
            this.getPageCache().put(PARAM_AFTER_CONFIRM, String.valueOf(messageBoxClosedEvent.getResult().getValue()));
            this.getView().invokeOperation("copy", operateOption);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            BillShowParameter parameter = e.getParameter();
            parameter.setCustomParam(PARAM_AFTER_CONFIRM, (Object)this.getPageCache().get(PARAM_AFTER_CONFIRM));
            parameter.setCustomParam("sourcePk", (Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
    }

    public static boolean isMultiSelect(ListSelectedRowCollection rows) {
        if (rows.size() > 1) {
            for (int i = 0; i < rows.size() - 1; ++i) {
                ListSelectedRow curr = rows.get(i);
                ListSelectedRow next = rows.get(i + 1);
                if (curr.getPrimaryKeyValue().equals(next.getPrimaryKeyValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("release".equals(operateKey) || "unrelease".equals(operateKey) || "invalid".equals(operateKey) || "closeplan".equals(operateKey) || "openplan".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

