/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;
import kd.fi.fcc.formplugin.util.WorkBenchTreeUtils;

public class PersonWorkbenchFormPlugin
extends AbstractFormPlugin {
    private static final String EXECUTE = "execute";
    private static final String DOING = "doing";
    private static final String DONE = "done";
    private static final String REFRESH = "statusrefresh";
    private static final String TASK_ENTRY = "treeentryentity";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String PRETASKS = "pretasks";
    private static final String PRETASKSTATUS = "pretaskstatus";
    private static String TRUESTARTTIME = "truestarttime";
    private static String TRUEENDTIME = "trueendtime";
    private static final String TASKSET = "1";
    private static final String PERSONTYPE = "3";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean flag;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ((DOING.equals(key) || DONE.equals(key) || REFRESH.equals(key) || EXECUTE.equals(key)) && !(flag = this.checkPlanStatus().booleanValue())) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (null == selectRows || selectRows.length == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u3002", (String)"PersonWorkbenchFormPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Boolean isExcute = false;
        if (DOING.equals(key)) {
            this.changeTaskStatus(selectRows, TaskStatusEnum.DOING.getType());
            isExcute = true;
        } else if (DONE.equals(key)) {
            this.changeTaskStatus(selectRows, TaskStatusEnum.DONE.getType());
            isExcute = true;
        } else if (REFRESH.equals(key)) {
            this.reverseTaskStatus(selectRows);
            isExcute = true;
        }
        if (isExcute.booleanValue()) {
            this.getView().updateView(TASK_ENTRY);
            WorkBenchFormUtils.showStatusTotal(this.getModel(), this.getView());
            String focusNodeID = this.getPageCache().get("focusNodeId");
            String leafOrgIds = this.getPageCache().get("leafOrgIds");
            List leafOrgIdList = (List)SerializationUtils.fromJsonString((String)leafOrgIds, List.class);
            WorkBenchTreeUtils.refreshOrgTree(this.getView(), leafOrgIdList, focusNodeID);
        }
    }

    private void changeTaskStatus(int[] selectRows, String TaskStatus) {
        String taskSetRowStr = this.getPageCache().get("taskSetRow");
        String parentToChildStr = this.getPageCache().get("parentToChild");
        String taskToPretasksStr = this.getView().getPageCache().get("taskToPretasks");
        if (StringUtils.isEmpty((CharSequence)taskSetRowStr) || StringUtils.isEmpty((CharSequence)parentToChildStr) || StringUtils.isEmpty((CharSequence)taskToPretasksStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PersonWorkbenchFormPlugin_10", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Map taskSetRowMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("taskSetRow"), Map.class);
        Map parentToChildMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("parentToChild"), Map.class);
        Map taskToPretasksMap = (Map)SerializationUtils.fromJsonString((String)taskToPretasksStr, Map.class);
        HashSet<Integer> successRows = new HashSet<Integer>(selectRows.length);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(TASK_ENTRY);
        if (selectRows.length == 1) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRows[0]);
            String taskType = dynamicObject.getString(TASKTYPE);
            String taskStatus = dynamicObject.getString(TASKSTATUS);
            String pretaskStatus = dynamicObject.getString(PRETASKSTATUS);
            String taskName = dynamicObject.getString("tasknumber.name");
            if (!PERSONTYPE.equals(taskType)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u624b\u5de5\u4efb\u52a1\u624d\u80fd\u72b6\u6001\u6807\u6ce8\u3002", (String)"PersonWorkbenchFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)pretaskStatus) && !TaskStatusEnum.DONE.getType().equals(pretaskStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1%s\u7684\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"PersonWorkbenchFormPlugin_6", (String)"fi-fcc-formplugin", (Object[])new Object[0]), taskName));
                return;
            }
            if (TaskStatus.equals(taskStatus)) {
                return;
            }
            if (TaskStatusEnum.DONE.getType().equals(taskStatus) && TaskStatusEnum.DOING.getType().equals(TaskStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u7684\u624b\u5de5\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u6807\u6ce8\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u9700\u8981\u5148\u72b6\u6001\u91cd\u7f6e\u3002", (String)"PersonWorkbenchFormPlugin_8", (String)"fi-fcc-formplugin", (Object[])new Object[0]), taskName));
                return;
            }
        }
        int successRow = 0;
        StringBuilder appendPretaskNames = new StringBuilder();
        Boolean hasNotPersonTask = false;
        Boolean hasDoneToDoing = false;
        ArrayList<Long> selectTaskIds = new ArrayList<Long>(selectRows.length);
        for (int selectRow : selectRows) {
            if (!PERSONTYPE.equals(this.getModel().getValue("tasktype", selectRow))) continue;
            selectTaskIds.add((Long)this.getModel().getValue("id", selectRow));
        }
        ArrayList<Long> allPreTaskIds = new ArrayList<Long>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            Long taskEntryId = dynamicObject.getLong("id");
            List preTaskIds = (List)taskToPretasksMap.get(String.valueOf(taskEntryId));
            if (null == preTaskIds || preTaskIds.isEmpty()) continue;
            allPreTaskIds.addAll((Collection)taskToPretasksMap.get(String.valueOf(taskEntryId)));
        }
        List<Long> notDonePreTaskIds = WorkBenchFormUtils.getNotDoneTaskIds(allPreTaskIds);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            String taskType = dynamicObject.getString(TASKTYPE);
            String taskStatus = dynamicObject.getString(TASKSTATUS);
            String pretaskStatus = dynamicObject.getString(PRETASKSTATUS);
            String taskName = dynamicObject.getString("tasknumber.name");
            Date trueStartTime = dynamicObject.getDate(TRUESTARTTIME);
            Boolean checkPretask = true;
            if (TaskStatusEnum.DONE.getType().equals(TaskStatus) && selectTaskIds.containsAll(notDonePreTaskIds)) {
                checkPretask = false;
            }
            if (checkPretask.booleanValue() && StringUtils.isNotEmpty((CharSequence)pretaskStatus) && !TaskStatusEnum.DONE.getType().equals(pretaskStatus)) {
                appendPretaskNames.append(taskName).append("\u3001");
                continue;
            }
            if (TaskStatusEnum.DONE.getType().equals(taskStatus) && TaskStatusEnum.DOING.getType().equals(TaskStatus)) {
                hasDoneToDoing = true;
                continue;
            }
            if (PERSONTYPE.equals(taskType) && !TaskStatus.equals(taskStatus)) {
                Long taskId = (Long)this.getModel().getValue("id", selectRow);
                WorkBenchFormUtils.updateTaskDetail(taskId, TaskStatus, trueStartTime, this.getView(), selectRow);
                successRows.add(selectRow);
                ++successRow;
                continue;
            }
            if (PERSONTYPE.equals(taskType)) continue;
            hasNotPersonTask = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)appendPretaskNames.toString())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1%s\u7684\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"PersonWorkbenchFormPlugin_6", (String)"fi-fcc-formplugin", (Object[])new Object[0]), appendPretaskNames.deleteCharAt(appendPretaskNames.length() - 1)));
        }
        if (hasDoneToDoing.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u7684\u624b\u5de5\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u6807\u6ce8\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u9700\u8981\u5148\u72b6\u6001\u91cd\u7f6e\u3002", (String)"PersonWorkbenchFormPlugin_8", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (hasNotPersonTask.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u624b\u5de5\u4efb\u52a1\u624d\u80fd\u72b6\u6001\u6807\u6ce8\uff0c\u5df2\u6210\u529f\u6807\u6ce8%s\u4e2a\u624b\u5de5\u4efb\u52a1\u72b6\u6001\u3002", (String)"PersonWorkbenchFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]), successRow));
        }
        if (successRow > 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"PersonWorkbenchFormPlugin_7", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        this.refreshTaskSetStatus(successRows, taskSetRowMap, parentToChildMap);
        this.refreshPreTaskStatus(successRows, taskSetRowMap, taskToPretasksMap);
    }

    private void reverseTaskStatus(int[] selectRows) {
        DynamicObject dynamicObject;
        String taskType;
        String taskSetRowStr = this.getPageCache().get("taskSetRow");
        String parentToChildStr = this.getPageCache().get("parentToChild");
        String taskToPretasksStr = this.getView().getPageCache().get("taskToPretasks");
        if (StringUtils.isEmpty((CharSequence)taskSetRowStr) || StringUtils.isEmpty((CharSequence)parentToChildStr) || StringUtils.isEmpty((CharSequence)taskToPretasksStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PersonWorkbenchFormPlugin_10", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Map taskSetRowMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("taskSetRow"), Map.class);
        Map parentToChildMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("parentToChild"), Map.class);
        Map taskToPretasksMap = (Map)SerializationUtils.fromJsonString((String)taskToPretasksStr, Map.class);
        HashSet<Integer> successRows = new HashSet<Integer>(selectRows.length);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(TASK_ENTRY);
        if (selectRows.length == 1 && TASKSET.equals(taskType = (dynamicObject = (DynamicObject)entity.get(selectRows[0])).getString(TASKTYPE))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\"\u7a0b\u5e8f\u4efb\u52a1\"\u6216\"\u624b\u5de5\u4efb\u52a1\"\u624d\u80fd\u6267\u884c\u72b6\u6001\u91cd\u7f6e\u3002", (String)"PersonWorkbenchFormPlugin_17", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        StringBuilder appendtaskNames = new StringBuilder();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject2 = (DynamicObject)entity.get(selectRow);
            String taskType2 = dynamicObject2.getString(TASKTYPE);
            String taskStatus = dynamicObject2.getString(TASKSTATUS);
            Date trueStartTime = dynamicObject2.getDate(TRUESTARTTIME);
            if (TASKSET.equals(taskType2) || TaskStatusEnum.NOT_START.getType().equals(taskStatus)) continue;
            String flag = this.hasPretaskContains(selectRow, taskToPretasksMap, taskSetRowMap);
            if (StringUtils.isNotEmpty((CharSequence)flag)) {
                appendtaskNames.append(flag).append("\u3001");
                continue;
            }
            Long taskId = (Long)this.getModel().getValue("id", selectRow);
            CheckOutTaskHelper.writeTaskFlowStatusAndTwoDate((Long)taskId, (String)TaskStatusEnum.NOT_START.getType(), (Date)trueStartTime, null);
            this.getModel().setValue(TASKSTATUS, (Object)TaskStatusEnum.NOT_START.getType(), selectRow);
            this.getModel().setValue(TRUEENDTIME, null, selectRow);
            successRows.add(selectRow);
        }
        if (!successRows.isEmpty()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5df2\u91cd\u7f6e\u3002", (String)"PersonWorkbenchFormPlugin_5", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)appendtaskNames.toString())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1%s\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u524d\u7f6e\u4efb\u52a1\u72b6\u6001\u3002", (String)"PersonWorkbenchFormPlugin_18", (String)"fi-fcc-formplugin", (Object[])new Object[0]), appendtaskNames.deleteCharAt(appendtaskNames.length() - 1)));
        }
        this.refreshTaskSetStatus(successRows, taskSetRowMap, parentToChildMap);
        this.refreshPreTaskStatus(successRows, taskSetRowMap, taskToPretasksMap);
    }

    private String hasPretaskContains(int currentRow, Map<String, List<Long>> taskToPretasksMap, Map<String, Integer> taskSetRowMap) {
        Boolean flag = false;
        Long currentTaskId = (Long)this.getModel().getValue("id", currentRow);
        for (Map.Entry<String, List<Long>> entry : taskToPretasksMap.entrySet()) {
            List<Long> pretasks = entry.getValue();
            String taskIdStr = entry.getKey();
            if (!pretasks.contains(currentTaskId)) continue;
            String taskId = entry.getKey();
            String taskStatus = "";
            if (null != taskSetRowMap.get(taskId)) {
                int taskRow = taskSetRowMap.get(taskId);
                taskStatus = (String)this.getModel().getValue(TASKSTATUS, taskRow);
            } else {
                String sql = "SELECT ftaskstatus FROM t_fcc_checkflow_det_entry WHERE fentryid = ?";
                DataSet status = DB.queryDataSet((String)"WorkBenchFormUtils.getTaskStatus", (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{Long.valueOf(taskId)});
                for (Row data : status) {
                    taskStatus = data.get(0).toString();
                }
            }
            if (!TaskStatusEnum.DONE.getType().equals(taskStatus)) continue;
            return WorkBenchFormUtils.getTaskName(Long.valueOf(taskIdStr));
        }
        return "";
    }

    private void refreshTaskSetStatus(Set<Integer> successRows, Map<String, Integer> taskSetRowMap, Map<String, List<Long>> parentToChildMap) {
        if (successRows.size() == 0) {
            return;
        }
        HashSet<Long> taskSetRows = new HashSet<Long>(successRows.size());
        for (int row : successRows) {
            taskSetRows.add((Long)this.getModel().getValue("pid", row));
        }
        for (Long taskSetRow : taskSetRows) {
            List<Long> childRows = parentToChildMap.get(taskSetRow.toString());
            if (null == childRows) continue;
            ArrayList<String> childStatus = new ArrayList<String>(childRows.size());
            for (Long childRow : childRows) {
                if (!taskSetRowMap.containsKey(childRow.toString())) continue;
                childStatus.add((String)this.getModel().getValue(TASKSTATUS, taskSetRowMap.get(childRow.toString()).intValue()));
            }
            String status = WorkBenchFormUtils.getTaskSetStatus(childStatus);
            if (!taskSetRowMap.containsKey(taskSetRow.toString())) continue;
            int selectRow = taskSetRowMap.get(taskSetRow.toString());
            Long taskId = (Long)this.getModel().getValue("id", selectRow);
            Date trueStartTime = (Date)this.getModel().getValue(TRUESTARTTIME, selectRow);
            WorkBenchFormUtils.updateTaskDetail(taskId, status, trueStartTime, this.getView(), selectRow);
        }
    }

    private void refreshPreTaskStatus(Set<Integer> successRows, Map<String, Integer> taskSetRowMap, Map<String, List<Long>> taskToPretasksMap) {
        if (successRows.size() == 0) {
            return;
        }
        for (int row : successRows) {
            Long pretaskId = (Long)this.getModel().getValue("id", row);
            for (Map.Entry<String, List<Long>> entry : taskToPretasksMap.entrySet()) {
                String taskId;
                List<Long> pretasks = entry.getValue();
                if (!pretasks.contains(pretaskId) || null == taskSetRowMap.get(taskId = entry.getKey())) continue;
                int taskRow = taskSetRowMap.get(taskId);
                List<String> preTaskStatus = WorkBenchFormUtils.getTaskStatus(new HashSet<Long>(pretasks));
                String parentPreTaskStatus = WorkBenchFormUtils.getTaskSetStatus(preTaskStatus);
                IFormView view = this.getView();
                view.getModel().setValue(PRETASKSTATUS, (Object)parentPreTaskStatus, taskRow);
                view.updateView(PRETASKSTATUS, taskRow);
            }
        }
    }

    private Boolean checkPlanStatus() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(view);
        String checkMethod = (String)model.getValue("checkmethod");
        String message = null;
        if ("month_check".equals(checkMethod)) {
            Date month = (Date)model.getValue("month");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            message = sdf.format(month);
        } else {
            Date date = (Date)model.getValue("date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            message = sdf.format(date);
        }
        if (null == checkoutPlan) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)" \u201c%s\u201d\u4e0d\u5b58\u5728\u201c\u5df2\u53d1\u5e03\u201d\u7684\u7ed3\u8d26\u8ba1\u5212\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PersonWorkbenchFormPlugin_19", (String)"fi-fcc-formplugin", (Object[])new Object[0]), message));
            return false;
        }
        String planStatus = checkoutPlan.getString("planstatus");
        if (!"B".equals(planStatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5b58\u5728\u201c\u5df2\u53d1\u5e03\u201d\u7684\u7ed3\u8d26\u8ba1\u5212\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PersonWorkbenchFormPlugin_9", (String)"fi-fcc-formplugin", (Object[])new Object[0]), message));
            return false;
        }
        return true;
    }
}

