/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.business.task.ProgramTask;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;
import kd.fi.fcc.formplugin.util.WorkBenchTreeUtils;
import kd.fi.fcc.formplugin.view.model.ProgramReturnResultData;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ProgramTaskDispatchFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ProgramTask.class);
    private static final String BTNPROGRAM = "execute";
    private static final String ENTRYENTITY = "treeentryentity";
    private static final String TASK_TYPE = "tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String PRETASKSTATUS = "pretaskstatus";
    private static final String TRUESTARTTIME = "truestarttime";
    private static final String TRUEENDTIME = "trueendtime";
    private static final String CALL_BACK_SAVE = "saveTaskCallBack";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equalsIgnoreCase((CharSequence)BTNPROGRAM, (CharSequence)evt.getItemKey())) {
            Map<Integer, String> msgMap = this.checkPreTaskStatus();
            boolean flag = this.checkPlanStatus();
            if (!flag) {
                return;
            }
            Map<Integer, DynamicObject> selectRows = this.getSelectRows(true, true);
            int selectRowLength = this.selectRowLength();
            StringBuilder message = new StringBuilder();
            if (selectRowLength > 1) {
                int taskTotal = selectRowLength;
                int executTaskTotal = selectRows.size();
                if (null != msgMap && msgMap.size() > 0) {
                    for (Map.Entry<Integer, String> row : msgMap.entrySet()) {
                        message.append(row.getValue());
                    }
                }
                String info = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u4e0d\u662f\u201c\u5df2\u5b8c\u6210\u201d\u72b6\u6001\u7684\u7a0b\u5e8f\u4efb\u52a1\u624d\u80fd\u6267\u884c\u3002\u9009\u4e2d\u7684%1$s\u6761\u4efb\u52a1\u5c06\u6267\u884c%2$s\u6761\uff0c\u786e\u5b9a\u8981\u6267\u884c\u5417\uff1f", (String)"ProgramTaskDispatchFormPlugin_9", (String)"fi-fcc-formplugin", (Object[])new Object[0]), taskTotal, executTaskTotal);
                message.append(info);
                this.getView().showConfirm(message.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_SAVE));
            } else {
                if (null != msgMap && msgMap.size() > 0) {
                    for (Map.Entry<Integer, String> row : msgMap.entrySet()) {
                        message.append(row.getValue());
                    }
                    this.getView().showTipNotification(message.toString());
                    return;
                }
                this.doProgramTaskBusiness(selectRows);
            }
        }
    }

    private int selectRowLength() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        return selectRows.length;
    }

    private Map<Integer, String> checkPreTaskStatus() {
        HashMap<Integer, String> msgMap = new HashMap<Integer, String>(1);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Long> taskIdList = new ArrayList<Long>(1);
        HashSet<Long> flowIdSet = new HashSet<Long>(1);
        HashMap preTaskMap = new HashMap(1);
        HashMap<Long, String> taskStatusMap = new HashMap<Long, String>(1);
        ArrayList<Integer> taskIndexList = new ArrayList<Integer>(1);
        for (int selectRow : selectRows) {
            String taskType = (String)this.getModel().getValue(TASK_TYPE, selectRow);
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)taskType)) continue;
            taskIndexList.add(selectRow);
        }
        int[] newRows = new int[taskIndexList.size()];
        for (int i = 0; i < taskIndexList.size(); ++i) {
            newRows[i] = (Integer)taskIndexList.get(i);
        }
        DynamicObjectCollection allTasks = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject task : allTasks) {
            Long id = task.getLong("id");
            String taskStatus = task.getString(TASKSTATUS);
            taskStatusMap.put(id, taskStatus);
        }
        for (Object selectRow : (Object)newRows) {
            Long checkoutFlowId = (Long)this.getModel().getValue("checkoutflowid", (int)selectRow);
            flowIdSet.add(checkoutFlowId);
            Long taskEnId = (Long)this.getModel().getValue("id", (int)selectRow);
            taskIdList.add(taskEnId);
        }
        QFilter qFilter = new QFilter("flowid", "in", flowIdSet);
        DynamicObject[] preTasks = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"taskrowid, entryentity, entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter});
        if (null != preTasks && preTasks.length > 0) {
            for (DynamicObject preTaskObj : preTasks) {
                Long taskRowId = preTaskObj.getLong("taskrowid");
                if (!taskIdList.contains(taskRowId)) continue;
                DynamicObjectCollection preTaskCollection = preTaskObj.getDynamicObjectCollection("entryentity");
                ArrayList<Long> preTaskList = new ArrayList<Long>(1);
                for (DynamicObject preTask : preTaskCollection) {
                    Long preTaskId = preTask.getLong("othertaskid");
                    preTaskList.add(preTaskId);
                }
                preTaskMap.put(taskRowId, preTaskList);
            }
        }
        if (null != preTaskMap && preTaskMap.size() > 0) {
            for (int selectRow : newRows) {
                String preTaskStatus = (String)this.getModel().getValue(PRETASKSTATUS, selectRow);
                DynamicObject task = (DynamicObject)this.getModel().getValue("tasknumber", selectRow);
                Long taskEnId = (Long)this.getModel().getValue("id", selectRow);
                String taskType = (String)this.getModel().getValue(TASK_TYPE, selectRow);
                if (null == task || !StringUtils.equals((CharSequence)"2", (CharSequence)taskType)) continue;
                String taskName = task.getString("name");
                List preTaskEnIds = (List)preTaskMap.get(taskEnId);
                if (null == preTaskStatus || StringUtils.equals((CharSequence)TaskStatusEnum.DONE.getType(), (CharSequence)preTaskStatus) || null == preTaskEnIds || preTaskEnIds.size() <= 0) continue;
                for (Long preTaskEnId : preTaskEnIds) {
                    String preStatus = (String)taskStatusMap.get(preTaskEnId);
                    if (StringUtils.equals((CharSequence)TaskStatusEnum.DONE.getType(), (CharSequence)preStatus) || taskIdList.contains(preTaskEnId)) continue;
                    String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7ed3\u8d26\u4efb\u52a1\u201c%2$s\u201d\u7684\u524d\u7f6e\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002\n", (String)"ProgramTaskDispatchFormPlugin_10", (String)"fi-fcc-formplugin", (Object[])new Object[0]), selectRow + 1, taskName);
                    msgMap.put(selectRow, message);
                }
            }
        }
        return msgMap;
    }

    private void doProgramTaskBusiness(Map<Integer, DynamicObject> selectRows) {
        String checkMethod = (String)this.getModel().getValue("checkmethod");
        Date month = (Date)this.getView().getModel().getValue("month");
        Date date = (Date)this.getView().getModel().getValue("date");
        String startDate = "";
        String endDate = "";
        String periodName = "";
        if (checkMethod.equals("day_check")) {
            endDate = startDate = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
            periodName = DateUtils.formatString((Date)date, (String)"yyyy-MM");
        } else if (checkMethod.equals("month_check")) {
            LocalDate monthLocal = month.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate firstDay = monthLocal.withDayOfMonth(1);
            LocalDate lastDay = monthLocal.withDayOfMonth(monthLocal.lengthOfMonth());
            startDate = firstDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            endDate = lastDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            periodName = DateUtils.formatString((Date)month, (String)"yyyy-MM");
        }
        String finalStartDate = startDate;
        String finalPeriodName = periodName;
        String finalEndDate = endDate;
        List<Map<String, Object>> collect = selectRows.entrySet().stream().map(r -> {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            DynamicObject value = (DynamicObject)r.getValue();
            map.put("entryId", value.get("id"));
            map.put("taskId", value.getDynamicObject("tasknumber").get("id"));
            map.put("rowNum", r.getKey());
            map.put("eorg", value.getDynamicObject("eorg").getString("number"));
            map.put("ebizorg", value.getDynamicObject("ebizorg").getString("number"));
            String bizNumber = value.getDynamicObject("tasknumber.bizsystem").getString("number");
            DynamicObject bizSystem = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_bizsystem", (String)"bizapp,bizapp.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizNumber)});
            DynamicObject bizApp = bizSystem.getDynamicObject("bizapp");
            if (null == bizApp) {
                map.put("kdbizid", bizNumber);
            } else {
                map.put("kdbizid", bizApp.getString("number"));
            }
            map.put("bizid", bizNumber);
            map.put("bizbooktype", value.get("bizbooktype") != null ? String.valueOf(value.getDynamicObject("bizbooktype").getLong("id")) : null);
            map.put("group", value.getDynamicObject("tasknumber.group").getString("number"));
            map.put("checkoutflowid", value.getLong("checkoutflowid"));
            map.put(TRUESTARTTIME, value.get(TRUESTARTTIME));
            map.put("ebizorgid", value.getDynamicObject("ebizorg").getLong("id"));
            map.put("eorgid", value.getDynamicObject("eorg").getLong("id"));
            map.put("type", value.getString("type"));
            map.put("startdate", finalStartDate);
            map.put("enddate", finalEndDate);
            map.put("periodname", finalPeriodName);
            return map;
        }).collect(Collectors.toList());
        this.dispatch(collect);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isInvalid;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        Map<Integer, DynamicObject> selectRows = this.getSelectRows(false, false);
        IFormView view = this.getView();
        if (BTNPROGRAM.equals(itemKey) && (isInvalid = this.isSelectRowsInvalid(view, selectRows))) {
            evt.setCancel(true);
        }
    }

    private Map<Integer, DynamicObject> getSelectRows(Boolean isFilter, Boolean isContainPreTask) {
        Map<Integer, String> msgMap;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        HashMap<Integer, DynamicObject> dynamicObjects = new HashMap<Integer, DynamicObject>(10);
        IDataModel model = this.getModel();
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject entryRowEntity = model.getEntryRowEntity(ENTRYENTITY, selectRow);
                if (isFilter.booleanValue()) {
                    String taskType = entryRowEntity.getString(TASKTYPE);
                    String taskStatus = entryRowEntity.getString(TASKSTATUS);
                    if (!"2".equals(taskType) || taskStatus.equals(TaskStatusEnum.DONE.getType())) continue;
                    dynamicObjects.put(selectRow, entryRowEntity);
                    continue;
                }
                dynamicObjects.put(selectRow, entryRowEntity);
            }
        }
        if (isContainPreTask.booleanValue() && null != (msgMap = this.checkPreTaskStatus()) && msgMap.size() > 0) {
            for (Integer row : msgMap.keySet()) {
                dynamicObjects.remove(row);
            }
        }
        return dynamicObjects;
    }

    private boolean isSelectRowsInvalid(IFormView view, Map<Integer, DynamicObject> dynamicObjects) {
        int size = dynamicObjects.size();
        if (size == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProgramTaskDispatchFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (size == 1) {
            DynamicObject dynamicObject = dynamicObjects.values().stream().findFirst().get();
            DynamicObject tasknumber = dynamicObject.getDynamicObject("tasknumber");
            Integer taskType = tasknumber.getInt(TASK_TYPE);
            if (taskType != 2) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7a0b\u5e8f\u4efb\u52a1\u624d\u80fd\u6267\u884c\u3002", (String)"ProgramTaskDispatchFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return true;
            }
            String taskStatus = dynamicObject.getString(TASKSTATUS);
            if (taskStatus.equals(TaskStatusEnum.DONE.getType())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u7684\u7a0b\u5e8f\u4efb\u52a1\u4e0d\u6267\u884c\uff0c\u5982\u9700\u518d\u6b21\u6267\u884c\uff0c\u8bf7\u5148\u91cd\u7f6e\u4efb\u52a1\u72b6\u6001\u3002", (String)"ProgramTaskDispatchFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (taskStatus.equals(TaskStatusEnum.DOING.getType())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\u7684\u7a0b\u5e8f\u4efb\u52a1\u4e0d\u6267\u884c\uff0c\u5982\u9700\u518d\u6b21\u6267\u884c\uff0c\u8bf7\u5148\u91cd\u7f6e\u4efb\u52a1\u72b6\u6001", (String)"ProgramTaskDispatchFormPlugin_11", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_SAVE.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            Map<Integer, DynamicObject> selectRows = this.getSelectRows(true, true);
            this.doProgramTaskBusiness(selectRows);
        }
    }

    private void dispatch(List<Map<String, Object>> dynamicObjects) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("kd.fi.fcc");
        jobInfo.setJobType(JobType.REALTIME);
        String name = ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u4efb\u52a1\u8fdb\u5ea6", (String)"ProgramTaskDispatchFormPlugin_7", (String)"fi-fcc-formplugin", (Object[])new Object[0]);
        jobInfo.setName(name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname("kd.fi.fcc.business.task.ProgramTask");
        jobInfo.setRunByLang(Lang.get());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 80);
        params.put("dynamicObjects", dynamicObjects);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u4efb\u52a1", (String)"ProgramTaskDispatchFormPlugin_8", (String)"fi-fcc-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.fi.fcc.business.task.ProgramTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            try {
                this.taskCallBack(closedCallBackEvent.getReturnData());
            }
            catch (IOException e) {
                this.logError("ProgramTaskDispatchFormPlugin closedCallBack occur exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                e.printStackTrace();
            }
        }
    }

    private void logError(String errorLog) {
        if (log.isErrorEnabled()) {
            log.error(errorLog);
        }
    }

    private void taskCallBack(Object returnData) throws IOException {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            String copywriting = this.refreshStatusRows(data);
            this.getView().showMessage(copywriting);
        }
    }

    private String refreshStatusRows(String data) throws IOException {
        Map<String, Object> startAndEndTime;
        Date startTime;
        ProgramReturnResultData cast = (ProgramReturnResultData)JSONUtils.cast((String)data, ProgramReturnResultData.class);
        if (StringUtils.isNotEmpty((CharSequence)cast.getErrorMessage())) {
            return cast.getErrorMessage();
        }
        List<Integer> successRows = cast.getSuccessRows();
        List<Integer> failedRows = cast.getFailedRows();
        Map<Integer, Map<String, Object>> dateMap = cast.getDateMap();
        for (Integer successRow : cast.getSuccessRows()) {
            this.getModel().setValue(TASKSTATUS, (Object)TaskStatusEnum.DONE.getType(), successRow.intValue());
            startTime = (Date)this.getModel().getValue(TRUESTARTTIME, successRow.intValue());
            startAndEndTime = dateMap.get(successRow);
            if (startAndEndTime.containsKey("startTime") && null == startTime) {
                this.getModel().setValue(TRUESTARTTIME, startAndEndTime.get("startTime"), successRow.intValue());
            }
            if (!startAndEndTime.containsKey("endTime")) continue;
            this.getModel().setValue(TRUEENDTIME, startAndEndTime.get("endTime"), successRow.intValue());
        }
        for (Integer failedRow : cast.getFailedRows()) {
            this.getModel().setValue(TASKSTATUS, (Object)TaskStatusEnum.FAILED.getType(), failedRow.intValue());
            startTime = (Date)this.getModel().getValue(TRUESTARTTIME, failedRow.intValue());
            startAndEndTime = dateMap.get(failedRow);
            if (!startAndEndTime.containsKey("startTime") || null != startTime) continue;
            this.getModel().setValue(TRUESTARTTIME, startAndEndTime.get("startTime"), failedRow.intValue());
        }
        Set<Integer> totalRows = Stream.concat(successRows.stream(), failedRows.stream()).collect(Collectors.toSet());
        this.refreshTaskParentStatus(totalRows);
        this.refreshPreTaskStatus(totalRows);
        String desc = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f%1$s\u6b21\uff0c\u5931\u8d25%2$s\u6b21\u3002", (String)"ProgramTaskDispatchFormPlugin_12", (String)"fi-fcc-formplugin", (Object[])new Object[0]), successRows.size(), failedRows.size());
        this.getView().updateView(ENTRYENTITY);
        WorkBenchFormUtils.showStatusTotal(this.getModel(), this.getView());
        String focusNodeID = this.getPageCache().get("focusNodeId");
        String leafOrgIds = this.getPageCache().get("leafOrgIds");
        List leafOrgIdList = (List)SerializationUtils.fromJsonString((String)leafOrgIds, List.class);
        WorkBenchTreeUtils.refreshOrgTree(this.getView(), leafOrgIdList, focusNodeID);
        return desc;
    }

    private void refreshTaskParentStatus(Set<Integer> totalRows) {
        if (totalRows.size() == 0) {
            return;
        }
        HashSet<Long> taskSetRows = new HashSet<Long>(totalRows.size());
        for (int row : totalRows) {
            taskSetRows.add((Long)this.getModel().getValue("pid", row));
        }
        String taskSetRowStr = this.getPageCache().get("taskSetRow");
        String parentToChildStr = this.getPageCache().get("parentToChild");
        if (kd.bos.util.StringUtils.isEmpty((String)taskSetRowStr) || kd.bos.util.StringUtils.isEmpty((String)parentToChildStr)) {
            return;
        }
        Map taskSetRowMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("taskSetRow"), Map.class);
        Map parentToChildMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("parentToChild"), Map.class);
        for (Long taskSetRow : taskSetRows) {
            String sql;
            if (!taskSetRowMap.containsKey(taskSetRow.toString())) {
                return;
            }
            int taskSetRowNum = (Integer)taskSetRowMap.get(taskSetRow.toString());
            List childRows = (List)parentToChildMap.get(taskSetRow.toString());
            if (null == childRows) continue;
            ArrayList<String> childStatus = new ArrayList<String>(childRows.size());
            ArrayList<Date> childStartDates = new ArrayList<Date>(childRows.size());
            ArrayList<Date> childEndDates = new ArrayList<Date>(childRows.size());
            for (Long childRow : childRows) {
                Date childEndTime;
                if (!taskSetRowMap.containsKey(childRow.toString())) continue;
                childStatus.add((String)this.getModel().getValue(TASKSTATUS, ((Integer)taskSetRowMap.get(childRow.toString())).intValue()));
                Date childStartTime = (Date)this.getModel().getValue(TRUESTARTTIME, ((Integer)taskSetRowMap.get(childRow.toString())).intValue());
                if (null != childStartTime) {
                    childStartDates.add(childStartTime);
                }
                if (null == (childEndTime = (Date)this.getModel().getValue(TRUEENDTIME, ((Integer)taskSetRowMap.get(childRow.toString())).intValue()))) continue;
                childEndDates.add(childEndTime);
            }
            String status = WorkBenchFormUtils.getTaskSetStatus(childStatus);
            CheckOutTaskHelper.writeTaskFlowStatus((Long)taskSetRow, (String)status, null, null);
            this.getModel().setValue(TASKSTATUS, (Object)status, taskSetRowNum);
            Date taskSetStartTime = (Date)this.getModel().getValue(TRUESTARTTIME, taskSetRowNum);
            if (null == taskSetStartTime && !childStartDates.isEmpty()) {
                Collections.sort(childStartDates);
                sql = "UPDATE t_fcc_checkflow_det_entry SET ftruestarttime = ? WHERE fentryid=?;";
                DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{childStartDates.get(0), taskSetRow});
                this.getModel().setValue(TRUESTARTTIME, childStartDates.get(0), taskSetRowNum);
            }
            if (!childStatus.stream().allMatch(element -> element.equals(TaskStatusEnum.DONE.getType())) || childEndDates.isEmpty()) continue;
            Collections.sort(childEndDates);
            sql = "UPDATE t_fcc_checkflow_det_entry SET ftrueendtime = ? WHERE fentryid=?;";
            DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{childEndDates.get(childEndDates.size() - 1), taskSetRow});
            this.getModel().setValue(TRUEENDTIME, childEndDates.get(childEndDates.size() - 1), taskSetRowNum);
        }
    }

    private void refreshPreTaskStatus(Set<Integer> totalRows) {
        if (totalRows.size() == 0) {
            return;
        }
        String taskSetRowStr = this.getView().getPageCache().get("taskSetRow");
        String taskToPretasksStr = this.getView().getPageCache().get("taskToPretasks");
        if (StringUtils.isEmpty((CharSequence)taskToPretasksStr)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)taskSetRowStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"ProgramTaskDispatchFormPlugin_13", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Map taskSetRowMap = (Map)SerializationUtils.fromJsonString((String)taskSetRowStr, Map.class);
        Map taskToPretasksMap = (Map)SerializationUtils.fromJsonString((String)taskToPretasksStr, Map.class);
        for (int row : totalRows) {
            Long pretaskId = (Long)this.getModel().getValue("id", row);
            for (Map.Entry entry : taskToPretasksMap.entrySet()) {
                String taskId;
                List pretasks = (List)entry.getValue();
                if (!pretasks.contains(pretaskId) || null == taskSetRowMap.get(taskId = (String)entry.getKey())) continue;
                int taskRow = (Integer)taskSetRowMap.get(taskId);
                List<String> preTaskStatus = WorkBenchFormUtils.getTaskStatus(new HashSet<Long>(pretasks));
                String parentPreTaskStatus = WorkBenchFormUtils.getTaskSetStatus(preTaskStatus);
                IFormView view = this.getView();
                view.getModel().setValue(PRETASKSTATUS, (Object)parentPreTaskStatus, taskRow);
                view.updateView(PRETASKSTATUS, taskRow);
            }
        }
    }

    private Boolean checkPlanStatus() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(view);
        String checkMethod = (String)model.getValue("checkmethod");
        String message = null;
        if ("month_check".equals(checkMethod)) {
            Date month = (Date)model.getValue("month");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            message = sdf.format(month);
        } else {
            Date date = (Date)model.getValue("date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            message = sdf.format(date);
        }
        if (null == checkoutPlan) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)" \u201c%s\u201d\u4e0d\u5b58\u5728\u201c\u5df2\u53d1\u5e03\u201d\u7684\u7ed3\u8d26\u8ba1\u5212\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ProgramTaskDispatchFormPlugin_14", (String)"fi-fcc-formplugin", (Object[])new Object[0]), message));
            return false;
        }
        String planStatus = checkoutPlan.getString("planstatus");
        if (!"B".equals(planStatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5b58\u5728\u201c\u5df2\u53d1\u5e03\u201d\u7684\u7ed3\u8d26\u8ba1\u5212\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ProgramTaskDispatchFormPlugin_15", (String)"fi-fcc-formplugin", (Object[])new Object[0]), message));
            return false;
        }
        return true;
    }
}

