/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.constant.CheckoutTemplateEntity;
import kd.fi.fcc.common.enums.CtrlStrategy;
import kd.fi.fcc.common.enums.OrgPermissionEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;

public class TemplateAssignFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fcc.formplugin.TemplateAssignFormPlugin");

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult permOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)"fcc", (String)"fcc_template_assign", (String)OrgPermissionEnum.NEW.getValue());
        List orgIds = CheckOutViewUtil.getAllLeaveOrgs((Long)CheckOutViewUtil.getView((Long)0L));
        if (!permOrgs.hasAllOrgPerm()) {
            List orgs = permOrgs.getHasPermOrgs();
            orgIds.retainAll(orgs);
        }
        this.setOrgFilter(orgIds);
        this.setTemplateFilter();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("templatelist");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRow row = evt.getCurrentListSelectedRow();
                List orgIds = CheckOutViewUtil.getAllLeaveOrgs((Long)CheckOutViewUtil.getView((Long)0L));
                log.info("TemplateAssignFormPlugin.orgIds:" + orgIds.toString());
                if (row != null) {
                    HasPermOrgResult permOrg;
                    Long id = (Long)evt.getCurrentListSelectedRow().getPrimaryKeyValue();
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fcc_checkout_template", (String)"createorg,ctrlstrategy");
                    String ctrlStrategy = plan.getString("ctrlstrategy");
                    DynamicObject view = BaseDataServiceHelper.getCtrlview((String)"fcc_checkout_template");
                    if (!CtrlStrategy.global_share.getValue().equals(ctrlStrategy) && CtrlStrategy.scope_share.getValue().equals(ctrlStrategy)) {
                        List subordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((long)view.getLong("id"), Collections.singletonList(plan.getLong(CheckoutTemplateEntity.id_((String)"createorg"))), (boolean)true);
                        if (subordinateOrgs != null) {
                            log.info("TemplateAssignFormPlugin.subordinateOrgs:" + subordinateOrgs.toString());
                        } else {
                            log.info("TemplateAssignFormPlugin.subordinateOrgs:null");
                        }
                        orgIds.retainAll(subordinateOrgs);
                    }
                    if (!(permOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)view.getString("treetype"), (String)"44W6RTUA4SKG", (String)"fcc_checkout_template", (String)OrgPermissionEnum.VIEW.getValue())).hasAllOrgPerm()) {
                        orgIds.retainAll(permOrg.getHasPermOrgs());
                        if (permOrg.getHasPermOrgs() != null) {
                            log.info("TemplateAssignFormPlugin.getHasPermOrgs:" + permOrg.getHasPermOrgs().toString());
                        }
                    }
                }
                log.info("TemplateAssignFormPlugin.orgIdsFinal:" + orgIds.toString());
                TemplateAssignFormPlugin.this.setOrgFilter(orgIds);
            }
        });
    }

    private void setOrgFilter(List<Long> orgIds) {
        BillList orgList = (BillList)this.getControl("orglist");
        FilterParameter param = orgList.getQueryFilterParameter();
        ArrayList<QFilter> filter = new ArrayList<QFilter>(1);
        filter.add(new QFilter("id", "in", orgIds));
        param.setQFilters(filter);
        orgList.refresh();
    }

    private void setTemplateFilter() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String method = (String)showParameter.getCustomParam("method");
        BillList templateList = (BillList)this.getControl("templatelist");
        FilterParameter param = templateList.getQueryFilterParameter();
        ArrayList<QFilter> filter = new ArrayList<QFilter>(1);
        filter.add(new QFilter("checkouttype", "=", (Object)method));
        filter.add(new QFilter("enable", "=", (Object)"1"));
        param.setQFilters(filter);
        templateList.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        BillList orgList = (BillList)this.getControl("orglist");
        ListSelectedRowCollection orgSelectList = orgList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)orgSelectList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u540e\u518d\u5206\u914d\u3002", (String)"TemplateAssignFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(orgSelectList.size());
        for (ListSelectedRow row : orgSelectList) {
            orgIds.add(Long.valueOf(row.getPrimaryKeyValue().toString()));
        }
        BillList templateList = (BillList)this.getControl("templatelist");
        ListSelectedRowCollection templateSelectList = templateList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)templateSelectList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u540e\u518d\u5206\u914d\u3002", (String)"TemplateAssignFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long templateId = Long.valueOf(templateSelectList.get(0).toString());
        FormOperate formOp = (FormOperate)args.getSource();
        OperateOption op = formOp.getOption();
        op.setVariableValue("template", templateId.toString());
        op.setVariableValue("org", SerializationUtils.toJsonString(orgIds));
        op.setVariableValue("plan", this.getView().getFormShowParameter().getCustomParam("plan").toString());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult result;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("assign".equals(key) && (result = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getView().returnDataToParent((Object)"success");
        }
    }
}

