/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.enums.DelayStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;
import kd.fi.fcc.formplugin.util.WorkBenchTreeUtils;

public class WorkbenchTplFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static Log logger = LogFactory.getLog(WorkbenchTplFormPlugin.class);
    private TreeView orgTree;
    private static final String CHECK_METHOD = "checkmethod";
    private static final String DAY_CHECK = "day_check";
    private static final String MONTH_CHECK = "month_check";
    private static final String DATE_SEARCH = "date";
    private static final String MONTH_SEARCH = "month";
    private static final String ORG = "org";
    private static final String TASKTYPESTR = "tasktype";
    private static final String EXPLAIN = "checkoutexplain";
    private static final String DELAYSTATUS = "isdelay";
    private static final String PRETASKSTATUS = "pretaskstatus";
    private static final String EXCUTOR = "executor";
    private static final String ATTACHMENT = "attachment";
    private static final String STARTDAYTIME = "startdaytime";
    private static final String ENDDAYTIME = "enddaytime";
    private static final String TASK_ENTRY = "treeentryentity";
    private static final String LAB_NOT_START = "label_notstart_data";
    private static final String LAB_DOING = "label_doing_data";
    private static final String LAB_DONE = "label_done_data";
    private static final String LAB_FAILED = "label_failed_data";
    private static final String LAB_DELAY = "label_delay_data";
    private static final String CHECKOUTFLOW_ID = "checkoutflowid";
    private static final String PERSON_WORKBENCH = "fcc_workbench_person";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String REFRESH_BTN = "refresh";
    private static final String TASKSET = "1";

    public void initialize() {
        super.initialize();
        this.orgTree = (TreeView)this.getView().getControl("treeviewap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.orgTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        TextEdit payee = (TextEdit)this.getControl(EXPLAIN);
        payee.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{LAB_NOT_START, LAB_DOING, LAB_DONE, LAB_FAILED, LAB_DELAY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        WorkBenchFormUtils.setDateRange(this.getView(), MONTH_SEARCH, DATE_SEARCH);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u3010fcc\u3011\uff1acustomParams------" + SerializationUtils.toJsonString((Object)customParams));
        if (customParams.containsKey(CHECK_METHOD)) {
            this.getModel().setValue(CHECK_METHOD, customParams.get(CHECK_METHOD));
            this.getView().updateView(CHECK_METHOD);
            this.getModel().updateCache();
        }
        if (customParams.containsKey(DATE_SEARCH)) {
            this.getModel().setValue(DATE_SEARCH, customParams.get(DATE_SEARCH));
            this.getView().updateView(DATE_SEARCH);
            this.getModel().updateCache();
        }
        if (customParams.containsKey(MONTH_SEARCH)) {
            this.getModel().setValue(MONTH_SEARCH, customParams.get(MONTH_SEARCH));
            this.getView().updateView(MONTH_SEARCH);
            this.getModel().updateCache();
        } else {
            QFilter qFilter = new QFilter(MONTH_SEARCH, "<=", (Object)new Date());
            qFilter.and("planstatus", "=", (Object)"B");
            qFilter.and("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
            Map month_desc = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_plan", (String)"id,number,name,method,month,planstatus", (QFilter[])new QFilter[]{qFilter}, (String)"month desc");
            ArrayList values = new ArrayList(month_desc.values());
            if (values.size() > 0) {
                DynamicObject plan = (DynamicObject)values.get(0);
                Date month = plan.getDate(MONTH_SEARCH);
                this.getModel().setValue(MONTH_SEARCH, (Object)month);
            }
            Long orgId = RequestContext.get().getOrgId();
            this.getPageCache().put("focusNodeId", String.valueOf(orgId));
        }
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(this.getView());
        logger.info("\u3010fcc\u3011\uff1acheckoutPlan------" + SerializationUtils.toJsonString((Object)checkoutPlan));
        if (null == checkoutPlan) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u6ca1\u6709\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"WorkbenchTplFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> leafOrgIds = WorkBenchFormUtils.getAllLeafOrgId(checkoutPlan.getLong("id"));
        this.getPageCache().put("leafOrgIds", SerializationUtils.toJsonString(leafOrgIds));
        Map<String, String> leafOrgToStatus = WorkBenchFormUtils.getAllLeafOrgToStatus(checkoutPlan, leafOrgIds, this.getModel().getDataEntityType().getName(), this.getView());
        logger.info("\u3010fcc\u3011\uff1aleafOrgToStatus------" + SerializationUtils.toJsonString(leafOrgToStatus));
        if (customParams.containsKey("filterStatusKey")) {
            String filterStatusKey = (String)customParams.get("filterStatusKey");
            logger.info("\u3010fcc\u3011\uff1afilterStatusKey_afterCreateNewData------" + filterStatusKey);
            String filterStatus = "";
            switch (filterStatusKey) {
                case "label_notstart_data": {
                    filterStatus = TaskStatusEnum.NOT_START.getType();
                    break;
                }
                case "label_doing_data": {
                    filterStatus = TaskStatusEnum.DOING.getType();
                    break;
                }
                case "label_done_data": {
                    filterStatus = TaskStatusEnum.DONE.getType();
                    break;
                }
                case "label_failed_data": {
                    filterStatus = TaskStatusEnum.FAILED.getType();
                    break;
                }
                case "label_delay_data": {
                    filterStatus = "DELAY";
                }
            }
            this.getPageCache().put("cardFilterStatus", filterStatus);
            WorkBenchFormUtils.setLabFilterBackColor(filterStatusKey, filterStatus, this.getView());
        }
        this.initAcctOrgTree(checkoutPlan, leafOrgToStatus);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String checkMethod = (String)this.getModel().getValue(CHECK_METHOD);
        logger.info("\u3010fcc\u3011\uff1acheckMethod_beforeBindData------" + checkMethod);
        this.showDateSearchControl(checkMethod);
        String formName = this.getModel().getDataEntityType().getName();
        if (!PERSON_WORKBENCH.equals(formName)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{EXPLAIN, ATTACHMENT});
        }
        this.getModel().updateCache();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (REFRESH_BTN.equals(key)) {
            WorkBenchFormUtils.setDateRange(this.getView(), MONTH_SEARCH, DATE_SEARCH);
            this.refreshTreeAndDetail();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        logger.info("\u3010fcc\u3011\uff1akey_click------" + key);
        String filterStatus = "";
        switch (key) {
            case "label_notstart_data": {
                filterStatus = TaskStatusEnum.NOT_START.getType();
                break;
            }
            case "label_doing_data": {
                filterStatus = TaskStatusEnum.DOING.getType();
                break;
            }
            case "label_done_data": {
                filterStatus = TaskStatusEnum.DONE.getType();
                break;
            }
            case "label_failed_data": {
                filterStatus = TaskStatusEnum.FAILED.getType();
                break;
            }
            case "label_delay_data": {
                filterStatus = "DELAY";
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)filterStatus)) {
            String allNodeIdStr = this.getPageCache().get("allNodeIds");
            if (kd.bos.util.StringUtils.isEmpty((String)allNodeIdStr)) {
                return;
            }
            Set allNodeIds = (Set)SerializationUtils.fromJsonString((String)allNodeIdStr, Set.class);
            DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(this.getView());
            if (filterStatus.equals(this.getPageCache().get("filterStatus"))) {
                filterStatus = "";
            }
            this.getPageCache().put("filterStatus", filterStatus);
            logger.info("\u3010fcc\u3011\uff1afilterStatus_click------" + filterStatus);
            this.showDetail(checkoutPlan, allNodeIds, filterStatus, false);
            WorkBenchFormUtils.setLabFilterBackColor(key, filterStatus, this.getView());
            WorkBenchFormUtils.showStatusTotal(this.getModel(), this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (DATE_SEARCH.equals(propertyName) || MONTH_SEARCH.equals(propertyName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Date oldValue = (Date)e.getChangeSet()[0].getOldValue();
            if (null == newValue) {
                this.getModel().setValue(propertyName, (Object)oldValue);
                return;
            }
            this.refreshTreeAndDetail();
        }
        if (CHECK_METHOD.equals(propertyName)) {
            String checkMethod = (String)this.getModel().getValue(CHECK_METHOD);
            this.showDateSearchControl(checkMethod);
            this.refreshTreeAndDetail();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        logger.info("\u3010fcc\u3011\uff1a\u6811\u8282\u70b9\u70b9\u51fb\u4e8b\u4ef6");
        Long orgId = Long.valueOf((String)evt.getNodeId());
        this.getPageCache().put("focusNodeId", String.valueOf(orgId));
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(this.getView());
        if (null == checkoutPlan) {
            logger.info("\u3010fcc\u3011\uff1areturn1");
            return;
        }
        TreeNode rootTreeNode = WorkBenchTreeUtils.getTreeNode(checkoutPlan.getLong("id"), new HashMap<String, String>());
        if (null == rootTreeNode) {
            logger.info("\u3010fcc\u3011\uff1areturn2");
            return;
        }
        TreeNode orgTreeNode = rootTreeNode.getTreeNode(orgId.toString());
        logger.info("\u3010fcc\u3011\uff1aorgTreeNode------" + SerializationUtils.toJsonString((Object)orgTreeNode));
        if (null == orgTreeNode) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6811\u5f62\u8282\u70b9\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"WorkbenchTplFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        this.orgTree.focusNode(orgTreeNode);
        List<TreeNode> allChildrenNode = WorkBenchTreeUtils.getAllChildrenAndSelf(orgTreeNode);
        HashSet<String> allNodeIds = new HashSet<String>(allChildrenNode.size());
        for (TreeNode node : allChildrenNode) {
            allNodeIds.add(node.getId());
        }
        this.getPageCache().put("allNodeIds", SerializationUtils.toJsonString(allNodeIds));
        String filterStatus = "";
        String cardFilterStatus = this.getPageCache().get("cardFilterStatus");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cardFilterStatus)) {
            logger.info("\u3010fcc\u3011\uff1atreeNodeClick------\u5b58\u5728\u5361\u7247\u8df3\u8f6c\u8fc7\u6ee4\uff1a" + cardFilterStatus);
            filterStatus = cardFilterStatus;
            this.getPageCache().remove("cardFilterStatus");
            this.getPageCache().put("filterStatus", filterStatus);
        } else {
            WorkBenchFormUtils.setLabNormalBackColor(this.getView());
        }
        this.showDetail(checkoutPlan, allNodeIds, filterStatus, false);
        WorkBenchFormUtils.showStatusTotal(this.getModel(), this.getView());
    }

    public void search(SearchEnterEvent e) {
        String content;
        String text = e.getText();
        String focusNodeId = this.orgTree.getTreeState().getFocusNodeId();
        boolean isFocus = false;
        boolean matched = false;
        if (focusNodeId == null) {
            isFocus = true;
        }
        if (StringUtils.isEmpty((CharSequence)(content = this.getPageCache().get("treenode")))) {
            return;
        }
        TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)content, TreeNode.class);
        List<TreeNode> allTreeNode = WorkBenchTreeUtils.getAllChildrenAndSelf(orgTreeNode);
        TreeNode treeNode = null;
        for (TreeNode matchedTreeNode : allTreeNode) {
            if (matchedTreeNode.getId().equals(focusNodeId)) {
                isFocus = true;
                continue;
            }
            if (!this.patten(matchedTreeNode.getText(), text) || !isFocus) continue;
            treeNode = matchedTreeNode;
            matchedTreeNode.setExpend(true);
            matched = true;
            break;
        }
        if (!matched) {
            for (TreeNode matchedTreeNode : allTreeNode) {
                if (matchedTreeNode.getId().equals(focusNodeId)) break;
                if (!this.patten(matchedTreeNode.getText(), text)) continue;
                treeNode = matchedTreeNode;
                matchedTreeNode.setExpend(true);
                break;
            }
        }
        if (treeNode != null) {
            this.orgTree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            this.orgTree.showNode(treeNode.getId());
            this.orgTree.focusNode(treeNode);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"WorkbenchTplFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshTreeAndDetail() {
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(this.getView());
        if (null == checkoutPlan) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u6ca1\u6709\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"WorkbenchTplFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            this.orgTree.deleteAllNodes();
            this.getModel().deleteEntryData(TASK_ENTRY);
            WorkBenchFormUtils.showStatusTotal(this.getModel(), this.getView());
            return;
        }
        List<Long> leafOrgIdList = WorkBenchFormUtils.getAllLeafOrgId(checkoutPlan.getLong("id"));
        this.getPageCache().put("leafOrgIds", SerializationUtils.toJsonString(leafOrgIdList));
        Map<String, String> leafOrgToStatus = WorkBenchFormUtils.getAllLeafOrgToStatus(checkoutPlan, leafOrgIdList, this.getModel().getDataEntityType().getName(), this.getView());
        this.initAcctOrgTree(checkoutPlan, leafOrgToStatus);
    }

    private boolean patten(String name, String search) {
        return Pattern.matches(".*" + search + ".*", name);
    }

    private void showDateSearchControl(String checkMethod) {
        if (DAY_CHECK.equals(checkMethod)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DATE_SEARCH});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONTH_SEARCH});
        } else if (MONTH_CHECK.equals(checkMethod)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONTH_SEARCH});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATE_SEARCH});
        }
    }

    private void initAcctOrgTree(DynamicObject checkOutPlan, Map<String, String> leafOrgToStatus) {
        this.orgTree.deleteAllNodes();
        this.getPageCache().remove("treenode");
        long view = CheckOutViewUtil.getView((Long)checkOutPlan.getLong("id"));
        if (view == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u4fdd\u5b58/\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u7ed3\u8d26\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"WorkbenchTplFormPlugin_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode orgTreeNode = WorkBenchTreeUtils.getTreeNode(checkOutPlan.getLong("id"), leafOrgToStatus);
        if (orgTreeNode == null) {
            Label label_checkplanname = (Label)this.getView().getControl("label_checkplanname");
            label_checkplanname.setText("");
            return;
        }
        this.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)orgTreeNode));
        this.orgTree.addNode(orgTreeNode);
        TreeNodeEvent tne = new TreeNodeEvent((Object)this.orgTree, (Object)orgTreeNode.getParentid(), (Object)orgTreeNode.getId());
        String focusNodeID = this.getPageCache().get("focusNodeId");
        if (kd.bos.util.StringUtils.isNotEmpty((String)focusNodeID) && orgTreeNode.getTreeNode(focusNodeID) != null) {
            this.orgTree.focusNode(orgTreeNode.getTreeNode(focusNodeID));
            tne = new TreeNodeEvent((Object)this.orgTree, (Object)orgTreeNode.getParentid(), (Object)focusNodeID);
            this.treeNodeClick(tne);
        } else {
            this.orgTree.focusNode(orgTreeNode);
            this.treeNodeClick(tne);
        }
    }

    private void showDetail(DynamicObject plan, Set<String> orgIds, String filterStatus, Boolean notDoneStatus) {
        this.getModel().deleteEntryData(TASK_ENTRY);
        this.getView().updateView(TASK_ENTRY);
        if (null == plan) {
            logger.info("\u3010fcc\u3011\uff1aplan_showDetail------\u4e3a\u7a7a");
            return;
        }
        HashSet<Long> longIds = new HashSet<Long>(orgIds.size());
        for (String str : orgIds) {
            longIds.add(Long.parseLong(str));
        }
        String checkMethod = (String)this.getModel().getValue(CHECK_METHOD);
        QFilter flowDateFilter = null;
        if (DAY_CHECK.equals(checkMethod)) {
            Date dayDate = (Date)this.getModel().getValue(DATE_SEARCH);
            flowDateFilter = new QFilter("flowdate", "=", (Object)dayDate);
        }
        DynamicObject[] checkoutFlowDetails = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)String.join((CharSequence)",", WorkBenchFormUtils.getFields()), (QFilter[])new QFilter[]{new QFilter(ORG, "in", longIds), new QFilter("plan", "=", (Object)plan.getLong("id")), new QFilter("flowstatus", "=", (Object)CheckoutFlowStatusEnum.confirm.getType()), flowDateFilter});
        if (kd.bos.util.StringUtils.isNotEmpty((String)filterStatus)) {
            checkoutFlowDetails = WorkBenchFormUtils.filterByTaskStatus(checkoutFlowDetails, filterStatus, notDoneStatus, this.getView());
        }
        String formName = this.getModel().getDataEntityType().getName();
        HashMap<Long, Integer> taskSetRow = new HashMap<Long, Integer>(checkoutFlowDetails.length);
        HashMap<Long, Set<Long>> parentToChilds = new HashMap<Long, Set<Long>>(checkoutFlowDetails.length);
        Map<Long, Set<Long>> taskToPretasks = WorkBenchFormUtils.getPretasks(checkoutFlowDetails);
        this.getView().getPageCache().put("taskToPretasks", SerializationUtils.toJsonString(taskToPretasks));
        HashMap<List<Object>, Integer> attachementToRow = new HashMap<List<Object>, Integer>(checkoutFlowDetails.length);
        if (PERSON_WORKBENCH.equals(formName)) {
            this.showPersonTask(checkoutFlowDetails, taskSetRow, parentToChilds, attachementToRow, taskToPretasks);
        } else {
            this.showOrgTask(checkoutFlowDetails, taskSetRow, parentToChilds, attachementToRow, taskToPretasks);
        }
        this.getView().getPageCache().put("taskSetRow", SerializationUtils.toJsonString(taskSetRow));
        this.getView().getPageCache().put("parentToChild", SerializationUtils.toJsonString(parentToChilds));
        this.refreshDelayStatus(taskSetRow, parentToChilds);
        this.setAttachementFields(attachementToRow);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TASK_ENTRY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView(TASK_ENTRY);
    }

    private void refreshDelayStatus(Map<Long, Integer> taskSetRow, Map<Long, Set<Long>> parentToChilds) {
        block0: for (Map.Entry<Long, Set<Long>> parentToChild : parentToChilds.entrySet()) {
            Set<Long> childIds = parentToChild.getValue();
            Long parentId = parentToChild.getKey();
            for (Long childId : childIds) {
                int childIndex = taskSetRow.get(childId);
                String isDelay = (String)this.getModel().getValue(DELAYSTATUS, childIndex);
                if (!DelayStatusEnum.DELAY.getType().equals(isDelay)) continue;
                int parentIndex = taskSetRow.get(parentId);
                this.getModel().setValue(DELAYSTATUS, (Object)isDelay, parentIndex);
                continue block0;
            }
        }
    }

    private void showOrgTask(DynamicObject[] checkoutFlowDetails, Map<Long, Integer> taskSetRow, Map<Long, Set<Long>> parentToChilds, Map<List<Object>, Integer> attachementToRow, Map<Long, Set<Long>> taskToPretasks) {
        int index = 0;
        for (DynamicObject checkOutFlowDetail : checkoutFlowDetails) {
            Long checkOutFlowId = checkOutFlowDetail.getLong("id");
            DynamicObjectCollection checkDetails = checkOutFlowDetail.getDynamicObjectCollection("taskentry");
            for (DynamicObject checkDetail : checkDetails) {
                Long id = checkDetail.getLong("id");
                Long pid = checkDetail.getLong("pid");
                String taskType = checkDetail.getString(TASKTYPE);
                if (TASKSET.equals(taskType) && WorkBenchFormUtils.containsTask(checkDetails, id)) {
                    this.getModel().createNewEntryRow(TASK_ENTRY);
                    this.getModel().updateCache();
                    HashSet childs = new HashSet(5);
                    parentToChilds.put(id, childs);
                    taskSetRow.put(id, index);
                    this.setCheckFields(checkDetail, index, checkOutFlowId, checkOutFlowDetail, attachementToRow, taskToPretasks);
                    ++index;
                    continue;
                }
                if (!taskSetRow.containsKey(pid)) continue;
                this.getModel().insertEntryRow(TASK_ENTRY, taskSetRow.get(pid).intValue());
                this.getModel().updateCache();
                parentToChilds.get(pid).add(id);
                taskSetRow.put(id, index);
                this.setCheckFields(checkDetail, index, checkOutFlowId, checkOutFlowDetail, attachementToRow, taskToPretasks);
                ++index;
            }
        }
    }

    private void showPersonTask(DynamicObject[] checkoutFlowDetails, Map<Long, Integer> taskSetRow, Map<Long, Set<Long>> parentToChilds, Map<List<Object>, Integer> attachementToRow, Map<Long, Set<Long>> taskToPretasks) {
        int index = 0;
        for (DynamicObject checkOutFlowDetail : checkoutFlowDetails) {
            Long checkOutFlowId = checkOutFlowDetail.getLong("id");
            DynamicObjectCollection checkDetails = checkOutFlowDetail.getDynamicObjectCollection("taskentry");
            String currentUserId = String.valueOf(UserServiceHelper.getCurrentUserId());
            logger.info("\u3010fcc\u3011\uff1acurrentUserId_showPersonTask------" + currentUserId);
            logger.info("\u3010fcc\u3011\uff1acheckDetails_showPersonTask------" + SerializationUtils.toJsonString((Object)checkDetails));
            for (DynamicObject checkDetail : checkDetails) {
                DynamicObject taskuser = checkDetail.getDynamicObject(EXCUTOR);
                Long id = checkDetail.getLong("id");
                Long pid = checkDetail.getLong("pid");
                String taskType = checkDetail.getString(TASKTYPE);
                if (TASKSET.equals(taskType) && WorkBenchFormUtils.containsPersonTask(checkDetails, id, currentUserId)) {
                    this.getModel().createNewEntryRow(TASK_ENTRY);
                    this.getModel().updateCache();
                    HashSet childs = new HashSet(5);
                    parentToChilds.put(id, childs);
                    taskSetRow.put(id, index);
                    logger.info("\u3010fcc\u3011\uff1a\u4efb\u52a1\u96c6id_showPersonTask------" + id);
                    this.setCheckFields(checkDetail, index, checkOutFlowId, checkOutFlowDetail, attachementToRow, taskToPretasks);
                    ++index;
                    continue;
                }
                if (!taskSetRow.containsKey(pid) || null == taskuser || !taskuser.getString("id").equals(currentUserId)) continue;
                this.getModel().insertEntryRow(TASK_ENTRY, taskSetRow.get(pid).intValue());
                this.getModel().updateCache();
                parentToChilds.get(pid).add(id);
                taskSetRow.put(id, index);
                this.setCheckFields(checkDetail, index, checkOutFlowId, checkOutFlowDetail, attachementToRow, taskToPretasks);
                ++index;
            }
        }
    }

    private void setCheckFields(DynamicObject checkDetail, int index, Long checkOutFlowId, DynamicObject checkOutFlow, Map<List<Object>, Integer> attachementToRow, Map<Long, Set<Long>> taskToPretasks) {
        List<String> fields = WorkBenchFormUtils.getFields();
        String taskType = checkDetail.getString(TASKTYPE);
        this.getModel().setValue(CHECKOUTFLOW_ID, (Object)checkOutFlowId, index);
        String taskTypeStr = checkDetail.getDynamicObject("tasknumber").getString(TASKTYPESTR);
        this.getModel().setValue(TASKTYPESTR, (Object)taskTypeStr, index);
        Long id = checkDetail.getLong("id");
        if (!TASKSET.equals(taskType) && taskToPretasks.containsKey(id) && !taskToPretasks.get(id).isEmpty()) {
            Set<Long> pretasksId = taskToPretasks.get(id);
            List<String> taskStatusList = WorkBenchFormUtils.getTaskStatus(pretasksId);
            this.getModel().setValue(PRETASKSTATUS, (Object)WorkBenchFormUtils.getTaskSetStatus(taskStatusList), index);
        }
        for (String field : fields) {
            if ("id".equals(field) || ORG.equals(field) || "taskentry.seq".equals(field)) continue;
            if (DELAYSTATUS.equals(field = field.substring(field.lastIndexOf(46) + 1))) {
                String isDelay = WorkBenchFormUtils.checkIsDelay(checkDetail, this.getView()) ? DelayStatusEnum.DELAY.getType() : DelayStatusEnum.NORMAL.getType();
                this.getModel().setValue(field, (Object)isDelay, index);
                continue;
            }
            if (EXCUTOR.equals(field) && TASKSET.equals(taskType)) continue;
            if (ATTACHMENT.equals(field)) {
                DynamicObjectCollection attachments = checkDetail.getDynamicObjectCollection(field);
                if (attachments.isEmpty()) continue;
                List attaIdList = attachments.stream().map(r -> r.getDynamicObject("fbasedataId").getPkValue()).collect(Collectors.toList());
                attachementToRow.put(attaIdList, index);
                continue;
            }
            if (STARTDAYTIME.equals(field) || ENDDAYTIME.equals(field)) {
                if (null == checkDetail.get(field) || checkDetail.getInt(field) < 0) continue;
                int totalSeconds = checkDetail.getInt(field);
                int hours = totalSeconds / 3600;
                if (24 == hours) {
                    hours = 0;
                }
                int minutes = totalSeconds % 3600 / 60;
                int seconds = totalSeconds % 60;
                Date date = (Date)this.getModel().getValue(DATE_SEARCH);
                LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                LocalDateTime updatedDateTime = localDateTime.withHour(hours).withMinute(minutes).withSecond(seconds);
                Date updatedDate = Date.from(updatedDateTime.atZone(ZoneId.systemDefault()).toInstant());
                this.getModel().setValue(field, (Object)updatedDate, index);
                continue;
            }
            this.getModel().setValue(field, checkDetail.get(field), index);
        }
        if (TASKSET.equals(taskType)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
            ArrayList<String> opeIds = new ArrayList<String>();
            opeIds.add("tobizentity");
            entryGrid.hideOperateItems("operationcolumnap", index, opeIds);
        }
    }

    private void setAttachementFields(Map<List<Object>, Integer> attachementToRow) {
        for (Map.Entry<List<Object>, Integer> entry : attachementToRow.entrySet()) {
            this.getModel().setValue(ATTACHMENT, (Object)entry.getKey().toArray(new Object[0]), entry.getValue().intValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("tobizentity".equals(key)) {
            int currentRow;
            IDataModel model = this.getModel();
            DynamicObject task = (DynamicObject)model.getValue("tasknumber", currentRow = model.getEntryCurrentRowIndex(TASK_ENTRY));
            DynamicObject bizEntityDyn = task.getDynamicObject("tobizentity");
            if (bizEntityDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4efb\u52a1\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u201c\u8054\u67e5\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002", (String)"WorkbenchTplFormPlugin_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bizEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)bizEntityDyn.get("id"), (String)"bos_entityobject");
            String modeltype = bizEntity.getString("modeltype");
            HashMap<String, Object> customParam = new HashMap<String, Object>(8);
            customParam.put("fcc_org", model.getValue(FCCField.id_((String)"eorg"), currentRow));
            customParam.put("fcc_bizOrg", model.getValue(FCCField.id_((String)"ebizorg"), currentRow));
            customParam.put("fcc_bizBookType", model.getValue(FCCField.id_((String)"bizbooktype"), currentRow));
            if (MONTH_CHECK.equals(model.getValue(CHECK_METHOD))) {
                customParam.put("fcc_date", model.getValue(MONTH_SEARCH));
            } else if (DAY_CHECK.equals(model.getValue(CHECK_METHOD))) {
                customParam.put("fcc_date", model.getValue(DATE_SEARCH));
            }
            if ("BillFormModel".equals(modeltype)) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setBillFormId(bizEntity.getString("number"));
                parameter.setFormId("bos_list");
                parameter.setCustomParams(customParam);
                this.getView().showForm((FormShowParameter)parameter);
            } else if ("ReportFormModel".equals(modeltype)) {
                ReportShowParameter parameter = new ReportShowParameter();
                parameter.setFormId(bizEntity.getString("number"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCustomParams(customParam);
                this.getView().showForm((FormShowParameter)parameter);
            } else if ("DynamicFormModel".equals(modeltype)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setFormId(bizEntity.getString("number"));
                parameter.setCustomParams(customParam);
                this.getView().showForm(parameter);
            }
        }
    }
}

