/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fcc.common.enums.TaskStatusEnum;

public class WorkbenchTplShowFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String TASKSTATUS = "taskstatus";
    private static final String EXPLAIN = "checkoutexplain";
    private static final String ATTACHMENT = "attachment";
    private static final String PRETASKS = "pretasks";
    private static final String PRETASKSTATUS = "pretaskstatus";
    private static final String CHECKOUTFLOW_ID = "checkoutflowid";
    private static final String TASK_ENTRY = "treeentryentity";
    private static final String CHECKOUT_EXPLAIN_CALLBACK = "checkout_explain_form";
    private static final String PRETASKS_CALLBACK = "pretasks_form";
    private static final String PERSON_WORKBENCH = "fcc_workbench_person";
    private static final String PROGRAM_LOG_CALLBACK = "program_log_callback";
    private static final String PROGRAM_TASK = "2";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payee = (TextEdit)this.getControl(EXPLAIN);
        payee.addButtonClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String formName = this.getModel().getDataEntityType().getName();
        if (EXPLAIN.equals(key) && PERSON_WORKBENCH.equals(formName)) {
            int clickRow = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
            String pageId = UUID.randomUUID().toString().replace("-", "");
            this.getPageCache().put("pageId", pageId);
            this.showExplainForm(clickRow, pageId);
            this.getPageCache().put("clickRow", String.valueOf(clickRow));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String key = hyperLinkClickEvent.getFieldName();
        int clickRow = this.getModel().getEntryCurrentRowIndex(TASK_ENTRY);
        if (PRETASKSTATUS.equals(key)) {
            this.showPretaskForm(clickRow);
            this.getPageCache().put("clickRow", String.valueOf(clickRow));
        } else if (TASKSTATUS.equals(key)) {
            this.showProgramLogForm(clickRow);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnMap;
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)CHECKOUT_EXPLAIN_CALLBACK) && (returnMap = (Map)evt.getReturnData()) != null && !returnMap.isEmpty()) {
            String clickRowStr = this.getPageCache().get("clickRow");
            if (StringUtils.isEmpty((CharSequence)clickRowStr)) {
                return;
            }
            int clickRow = Integer.parseInt(clickRowStr);
            DynamicObjectCollection headerAttaColl = (DynamicObjectCollection)returnMap.get("attach");
            String explain = (String)returnMap.get("explain");
            Long checkOutId = (Long)this.getModel().getValue(CHECKOUTFLOW_ID, clickRow);
            QFilter qFilter = new QFilter("id", "=", (Object)checkOutId);
            DynamicObject checkOutDt = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_checkout_flow_detail", (String)String.join((CharSequence)",", WorkbenchTplShowFormPlugin.getFields()), (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection checkOutDetails = checkOutDt.getDynamicObjectCollection("taskentry");
            Long entryId = (Long)this.getModel().getValue("id", clickRow);
            for (DynamicObject checkOutDetail : checkOutDetails) {
                if (checkOutDetail.getLong("id") != entryId.longValue()) continue;
                checkOutDetail.set(EXPLAIN, (Object)explain);
                checkOutDetail.set(ATTACHMENT, (Object)headerAttaColl);
                break;
            }
            checkOutDt.set("taskentry", (Object)checkOutDetails);
            OperationResult saveBillResult = SaveServiceHelper.saveOperate((String)"fcc_checkout_flow_detail", (DynamicObject[])new DynamicObject[]{checkOutDt}, (OperateOption)OperateOption.create());
            if (!saveBillResult.isSuccess()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u8bf4\u660e\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"WorkbenchTplShowFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("PkId", checkOutDt.getPkValue());
            paramMap.put("PageId", this.getPageCache().get("pageId"));
            String paramStr = SerializationUtils.toJsonString(paramMap);
            AttachmentFieldServiceHelper.saveTempAttachments((String)paramStr);
            ArrayList<Object> attaIdList = new ArrayList<Object>();
            for (DynamicObject attaObj : headerAttaColl) {
                attaIdList.add(attaObj.getDynamicObject("fbasedataId").getPkValue());
            }
            this.getModel().setValue(ATTACHMENT, (Object)attaIdList.toArray(new Object[0]), clickRow);
            this.getView().updateView(ATTACHMENT, clickRow);
            this.getModel().setValue(EXPLAIN, (Object)explain, clickRow);
            this.getView().updateView(EXPLAIN, clickRow);
        }
    }

    private void showExplainForm(int clickRow, String pageId) {
        FormShowParameter formShowParam = new FormShowParameter();
        formShowParam.setFormId("fcc_checkout_explain");
        formShowParam.getOpenStyle().setShowType(ShowType.Modal);
        formShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHECKOUT_EXPLAIN_CALLBACK));
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        String explainStr = (String)this.getModel().getValue(EXPLAIN, clickRow);
        DynamicObjectCollection attachments = (DynamicObjectCollection)this.getModel().getValue(ATTACHMENT, clickRow);
        if (!attachments.isEmpty()) {
            List attaIdList = attachments.stream().map(r -> r.getDynamicObject("fbasedataId").getPkValue()).collect(Collectors.toList());
            paramMap.put("attachmentIds", attaIdList);
        }
        paramMap.put("explainStr", explainStr);
        paramMap.put("parentPageId", pageId);
        formShowParam.setCustomParams(paramMap);
        this.getView().showForm(formShowParam);
    }

    private void showPretaskForm(int clickRow) {
        FormShowParameter formShowParam = new FormShowParameter();
        formShowParam.setFormId("fcc_pretasks");
        formShowParam.getOpenStyle().setShowType(ShowType.Modal);
        formShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRETASKS_CALLBACK));
        Long checkOutId = (Long)this.getModel().getValue(CHECKOUTFLOW_ID, clickRow);
        Long pId = (Long)this.getModel().getValue("pid", clickRow);
        Long id = (Long)this.getModel().getValue("id", clickRow);
        String taskStatus = (String)this.getModel().getValue(TASKSTATUS, clickRow);
        String taskToPretasksStr = this.getView().getPageCache().get("taskToPretasks");
        if (StringUtils.isEmpty((CharSequence)taskToPretasksStr)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"WorkbenchTplShowFormPlugin_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Map taskToPretasks = (Map)SerializationUtils.fromJsonString((String)taskToPretasksStr, Map.class);
        List pretaskIds = new ArrayList(10);
        if (taskToPretasks.containsKey(String.valueOf(id))) {
            pretaskIds = (List)taskToPretasks.get(String.valueOf(id));
        }
        String formName = this.getModel().getDataEntityType().getName();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
        paramMap.put("clickRow", clickRow);
        paramMap.put("taskStatus", taskStatus);
        paramMap.put("checkOutId", checkOutId);
        paramMap.put("pId", pId);
        paramMap.put("taskIdSet", pretaskIds);
        paramMap.put("formName", formName);
        formShowParam.setCustomParams(paramMap);
        this.getView().showForm(formShowParam);
    }

    private void showProgramLogForm(int clickRow) {
        FormShowParameter formShowParam = new FormShowParameter();
        formShowParam.setFormId("fcc_execute_task_log");
        formShowParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROGRAM_LOG_CALLBACK));
        Long entryId = (Long)this.getModel().getValue("id", clickRow);
        Long pId = (Long)this.getModel().getValue(CHECKOUTFLOW_ID, clickRow);
        HashMap<String, Long> paramMap = new HashMap<String, Long>(6);
        paramMap.put("pId", pId);
        paramMap.put("entryId", entryId);
        formShowParam.setCustomParams(paramMap);
        formShowParam.setStatus(OperationStatus.VIEW);
        this.getView().showForm(formShowParam);
    }

    private void packageData(PackageDataEvent event) {
        if (event.getRowData().containsProperty(TASKSTATUS) && event.getRowData().containsProperty("tasktype")) {
            String taskstatus = event.getRowData().getString(TASKSTATUS);
            String tasktype = event.getRowData().getString("tasktype");
            if (PROGRAM_TASK.equals(tasktype)) {
                if (taskstatus.equals(TaskStatusEnum.NOT_START.getType()) || taskstatus.equals(TaskStatusEnum.DOING.getType())) {
                    event.getNoLinkKey().add(TASKSTATUS);
                }
            } else {
                event.getNoLinkKey().add(TASKSTATUS);
            }
        }
    }

    public static List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("id");
        fields.add("org");
        fields.add("plan");
        fields.add("taskentry.id");
        fields.add("taskentry.pid");
        fields.add("taskentry.tasknumber");
        fields.add("taskentry.eorg");
        fields.add("taskentry.type");
        fields.add("taskentry.bizbooktype");
        fields.add("taskentry.executor");
        fields.add("taskentry.starttime");
        fields.add("taskentry.endtime");
        fields.add("taskentry.startdaytime");
        fields.add("taskentry.enddaytime");
        fields.add("taskentry.pretasks");
        fields.add("taskentry.taskstatus");
        fields.add("taskentry.isdelay");
        fields.add("taskentry.truestarttime");
        fields.add("taskentry.trueendtime");
        fields.add("taskentry.ebizorg");
        fields.add("taskentry.checkoutexplain");
        fields.add("taskentry.attachment");
        return fields;
    }
}

