/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.homepage;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.HomePageCardUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class DoTaskCardFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(DoTaskCardFormPlugin.class);
    private static final String DOTASK_CARD = "fcc_apphome_dotask_card";
    private static final String LAB_NOT_START = "label_notstart_data";
    private static final String LAB_DOING = "label_doing_data";
    private static final String LAB_FAILED = "label_failed_data";
    private static final String LAB_DELAY = "label_delay_data";
    private static final String EXCUTOR = "executor";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String TASKSET = "1";
    private static final String PERSON_WORKBENCH = "fcc_workbench_person";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LAB_NOT_START, LAB_DOING, LAB_FAILED, LAB_DELAY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String pageId = this.getView().getPageId();
        this.getView().getParentView().getPageCache().put(DOTASK_CARD, pageId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label label_not_start = (Label)this.getView().getControl(LAB_NOT_START);
        Label label_doing = (Label)this.getView().getControl(LAB_DOING);
        Label label_failed = (Label)this.getView().getControl(LAB_FAILED);
        Label label_delay = (Label)this.getView().getControl(LAB_DELAY);
        int delay_count = 0;
        int failed_count = 0;
        int doing_count = 0;
        int nostart_count = 0;
        IFormView parentView = this.getView().getParentView();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(parentView);
        if (null != checkoutPlan) {
            this.getPageCache().put("checkoutplan", "true");
        }
        if (null == checkoutPlan) {
            label_not_start.setText(String.valueOf(nostart_count));
            label_doing.setText(String.valueOf(doing_count));
            label_failed.setText(String.valueOf(failed_count));
            label_delay.setText(String.valueOf(delay_count));
            return;
        }
        Map<Object, DynamicObject> checkoutFlows = HomePageCardUtil.getAllCheckFlows(checkoutPlan, parentView);
        if (checkoutFlows.isEmpty()) {
            label_not_start.setText(String.valueOf(nostart_count));
            label_doing.setText(String.valueOf(doing_count));
            label_failed.setText(String.valueOf(failed_count));
            label_delay.setText(String.valueOf(delay_count));
            return;
        }
        for (Map.Entry<Object, DynamicObject> checkoutFlowEntry : checkoutFlows.entrySet()) {
            DynamicObject checkoutFlow = checkoutFlowEntry.getValue();
            DynamicObjectCollection checkDetails = checkoutFlow.getDynamicObjectCollection("taskentry");
            String currentUserId = String.valueOf(UserServiceHelper.getCurrentUserId());
            for (DynamicObject checkDetail : checkDetails) {
                DynamicObject taskuser = checkDetail.getDynamicObject(EXCUTOR);
                String taskType = checkDetail.getString(TASKTYPE);
                String taskStatus = checkDetail.getString(TASKSTATUS);
                if (TASKSET.equals(taskType) || null == taskuser || !taskuser.getString("id").equals(currentUserId)) continue;
                switch (taskStatus) {
                    case "a": {
                        ++nostart_count;
                        break;
                    }
                    case "b": {
                        ++doing_count;
                        break;
                    }
                    case "d": {
                        ++failed_count;
                    }
                }
                if (TaskStatusEnum.DONE.getType().equals(taskStatus) || !WorkBenchFormUtils.checkIsDelay(checkDetail, this.getView().getParentView())) continue;
                ++delay_count;
            }
        }
        label_not_start.setText(String.valueOf(nostart_count));
        label_doing.setText(String.valueOf(doing_count));
        label_failed.setText(String.valueOf(failed_count));
        label_delay.setText(String.valueOf(delay_count));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String filterStatusKey = "";
        if (LAB_NOT_START.equals(key) || LAB_DOING.equals(key) || LAB_FAILED.equals(key) || LAB_DELAY.equals(key)) {
            filterStatusKey = key;
        }
        if (StringUtils.isNotEmpty((CharSequence)filterStatusKey)) {
            String hasCheckPlan = this.getPageCache().get("checkoutplan");
            if (StringUtils.isEmpty((CharSequence)hasCheckPlan)) {
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(PERSON_WORKBENCH);
            IDataModel homepageModel = this.getView().getParentView().getModel();
            showParameter.setCustomParam("checkmethod", homepageModel.getValue("checkmethod"));
            logger.info("\u3010fcc\u3011\uff1acheckmethod------" + SerializationUtils.toJsonString((Object)homepageModel.getValue("checkmethod")));
            showParameter.setCustomParam("date", homepageModel.getValue("date"));
            logger.info("\u3010fcc\u3011\uff1adate------" + SerializationUtils.toJsonString((Object)homepageModel.getValue("date")));
            showParameter.setCustomParam("month", homepageModel.getValue("month"));
            logger.info("\u3010fcc\u3011\uff1amonth------" + SerializationUtils.toJsonString((Object)homepageModel.getValue("month")));
            showParameter.setCustomParam("filterStatusKey", (Object)filterStatusKey);
            logger.info("\u3010fcc\u3011\uff1afilterStatusKey------" + filterStatusKey);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }
}

