/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.homepage;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class HomePageFormPlugin
extends AbstractFormPlugin {
    private static final String CHECK_METHOD = "checkmethod";
    private static final String DAY_CHECK = "day_check";
    private static final String MONTH_CHECK = "month_check";
    private static final String DATE_SEARCH = "date";
    private static final String MONTH_SEARCH = "month";
    private static final String REFRESH_BTN = "bar_refresh";
    private static final String DOTASK_CARD = "fcc_apphome_dotask_card";
    private static final String PROCESS_CARD = "fcc_apphome_process_card";
    private static final String PENDING_CARD = "fcc_apphome_pending_card";
    private static final String ORGRATE_CARD = "fcc_apphome_orgrate_card";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        WorkBenchFormUtils.setDateRange(this.getView(), MONTH_SEARCH, DATE_SEARCH);
        QFilter qFilter = new QFilter(MONTH_SEARCH, "<=", (Object)new Date());
        qFilter.and("planstatus", "=", (Object)"B");
        qFilter.and("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
        Map month_desc = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_plan", (String)"id,number,name,method,month,planstatus", (QFilter[])new QFilter[]{qFilter}, (String)"month desc");
        ArrayList values = new ArrayList(month_desc.values());
        if (values.size() > 0) {
            DynamicObject plan = (DynamicObject)values.get(0);
            Date month = plan.getDate(MONTH_SEARCH);
            this.getModel().setValue(MONTH_SEARCH, (Object)month);
        }
        String checkMethod = (String)this.getModel().getValue(CHECK_METHOD);
        this.showDateSearchControl(checkMethod);
        this.refreshCard(DOTASK_CARD);
        this.refreshCard(PROCESS_CARD);
        this.refreshCard(PENDING_CARD);
        this.refreshCard(ORGRATE_CARD);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (CHECK_METHOD.equals(propertyName)) {
            String checkMethod = (String)this.getModel().getValue(CHECK_METHOD);
            this.showDateSearchControl(checkMethod);
            this.refreshCard(DOTASK_CARD);
            this.refreshCard(PROCESS_CARD);
            this.refreshCard(PENDING_CARD);
            this.refreshCard(ORGRATE_CARD);
        }
        if (DATE_SEARCH.equals(propertyName) || MONTH_SEARCH.equals(propertyName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Date oldValue = (Date)e.getChangeSet()[0].getOldValue();
            if (null == newValue) {
                this.getModel().setValue(propertyName, (Object)oldValue);
                return;
            }
            this.refreshCard(DOTASK_CARD);
            this.refreshCard(PROCESS_CARD);
            this.refreshCard(PENDING_CARD);
            this.refreshCard(ORGRATE_CARD);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (REFRESH_BTN.equals(key)) {
            WorkBenchFormUtils.setDateRange(this.getView(), MONTH_SEARCH, DATE_SEARCH);
            this.refreshCard(DOTASK_CARD);
            this.refreshCard(PROCESS_CARD);
            this.refreshCard(PENDING_CARD);
            this.refreshCard(ORGRATE_CARD);
        }
    }

    private void showDateSearchControl(String checkMethod) {
        if (DAY_CHECK.equals(checkMethod)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DATE_SEARCH});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONTH_SEARCH});
        } else if (MONTH_CHECK.equals(checkMethod)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONTH_SEARCH});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATE_SEARCH});
        }
    }

    private void refreshCard(String cardName) {
        IFormView childView;
        String dcard_pageId = this.getView().getPageCache().get(cardName);
        if (StringUtils.isNotBlank((CharSequence)dcard_pageId) && null != (childView = this.getView().getView(dcard_pageId))) {
            childView.updateView();
            this.getView().sendFormAction(childView);
        }
    }
}

