/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.homepage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.HomePageCardUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class OrgRateCardFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String ORGRATE_CARD = "fcc_apphome_orgrate_card";
    private static final String FLEX = "flexpanelap";
    private static final String LAB_ORG = "lab_org";
    private static final String PROGRESS = "progress";
    private static final String LAB_RATE = "lab_rate";
    private static final String EXCUTOR = "executor";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String TASKSET = "1";

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String pageId = this.getView().getPageId();
        this.getView().getParentView().getPageCache().put(ORGRATE_CARD, pageId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(parentView);
        if (null == checkoutPlan) {
            this.hideAllFlex();
            return;
        }
        Map<Object, DynamicObject> checkoutFlows = HomePageCardUtil.getAllCheckFlows(checkoutPlan, parentView);
        if (checkoutFlows.isEmpty()) {
            this.hideAllFlex();
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        HashMap<String, String> orgRateStrMap = new HashMap<String, String>(checkoutFlows.size());
        Map<String, Integer> orgRateMap = this.getOrgRateMap(checkoutFlows, "person".equals(currentTab), orgRateStrMap);
        this.renderingFlex(orgRateMap, orgRateStrMap);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        IFormView parentView = this.getView().getParentView();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(parentView);
        if (null == checkoutPlan) {
            this.hideAllFlex();
            return;
        }
        Map<Object, DynamicObject> checkoutFlows = HomePageCardUtil.getAllCheckFlows(checkoutPlan, parentView);
        if (checkoutFlows.isEmpty()) {
            this.hideAllFlex();
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        HashMap<String, String> orgRateStrMap = new HashMap<String, String>(checkoutFlows.size());
        Map<String, Integer> orgRateMap = this.getOrgRateMap(checkoutFlows, "person".equals(currentTab), orgRateStrMap);
        this.renderingFlex(orgRateMap, orgRateStrMap);
    }

    private void renderingFlex(Map<String, Integer> orgRateMap, Map<String, String> orgRateStrMap) {
        this.hideAllFlex();
        int index = 1;
        for (Map.Entry<String, Integer> entry : orgRateMap.entrySet()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX + index});
            Label orgName = (Label)this.getView().getControl(LAB_ORG + index);
            orgName.setText(entry.getKey());
            ProgressBar process = (ProgressBar)this.getView().getControl(PROGRESS + index);
            process.setPercent(entry.getValue().intValue());
            Label rate = (Label)this.getView().getControl(LAB_RATE + index);
            rate.setText(entry.getValue() + "%");
            if (orgRateStrMap.containsKey(entry.getKey())) {
                Tips tips = new Tips();
                tips.setContent(new LocaleString(orgRateStrMap.get(entry.getKey())));
                tips.setType("text");
                rate.addTips(tips);
            }
            ++index;
        }
    }

    private void hideAllFlex() {
        for (int i = 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX + i});
        }
    }

    private Map<String, Integer> getOrgRateMap(Map<Object, DynamicObject> checkoutFlows, Boolean isPerson, Map<String, String> orgRateStrMap) {
        HashMap<String, Integer> orgRateMap = new HashMap<String, Integer>(checkoutFlows.size());
        for (Map.Entry<Object, DynamicObject> checkoutFlowEntry : checkoutFlows.entrySet()) {
            DynamicObject checkoutFlow = checkoutFlowEntry.getValue();
            int doneTaskCount = 0;
            int allTaskCount = 0;
            String orgName = checkoutFlow.getDynamicObject("org").getString("name");
            DynamicObjectCollection checkDetails = checkoutFlow.getDynamicObjectCollection("taskentry");
            if (isPerson.booleanValue()) {
                String currentUserId = String.valueOf(UserServiceHelper.getCurrentUserId());
                for (DynamicObject checkDetail : checkDetails) {
                    DynamicObject taskuser = checkDetail.getDynamicObject(EXCUTOR);
                    String taskType = checkDetail.getString(TASKTYPE);
                    String taskStatus = checkDetail.getString(TASKSTATUS);
                    if (TASKSET.equals(taskType) || null == taskuser || !taskuser.getString("id").equals(currentUserId)) continue;
                    ++allTaskCount;
                    if (!TaskStatusEnum.DONE.getType().equals(taskStatus)) continue;
                    ++doneTaskCount;
                }
            } else {
                for (DynamicObject checkDetail : checkDetails) {
                    String taskType = checkDetail.getString(TASKTYPE);
                    String taskStatus = checkDetail.getString(TASKSTATUS);
                    if (TASKSET.equals(taskType)) continue;
                    ++allTaskCount;
                    if (!TaskStatusEnum.DONE.getType().equals(taskStatus)) continue;
                    ++doneTaskCount;
                }
            }
            if (allTaskCount <= 0) continue;
            double taskpercent = (double)doneTaskCount / (double)allTaskCount * 100.0;
            int roundedTaskPercen = (int)Math.round(taskpercent);
            orgRateMap.put(orgName, roundedTaskPercen);
            orgRateStrMap.put(orgName, doneTaskCount + "/" + allTaskCount);
        }
        LinkedHashMap<String, Integer> sortedMap = this.sortByValue(orgRateMap);
        LinkedHashMap<String, Integer> topTenMap = this.getTopTen(sortedMap);
        return topTenMap;
    }

    private LinkedHashMap<String, Integer> sortByValue(Map<String, Integer> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private LinkedHashMap<String, Integer> getTopTen(Map<String, Integer> map) {
        LinkedHashMap<String, Integer> topTenMap = new LinkedHashMap<String, Integer>();
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (count >= 10) break;
            topTenMap.put(entry.getKey(), entry.getValue());
            ++count;
        }
        return topTenMap;
    }
}

