/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.homepage;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.enums.DelayStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.HomePageCardUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class PendingCardFormPlugin
extends AbstractFormPlugin {
    private static final String PENDING_CARD = "fcc_apphome_pending_card";
    private static final String STARTDAYTIME = "startdaytime";
    private static final String ENDDAYTIME = "enddaytime";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String TASK_ENTRY = "entryentity";
    private static final String[] ENTRY_FIELDS = new String[]{"org", "tasknumber", "starttime", "endtime", "taskstatus", "isdelay"};
    private static final String EXCUTOR = "executor";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String TASKSET = "1";
    private static final String CHECK_METHOD = "checkmethod";
    private static final String DAY_CHECK = "day_check";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String pageId = this.getView().getPageId();
        this.getView().getParentView().getPageCache().put(PENDING_CARD, pageId);
    }

    public void beforeBindData(EventObject e) {
        Long id;
        Object oldTaskIds;
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(parentView);
        if (null == checkoutPlan) {
            this.getModel().deleteEntryData(TASK_ENTRY);
            this.getPageCache().remove("taskIds");
            return;
        }
        String checkMethod = (String)this.getView().getParentView().getModel().getValue(CHECK_METHOD);
        HashMap<DynamicObject, Date> delayTaskMap = new HashMap<DynamicObject, Date>(10);
        HashMap<DynamicObject, Date> normalTaskMap = new HashMap<DynamicObject, Date>(10);
        HashMap<DynamicObject, DynamicObject> taskToOrg = new HashMap<DynamicObject, DynamicObject>(10);
        Map<Object, DynamicObject> checkoutFlows = HomePageCardUtil.getAllCheckFlows(checkoutPlan, parentView);
        if (checkoutFlows.isEmpty()) {
            this.getModel().deleteEntryData(TASK_ENTRY);
            return;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(checkoutFlows.size());
        for (Map.Entry<Object, DynamicObject> checkoutFlowEntry : checkoutFlows.entrySet()) {
            DynamicObject dynamicObject = checkoutFlowEntry.getValue();
            DynamicObjectCollection checkDetails = dynamicObject.getDynamicObjectCollection("taskentry");
            for (DynamicObject checkDetail : checkDetails) {
                if (TaskStatusEnum.DONE.getType().equals(checkDetail.getString(TASKSTATUS))) continue;
                taskIds.add(checkDetail.getLong("id"));
            }
        }
        String taskIdStr = this.getPageCache().get("taskIds");
        if (StringUtils.isNotEmpty((CharSequence)taskIdStr) && taskIds.containsAll((Collection<?>)(oldTaskIds = (List)SerializationUtils.fromJsonString((String)taskIdStr, List.class))) && oldTaskIds.containsAll(taskIds)) {
            Map<Long, String> map = HomePageCardUtil.getTaskStatus(taskIds);
            DynamicObjectCollection entry = this.getModel().getEntryEntity(TASK_ENTRY);
            for (int i = 0; i < entry.size(); ++i) {
                String oldStatus = (String)this.getModel().getValue(TASKSTATUS, i);
                Long taskId = (Long)this.getModel().getValue("id", i);
                String newStatus = map.get(taskId);
                if (!StringUtils.isNotEmpty((CharSequence)newStatus) || newStatus.equals(oldStatus)) continue;
                this.getModel().setValue(TASKSTATUS, (Object)newStatus, i);
            }
            this.getView().updateView(TASK_ENTRY);
            return;
        }
        this.getPageCache().put("taskIds", SerializationUtils.toJsonString(taskIds));
        for (Map.Entry entry : checkoutFlows.entrySet()) {
            DynamicObject checkoutFlow = (DynamicObject)entry.getValue();
            DynamicObject org = checkoutFlow.getDynamicObject("org");
            DynamicObjectCollection checkDetails = checkoutFlow.getDynamicObjectCollection("taskentry");
            String currentUserId = String.valueOf(UserServiceHelper.getCurrentUserId());
            for (DynamicObject checkDetail : checkDetails) {
                Boolean isDelay;
                DynamicObject taskuser = checkDetail.getDynamicObject(EXCUTOR);
                String taskType = checkDetail.getString(TASKTYPE);
                String taskStatus = checkDetail.getString(TASKSTATUS);
                if (TASKSET.equals(taskType) || null == taskuser || !taskuser.getString("id").equals(currentUserId) || TaskStatusEnum.DONE.getType().equals(taskStatus)) continue;
                if (DAY_CHECK.equals(checkMethod)) {
                    Date date = (Date)this.getView().getParentView().getModel().getValue("date");
                    Date longstarttime = this.getLongTime(checkDetail, date, STARTDAYTIME);
                    Date longendtime = this.getLongTime(checkDetail, date, ENDDAYTIME);
                    checkDetail.set(STARTTIME, (Object)longstarttime);
                    checkDetail.set(ENDTIME, (Object)longendtime);
                }
                if ((isDelay = Boolean.valueOf(WorkBenchFormUtils.checkIsDelay(checkDetail, this.getView().getParentView()))).booleanValue()) {
                    delayTaskMap.put(checkDetail, checkDetail.getDate(STARTTIME));
                    taskToOrg.put(checkDetail, org);
                    continue;
                }
                normalTaskMap.put(checkDetail, checkDetail.getDate(STARTTIME));
                taskToOrg.put(checkDetail, org);
            }
        }
        Date currentDate = this.convertDate(new Date());
        List<DynamicObject> list = this.getSortAndFilterTasks(currentDate, delayTaskMap);
        List<DynamicObject> sortedNormalTask = this.getSortAndFilterTasks(currentDate, normalTaskMap);
        this.getModel().deleteEntryData(TASK_ENTRY);
        List<String> entryFields = Arrays.asList(ENTRY_FIELDS);
        int index = 0;
        for (DynamicObject deleyTask : list) {
            this.getModel().createNewEntryRow(TASK_ENTRY);
            id = deleyTask.getLong("id");
            this.getModel().setValue("id", (Object)id, index);
            for (String field : entryFields) {
                if (field.equals("org")) {
                    this.getModel().setValue(field, taskToOrg.get(deleyTask), index);
                    continue;
                }
                if (field.equals("isdelay")) {
                    this.getModel().setValue("isdelay", (Object)DelayStatusEnum.DELAY.getType(), index);
                    continue;
                }
                this.getModel().setValue(field, deleyTask.get(field), index);
            }
            ++index;
        }
        for (DynamicObject normalTask : sortedNormalTask) {
            this.getModel().createNewEntryRow(TASK_ENTRY);
            id = normalTask.getLong("id");
            this.getModel().setValue("id", (Object)id, index);
            for (String field : entryFields) {
                if (field.equals("org")) {
                    this.getModel().setValue(field, taskToOrg.get(normalTask), index);
                    continue;
                }
                if (field.equals("isdelay")) {
                    this.getModel().setValue("isdelay", (Object)DelayStatusEnum.NORMAL.getType(), index);
                    continue;
                }
                this.getModel().setValue(field, normalTask.get(field), index);
            }
            ++index;
        }
    }

    private Date getLongTime(DynamicObject checkDetail, Date date, String field) {
        int totalSeconds = checkDetail.getInt(field);
        if (totalSeconds <= 0) {
            return date;
        }
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        if (24 == hours) {
            hours = 0;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime updatedDateTime = localDateTime.withHour(hours).withMinute(minutes).withSecond(seconds);
        Date updatedDate = Date.from(updatedDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return updatedDate;
    }

    private Date convertDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date currentDate = calendar.getTime();
        return currentDate;
    }

    private List<DynamicObject> getSortAndFilterTasks(Date currentDate, Map<DynamicObject, Date> taskMap) {
        LinkedList<Map.Entry<DynamicObject, Date>> list = new LinkedList<Map.Entry<DynamicObject, Date>>(taskMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<DynamicObject, Date>>(){

            @Override
            public int compare(Map.Entry<DynamicObject, Date> o1, Map.Entry<DynamicObject, Date> o2) {
                int dateComparison = o1.getValue().compareTo(o2.getValue());
                if (dateComparison != 0) {
                    return dateComparison;
                }
                String orgName1 = o1.getKey().getDynamicObject("eorg").getString("name");
                String orgName2 = o2.getKey().getDynamicObject("eorg").getString("name");
                return orgName1.compareTo(orgName2);
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Date date = (Date)entry.getValue();
            if (this.convertDate(date).compareTo(currentDate) <= 0) continue;
            iterator.remove();
        }
        ArrayList<DynamicObject> sortedValues = new ArrayList<DynamicObject>(taskMap.size());
        for (Map.Entry entry : list) {
            sortedValues.add((DynamicObject)entry.getKey());
        }
        return sortedValues;
    }
}

