/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.homepage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.GaugeChart;
import kd.bos.form.chart.GaugeSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.formplugin.util.HomePageCardUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class ProcessCardFormPlugin
extends AbstractFormPlugin {
    private static final String PROCESS_CARD = "fcc_apphome_process_card";
    private static final String LAB_DONE_TASK = "label_done_task";
    private static final String LAB_ALL_TASK = "label_all_task";
    private static final String LAB_DONE_ORG = "label_done_org";
    private static final String LAB_ALL_ORG = "label_all_org";
    private static final String TASK_PROCESS = "done_task_process";
    private static final String ORG_PROCESS = "done_org_process";
    private static final String TASK_PROCESS_PERCENT = "done_task_process_percent";
    private static final String ORG_PROCESS_PERCENT = "done_org_process_percent";
    private static final String EXCUTOR = "executor";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String TASKSTATUS = "taskstatus";
    private static final String TASKSET = "1";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String pageId = this.getView().getPageId();
        this.getView().getParentView().getPageCache().put(PROCESS_CARD, pageId);
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        Label label_done_task = (Label)this.getView().getControl(LAB_DONE_TASK);
        Label label_all_task = (Label)this.getView().getControl(LAB_ALL_TASK);
        Label label_done_org = (Label)this.getView().getControl(LAB_DONE_ORG);
        Label label_all_org = (Label)this.getView().getControl(LAB_ALL_ORG);
        ProgressBar task_process = (ProgressBar)this.getView().getControl(TASK_PROCESS);
        ProgressBar org_process = (ProgressBar)this.getView().getControl(ORG_PROCESS);
        ProgressBar task_process_percent = (ProgressBar)this.getView().getControl(TASK_PROCESS_PERCENT);
        ProgressBar org_process_percent = (ProgressBar)this.getView().getControl(ORG_PROCESS_PERCENT);
        IFormView parentView = this.getView().getParentView();
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(parentView);
        if (null == checkoutPlan) {
            label_done_task.setText("0");
            label_all_task.setText("0");
            label_done_org.setText("0");
            label_all_org.setText("0");
            task_process_percent.setPercent(0, "0%");
            org_process_percent.setPercent(0, "0%");
            return;
        }
        Map<Object, DynamicObject> checkoutFlows = HomePageCardUtil.getAllCheckFlows(checkoutPlan, parentView);
        if (checkoutFlows.isEmpty()) {
            label_done_task.setText("0");
            label_all_task.setText("0");
            label_done_org.setText("0");
            label_all_org.setText("0");
            task_process_percent.setPercent(0, "0%");
            org_process_percent.setPercent(0, "0%");
            return;
        }
        int done_task_count = 0;
        int all_task_count = 0;
        int done_org_count = 0;
        int all_org_count = 0;
        for (Map.Entry<Object, DynamicObject> checkoutFlowEntry : checkoutFlows.entrySet()) {
            DynamicObject checkoutFlow = checkoutFlowEntry.getValue();
            DynamicObjectCollection dynamicObjectCollection = checkoutFlow.getDynamicObjectCollection("taskentry");
            String currentUserId = String.valueOf(UserServiceHelper.getCurrentUserId());
            for (DynamicObject checkDetail : dynamicObjectCollection) {
                DynamicObject taskuser = checkDetail.getDynamicObject(EXCUTOR);
                String taskType = checkDetail.getString(TASKTYPE);
                String taskStatus = checkDetail.getString(TASKSTATUS);
                if (TASKSET.equals(taskType) || null == taskuser || !taskuser.getString("id").equals(currentUserId)) continue;
                ++all_task_count;
                if (!TaskStatusEnum.DONE.getType().equals(taskStatus)) continue;
                ++done_task_count;
            }
        }
        List<Long> allLeafOrgId = WorkBenchFormUtils.getAllLeafOrgId(checkoutPlan.getLong("id"));
        Map<String, String> orgToStatus = WorkBenchFormUtils.getAllLeafOrgToStatus(checkoutPlan, allLeafOrgId, "fcc_workbench_person", this.getView().getParentView());
        for (Map.Entry entry : orgToStatus.entrySet()) {
            String status = (String)entry.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)status)) continue;
            ++all_org_count;
            if (!status.contains(ResManager.loadKDString((String)"\u5ef6\u671f\u5b8c\u6210", (String)"ProcessCardFormPlugin_0", (String)"fi-fcc-formplugin", (Object[])new Object[0])) && !status.contains(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26", (String)"ProcessCardFormPlugin_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]))) continue;
            ++done_org_count;
        }
        label_done_task.setText(String.valueOf(done_task_count));
        label_all_task.setText(String.valueOf(all_task_count));
        label_done_org.setText(String.valueOf(done_org_count));
        label_all_org.setText(String.valueOf(all_org_count));
        double taskpercent = (double)done_task_count / (double)all_task_count * 100.0;
        int roundedTaskPercen = (int)Math.round(taskpercent);
        task_process.setPercent(roundedTaskPercen);
        task_process_percent.setPercent(roundedTaskPercen, roundedTaskPercen + "%");
        double orgpercent = (double)done_org_count / (double)all_org_count * 100.0;
        int roundedOrgPercen = (int)Math.round(orgpercent);
        org_process.setPercent(roundedOrgPercen);
        org_process_percent.setPercent(roundedOrgPercen, roundedOrgPercen + "%");
    }

    private void drawChart(String chartName, int percent) {
        GaugeChart chart = (GaugeChart)this.getControl(chartName);
        GaugeSeries gaugeSeries = chart.createSeries("gauge");
        gaugeSeries.setType(ChartType.bar);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formatter", "{value}%");
        gaugeSeries.setDetail(map);
        ItemValue itemValue = new ItemValue("test", (Number)percent);
        ItemValue[] itemValues = new ItemValue[]{itemValue};
        gaugeSeries.setData(itemValues);
        gaugeSeries.setPropValue("strokeWidth", (Object)1);
        gaugeSeries.setPropValue("pointerWidth", (Object)1);
        chart.refresh();
    }
}

