/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.enums.OrgPermissionEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.formplugin.util.WorkBenchTreeUtils;

public class WorkBenchFormUtils {
    private static Log logger = LogFactory.getLog(WorkBenchFormUtils.class);
    private static final String TASK_ENTRY = "treeentryentity";
    private static final String LAB_CHECKPLANNAME = "label_checkplanname";
    private static final String LAB_CHECKPLANNUM = "label_checkplannum";
    private static final String LAB_ORG = "label_org";
    private static final String LAB_STATUS = "label_status";
    private static final String LAB_PROCESS = "label_process";
    private static final String PROCESS_BARAP = "progressbarap";
    private static final String LAB_NOT_START = "label_notstart_data";
    private static final String LAB_DOING = "label_doing_data";
    private static final String LAB_DONE = "label_done_data";
    private static final String LAB_FAILED = "label_failed_data";
    private static final String LAB_DELAY = "label_delay_data";
    private static final String[] LAB_ARRAY = new String[]{"label_notstart_data", "label_doing_data", "label_done_data", "label_failed_data", "label_delay_data"};
    private static final String TASKSTATUS = "taskstatus";
    private static final String ISDELAY = "isdelay";
    private static final String TASKTYPE = "tasknumber.tasktype";
    private static final String PLANENDTIME = "endtime";
    private static final String PLANDAYENDTIME = "enddaytime";
    private static String TRUESTARTTIME = "truestarttime";
    private static final String TRUEENDTIME = "trueendtime";
    private static final String CHECK_METHOD = "checkmethod";
    private static final String DAY_CHECK = "day_check";
    private static final String MONTH_CHECK = "month_check";
    private static final String TASKSET = "1";
    private static final String PERSON_WORKBENCH = "fcc_workbench_person";

    public static DynamicObject getCheckPlan(IFormView view) {
        QFilter qFilter1 = null;
        QFilter qFilter2 = null;
        QFilter qFilter3 = new QFilter("planstatus", "in", (Object)new String[]{"B", "D"});
        String checkMethod = (String)view.getModel().getValue(CHECK_METHOD);
        if (DAY_CHECK.equals(checkMethod)) {
            Date date = (Date)view.getModel().getValue("date");
            if (null == date) {
                return null;
            }
            qFilter1 = new QFilter("method", "=", (Object)CheckoutCycleEnum.DAY_END.getValue());
            qFilter2 = new QFilter("startdate", "<=", (Object)date).and(new QFilter("enddate", ">=", (Object)date));
        } else if (MONTH_CHECK.equals(checkMethod)) {
            Date month = (Date)view.getModel().getValue("month");
            if (null == month) {
                return null;
            }
            LocalDate localDate = month.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            if (localDate.getDayOfMonth() != 1) {
                LocalDate firstDayOfMonth = localDate.withDayOfMonth(1);
                month = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            qFilter1 = new QFilter("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
            qFilter2 = new QFilter("month", "<=", (Object)month).and(new QFilter("month", ">=", (Object)month));
        }
        DynamicObject checkoutPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_checkout_plan", (String)"id,number,name,status,planstatus,method", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        return checkoutPlan;
    }

    public static void setDateRange(IFormView view, String monthControl, String dateControl) {
        List<Date> monthRange = WorkBenchFormUtils.getDateRange(CheckoutCycleEnum.MONTH_END.getValue());
        List<Date> dayRange = WorkBenchFormUtils.getDateRange(CheckoutCycleEnum.DAY_END.getValue());
        DateEdit monthEdit = (DateEdit)view.getControl(monthControl);
        if (null != monthRange.get(0)) {
            monthEdit.setMinDate(monthRange.get(0));
        }
        if (null != monthRange.get(1)) {
            monthEdit.setMaxDate(monthRange.get(1));
        }
        DateEdit dayEdit = (DateEdit)view.getControl(dateControl);
        if (null != dayRange.get(0)) {
            dayEdit.setMinDate(dayRange.get(0));
        }
        if (null != dayRange.get(1)) {
            dayEdit.setMaxDate(dayRange.get(1));
        }
    }

    public static void showStatusTotal(IDataModel model, IFormView view) {
        int notStart = 0;
        int doing = 0;
        int done = 0;
        int failed = 0;
        int normal = 0;
        int delay = 0;
        DynamicObjectCollection taskEntry = model.getEntryEntity(TASK_ENTRY);
        if (null == taskEntry || taskEntry.isEmpty()) {
            WorkBenchFormUtils.setAllLableZero(view);
        } else {
            for (DynamicObject task : taskEntry) {
                String taskType = task.getString(TASKTYPE);
                if (TASKSET.equals(taskType)) continue;
                String taskstatus = task.getString(TASKSTATUS);
                String isdelay = task.getString(ISDELAY);
                switch (taskstatus) {
                    case "a": {
                        ++notStart;
                        break;
                    }
                    case "b": {
                        ++doing;
                        break;
                    }
                    case "c": {
                        ++done;
                        break;
                    }
                    case "d": {
                        ++failed;
                    }
                }
                switch (isdelay) {
                    case "a": {
                        ++normal;
                        break;
                    }
                    case "b": {
                        ++delay;
                    }
                }
                Label label_not_start = (Label)view.getControl(LAB_NOT_START);
                Label label_doing = (Label)view.getControl(LAB_DOING);
                Label label_done = (Label)view.getControl(LAB_DONE);
                Label label_failed = (Label)view.getControl(LAB_FAILED);
                Label label_delay = (Label)view.getControl(LAB_DELAY);
                label_not_start.setText(String.valueOf(notStart));
                label_doing.setText(String.valueOf(doing));
                label_done.setText(String.valueOf(done));
                label_failed.setText(String.valueOf(failed));
                label_delay.setText(String.valueOf(delay));
            }
        }
        Label label_checkplanname = (Label)view.getControl(LAB_CHECKPLANNAME);
        Label label_checkplannum = (Label)view.getControl(LAB_CHECKPLANNUM);
        DynamicObject checkPlan = WorkBenchFormUtils.getCheckPlan(view);
        label_checkplanname.setText(checkPlan == null ? "" : checkPlan.getString("name"));
        label_checkplannum.setText(checkPlan == null ? "" : checkPlan.getString("number"));
        Label label_org = (Label)view.getControl(LAB_ORG);
        Label label_status = (Label)view.getControl(LAB_STATUS);
        Label label_process = (Label)view.getControl(LAB_PROCESS);
        ProgressBar process_barap = (ProgressBar)view.getControl(PROCESS_BARAP);
        TreeView orgTree = (TreeView)view.getControl("treeviewap");
        Map focusNodeMap = orgTree.getTreeState().getFocusNode();
        if (null == focusNodeMap || focusNodeMap.isEmpty()) {
            label_status.setText("");
            label_process.setText("");
            label_org.setText("");
            view.setVisible(Boolean.valueOf(false), new String[]{PROCESS_BARAP});
            return;
        }
        String orgname = (String)focusNodeMap.get("text");
        if (orgname.contains("_")) {
            int index = orgname.indexOf("_");
            orgname = orgname.substring(0, index);
        }
        label_status.setText("");
        label_process.setText("");
        view.setVisible(Boolean.valueOf(false), new String[]{PROCESS_BARAP});
        label_org.setText(orgname);
        int total = notStart + doing + done + failed;
        if (total == 0) {
            label_org.setText(orgname);
            return;
        }
        double taskpercent = (double)done / (double)total * 100.0;
        int roundedTaskPercen = (int)Math.round(taskpercent);
        if (delay == 0 && notStart == total) {
            label_status.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"WorkBenchFormUtils_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            label_process.setText(done + "/" + total);
            view.setVisible(Boolean.valueOf(true), new String[]{PROCESS_BARAP});
            process_barap.setPercent(roundedTaskPercen);
            WorkBenchFormUtils.setLableStyle("#212121", view);
            return;
        }
        if (delay == 0 && done == total) {
            label_status.setText(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26", (String)"WorkBenchFormUtils_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            label_process.setText(done + "/" + total);
            view.setVisible(Boolean.valueOf(true), new String[]{PROCESS_BARAP});
            process_barap.setPercent(roundedTaskPercen);
            WorkBenchFormUtils.setLableStyle("#1BA854", view);
            return;
        }
        if (delay == 0 && done < total) {
            label_status.setText(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"WorkBenchFormUtils_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            label_process.setText(done + "/" + total);
            view.setVisible(Boolean.valueOf(true), new String[]{PROCESS_BARAP});
            process_barap.setPercent(roundedTaskPercen);
            WorkBenchFormUtils.setLableStyle("#276FF5", view);
            return;
        }
        if (delay > 0 && done == total) {
            label_status.setText(ResManager.loadKDString((String)"\u5ef6\u671f\u5b8c\u6210", (String)"WorkBenchFormUtils_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            label_process.setText(done + "/" + total);
            view.setVisible(Boolean.valueOf(true), new String[]{PROCESS_BARAP});
            process_barap.setPercent(roundedTaskPercen);
            WorkBenchFormUtils.setLableStyle("#FF991C", view);
            return;
        }
        if (delay > 0 && done < total) {
            label_status.setText(ResManager.loadKDString((String)"\u5df2\u5ef6\u671f", (String)"WorkBenchFormUtils_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            label_process.setText(done + "/" + total);
            view.setVisible(Boolean.valueOf(true), new String[]{PROCESS_BARAP});
            process_barap.setPercent(roundedTaskPercen);
            WorkBenchFormUtils.setLableStyle("#FF991C", view);
            return;
        }
    }

    private static void setLableStyle(String color, IFormView view) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", color);
        view.updateControlMetadata(LAB_STATUS, map);
    }

    public static boolean checkIsDelay(DynamicObject dynamicObject, IFormView view) {
        String checkMethod;
        Date trueEndtime = dynamicObject.getDate(TRUEENDTIME);
        Date currentDate = new Date();
        if (dynamicObject.getString(TASKSTATUS).equals(TaskStatusEnum.DONE.getType()) && trueEndtime != null) {
            currentDate = trueEndtime;
        }
        if (DAY_CHECK.equals(checkMethod = (String)view.getModel().getValue(CHECK_METHOD))) {
            int planDayEndTimeSeconds = dynamicObject.getInt(PLANDAYENDTIME);
            if (planDayEndTimeSeconds >= 0) {
                int hours = planDayEndTimeSeconds / 3600;
                int minutes = planDayEndTimeSeconds % 3600 / 60;
                int seconds = planDayEndTimeSeconds % 60;
                Date date = (Date)view.getModel().getValue("date");
                LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                LocalDateTime updatedDateTime = localDateTime.withHour(hours).withMinute(minutes).withSecond(seconds);
                Date planDayEndTime = Date.from(updatedDateTime.atZone(ZoneId.systemDefault()).toInstant());
                return planDayEndTime.before(currentDate);
            }
            return false;
        }
        Date planEndTime = dynamicObject.getDate(PLANENDTIME);
        if (null != planEndTime) {
            return planEndTime.before(currentDate);
        }
        return false;
    }

    public static String getTaskSetStatus(List<String> childStatus) {
        String status = TaskStatusEnum.DOING.getType();
        if (null == childStatus || childStatus.isEmpty()) {
            return "";
        }
        if (childStatus.stream().allMatch(element -> element.equals(TaskStatusEnum.NOT_START.getType()))) {
            return TaskStatusEnum.NOT_START.getType();
        }
        if (childStatus.stream().allMatch(element -> element.equals(TaskStatusEnum.DONE.getType()))) {
            return TaskStatusEnum.DONE.getType();
        }
        return status;
    }

    public static boolean containsTask(DynamicObjectCollection checkDetails, Long id) {
        boolean isContains = false;
        for (DynamicObject checkDetail : checkDetails) {
            Long pid = checkDetail.getLong("pid");
            if (!id.equals(pid)) continue;
            isContains = true;
            break;
        }
        return isContains;
    }

    public static boolean containsPersonTask(DynamicObjectCollection checkDetails, Long id, String currentUserId) {
        boolean isContains = false;
        for (DynamicObject checkDetail : checkDetails) {
            DynamicObject taskuser;
            Long pid = checkDetail.getLong("pid");
            if (!id.equals(pid) || null == (taskuser = checkDetail.getDynamicObject("executor")) || !taskuser.getString("id").equals(currentUserId)) continue;
            isContains = true;
            break;
        }
        logger.info("\u3010fcc\u3011\uff1a\u662f\u5426\u5b58\u5728\u672c\u4eba\u4efb\u52a1_containsPersonTask------" + SerializationUtils.toJsonString((Object)isContains));
        return isContains;
    }

    public static List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("id");
        fields.add("org");
        fields.add("taskentry.id");
        fields.add("taskentry.pid");
        fields.add("taskentry.tasknumber");
        fields.add("taskentry.eorg");
        fields.add("taskentry.ebizorg");
        fields.add("taskentry.type");
        fields.add("taskentry.bizbooktype");
        fields.add("taskentry.executor");
        fields.add("taskentry.starttime");
        fields.add("taskentry.endtime");
        fields.add("taskentry.startdaytime");
        fields.add("taskentry.enddaytime");
        fields.add("taskentry.taskstatus");
        fields.add("taskentry.isdelay");
        fields.add("taskentry.truestarttime");
        fields.add("taskentry.trueendtime");
        fields.add("taskentry.checkoutexplain");
        fields.add("taskentry.attachment");
        return fields;
    }

    public static Map<String, String> getAllLeafOrgToStatus(DynamicObject checkPlan, List<Long> leafOrgIds, String openFormName, IFormView view) {
        if (checkPlan == null || leafOrgIds.isEmpty()) {
            return new HashMap<String, String>();
        }
        QFilter qFilter1 = new QFilter("org", "in", leafOrgIds);
        QFilter qFilter2 = new QFilter("plan", "=", (Object)checkPlan.getLong("id"));
        QFilter qFilter3 = new QFilter("flowstatus", "=", (Object)CheckoutFlowStatusEnum.confirm.getType());
        QFilter qFilter4 = new QFilter("taskentry.tasknumber.tasktype", "!=", (Object)TASKSET);
        QFilter qFilter5 = new QFilter("taskentry.executor.id", "=", (Object)UserServiceHelper.getCurrentUserId());
        QFilter qFilter6 = new QFilter("flowdate", "=", (Object)((Date)view.getModel().getValue("date")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
        filters.add(qFilter1);
        filters.add(qFilter2);
        filters.add(qFilter3);
        filters.add(qFilter4);
        String checkMethod = (String)view.getModel().getValue(CHECK_METHOD);
        if (PERSON_WORKBENCH.equals(openFormName)) {
            filters.add(qFilter5);
        }
        if (DAY_CHECK.equals(checkMethod)) {
            filters.add(qFilter6);
        }
        DynamicObjectCollection checkFlows = QueryServiceHelper.query((String)"fcc_checkout_flow_detail", (String)"org,taskentry.executor,taskentry.endtime,taskentry.trueendtime,taskentry.taskstatus,taskentry.enddaytime", (QFilter[])filters.toArray(new QFilter[0]));
        Map<Object, List<DynamicObject>> groupByOrg = checkFlows.stream().collect(Collectors.groupingBy(map -> map.get("org")));
        HashMap<String, String> leafOrgToStatus = new HashMap<String, String>(groupByOrg.size());
        for (Map.Entry<Object, List<DynamicObject>> entry : groupByOrg.entrySet()) {
            List<DynamicObject> checkoutFlowDetails = entry.getValue();
            leafOrgToStatus.put(entry.getKey().toString(), WorkBenchFormUtils.getTreeText(checkoutFlowDetails, view));
        }
        return leafOrgToStatus;
    }

    public static List<Long> getAllLeafOrgId(Long planId) {
        ArrayList<Long> leafOrgIds = new ArrayList(50);
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)"fcc_checkout_flow_detail", (String)OrgPermissionEnum.VIEW.getValue());
        QFilter qFilter = null;
        HashSet<Long> set = new HashSet<Long>();
        if (!fcc.hasAllOrgPerm()) {
            List hasPermOrgs = fcc.getHasPermOrgs();
            long orgViewSchemaId = CheckOutViewUtil.getView((Long)planId);
            Map<Long, List<Long>> allSuperiorOrgs = WorkBenchTreeUtils.getAllSuperiorOrgs(orgViewSchemaId, hasPermOrgs);
            if (!allSuperiorOrgs.isEmpty()) {
                for (Map.Entry<Long, List<Long>> entry2 : allSuperiorOrgs.entrySet()) {
                    Long key = entry2.getKey();
                    List<Long> value = entry2.getValue();
                    set.add(key);
                    set.addAll(value);
                }
            } else {
                set.addAll(hasPermOrgs);
            }
            qFilter = new QFilter("org", "in", set);
        }
        Map orgTreeMap = CheckOutViewUtil.getAllOrgByViewId((Long)planId, qFilter, (boolean)false);
        leafOrgIds = orgTreeMap.entrySet().stream().filter(entry -> TASKSET.equals(((Map)entry.getValue()).get("isleaf"))).map(entry -> Long.parseLong((String)entry.getKey())).collect(Collectors.toList());
        return leafOrgIds;
    }

    public static void updateTaskDetail(Long taskId, String taskStatus, Date trueStartTime, IFormView view, int selectRow) {
        Date date = new Date();
        if (TaskStatusEnum.DONE.getType().equals(taskStatus)) {
            if (null == trueStartTime) {
                CheckOutTaskHelper.writeTaskFlowStatusAndTwoDate((Long)taskId, (String)taskStatus, (Date)date, (Date)date);
                view.getModel().setValue(TASKSTATUS, (Object)taskStatus, selectRow);
                view.getModel().setValue(TRUESTARTTIME, (Object)date, selectRow);
                view.getModel().setValue(TRUEENDTIME, (Object)date, selectRow);
            } else {
                CheckOutTaskHelper.writeTaskFlowStatus((Long)taskId, (String)taskStatus, null, (Date)date);
                view.getModel().setValue(TASKSTATUS, (Object)taskStatus, selectRow);
                view.getModel().setValue(TRUEENDTIME, (Object)date, selectRow);
            }
        } else if (null == trueStartTime) {
            CheckOutTaskHelper.writeTaskFlowStatusAndTwoDate((Long)taskId, (String)taskStatus, (Date)date, null);
            view.getModel().setValue(TASKSTATUS, (Object)taskStatus, selectRow);
            view.getModel().setValue(TRUESTARTTIME, (Object)date, selectRow);
            view.getModel().setValue(TRUEENDTIME, null, selectRow);
        } else {
            CheckOutTaskHelper.writeTaskFlowStatusAndTwoDate((Long)taskId, (String)taskStatus, (Date)trueStartTime, null);
            view.getModel().setValue(TASKSTATUS, (Object)taskStatus, selectRow);
            view.getModel().setValue(TRUEENDTIME, null, selectRow);
        }
    }

    public static void deleteEndTime(Long taskId) {
        String sql = "UPDATE t_fcc_checkflow_det_entry SET ftrueendtime = ? WHERE fentryid=?;";
        DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{null, taskId});
    }

    public static DynamicObject[] filterByTaskStatus(DynamicObject[] checkoutFlows, String filterStatus, Boolean notDoneStatus, IFormView view) {
        for (DynamicObject checkoutFlow : checkoutFlows) {
            DynamicObjectCollection checkDetails = checkoutFlow.getDynamicObjectCollection("taskentry");
            Iterator iterator = checkDetails.iterator();
            while (iterator.hasNext()) {
                DynamicObject checkDetail = (DynamicObject)iterator.next();
                String status = checkDetail.getString(TASKSTATUS);
                String taskType = checkDetail.getString(TASKTYPE);
                if (TASKSET.equals(taskType)) continue;
                if (notDoneStatus.booleanValue() && TaskStatusEnum.DONE.getType().equals(status)) {
                    iterator.remove();
                    continue;
                }
                if ("DELAY".equals(filterStatus) && !WorkBenchFormUtils.checkIsDelay(checkDetail, view)) {
                    iterator.remove();
                    continue;
                }
                if ("DELAY".equals(filterStatus) || filterStatus.equals(status)) continue;
                iterator.remove();
            }
            checkoutFlow.set("taskentry", (Object)checkDetails);
        }
        return checkoutFlows;
    }

    public static void setLabFilterBackColor(String labKey, String filterStatus, IFormView view) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(1);
        fieldMap.put("bc", "#e5e5e5");
        HashMap<String, String> nomarMap = new HashMap<String, String>(1);
        nomarMap.put("bc", "#ffffff");
        WorkBenchFormUtils.setLabNormalBackColor(view);
        if (StringUtils.isEmpty((CharSequence)filterStatus)) {
            for (String labkey : LAB_ARRAY) {
                view.updateControlMetadata(labkey, nomarMap);
            }
        } else {
            view.updateControlMetadata(labKey, fieldMap);
        }
    }

    public static void setLabNormalBackColor(IFormView view) {
        HashMap<String, String> nomarMap = new HashMap<String, String>(1);
        nomarMap.put("bc", "#ffffff");
        for (String labkey : LAB_ARRAY) {
            view.updateControlMetadata(labkey, nomarMap);
        }
    }

    public static List<Date> getDateRange(String checkMethod) {
        ArrayList<Date> rangeList = new ArrayList<Date>(2);
        QFilter qFilter1 = new QFilter("planstatus", "in", (Object)new String[]{"B", "D"});
        QFilter qFilter2 = new QFilter("method", "=", (Object)checkMethod);
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(checkMethod)) {
            Map monthMap = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_plan", (String)"id,month", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"month");
            ArrayList months = new ArrayList(monthMap.values());
            rangeList.add(months.size() > 0 ? ((DynamicObject)months.get(0)).getDate("month") : null);
            rangeList.add(months.size() > 0 ? ((DynamicObject)months.get(months.size() - 1)).getDate("month") : null);
        }
        if (CheckoutCycleEnum.DAY_END.getValue().equals(checkMethod)) {
            Map startdateMap = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_plan", (String)"id,startdate", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"startdate");
            ArrayList startdates = new ArrayList(startdateMap.values());
            rangeList.add(startdates.size() > 0 ? ((DynamicObject)startdates.get(0)).getDate("startdate") : null);
            rangeList.add(new Date());
        }
        return rangeList;
    }

    private static void setAllLableZero(IFormView view) {
        Label label_not_start = (Label)view.getControl(LAB_NOT_START);
        label_not_start.setText("0");
        Label label_doing = (Label)view.getControl(LAB_DOING);
        label_doing.setText("0");
        Label label_done = (Label)view.getControl(LAB_DONE);
        label_done.setText("0");
        Label label_failed = (Label)view.getControl(LAB_FAILED);
        label_failed.setText("0");
        Label label_delay = (Label)view.getControl(LAB_DELAY);
        label_delay.setText("0");
    }

    private static String getTreeText(List<DynamicObject> checkoutFlowDetails, IFormView view) {
        String text = "";
        Boolean isDelay = false;
        Boolean isDone = false;
        ArrayList<String> statusList = new ArrayList<String>(checkoutFlowDetails.size());
        for (DynamicObject checkoutFlowDetail : checkoutFlowDetails) {
            statusList.add(checkoutFlowDetail.getString("taskentry.taskstatus"));
            if (isDelay.booleanValue()) continue;
            isDelay = WorkBenchFormUtils.checkHasDelay(checkoutFlowDetail, view);
        }
        long count = statusList.stream().filter(c -> c.equals(TaskStatusEnum.DONE.getType())).count();
        if (count == (long)statusList.size()) {
            isDone = true;
        }
        if (!isDelay.booleanValue() && statusList.stream().allMatch(element -> element.equals(TaskStatusEnum.NOT_START.getType()))) {
            text = ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"WorkBenchFormUtils_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]) + "  " + count + "/" + checkoutFlowDetails.size();
            return text;
        }
        if (!isDelay.booleanValue() && isDone.booleanValue()) {
            text = ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26", (String)"WorkBenchFormUtils_1", (String)"fi-fcc-formplugin", (Object[])new Object[0]) + "  " + count + "/" + checkoutFlowDetails.size();
            return text;
        }
        if (!isDelay.booleanValue() && !isDone.booleanValue()) {
            text = ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"WorkBenchFormUtils_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]) + "  " + count + "/" + checkoutFlowDetails.size();
            return text;
        }
        if (isDelay.booleanValue() && isDone.booleanValue()) {
            text = ResManager.loadKDString((String)"\u5ef6\u671f\u5b8c\u6210", (String)"WorkBenchFormUtils_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]) + "  " + count + "/" + checkoutFlowDetails.size();
            return text;
        }
        if (isDelay.booleanValue() && !isDone.booleanValue()) {
            text = ResManager.loadKDString((String)"\u5df2\u5ef6\u671f", (String)"WorkBenchFormUtils_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]) + "  " + count + "/" + checkoutFlowDetails.size();
            return text;
        }
        return text;
    }

    private static boolean checkHasDelay(DynamicObject dynamicObject, IFormView view) {
        String checkMethod;
        Date trueEndtime = dynamicObject.getDate("taskentry.trueendtime");
        Date currentDate = new Date();
        if (dynamicObject.getString("taskentry.taskstatus").equals(TaskStatusEnum.DONE.getType()) && trueEndtime != null) {
            currentDate = trueEndtime;
        }
        if (DAY_CHECK.equals(checkMethod = (String)view.getModel().getValue(CHECK_METHOD))) {
            int planDayEndTimeSeconds = dynamicObject.getInt("taskentry.enddaytime");
            if (planDayEndTimeSeconds >= 0) {
                int hours = planDayEndTimeSeconds / 3600;
                int minutes = planDayEndTimeSeconds % 3600 / 60;
                int seconds = planDayEndTimeSeconds % 60;
                Date date = (Date)view.getModel().getValue("date");
                LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                LocalDateTime updatedDateTime = localDateTime.withHour(hours).withMinute(minutes).withSecond(seconds);
                Date planDayEndTime = Date.from(updatedDateTime.atZone(ZoneId.systemDefault()).toInstant());
                return planDayEndTime.before(currentDate);
            }
            return false;
        }
        Date planEndTime = dynamicObject.getDate("taskentry.endtime");
        if (null != planEndTime) {
            return planEndTime.before(currentDate);
        }
        return false;
    }

    public static Map<Long, Set<Long>> getPretasks(DynamicObject[] checkoutFlowDetails) {
        DynamicObject[] allPretasks;
        HashMap<Long, Set<Long>> taskToPretasks = new HashMap<Long, Set<Long>>(checkoutFlowDetails.length);
        ArrayList<Long> taskIds = new ArrayList<Long>(checkoutFlowDetails.length);
        for (DynamicObject checkFlowDetail : checkoutFlowDetails) {
            DynamicObjectCollection checkDetails = checkFlowDetail.getDynamicObjectCollection("taskentry");
            for (DynamicObject checkDetail : checkDetails) {
                taskIds.add(checkDetail.getLong("id"));
            }
        }
        QFilter qFilter = new QFilter("taskrowid", "in", taskIds);
        for (DynamicObject allpretask : allPretasks = BusinessDataServiceHelper.load((String)"fcc_checkout_pretasks", (String)"taskrowid, entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter})) {
            HashSet<Long> pretaskIds = new HashSet<Long>(checkoutFlowDetails.length);
            DynamicObjectCollection pretasks = allpretask.getDynamicObjectCollection("entryentity");
            for (DynamicObject pretask : pretasks) {
                pretaskIds.add(pretask.getLong("othertaskid"));
            }
            taskToPretasks.put(allpretask.getLong("taskrowid"), pretaskIds);
        }
        return taskToPretasks;
    }

    public static List<String> getTaskStatus(Set<Long> pretasksId) {
        ArrayList<String> taskStatus = new ArrayList<String>(5);
        if (null == pretasksId || pretasksId.isEmpty()) {
            return taskStatus;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Long id : pretasksId) {
            stringBuilder.append(id).append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(")");
        String sqlInStr = stringBuilder.toString();
        String sql = "SELECT ftaskstatus FROM t_fcc_checkflow_det_entry WHERE fentryid IN " + sqlInStr;
        DataSet status = DB.queryDataSet((String)"WorkBenchFormUtils.getTaskStatus", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        for (Row data : status) {
            taskStatus.add((String)data.get(0));
        }
        return taskStatus;
    }

    public static List<Long> getNotDoneTaskIds(List<Long> pretasksId) {
        ArrayList<Long> taskStatus = new ArrayList<Long>(5);
        if (null == pretasksId || pretasksId.isEmpty()) {
            return taskStatus;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Long id : pretasksId) {
            stringBuilder.append(id).append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(")");
        String sqlInStr = stringBuilder.toString();
        String sql = "SELECT ftaskstatus,fentryid FROM t_fcc_checkflow_det_entry WHERE fentryid IN " + sqlInStr;
        DataSet status = DB.queryDataSet((String)"WorkBenchFormUtils.getTaskStatus", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        for (Row data : status) {
            if (TaskStatusEnum.DONE.getType().equals(data.get(0))) continue;
            taskStatus.add((Long)data.get(1));
        }
        return taskStatus;
    }

    public static String getTaskName(Long taskId) {
        if (null == taskId) {
            return "";
        }
        String sql = "SELECT ftaskid FROM t_fcc_checkflow_det_entry WHERE fentryid = " + taskId;
        DataSet status = DB.queryDataSet((String)"WorkBenchFormUtils.getTaskStatus", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        for (Row data : status) {
            DynamicObject plan = BusinessDataServiceHelper.loadSingleFromCache((Object)data.get(0), (String)"fcc_checkout_task");
            if (null == plan) continue;
            return plan.getString("name");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static void updateCheckFlowSuccessNum(Set<Integer> successRows, boolean isDone, IDataModel model) {
        String sql;
        void var8_11;
        DynamicObject[] checkFlowDts;
        DynamicObject[] checkFlowId;
        ArrayList<DynamicObject[]> checkFlowIds = new ArrayList<DynamicObject[]>(successRows.size());
        for (int row : successRows) {
            checkFlowId = (DynamicObject[])model.getValue("checkoutflowid", row);
            if (0L == checkFlowId.longValue()) continue;
            checkFlowIds.add(checkFlowId);
        }
        HashMap<Long, Object> checkFlowDtIdToCount = new HashMap<Long, Object>(successRows.size());
        checkFlowId = checkFlowDts = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"successnum", (QFilter[])new QFilter[]{new QFilter("id", "in", checkFlowIds)});
        int n = checkFlowId.length;
        boolean bl = false;
        while (var8_11 < n) {
            DynamicObject checkFlowDt = checkFlowId[var8_11];
            checkFlowDtIdToCount.put(checkFlowDt.getLong("id"), checkFlowDt.get("successnum"));
            ++var8_11;
        }
        HashMap<Long, Integer> checkFlowIdGroup = new HashMap<Long, Integer>(checkFlowIds.size());
        for (Long l : checkFlowIds) {
            checkFlowIdGroup.put(l, checkFlowIdGroup.getOrDefault(l, 0) + 1);
        }
        if (isDone) {
            for (Map.Entry entry : checkFlowIdGroup.entrySet()) {
                sql = "UPDATE t_fcc_checkflow_detail SET fsuccessnum = ? WHERE fid=?;";
                int count = (Integer)entry.getValue();
                if (null != checkFlowDtIdToCount.get(entry.getKey())) {
                    count = (Integer)checkFlowDtIdToCount.get(entry.getKey()) + (Integer)entry.getValue();
                }
                DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{count, entry.getKey()});
            }
        } else {
            for (Map.Entry entry : checkFlowIdGroup.entrySet()) {
                sql = "UPDATE t_fcc_checkflow_detail SET fsuccessnum = fsuccessnum - ? WHERE fid=?;";
                DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{entry.getValue(), entry.getKey()});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateCheckFlowFailedNum(Set<Integer> failedExcuteRows, boolean isAddFail, IDataModel model) {
        String sql;
        void var8_11;
        DynamicObject[] checkFlowDts;
        DynamicObject[] checkFlowId;
        ArrayList<DynamicObject[]> checkFlowIds = new ArrayList<DynamicObject[]>(failedExcuteRows.size());
        for (int row : failedExcuteRows) {
            checkFlowId = (DynamicObject[])model.getValue("checkoutflowid", row);
            if (0L == checkFlowId.longValue()) continue;
            checkFlowIds.add(checkFlowId);
        }
        HashMap<Long, Object> checkFlowDtIdToCount = new HashMap<Long, Object>(failedExcuteRows.size());
        checkFlowId = checkFlowDts = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"successnum", (QFilter[])new QFilter[]{new QFilter("id", "in", checkFlowIds)});
        int n = checkFlowId.length;
        boolean bl = false;
        while (var8_11 < n) {
            DynamicObject checkFlowDt = checkFlowId[var8_11];
            checkFlowDtIdToCount.put(checkFlowDt.getLong("id"), checkFlowDt.get("failednum"));
            ++var8_11;
        }
        HashMap<Long, Integer> checkFlowIdGroup = new HashMap<Long, Integer>(checkFlowIds.size());
        for (Long l : checkFlowIds) {
            checkFlowIdGroup.put(l, checkFlowIdGroup.getOrDefault(l, 0) + 1);
        }
        if (isAddFail) {
            for (Map.Entry entry : checkFlowIdGroup.entrySet()) {
                sql = "UPDATE t_fcc_checkflow_detail SET ffailednum = ? WHERE fid=?;";
                int count = (Integer)entry.getValue();
                if (null != checkFlowDtIdToCount.get(entry.getKey())) {
                    count = (Integer)checkFlowDtIdToCount.get(entry.getKey()) + (Integer)entry.getValue();
                }
                DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{count, entry.getKey()});
            }
        } else {
            for (Map.Entry entry : checkFlowIdGroup.entrySet()) {
                sql = "UPDATE t_fcc_checkflow_detail SET ffailednum = ffailednum - ? WHERE fid=?;";
                DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{entry.getValue(), entry.getKey()});
            }
        }
    }
}

