/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.enums.OrgPermissionEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.formplugin.util.WorkBenchFormUtils;

public class WorkBenchTreeUtils {
    public static void refreshOrgTree(IFormView view, List<Long> leafOrgIdList, String focusNodeId) {
        TreeView orgTree = (TreeView)view.getControl("treeviewap");
        DynamicObject checkoutPlan = WorkBenchFormUtils.getCheckPlan(view);
        orgTree.deleteAllNodes();
        if (null == checkoutPlan) {
            return;
        }
        Map<String, String> leafOrgToStatus = WorkBenchFormUtils.getAllLeafOrgToStatus(checkoutPlan, leafOrgIdList, view.getModel().getDataEntityType().getName(), view);
        TreeNode orgTreeNode = WorkBenchTreeUtils.getTreeNode(checkoutPlan.getLong("id"), leafOrgToStatus);
        if (orgTreeNode != null) {
            view.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)orgTreeNode));
            orgTree.addNode(orgTreeNode);
            if (kd.bos.util.StringUtils.isNotEmpty((String)focusNodeId)) {
                orgTree.focusNode(orgTreeNode.getTreeNode(focusNodeId));
            }
        }
    }

    public static List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = new ArrayList<TreeNode>(5);
        if (null == parentNode) {
            return allChildren;
        }
        allChildren = WorkBenchTreeUtils.getAllChildren(parentNode);
        allChildren.add(0, parentNode);
        return allChildren;
    }

    public static List<TreeNode> getAllChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children != null && children.size() != 0) {
            ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
            for (TreeNode child : children) {
                result.addAll(WorkBenchTreeUtils.getAllChildren(child));
            }
            return result;
        }
        return new ArrayList<TreeNode>();
    }

    public static TreeNode getTreeNode(Long planId, Map<String, String> leafOrgToStatus) {
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)"fcc_checkout_flow_detail", (String)OrgPermissionEnum.VIEW.getValue());
        QFilter qFilter = null;
        HashSet<Long> set = new HashSet<Long>();
        if (!fcc.hasAllOrgPerm()) {
            List hasPermOrgs = fcc.getHasPermOrgs();
            long orgViewSchemaId = CheckOutViewUtil.getView((Long)planId);
            Map<Long, List<Long>> allSuperiorOrgs = WorkBenchTreeUtils.getAllSuperiorOrgs(orgViewSchemaId, hasPermOrgs);
            if (!allSuperiorOrgs.isEmpty()) {
                for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
                    Long key = entry.getKey();
                    List<Long> value = entry.getValue();
                    set.add(key);
                    set.addAll(value);
                }
            } else {
                set.addAll(hasPermOrgs);
            }
            qFilter = new QFilter("org", "in", set);
        }
        Map orgTreeMap = CheckOutViewUtil.getAllOrgByViewId((Long)planId, qFilter, (boolean)false);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)orgTreeMap);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        TreeNode rootTreeNode = WorkBenchTreeUtils.createTreeNode(orgTreeMap, Long.toString(rootOrgId));
        if (rootTreeNode != null && flatOrgTreeMap.size() > 0) {
            WorkBenchTreeUtils.createChildNodes(flatOrgTreeMap, rootTreeNode.getId(), rootTreeNode, leafOrgToStatus);
        }
        return rootTreeNode;
    }

    public static Map<Long, List<Long>> getAllSuperiorOrgs(long viewId, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter filter = new QFilter("view", "=", (Object)viewId);
        if (orgIds.size() <= 1000) {
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            filter = filter.and(orgFilter);
        }
        return WorkBenchTreeUtils.getAllSuperiorOrgs(filter, orgIds.size());
    }

    private static Map<Long, List<Long>> getAllSuperiorOrgs(QFilter filter, int count) {
        HashMap<Long, List<Long>> parentIdMap = new HashMap<Long, List<Long>>(count);
        HashSet<String> parentNumbers = new HashSet<String>(count);
        HashMap<Long, String> parentLongNumberMap = new HashMap<Long, String>(count);
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(count);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllSuperiorOrgs", (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])filters, (String)"");){
            Iterator var10 = ds.iterator();
            while (var10.hasNext()) {
                Row row = (Row)var10.next();
                String longNumber = row.getString("longnumber");
                Long orgId = row.getLong("org");
                if (StringUtils.isBlank((CharSequence)longNumber)) {
                    parentIdMap.put(orgId, new ArrayList(0));
                    continue;
                }
                if (longNumber.indexOf("!") == -1) {
                    parentIdMap.put(orgId, new ArrayList(0));
                    numberIdMap.put(longNumber, orgId);
                    continue;
                }
                String[] numbers = longNumber.split("!");
                int currentNumberIndex = numbers.length - 1;
                String currentNumber = numbers[currentNumberIndex];
                numberIdMap.put(currentNumber, orgId);
                for (int i = 0; i < currentNumberIndex; ++i) {
                    String number = numbers[i];
                    parentNumbers.add(number);
                }
                parentLongNumberMap.put(orgId, StringUtils.substringBeforeLast((String)longNumber, (String)"!"));
                parentIdMap.put(orgId, new ArrayList(numbers.length));
            }
        }
        parentNumbers.removeAll(numberIdMap.keySet());
        numberIdMap.putAll(WorkBenchTreeUtils.getOrgNumberIdMap(parentNumbers));
        HashMap<String, List<Long>> longNumberIdMap = new HashMap<String, List<Long>>(numberIdMap.size());
        for (Map.Entry parentEntry : parentLongNumberMap.entrySet()) {
            WorkBenchTreeUtils.getParentIdByLongNumber((List)parentIdMap.get(parentEntry.getKey()), (String)parentEntry.getValue(), numberIdMap, longNumberIdMap);
        }
        return parentIdMap;
    }

    private static void getParentIdByLongNumber(List<Long> orgIds, String parentLongNumber, Map<String, Long> numberIdMap, Map<String, List<Long>> longNumberIdMap) {
        List<Long> parentIds = longNumberIdMap.get(parentLongNumber);
        if (parentIds != null) {
            orgIds.addAll(parentIds);
        } else {
            String[] numbers = parentLongNumber.split("!");
            if (numbers.length != 0) {
                String[] var7 = numbers;
                int var8 = numbers.length;
                for (int var9 = 0; var9 < var8; ++var9) {
                    String number = var7[var9];
                    Long orgId = numberIdMap.get(number);
                    if (orgId == null) continue;
                    orgIds.add(orgId);
                }
                longNumberIdMap.put(parentLongNumber, orgIds);
            }
        }
    }

    private static Map<String, Long> getOrgNumberIdMap(Collection<String> numbers) {
        if (numbers.isEmpty()) {
            return new HashMap<String, Long>(0);
        }
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter[] filters = new QFilter[]{numberFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"number", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(orgObjMap.size());
        for (Map.Entry orgEntry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)orgEntry.getValue();
            numberIdMap.put(orgObj.getString("number"), orgObj.getLong("id"));
        }
        return numberIdMap;
    }

    private static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap, String orgId) {
        if (orgTreeMap == null || orgTreeMap.size() == 0 || !orgTreeMap.containsKey(orgId)) {
            return null;
        }
        String rootName = orgTreeMap.get(orgId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(orgId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(orgId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    private static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root, Map<String, String> leafOrgToStatus) {
        if (orgTreeMap != null && rootId != null && orgTreeMap.size() != 0 && root != null) {
            WorkBenchTreeUtils.buildTreeNode(orgTreeMap, rootId, root, leafOrgToStatus);
            return root;
        }
        return null;
    }

    private static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode, Map<String, String> leafOrgToStatu) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        Map dataMap = (Map)treeNode.getData();
        if (childList != null && childList.size() != 0) {
            String parentName = (String)dataMap.get("fullname");
            for (Map<String, String> org : childList) {
                TreeNode childrenTree = new TreeNode();
                String orgid = org.get("id");
                if (Long.valueOf(0L).equals(Long.valueOf(orgid)) || kd.bos.util.StringUtils.isEmpty((String)org.get("name"))) continue;
                childrenTree.setParentid(org.get("parentid"));
                childrenTree.setId(orgid);
                childrenTree.setText(org.get("name"));
                childrenTree.setIsOpened(false);
                childrenTree.setLongNumber(org.get("longnumber"));
                HashMap<String, String> childDataMap = new HashMap<String, String>(3);
                childDataMap.put("isleaf", "0");
                childDataMap.put("level", String.valueOf(childrenTree.getLongNumber().split("!").length));
                childDataMap.put("fullname", parentName + "_" + org.get("name"));
                childrenTree.setData(childDataMap);
                treeNode.addChild(childrenTree);
                WorkBenchTreeUtils.buildTreeNode(orgTreeMap, orgid, childrenTree, leafOrgToStatu);
            }
            AccountingSysUtil.sortTreeNode((List)treeNode.getChildren());
        } else {
            dataMap.put("isleaf", "1");
            treeNode.setLeaf(true);
            String appendText = leafOrgToStatu.get(treeNode.getId());
            if (kd.bos.util.StringUtils.isNotEmpty((String)appendText)) {
                treeNode.setText(treeNode.getText() + " _ " + appendText);
            }
        }
    }
}

