/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.formplugin.view;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accsyscache.AccSysModelCacheService;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.fcc.formplugin.view.model.OrgTreeSearchParam;

public class CheckoutViewEdit
extends AbstractFormPlugin
implements ClickListener,
TreeNodeCheckListener,
TreeNodeDragListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(CheckoutViewEdit.class);
    private static final String BIZUNITTREE = "bizunittree";
    private static final String BIZVIEWTREE = "bizviewtree";
    private static final String ISCHECKUNITCHILD = "ischeckunitchild";
    private static final String ISCHECKORGCHILD = "ischeckorgchild";
    private static final String BTN_UNCHECKUNIT = "btn_uncheckunit";
    private static final String BTN_ADDNODE = "btn_addnode";
    private static final String BTN_DELETENODE = "btn_deletenode";
    private static final String CACHEKEY_UNIT_ROOT = "unittreenode";
    private static final String CACHEKEY_VIEW_ROOT = "viewtreenode";
    private static final String CACHEKEY_FILTER_VALUE = "filterValue";
    private static final String FCC_CHECKOUT_VIEW = "fcc_checkout_view";
    private TreeView bizunittree;
    private TreeView bizviewtree;

    public void initialize() {
        super.initialize();
        this.bizunittree = (TreeView)this.getView().getControl(BIZUNITTREE);
        this.bizviewtree = (TreeView)this.getView().getControl(BIZVIEWTREE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ISCHECKUNITCHILD, BTN_UNCHECKUNIT, BTN_ADDNODE, BTN_DELETENODE});
        this.bizunittree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizviewtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizunittree.addTreeNodeDragListener((TreeNodeDragListener)this);
        this.bizviewtree.addTreeNodeDragListener((TreeNodeDragListener)this);
        this.bizviewtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.bizunittree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        orgsearchap.addEnterListener((SearchEnterListener)this);
        Search viewsearchap = (Search)this.getView().getControl("viewsearchap");
        viewsearchap.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "ischeckunitchild": {
                break;
            }
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_deletenode": {
                this.deleteNode();
                break;
            }
            case "clear": {
                TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(new TreeNode(bizTree.getParentid(), bizTree.getId(), bizTree.getText()));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"patterntype", "labelpt"});
        Long id = this.getModel().getDataEntity().getLong("id");
        this.showTreeView(id, AccountingSysUtil.getDefaultViewSchemaInfoId(), true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        QFilter qf = null;
        String filterValue = "";
        if ("orgproperty".equals(name)) {
            changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue != null) {
                filterValue = newValue.getString("name");
                qf = new QFilter("org.orgpattern.name", "=", (Object)filterValue);
            }
            this.filterProperty(filterValue, qf);
        }
        if ("patterntype".equals(name)) {
            changeData = e.getChangeSet()[0];
            filterValue = (String)changeData.getNewValue();
            if (StringUtils.isNotBlank((CharSequence)filterValue)) {
                qf = new QFilter("org.orgpattern.patterntype", "=", (Object)filterValue);
            }
            this.filterProperty(filterValue, qf);
        }
    }

    private void filterProperty(String filterValue, QFilter qFilter) {
        this.bizunittree.deleteAllNodes();
        this.getPageCache().put(CACHEKEY_FILTER_VALUE, filterValue);
        String def = this.getPageCache().get("mainViewId");
        Map unitTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)Long.parseLong(def), (QFilter)qFilter, (boolean)false);
        Map allTreeMap = AccountingSysUtil.getAllOrgByViewIdIncludeDisable((Long)Long.parseLong(def));
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), allTreeMap.get(tree.getId()));
            }
            unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
            flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put(CACHEKEY_UNIT_ROOT, SerializationUtils.toJsonString((Object)unitRoot));
        CheckoutViewEdit.removeAllSearchTreeNodeCache(this.getPageCache());
    }

    private void getInfo(Map<String, Map<String, String>> unitTreeMap, Map<String, Map<String, String>> allTreeMap) {
        for (Map.Entry<String, Map<String, String>> unitTree : unitTreeMap.entrySet()) {
            Map<String, String> map = allTreeMap.get(unitTree.getKey());
            unitTreeMap.get(unitTree.getKey()).put("parentid", this.getParent(map.get("id"), allTreeMap, unitTreeMap));
        }
    }

    private String getParent(String key, Map<String, Map<String, String>> allTreeMap, Map<String, Map<String, String>> unitTreeMap) {
        String parent = "";
        while (StringUtils.isBlank((CharSequence)parent)) {
            Map<String, String> map = allTreeMap.get(key);
            if (null == map) {
                TreeNode treeNode = AccountingSysUtil.createTreeNode(unitTreeMap);
                if (null == treeNode) {
                    parent = String.valueOf(OrgUnitServiceHelper.getRootOrgId());
                    continue;
                }
                parent = treeNode.getId();
                continue;
            }
            key = map.get("parentid");
            if (unitTreeMap.containsKey(key)) {
                parent = key;
                continue;
            }
            if (!"0".equals(key)) continue;
            parent = map.get("id");
        }
        return parent;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            FormOperate source = (FormOperate)args.getSource();
            source.getOption().setVariableValue("viewschemanumber", this.getViewSchemaNumber());
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (StringUtils.isNotEmpty((CharSequence)((String)map.get("id")))) {
                source.getOption().setVariableValue("accountingsys_id", (String)map.get("id"));
            }
            ArrayList<String> rootnodeList = new ArrayList<String>(2);
            TreeNode viewTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_VIEW_ROOT), TreeNode.class);
            rootnodeList.add(viewTreeNode.getId());
            rootnodeList.add(viewTreeNode.getParentid());
            source.getOption().setVariableValue("rootnode", SerializationUtils.toJsonString(rootnodeList));
            LinkedHashMap<String, String> savenode = new LinkedHashMap<String, String>(16);
            List<OrgParam> orgParams = this.constructStruc(viewTreeNode);
            for (OrgParam orgParam : orgParams) {
                savenode.put(Long.toString(orgParam.getId()), Long.toString(orgParam.getParentId()));
            }
            if (savenode.size() > 0) {
                source.getOption().setVariableValue("savenode", SerializationUtils.toJsonString(savenode));
            }
            if (this.getPageCache().get("deletenode") != null) {
                source.getOption().setVariableValue("deletenode", this.getPageCache().get("deletenode"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("saveview".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
        this.clearCahce();
    }

    private void clearCahce() {
        AccSysModelCacheService accSysModelCacheService = new AccSysModelCacheService();
        accSysModelCacheService.clear();
    }

    private List<OrgParam> constructStruc(TreeNode viewTreeNode) {
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>();
        this.getAllNodeInfo(orgParams, viewTreeNode);
        return orgParams;
    }

    private void getAllNodeInfo(List<OrgParam> orgParams, TreeNode viewTreeNode) {
        List childList;
        OrgParam param = new OrgParam();
        param.setId(Long.parseLong(viewTreeNode.getId()));
        String parentId = viewTreeNode.getParentid();
        param.setDuty(this.getViewSchemaNumber());
        param.setParentId(parentId.equals("") ? 0L : Long.parseLong(parentId));
        if (!parentId.equals("")) {
            orgParams.add(param);
        }
        if ((childList = viewTreeNode.getChildren()) != null && childList.size() > 0) {
            for (TreeNode childTreeNode : childList) {
                this.getAllNodeInfo(orgParams, childTreeNode);
            }
        }
    }

    private void deleteNode() {
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        HashSet deleteNode = new HashSet(10);
        for (String node : rightNodes) {
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)node, (TreeNode)viewRoot);
            if (checkNodeInfo == null) continue;
            String parentId = checkNodeInfo.getParentid();
            if (parentId.equals("")) {
                ArrayList deleteNodeId = new ArrayList();
                this.getAllChildrenAndSelf(checkNodeInfo).forEach(n -> deleteNodeId.add(n.getId()));
                deleteNodeId.remove(checkNodeInfo.getId());
                deleteNode.addAll(deleteNodeId);
                viewRoot.setChildren(null);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(viewRoot);
                continue;
            }
            viewRoot.deleteChildNode(checkNodeInfo.getId());
            this.bizviewtree.deleteNode(checkNodeInfo.getId());
            TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
            if (parentNode.getChildren() == null || parentNode.getChildren() != null && parentNode.getChildren().isEmpty()) {
                parentNode.setChildren(null);
            }
            this.bizviewtree.updateNode(parentNode);
            this.bizviewtree.expand(parentId);
            ArrayList deleteNodeId = new ArrayList();
            this.getAllChildrenAndSelf(checkNodeInfo).forEach(n -> deleteNodeId.add(n.getId()));
            deleteNode.addAll(deleteNodeId);
        }
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
        this.getPageCache().put("deletenode", SerializationUtils.toJsonString(deleteNode));
    }

    public void treeNodeDragged(TreeNodeDragEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        if (!BIZVIEWTREE.equalsIgnoreCase(source.getKey())) {
            return;
        }
        String sourceNodeId = (String)evt.getNodeId();
        if ("".equals(sourceNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6e90\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckoutViewEdit_0", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        String targetNodeId = (String)evt.getToParentId();
        TreeNode unitRoot = this.getCachedRoot(CACHEKEY_UNIT_ROOT);
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        TreeNode sourceNode = AccountingSysUtil.getTreeNodeById((String)sourceNodeId, (TreeNode)unitRoot);
        TreeNode targetNode = AccountingSysUtil.getTreeNodeById((String)targetNodeId, (TreeNode)viewRoot);
        List<TreeNode> allAppendNodes = this.getAllChildrenAndSelf(sourceNode);
        List allAppendNodeIds = allAppendNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        List allViewNodeIds = allViewNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<String> dumpIds = allAppendNodeIds.stream().filter(allViewNodeIds::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getParentExcludeIds(viewRoot, targetNode, dumpIds);
        String finalAppendNodeId = finalAppendNode.getId();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(targetNode);
        this.removeNodes(viewRoot, dumpIds);
        if ("".equals(sourceNode.getParentid())) {
            List children = sourceNode.getChildren();
            for (TreeNode child : children) {
                child.setParentid(finalAppendNodeId);
                finalAppendNode.addChild(child);
            }
        } else {
            sourceNode.setParentid(finalAppendNodeId);
            finalAppendNode.addChild(sourceNode);
        }
        this.bizviewtree.updateNodes(needUpdateNodes);
        this.expandUp(this.bizviewtree, viewRoot, finalAppendNode);
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private void addNode() {
        List<Map> leftNodes;
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        if (rightNodes.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"CheckoutViewEdit_1", (String)"fi-fcc-formplugin", (Object[])new Object[]{rightNodes.size()}));
            return;
        }
        Map leftFocusNode = this.bizunittree.getTreeState().getFocusNode();
        List<Map> list = this.bizunittree.getTreeState().getCheckedNodes().size() == 0 ? (null == leftFocusNode ? Collections.EMPTY_LIST : Collections.singletonList(leftFocusNode)) : (leftNodes = this.bizunittree.getTreeState().getCheckedNodes());
        if (leftNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"CheckoutViewEdit_2", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
            return;
        }
        String viewCheckedId = (String)rightNodes.get(0);
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        List<TreeNode> viewNodeAll = this.getAllChildrenAndSelf(viewRoot);
        List viewIdAll = viewNodeAll.stream().map(TreeNode::getId).collect(Collectors.toList());
        TreeNode viewCheckedNode = AccountingSysUtil.getTreeNodeById((String)viewCheckedId, (TreeNode)viewRoot);
        List unitCheckedNodes = AccountingSysUtil.buildTreeNodeByList((TreeNode)viewCheckedNode, leftNodes);
        unitCheckedNodes.removeIf(node -> node.getId().equals(viewRoot.getId()));
        List<String> dumpIds = unitCheckedNodes.stream().map(TreeNode::getId).filter(viewIdAll::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getAllNode();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(viewCheckedNode);
        this.removeNodes(viewRoot, dumpIds);
        this.bizviewtree.updateNodes(needUpdateNodes);
        if (finalAppendNode.getChildren() != null) {
            for (TreeNode tre : finalAppendNode.getChildren()) {
                this.clearSelectNode(tre);
                tre.setParentid(viewCheckedNode.getId());
                if (viewCheckedNode.getChildren() == null) {
                    viewCheckedNode.addChild(tre);
                    continue;
                }
                viewCheckedNode.getChildren().add(tre);
            }
        }
        AccountingSysUtil.sortTreeNode((List)viewCheckedNode.getChildren());
        this.bizviewtree.checkNode(viewCheckedNode);
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private void clearSelectNode(TreeNode viewCheckedNode) {
        this.bizunittree.uncheckNode(viewCheckedNode.getId());
    }

    private TreeNode getAllNode() {
        Map leftFocusNode = this.bizunittree.getTreeState().getFocusNode();
        List<Map<String, Object>> leftNodes = this.bizunittree.getTreeState().getCheckedNodes().size() == 0 ? (null == leftFocusNode ? Collections.EMPTY_LIST : Collections.singletonList(leftFocusNode)) : this.bizunittree.getTreeState().getCheckedNodes();
        Long mainViewId = Long.parseLong(this.getPageCache().get("mainViewId"));
        Map<String, Map<String, String>> unitTreeMap = this.getSelectInfo(AccountingSysUtil.getAllOrgByViewId((Long)mainViewId), leftNodes);
        this.removeRepetion(unitTreeMap);
        Map allTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)mainViewId);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap(unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode(unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), (Map<String, String>)allTreeMap.get(tree.getId()));
            }
            unitRoot = AccountingSysUtil.createTreeNode(unitTreeMap);
            flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap(unitTreeMap);
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        return unitRoot;
    }

    private void removeRepetion(Map<String, Map<String, String>> unitTreeMap) {
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        Set<String> nodeIds = unitTreeMap.keySet();
        Iterator<TreeNode> iterator = allViewNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!nodeIds.contains(node.getId())) continue;
            iterator.remove();
            if (node.getChildren() == null) continue;
            for (TreeNode n : node.getChildren()) {
                n.setParentid(node.getParentid());
            }
        }
    }

    private Map<String, Map<String, String>> getSelectInfo(Map<String, Map<String, String>> unitTreeMap, List<Map<String, Object>> leftNodes) {
        ArrayList<Object> list = new ArrayList<Object>(leftNodes.size());
        HashMap<String, String> idParentidMap = new HashMap<String, String>(leftNodes.size());
        for (Map<String, Object> leftNode : leftNodes) {
            list.add(leftNode.get("id"));
            idParentidMap.put((String)leftNode.get("id"), (String)leftNode.get("parentid"));
        }
        unitTreeMap.keySet().retainAll(list);
        unitTreeMap.keySet().forEach(x -> {
            if (!"0".equals(((Map)unitTreeMap.get(x)).get("parentid"))) {
                ((Map)unitTreeMap.get(x)).put("parentid", idParentidMap.get(x));
            }
        });
        return unitTreeMap;
    }

    private TreeNode getCachedRoot(String key) {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), TreeNode.class);
    }

    private Long getParamAccsysId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return 0L;
    }

    private Long getParamSelfId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return Long.valueOf((String)map.get("id"));
    }

    private String getViewSchemaNumber() {
        return this.getParamAccsysId() + ":" + this.getModel().getValue("number").toString();
    }

    private void showTreeView(Long orgViewSchemaId, Long orgDefaultViewSchemaId, boolean isEdit) {
        this.getPageCache().put("mainViewId", orgDefaultViewSchemaId + "");
        Map unitTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)orgDefaultViewSchemaId);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            return;
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put(BIZUNITTREE, SerializationUtils.toJsonString((Object)unitRoot));
        Map viewTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)orgViewSchemaId);
        Map flatOrgTreeMap2 = AccountingSysUtil.getOrgTreeMap((Map)viewTreeMap);
        TreeNode viewRoot = AccountingSysUtil.createTreeNode((Map)viewTreeMap);
        if (isEdit) {
            if (viewRoot == null) {
                viewRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
            } else {
                AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap2, (String)viewRoot.getId(), (TreeNode)viewRoot);
            }
        }
        this.bizviewtree.addNode(viewRoot);
        this.cacheTreeNode(unitRoot, viewRoot);
    }

    private void cacheTreeNode(TreeNode unitTreeNode, TreeNode viewTreeNode) {
        IPageCache cache = this.getPageCache();
        cache.put(CACHEKEY_UNIT_ROOT, SerializationUtils.toJsonString((Object)unitTreeNode));
        cache.put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewTreeNode));
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        Control treeView = (Control)e.getSource();
        boolean isCheckChild = (Boolean)this.getModel().getValue(ISCHECKUNITCHILD);
        boolean isCheckOrgChild = (Boolean)this.getModel().getValue(ISCHECKORGCHILD);
        if (treeView.getKey().equals(BIZUNITTREE) && isCheckChild) {
            boolean containsAll;
            String nodeId = (String)e.getNodeId();
            TreeNode unitTreeNode = this.getCachedRoot(CACHEKEY_UNIT_ROOT);
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)unitTreeNode);
            List checkedNodeIds = this.bizunittree.getTreeState().getCheckedNodeIds();
            boolean empty = this.bizviewtree.getTreeState().getSelectedNodeId().isEmpty();
            boolean bl = containsAll = empty ? false : checkedNodeIds.containsAll(this.bizviewtree.getTreeState().getSelectedNodeId());
            if (containsAll && StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADDNODE, BTN_DELETENODE});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (checkedNodeIds.contains(nodeId)) {
                this.bizunittree.checkNodes(allChildren);
            } else {
                List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                this.bizunittree.unCheckNodesWithoutChild(allChildrenIds);
            }
        } else if (treeView.getKey().equals(BIZVIEWTREE)) {
            TreeNode viewTreeNode = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
            String nodeId = (String)e.getNodeId();
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)viewTreeNode);
            if (e.getChecked().booleanValue()) {
                if (StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                    List list = this.bizunittree.getTreeState().getSelectedNodeId();
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADDNODE, BTN_DELETENODE});
                }
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
            List checkedNodeIds = this.bizviewtree.getTreeState().getCheckedNodeIds();
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (isCheckOrgChild) {
                if (checkedNodeIds.contains(nodeId)) {
                    this.bizviewtree.checkNodes(allChildren);
                } else {
                    List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                    this.bizviewtree.unCheckNodesWithoutChild(allChildrenIds);
                }
            }
        }
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
        for (TreeNode child : children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(parentNode);
        return allChildren;
    }

    private List<TreeNode> getNeedUpdateNodes(TreeNode viewRoot, List<String> dumpIds) {
        ArrayList<TreeNode> needUpdateNodes = new ArrayList<TreeNode>(dumpIds.size());
        for (String dumpId : dumpIds) {
            needUpdateNodes.add(this.getParentExcludeIds(viewRoot, AccountingSysUtil.getTreeNodeById((String)dumpId, (TreeNode)viewRoot), dumpIds));
        }
        return needUpdateNodes;
    }

    private void expandUp(TreeView treeView, TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodesAndSelf(treeRoot, treeNode);
        parentNodes.forEach(x -> treeView.expand(x.getId()));
    }

    private List<TreeNode> getParentNodesAndSelf(TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodes(treeRoot, treeNode);
        parentNodes.add(treeNode);
        return parentNodes;
    }

    private List<TreeNode> getParentNodes(TreeNode treeRoot, TreeNode treeNode) {
        String parentId = treeNode.getParentid();
        if ("".equals(parentId)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)treeRoot);
        result.add(parentNode);
        result.addAll(this.getParentNodesAndSelf(treeRoot, parentNode));
        return result;
    }

    private TreeNode getParentExcludeIds(TreeNode viewRoot, TreeNode targetNode, List<String> dumpIds) {
        if (!dumpIds.contains(targetNode.getId())) {
            return targetNode;
        }
        String parentId = targetNode.getParentid();
        if ("".equals(parentId)) {
            return targetNode;
        }
        TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
        return this.getParentExcludeIds(viewRoot, parentNode, dumpIds);
    }

    private void removeNodes(TreeNode root, List<String> nodeIds) {
        for (String nodeId : nodeIds) {
            String parentId;
            TreeNode node = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)root);
            if (node == null || "".equals(parentId = node.getParentid())) continue;
            List childNodes = node.getChildren();
            TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)root);
            List parentChilds = parentNode.getChildren();
            parentChilds.removeIf(x -> x.getId().equals(nodeId));
            if (parentChilds.isEmpty()) {
                parentNode.setChildren(null);
            }
            if (childNodes == null) continue;
            for (TreeNode childNode : childNodes) {
                parentChilds.add(childNode);
                childNode.setParentid(parentId);
            }
        }
    }

    public void search(SearchEnterEvent e) {
        OrgTreeSearchParam searchParam;
        String searchText = e.getText();
        Search search = (Search)e.getSource();
        QFilter orgFilter = null;
        if ("orgsearchap".equals(search.getKey())) {
            TreeView treeView = (TreeView)this.getControl(BIZUNITTREE);
            String viewId = this.getPageCache().get("mainViewId");
            String filterValue = this.getPageCache().get(CACHEKEY_FILTER_VALUE);
            if (StringUtils.isNotBlank((CharSequence)filterValue)) {
                orgFilter = new QFilter("org.orgpattern.name", "=", (Object)filterValue);
            }
            searchParam = new OrgTreeSearchParam(searchText, this.getView(), treeView, CACHEKEY_UNIT_ROOT, Long.parseLong(viewId), orgFilter);
        } else {
            TreeView treeView = (TreeView)this.getControl(BIZVIEWTREE);
            String viewId = this.getModel().getValue("id").toString();
            searchParam = new OrgTreeSearchParam(searchText, this.getView(), treeView, CACHEKEY_VIEW_ROOT, Long.parseLong(viewId), orgFilter);
        }
        CheckoutViewEdit.searchFromLazyOrgTree(searchParam);
    }

    public Long getSchemaId(Long orgDefaultViewSchemaId, Long id) {
        return 0L;
    }

    public static void removeAllSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
        pageCache.remove("_oldSearchText");
        pageCache.remove("_oldSearchViewSchema");
        pageCache.remove("_resultTotalCacheKey");
    }

    public static void preTravel(TreeNode node, Consumer<TreeNode> consumer) {
        consumer.accept(node);
        if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
            ArrayList childClone = new ArrayList(node.getChildren());
            for (TreeNode c : childClone) {
                CheckoutViewEdit.preTravel(c, consumer);
            }
        }
    }

    public static ListMultimap<Integer, TreeNode> tagNodeWithLevel(TreeNode rootNode, Map<String, TreeNode> idNodeMap) {
        LinkedListMultimap levelNodeMap = LinkedListMultimap.create();
        CheckoutViewEdit.preTravel(rootNode, x -> {
            if (Objects.equals(rootNode, x)) {
                ((Map)x.getData()).put("level", "1");
            } else {
                ((Map)x.getData()).put("level", String.valueOf(Integer.parseInt((String)((Map)((TreeNode)idNodeMap.get(x.getParentid())).getData()).get("level")) + 1));
            }
            int curLevel = Integer.parseInt((String)((Map)x.getData()).get("level"));
            levelNodeMap.put((Object)curLevel, x);
        });
        return levelNodeMap;
    }

    public static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam) {
        if (searchParam == null) {
            return;
        }
        String searchText = searchParam.getSearchText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        String orgViewNumber = searchParam.getOrgViewNumber();
        List treeNodes = Collections.EMPTY_LIST;
        IPageCache pageCache = searchParam.getPageCache();
        if (!orgViewNumber.equals(pageCache.get("_oldSearchViewSchema"))) {
            CheckoutViewEdit.removeAllSearchTreeNodeCache(pageCache);
        }
        pageCache.put("_oldSearchViewSchema", orgViewNumber);
        String oldSearchText = pageCache.get("_oldSearchText");
        pageCache.put("_oldSearchText", searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get("_searchNodes");
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            pageCache.remove("_searchNodes");
            treeNodes = CheckoutViewEdit.searchTreeNode(searchParam);
            if (CheckoutViewEdit.finishSearch(searchParam, treeNodes, true)) {
                return;
            }
            pageCache.put("_resultTotalCacheKey", Integer.toString(treeNodes.size()));
        }
        if (CollectionUtils.isEmpty(treeNodes)) {
            CheckoutViewEdit.finishSearch(searchParam, treeNodes, false);
        } else {
            CheckoutViewEdit.searchFromLazyOrgTree(searchParam, treeNodes);
        }
    }

    private static List<TreeNode> searchTreeNode(OrgTreeSearchParam searchParam) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        String searchText = searchParam.getSearchText();
        String orgViewNumber = searchParam.getOrgViewNumber();
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        QFilter nameFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
        viewFilter = viewFilter.and(nameFilter);
        if (null != searchParam.getOrgFilter()) {
            viewFilter.and(searchParam.getOrgFilter());
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        String orderBy = "level,longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(CheckoutViewEdit.class.getName() + "searchTreeNode"), (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBy);){
            for (Row structObj : ds) {
                String orgId = structObj.getString("org");
                TreeNode treeNode = new TreeNode(structObj.getString("parent"), orgId, structObj.getString("name"));
                treeNode.setExpend(true);
                treeNode.setLongNumber(structObj.getString("longnumber"));
                treeNodes.add(treeNode);
            }
        }
        return treeNodes;
    }

    private static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        IPageCache pageCache = searchParam.getPageCache();
        String resultTotal = pageCache.get("_resultTotalCacheKey");
        boolean firstTimeCheck = StringUtils.isNotBlank((CharSequence)resultTotal) && Integer.parseInt(resultTotal) == treeNodes.size();
        TreeView treeView = searchParam.getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = CheckoutViewEdit.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        if (node == null) {
            CheckoutViewEdit.finishSearch(searchParam, treeNodes, firstTimeCheck);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            treeView.expand(node.getId());
            treeView.checkNode(node);
            treeView.focusNode(node);
            if (treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        pageCache.put("_searchNodes", SerializationUtils.toJsonString(treeNodes));
    }

    private static boolean finishSearch(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        TreeView treeView = searchParam.getTreeView();
        searchParam.getPageCache().put("_searchNodes", "");
        searchParam.getPageCache().remove("_oldSearchText");
        if (noResult) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            searchParam.getFormView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"CheckoutViewEdit_3", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        } else {
            searchParam.getFormView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"CheckoutViewEdit_4", (String)"fi-fcc-formplugin", (Object[])new Object[0]));
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            treeView.focusNode(rootNode);
        }
        return true;
    }

    private static TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        String parentId = node.getParentid();
        TreeNode parentNode = CheckoutViewEdit.getNode(searchParam.getRootNode(), parentId);
        if (CheckoutViewEdit.isChildNode(parentNode, node)) {
            ArrayList<String> loopController = new ArrayList<String>();
            CheckoutViewEdit.expandParentNode(searchParam, parentId, loopController);
        } else {
            CheckoutViewEdit.queryTreeNodeWithParent(searchParam, node);
        }
        node = CheckoutViewEdit.getNode(searchParam.getRootNode(), node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList<TreeNode> removeSubNodes = new ArrayList<TreeNode>(treeNodes.size());
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return CheckoutViewEdit.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        }
        return node;
    }

    public static TreeNode getNode(TreeNode rootNode, Object nodeId) {
        if (rootNode == null || StringUtils.isBlank((Object)nodeId)) {
            return null;
        }
        return rootNode.getTreeNode(nodeId.toString(), 20);
    }

    private static boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode == null || CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            return false;
        }
        for (TreeNode child : parentNode.getChildren()) {
            if (!node.getId().equals(child.getId())) continue;
            return true;
        }
        return false;
    }

    public static void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, List<String> loopController) {
        if (searchParam == null || StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        if (loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = CheckoutViewEdit.getNode(rootNode, nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            searchParam.getTreeView().expand(nodeId);
            treeNode.setExpend(true);
            CheckoutViewEdit.expandParentNode(searchParam, treeNode.getParentid(), loopController);
        }
    }

    private static void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        TreeView treeView = searchParam.getTreeView();
        String orgViewNumber = searchParam.getOrgViewNumber();
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        List<String> longNumList = CheckoutViewEdit.getParentNumbers(searchParam, node, viewFilter);
        if (longNumList.isEmpty()) {
            return;
        }
        String selectFields = "id,org,parent";
        QFilter numberFilter = new QFilter("org.number", "in", longNumList);
        QFilter[] filters = new QFilter[]{numberFilter, viewFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeUtils.queryTreeNodeWithParent", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");){
            TreeNode parentNode = searchParam.getRootNode();
            for (Row row : ds) {
                String orgId = row.getString("org");
                if ((parentNode = CheckoutViewEdit.getNode(parentNode, orgId)) == null || parentNode.getChildren() == null || parentNode.getChildren().isEmpty() || node.getParentid().equals(orgId)) {
                    String parentId = row.getString("parent");
                    treeView.queryTreeNodeChildren(parentId, orgId);
                }
                treeView.expand(orgId);
            }
        }
    }

    private static List<String> getParentNumbers(OrgTreeSearchParam searchParam, TreeNode node, QFilter viewFilter) {
        QFilter orgFilter;
        QFilter[] filters;
        DynamicObject structObj;
        ArrayList<String> longNumList = new ArrayList<String>();
        String longNumber = node.getLongNumber();
        if (StringUtils.isBlank((CharSequence)longNumber) && (structObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])(filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "=", (Object)Long.valueOf(node.getId()))}))) != null) {
            longNumber = structObj.getString("longnumber");
            node.setLongNumber(longNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            int i;
            String[] numbers = longNumber.split("!");
            int n = i = searchParam.getRootNode().getId().equals(node.getParentid()) ? 0 : 1;
            while (i < numbers.length - 1) {
                longNumList.add(numbers[i]);
                ++i;
            }
        }
        return longNumList;
    }
}

