/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fcc.opplugin.validator.CheckOutMemberBatchValidator;
import org.apache.commons.lang3.math.NumberUtils;

public class CheckOutMemberBatchOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String SUB_ENTITY = "fcc_checkout_members";
    private static final String ENTITY_NUMBER = "fcc_checkout_task";
    private static final String BUSINESS_SYSTEM_ID = "businesssystem";
    private static final String MEMBERID = "member";
    private static final Log log = LogFactory.getLog(CheckOutMemberBatchOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CheckOutMemberBatchValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
    }

    private void batchUpdate(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Long orgId = NumberUtils.toLong((String)String.valueOf(dataEntity.getDynamicObject("createorg").get("masterid")));
            DynamicObjectCollection fcc_checkout_members = dataEntity.getDynamicObjectCollection(SUB_ENTITY);
            ArrayList<Long> bizIds = new ArrayList<Long>();
            HashMap<Long, Long> buMap = new HashMap<Long, Long>();
            for (DynamicObject fcc_checkout_member : fcc_checkout_members) {
                DynamicObject dynamicObject = fcc_checkout_member.getDynamicObject(BUSINESS_SYSTEM_ID);
                Long bizsystemId = NumberUtils.toLong((String)String.valueOf(dynamicObject.get("masterid")));
                bizIds.add(bizsystemId);
                DynamicObject user = fcc_checkout_member.getDynamicObject(MEMBERID);
                Long userId = NumberUtils.toLong((String)String.valueOf(user.get("masterid")));
                buMap.put(bizsystemId, userId);
            }
            QFilter qFilter = new QFilter("taskentry.eorg.id", "=", (Object)orgId);
            qFilter.and(new QFilter("taskentry.tasknumber.bizsystem.id", "in", bizIds));
            DynamicObject[] checkoutFlows = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id,taskentry", (QFilter[])new QFilter[]{qFilter});
            if (null == checkoutFlows || checkoutFlows.length < 1) continue;
            for (DynamicObject checkoutFlow : checkoutFlows) {
                for (DynamicObject dynamicObject : checkoutFlow.getDynamicObjectCollection("taskentry")) {
                    dynamicObject.set("executor", buMap.get(dynamicObject.get("tasknumber.bizsystem.id")));
                }
            }
            OperationServiceHelper.executeOperate((String)"save", (String)"fcc_checkout_flow_detail", (DynamicObject[])checkoutFlows, (OperateOption)OperateOption.create());
        }
    }
}

