/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.opplugin.validator.CheckoutTaskSaveValidator;

public class CheckOutTaskSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckoutTaskSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.removeNotExistServices(e);
        this.clearServices(e);
    }

    private void removeNotExistServices(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> serviceDetailsMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject dataEntry : dataEntities) {
            DynamicObjectCollection serviceEntry = dataEntry.getDynamicObjectCollection("entryentity");
            if (null == serviceEntry) continue;
            for (DynamicObject serviceEn : serviceEntry) {
                DynamicObject task = (DynamicObject)serviceEn.get("service");
                if (null == task) continue;
                Long serviceId = task.getLong("id");
                serviceDetailsMap.put(serviceId, serviceEn);
            }
            for (DynamicObject serviceEn : serviceEntry) {
                MulBasedataDynamicObjectCollection preServices = (MulBasedataDynamicObjectCollection)serviceEn.get("preservice");
                if (null == preServices || preServices.size() == 0) continue;
                ArrayList<DynamicObject> removePreTasks = new ArrayList<DynamicObject>(2);
                for (DynamicObject preService : preServices) {
                    Long preTaskId = preService.getLong("fbasedataid.id");
                    DynamicObject preTaskEntry = (DynamicObject)serviceDetailsMap.get(preTaskId);
                    if (null != preTaskEntry) continue;
                    removePreTasks.add(preService);
                }
                if (null == removePreTasks || removePreTasks.size() <= 0) continue;
                preServices.removeAll(removePreTasks);
                serviceEn.set("preservice", (Object)preServices);
            }
        }
    }

    private void clearServices(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String taskType = dataEntity.getString("taskType");
            if (!StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.MANUAL_TASKS.getType())) continue;
            dataEntity.set("entryentity", null);
        }
    }
}

