/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.opplugin.validator.CheckOutTemplateSaveValidator;

public class CheckTemplateSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.checkTaskEntry(e.getDataEntities());
        e.addValidator((AbstractValidator)new CheckOutTemplateSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.clearNotExitsPreTask(dataEntities);
        this.clearVirtualTaskInfo(dataEntities);
        this.clearNotExitsChildTask(dataEntities);
    }

    private void clearNotExitsPreTask(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntry : dataEntities) {
            HashMap<Long, DynamicObject> taskDetailsMap = new HashMap<Long, DynamicObject>(2);
            DynamicObjectCollection taskEntry = dataEntry.getDynamicObjectCollection("taskentry");
            if (null == taskEntry) continue;
            for (DynamicObject taskEn : taskEntry) {
                DynamicObject task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long taskId = task.getLong("id");
                taskDetailsMap.put(taskId, taskEn);
            }
            for (DynamicObject taskEn : taskEntry) {
                MulBasedataDynamicObjectCollection preTasks = (MulBasedataDynamicObjectCollection)taskEn.get("pretasks");
                if (null == preTasks || preTasks.size() == 0) continue;
                ArrayList<DynamicObject> removePreTasks = new ArrayList<DynamicObject>(2);
                for (DynamicObject preTask : preTasks) {
                    Long preTaskId = preTask.getLong("fbasedataid.id");
                    DynamicObject preTaskEntry = (DynamicObject)taskDetailsMap.get(preTaskId);
                    if (null != preTaskEntry) continue;
                    removePreTasks.add(preTask);
                }
                if (null == removePreTasks || removePreTasks.size() <= 0) continue;
                preTasks.removeAll(removePreTasks);
                taskEn.set("pretasks", (Object)preTasks);
            }
        }
    }

    private void clearVirtualTaskInfo(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection taskEntry = dataEntity.getDynamicObjectCollection("taskentry");
            if (null == taskEntry) continue;
            for (DynamicObject taskEn : taskEntry) {
                DynamicObject task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long pid = taskEn.getLong("pid");
                String taskType = task.getString("tasktype");
                if (!StringUtils.equals((CharSequence)TaskTypeEnum.TASK_SET.getType(), (CharSequence)taskType) || pid != 0L) continue;
                taskEn.set("pretasks", null);
                taskEn.set("startdate", null);
                taskEn.set("starttime", (Object)-1);
                taskEn.set("enddate", null);
                taskEn.set("endtime", (Object)-1);
            }
        }
    }

    private void checkTaskEntry(DynamicObject[] dataEntities) {
        HashMap<Long, Long> virtualTaskMap = new HashMap<Long, Long>(1);
        Boolean flag = false;
        for (DynamicObject dataEntity : dataEntities) {
            String taskType;
            DynamicObject task;
            DynamicObjectCollection taskEntry = dataEntity.getDynamicObjectCollection("taskentry");
            if (null == taskEntry) continue;
            for (DynamicObject taskEn : taskEntry) {
                task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long id = taskEn.getLong("id");
                Long pid = taskEn.getLong("pid");
                Long taskId = task.getLong("id");
                taskType = task.getString("tasktype");
                if (StringUtils.equals((CharSequence)TaskTypeEnum.TASK_SET.getType(), (CharSequence)taskType) && pid == 0L) {
                    virtualTaskMap.put(taskId, id);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)taskType) || pid != 0L) continue;
                flag = true;
            }
            if (!flag.booleanValue()) continue;
            for (DynamicObject taskEn : taskEntry) {
                Long taskEnId;
                task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long pid = taskEn.getLong("pid");
                DynamicObject virtualTask = task.getDynamicObject("virtualtask");
                if (null == virtualTask) continue;
                Long virtualTaskId = virtualTask.getLong("id");
                taskType = task.getString("tasktype");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)taskType) || pid != 0L || null == (taskEnId = (Long)virtualTaskMap.get(virtualTaskId))) continue;
                taskEn.set("pid", (Object)taskEnId);
            }
        }
    }

    private void clearNotExitsChildTask(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntry : dataEntities) {
            DynamicObject task;
            HashSet<Long> taskSetId = new HashSet<Long>(1);
            ArrayList<DynamicObject> removeObj = new ArrayList<DynamicObject>(1);
            DynamicObjectCollection taskEntry = dataEntry.getDynamicObjectCollection("taskentry");
            if (null == taskEntry) continue;
            for (DynamicObject taskEn : taskEntry) {
                task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long taskId = task.getLong("virtualtask.id");
                taskSetId.add(taskId);
            }
            for (DynamicObject taskEn : taskEntry) {
                task = (DynamicObject)taskEn.get("task");
                if (null == task) continue;
                Long id = task.getLong("id");
                String taskType = task.getString("tasktype");
                if (!StringUtils.equals((CharSequence)TaskTypeEnum.TASK_SET.getType(), (CharSequence)taskType) || taskSetId.contains(id)) continue;
                removeObj.add(taskEn);
            }
            taskEntry.removeAll(removeObj);
        }
    }
}

